package jcircus.util;

/**
 * The possible kinds of names in Circus.
 *
 * @author Angela Freitas
 */
public enum NameType {
    
    Undefined,
    /**
     * For components of a schema that defines state, 
     * when they are brought to global scope.
     */
    StateComponent, 

    ProcessParam,
    ActionParam,
    LocalVariable,
    Channel,
    GlobalConstant,
    LocalConstant,
    FreeType,
    ElemFreeType,
    ProcessName,
    ActionName,
    SchemaName,
    RecursiveName,
    ChannelSetName,
    NameSetName,
    /**
     * For names declared in the declpart of a schema.
     */
    SchemaComponent 
    ;
    
    public String toString() {
        return "NameType." + name();
    }
}
