package jcircus.util;

import java.text.MessageFormat;
import java.util.Locale;
import java.util.ResourceBundle;

/**
 * Represents a error that occurred during the translation.
 *
 * @author Angela
 */
public class Error {
    
    /** Contains the error messages */
    private static ResourceBundle RESOURCE_BUNDLE =
            ResourceBundle.getBundle("jcircus.util.ErrorMessage");
    
    /** The parameters associated with this error message. */
    protected Object [] params_;
    
    /** The error message. */
    protected ErrorMessage errorMessage_;
    
    /**
     * Constructors
     */
    public Error(ErrorMessage errorMessage) {
        this.errorMessage_ = errorMessage;
        this.params_ = new Object [] {};
    }

    public Error(ErrorMessage errorMessage, Object [] params) {
        this.errorMessage_ = errorMessage;
        this.params_ = params;
    }
    
    /**
     * String representation of the error. Gets the appropriate message and 
     * replace the parameters.
     */
    public String toString() {
        String result = new String();
        
        // format the parameters and write into the message
        String formatted [] = new String[params_.length];
        for (int i = 0; i < params_.length; i++) {
            
            if (params_[i] == null)
                formatted[i] = "null";
            else
                formatted[i] = params_[i].toString();
        }
        
        // gets the message and formats it
        String pattern = RESOURCE_BUNDLE.getString(errorMessage_.toString());
        MessageFormat form = new MessageFormat(pattern);
        result = form.format(formatted);
        
        return result;
    }
    
}








