package jcircus.util;

/**
 * Defines the constants used in the program.
 *
 * @author Angela Freitas
 *
 */
public class Constants {
    
    /* Velocity parameters */
    public static final String PROJECT_NAME = "proj";
    
    /* Names of packages */    
    public static final String PKG_PROCESSES    = "processes";
    public static final String PKG_AXDEFS       = "axiomaticDefinitions";
    public static final String PKG_TYPING       = "typing";
    public static final String PKG_UTIL         = "util";
    public static final String PKG_GUI          = "gui";
    
    /* Name of the source directory */
    public static final String DIR_SOURCE       = "src";
    
    /* Location of resources */
    private static final String DIR_TEMPLATES   = "templates\\";
    public static final String DIR_EXAMPLES = "D:\\Angela\\Research\\Java\\JCircus\\src\\examples";
    public static final String DIR_PROJECTS = "D:\\Angela\\Research\\Java\\Translator";

// Use this when generating the binary distribution //////////////////////////////////
//    private static final String DIR_TEMPLATES = "";
//   public static final String DIR_EXAMPLES = "./examples";
//    public static final String DIR_PROJECTS = "./output";
//////////////////////////////////////////////////////////////////////////////////////
    
    /* Velocity templates */
    public static final String TMP_AXDEFS    = DIR_TEMPLATES + "AxiomaticDefinitionsClass.vm";
    public static final String TMP_BASICPROC = DIR_TEMPLATES + "BasicProcessCode.vm";
    public static final String TMP_BAT       = DIR_TEMPLATES + "BatFile.vm";
    public static final String TMP_CIRCINT   = DIR_TEMPLATES + "CircusIntegerClass.vm";
    public static final String TMP_CTRLMNGR  = DIR_TEMPLATES + "ControllersManagerCallCode.vm";
    public static final String TMP_GUI       = DIR_TEMPLATES + "GuiClass.vm";
    public static final String TMP_MAIN      = DIR_TEMPLATES + "MainClass.vm";
    public static final String TMP_PARACT    = DIR_TEMPLATES + "ParallelActionsCode.vm";
    public static final String TMP_PARCALL   = DIR_TEMPLATES + "ParallelCallCode.vm";
    public static final String TMP_PROC      = DIR_TEMPLATES + "ProcessClass.vm";
    public static final String TMP_PROCMNGR  = DIR_TEMPLATES + "ProcessManagerCallCode.vm";
    public static final String TMP_INNCLS    = DIR_TEMPLATES + "InnerClassCode.vm";
    public static final String TMP_SUBTYPE   = DIR_TEMPLATES + "SubTypeClass.vm";
    public static final String TMP_TYPE      = DIR_TEMPLATES + "TypeClass.vm";
            
    /* Constants in velocity templates */
    
    /* AxiomaticDefinitionsClass.vm */
    public static final String C_AXDEFS_PKG = "package";
    public static final String C_AXDEFS_IMP = "imports";
    public static final String C_AXDEFS_BODY = "body";
    
    /* BasicProcessCode.vm */
    public static final String C_BASICPROC_STDECL = "stateDecl";
    public static final String C_BASICPROC_ZPARA = "zParas";
    public static final String C_BASICPROC_ACTPARA = "actionParas";
    public static final String C_BASICPROC_MAINACT = "mainAction";
    
    /* BatFile.vm */
    public static final String C_BAT_PROJ = "proj";
    public static final String C_BAT_MAIN = "main";
    
    /* CircusIntegerClass.vm */ 
    public static final String C_CIRCINT_PKG = "package";
    
    /* ControllersManagerCallCode.vm */
    public static final String C_CTRLMNGR_CALL = "msControlCall";
    
    /* GuiClass.vm */
    public static final String C_GUI_PKG = "package";
    public static final String C_GUI_IMP = "imports";
    public static final String C_GUI_CLSNAME = "className";
    public static final String C_GUI_CHANDECL = "chanDecl";
    public static final String C_GUI_CHANASSIG = "chanAssign";
    public static final String C_GUI_CHANPARAM = "chanParam";
    public static final String C_GUI_CHANINIT = "chanInit";
    public static final String C_GUI_CHANACTPERF = "chanActPerf";
    
    /* MainClass.vm */
    public static final String C_MAIN_PKG = "package";
    public static final String C_MAIN_IMP = "imports";
    public static final String C_MAIN_PROJ = "proj";      
    public static final String C_MAIN_NMMAIN = "nameMain";
    public static final String C_MAIN_DECLS = "declarations";
    public static final String C_MAIN_PROCCALL = "processCall";
            
    /* ParallelActionsCode.vm */
     public static final String C_PARACT_LNAME = "lName";
     public static final String C_PARACT_LATT = "lAttributes";
     public static final String C_PARACT_LPARAMDECL = "lParamDeclConstructor";
     public static final String C_PARACT_LCONSTRBODY = "lConstructorBody";
     public static final String C_PARACT_LRUN = "lMethodRun";
     public static final String C_PARACT_LPARAM = "lParameters";
     public static final String C_PARACT_RNAME = "rName";
     public static final String C_PARACT_RATT = "rAttributes";
     public static final String C_PARACT_RPARAMDECL = "rParamDeclConstructor";
     public static final String C_PARACT_RCONSTRBODY = "rConstructorBody";
     public static final String C_PARACT_RRUN = "rMethodRun";
     public static final String C_PARACT_RPARAM = "rParameters";
     public static final String C_PARACT_INDEX = "index";
     public static final String C_PARACT_MERGE = "mergeVars";
     
    /* ParallelCallCode.vm */
    public static final String C_PARCALL_LISTPROC = "listProcessesCode";
    
    /* ProcessClass.vm */
    public static final String C_PROC_PKG = "package";
    public static final String C_PROC_IMP = "imports";
    public static final String C_PROC_PROJ = "proj";
    public static final String C_PROC_CLSBODY = "classBody";
    public static final String C_PROC_CLSNAME = "className";
            
    /* ProcessManagerCallCode.vm */
    public static final String C_PROCMNGR_PROC = "proc";
    
    /* InnerClassCode.vm */
    public static final String C_INNCLS_INDEX = "index";
    public static final String C_INNCLS_ATTDECL = "attDecl";
    public static final String C_INNCLS_CONSTBODY = "constructorBody";
    public static final String C_INNCLS_PARAMDECL = "paramDecl";
    public static final String C_INNCLS_RUNBODY = "runBody";
    public static final String C_INNCLS_RUNCALL = "runCall";

    /* SubTypeClass.vm */
    public static final String C_SUBTYPE_PKG = "package";
    public static final String C_SUBTYPE_PROJ = "proj";
    public static final String C_SUBTYPE_CLSNAME = "className";
    public static final String C_SUBTYPE_CONST = "constants";
    public static final String C_SUBTYPE_TOSTR = "toString";
    public static final String C_SUBTYPE_CONSTRUCTOR = "constructor";
    
    /* TypeClass.vm */
    public static final String C_TYPE_PKG = "package";
    public static final String C_TYPE_DECLCONST = "declTypeConstants";
    
    /* Name of Source Files */
    public static final String CLS_AXDEFS   = "AxiomaticDefinitions";
    public static final String CLS_TYPE     = "Type";
    public static final String CLS_CHINFO   = "ChannelInfo";
    public static final String CLS_CIRCNUM  = "CircusInteger";
    public static final String CLS_GENCHAN  = "GeneralChannel";
    public static final String CLS_RANGEN   = "RandomGenerator";
    public static final String CLS_MSCTRL   = "MultiSyncControl";
    public static final String CLS_ALTBAR   = "AltingBarrier"; /**By Samuel*/
    
    /* Java extension */
    public static final String JAVA_EXT     = ".java";
    
    /* Auxiliar */
    public static final int OP_INTCHOICE = 0;
    public static final int OP_EXTCHOICE = 1;
    
}    