package jcircus.util;

import java.util.List;
import jcircus.exceptions.runtime.NotYetImplementedException;
import net.sourceforge.czt.base.ast.ListTerm;

//import net.sourceforge.czt.base.impl.TermAImpl;
import net.sourceforge.czt.base.impl.TermImpl;

import net.sourceforge.czt.z.ast.Expr;
import net.sourceforge.czt.z.ast.RefExpr;
import net.sourceforge.czt.z.ast.Type;
import net.sourceforge.czt.z.impl.RefExprImpl;
import net.sourceforge.czt.z.util.Factory;

/**
 * Represents a Circus Type. May be a variable type or a channel type.
 * May be generic or not; in case it is not generic, the attribute 
 * 'genericParameters' is null.
 *
 * @author  Angela Freitas
 *
 */
public class CircusType extends /*TermAImpl*/ TermImpl implements Type {

    /**
     *
     */
    public static final String SYNC_CHANNEL= "$$SYNCH"; //Esse $$SYNCH � de Samuel Barrocas
    
    /*
     * List of String. The generic parameters, in case that this type is generic.
     * If the type is not generic it is null.
     */
    private List<String> genericParameters;
    
    /*
     * Type expr.
     */
    private Expr expr;
    
    /*
     * Name of the class that represents the type.
     */
    private String javaCircusTypeName;
    
    /*
     * The ID of this type in class Types.java.
     */
    private int id;
    
    /**
     * Constructor for a non-generic type.
     *
     * @param expr
     */
    public CircusType(Expr expr) {
        this.genericParameters = null;
        this.expr = expr;
    }
    
    /**
     * Constructor for a generic type.
     *
     * @param expr
     */
    public CircusType(List<String> genericParameters, Expr expr) {
        this.genericParameters = genericParameters;
        this.expr = expr;
    }

    /**
     *
     */
    public Expr getExpression() {
        return this.expr;
    }
    
    /**
     *
     */
    public List<String> getGenericParameters() {
        return this.genericParameters;
    }
    
    /**
     *
     */
    public String getJavaCircusTypeName() {
        return this.javaCircusTypeName;
    }
    
    /**
     *
     */
    public void setJavaCircusTypeName(String javaCircusTypeName) {
        this.javaCircusTypeName = javaCircusTypeName;
    }

    /**
     *
     */
    public void setId(int id) {
        this.id = id;
    }
    
    /**
     * This implementation must be fixed to take into account the following situation:
     *
     * [X] \power (X)
     * [Y] \power (Y)
     *
     * These two types are equal, because the generic names play the same role in
     * both expressions.
     *
     */
    public boolean equals(Object other){
        
        boolean r = false;
        
        if (other instanceof CircusType) {
            
  /*      if (this.expr instanceof RefExprImpl 
                && ((CircusType)other).expr instanceof RefExprImpl 
                && ((RefExprImpl)this.expr).getRefName().toString().equals("Color") 
                && ((RefExprImpl)((CircusType)other).expr).getRefName().toString().equals("Color")) */
                
            
            Expr otherExpr = ((CircusType) other).getExpression();
            
            // gambiarra medonha
            if (this.expr instanceof RefExpr && otherExpr instanceof RefExpr) {
                
                RefExpr thisRefExpr = (RefExpr) expr;
                RefExpr otherRefExpr = (RefExpr) otherExpr;
                
                if (thisRefExpr/*.getRefName()*/.getZName().toString().equals(otherRefExpr/*.getRefName()*/.getZName().toString())) {
                    return true;
                }
            }
            
            
            if (this.expr.equals(((CircusType) other).getExpression())) {
                
                if (this.genericParameters != null && ((CircusType)other).getGenericParameters() != null) {
                    
                    if (this.genericParameters.size() == ((CircusType)other).getGenericParameters().size()) {
                        
                        r = true;
                        
                        for (int i=0; i<this.genericParameters.size(); i++) {
                            
                            if (!this.genericParameters.get(i).equals(((CircusType)other).getGenericParameters().get(i))) {
                                r = false;
                            }
                        }
                    }
                } else {
                    r = true;
                }
            }
        }
        
        return r;
    }
    
    /**
     * Return true if this type is generic; false, otherwise.
     */
    public boolean isGeneric() {
        
        boolean  r = true;
        if (this.genericParameters == null || this.genericParameters.size() == 0)
            r = false;
        
        return r;
    }
    
    /**
     * Return true if this type is 'Sync'; false, otherwise.
     *
     * @return
     */
    public boolean isSyncType() {
        
        boolean r = false;
        
        if (this.expr instanceof RefExpr) {

            if (((RefExpr) this.expr)./*.getRefName()*/getZName().toString().equals(CircusType.SYNC_CHANNEL)) {
                r = true;
            }
        }
        
        return r;
    }
    
    /** **************************************************************************************************************
     * Static methods
     * ***************************************************************************************************************
     */

    /**
     * Create the Circus Integer type: \nat.
     *
     * TODO: Change to \arithmos.
     *
     * @return
     */
    public static CircusType createCircusInteger() {
        
        Factory factory = new Factory();
        return new CircusType(factory.createRefExpr(factory./*createRefName*/createZName(MathToolkitConstants.NAT)));
    }
    
    /**
     * Create the synchronization type 'Sync', for synchronization channels, for example:
     *
     * \circchannel a, b, c
     *
     * @return
     */
    public static CircusType createSyncType() {
        
        //return new CircusType(new RefName(new Name(CircusType.SYNC_CHANNEL)));
        return new CircusType(Util.createSyncExpression());
    }
    
    /** **************************************************************************************************************
     * Methods inherited from Term
     * ***************************************************************************************************************
     */
    
    /**
     *
     */
    public net.sourceforge.czt.base.ast.Term create(Object[] args) {
        throw new NotYetImplementedException();
    }
    
    /**
     *
     */
    public Object[] getChildren() {
        throw new NotYetImplementedException();
    }
}
