package jcircus.parallelism;

import java.util.List;

import net.sourceforge.czt.circus.ast.Action2;
import net.sourceforge.czt.circus.ast.ActionPara;
import net.sourceforge.czt.circus.ast.AssignmentCommand;
import net.sourceforge.czt.circus.ast.AssignmentPairs;
import net.sourceforge.czt.circus.ast.BasicProcess;
import net.sourceforge.czt.circus.ast.CallAction;
import net.sourceforge.czt.circus.ast.CallProcess;
import net.sourceforge.czt.circus.ast.CircusAction;
import net.sourceforge.czt.circus.ast.CircusChannelSet;
import net.sourceforge.czt.circus.ast.CircusCommand;
import net.sourceforge.czt.circus.ast.CircusFieldList;
import net.sourceforge.czt.circus.ast.CircusProcess;
import net.sourceforge.czt.circus.ast.Communication;
import net.sourceforge.czt.circus.ast.DotField;
import net.sourceforge.czt.circus.ast.ExtChoiceAction;
import net.sourceforge.czt.circus.ast.ExtChoiceProcess;
import net.sourceforge.czt.circus.ast.Field;
import net.sourceforge.czt.circus.ast.HideAction;
import net.sourceforge.czt.circus.ast.HideProcess;
import net.sourceforge.czt.circus.ast.IntChoiceAction;
import net.sourceforge.czt.circus.ast.IntChoiceProcess;
import net.sourceforge.czt.circus.ast.InterleaveAction;
import net.sourceforge.czt.circus.ast.InterleaveProcess;
import net.sourceforge.czt.circus.ast.ParallelAction;
import net.sourceforge.czt.circus.ast.ParallelProcess;
import net.sourceforge.czt.circus.ast.ParamAction;
import net.sourceforge.czt.circus.ast.ParamProcess;
import net.sourceforge.czt.circus.ast.PrefixingAction;
import net.sourceforge.czt.circus.ast.Process2;
import net.sourceforge.czt.circus.ast.SeqAction;
import net.sourceforge.czt.circus.ast.SeqProcess;
import net.sourceforge.czt.circus.util.Factory;
import net.sourceforge.czt.z.ast.ApplExpr;
import net.sourceforge.czt.z.ast.Expr;
import net.sourceforge.czt.z.ast.Para;
import net.sourceforge.czt.z.ast.RefExpr;
import net.sourceforge.czt.z.ast.TupleExpr;
import net.sourceforge.czt.z.ast.VarDecl;
import net.sourceforge.czt.z.ast.ZExprList;
import net.sourceforge.czt.z.ast.ZParaList;

public class ParamProcessUtil {
	public boolean isEqualTo (VarDecl vardecl, RefExpr expr) {
		String strdecl = vardecl.getName().toString();
		String strexpr = expr.getName().toString();
		if (strdecl.equals(strexpr))
			return true;
		else return false;
	}
	public static Expr updateExpr (String namevar, Expr paramExpr, Expr targetExpr) { //TODO N�O TESTADO
		Factory f = new Factory ();
		if (targetExpr instanceof RefExpr) {
			String nameoldexpr = ((RefExpr)targetExpr).getName().toString();
			if (nameoldexpr.equals(namevar)) {
				return paramExpr;
			}
			else return targetExpr;
		}
		else if (targetExpr instanceof ApplExpr) {
			ApplExpr appl = (ApplExpr)targetExpr;
			appl.setLeftExpr(updateExpr (namevar, paramExpr, ((ApplExpr) targetExpr).getLeftExpr()));
			appl.setRightExpr(updateExpr (namevar, paramExpr, ((ApplExpr) targetExpr).getRightExpr()));
			return appl;
		}
		else if (targetExpr instanceof TupleExpr) {
			ZExprList exprList = ((TupleExpr)targetExpr).getZExprList();
			for (int i = 0; i < exprList.size(); i++) {
				exprList.set(i, updateExpr (namevar, paramExpr, exprList.get(i)));
			}
			((TupleExpr) targetExpr).setExprList(exprList);
			return targetExpr;
		}
		//else if () {} //OUTROS TIPOS DE EXPRESSÃO?
		else {
			return targetExpr;
		}
	}
	public static Expr updateExpr (List <VarDecl> decls, ZExprList paramExprs, Expr targetExpr) {
		Factory f = new Factory ();
		int size1 = decls.size();
		Expr oldexprAux = f.createRefExpr();
		for (int i = 0; i < size1; i++) {
			oldexprAux = updateExpr (decls.get(i).getName().toString(), paramExprs.get(i), targetExpr);
		}
		return oldexprAux;
	}
	public int searchIndex (List <VarDecl> oldExprs, Expr expr) {
		Object [] oldExprsArray = oldExprs.toArray();
		if (expr instanceof RefExpr) {
			String exprName = ((RefExpr)expr).getName().toString();
			for (int i = 0; i < oldExprsArray.length; i++) {
				VarDecl decl = (VarDecl) oldExprsArray [i];
				String declName = decl.getName().toString();
				if (declName.equals(exprName)) {
					return i;
				}
			}
			return -1;
		}
		else {
			return -1;
		}
	}
	//Tenho uma d�vida: As únicas construções Circus que armazenam expressões
		//Comunicações (Communication)
		//Atribuições (AssignmentCommand)
		//TODO mais alguma?? Se sim, implementar também abaixo
	static ParallelismFactory pf = new ParallelismFactory ();
	public static CircusAction updatedExpression (List <VarDecl> decls, ZExprList paramExprs, CircusAction action) { //TODO N�O TESTADO
		CircusAction auxaction = pf.createCircusAction (action);
		if (auxaction instanceof ParamAction) {
			CircusAction action2 = ((ParamAction)auxaction).getCircusAction();
			return updatedExpression (decls, paramExprs, action2);
		}
		else if (auxaction instanceof AssignmentCommand) {
			AssignmentPairs assPairs = ((AssignmentCommand)auxaction).getAssignmentPairs();
			ZExprList exprList = assPairs.getZRHS();
			for (int i = 0; i < exprList.size(); i++) {
				updateExpr (decls, paramExprs, exprList.get(i));
			}
			assPairs.setRHS(exprList);
			((AssignmentCommand)action).setAssignmentPairs(assPairs);
			return auxaction;
		}
		else if (auxaction instanceof Action2) {
			Action2 action2 = (Action2)auxaction;
			action2.setLeftAction(updatedExpression (decls, paramExprs, action2.getLeftAction()));
			action2.setRightAction (updatedExpression (decls, paramExprs, action2.getRightAction()));
			return action2;
		}
		else if (auxaction instanceof PrefixingAction) {
			Communication comm = ((PrefixingAction)auxaction).getCommunication();
			CircusFieldList cfl = comm.getCircusFieldList();
			int size = cfl.size();
			for (int i = 0; i < size; i++) {
				Field field = cfl.get(i);
				if (field instanceof DotField) {
					DotField dotfield = (DotField)field;
					Expr target = dotfield.getExpr();
					dotfield.setExpr(updateExpr (decls, paramExprs, target));
					field = dotfield;
				}
				cfl.set(i, field);
			}
			comm.setFieldList(cfl);
			((PrefixingAction) auxaction).setCommunication(comm);
			return auxaction;
		}
		else {
			return auxaction;
		}
	}
	public static void changeExpressions (List <VarDecl> decls, ZExprList paramExprs, CircusProcess process) {
		if (process instanceof ParamProcess) {
			CircusProcess process2 = ((ParamProcess)process).getCircusBasicProcess();
			changeExpressions (decls, paramExprs, process2);
		}
		else if (process instanceof BasicProcess) {
			ZParaList paras = ((BasicProcess)process).getZParaList();
			for (int i = 0; i < paras.size(); i++) {
				Para para = paras.get(i);
				if (para instanceof ActionPara) {
					CircusAction action = ((ActionPara)para).getCircusAction();
					updatedExpression (decls, paramExprs, action);
				}
			}
		}
		else if (process instanceof Process2) {
			Process2 process2 = (Process2)process;
			changeExpressions (decls, paramExprs, process2.getLeftProcess());
			changeExpressions (decls, paramExprs, process2.getRightProcess());
		}
	}
}