package jcircus.parallelism;

import java.math.BigInteger;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Vector;

import net.sourceforge.czt.circus.ast.Action1;
import net.sourceforge.czt.circus.ast.Action2;
import net.sourceforge.czt.circus.ast.ActionPara;
import net.sourceforge.czt.circus.ast.AssignmentPairs;
import net.sourceforge.czt.circus.ast.BasicProcess;
import net.sourceforge.czt.circus.ast.CallAction;
import net.sourceforge.czt.circus.ast.ChannelDecl;
import net.sourceforge.czt.circus.ast.ChannelPara;
import net.sourceforge.czt.circus.ast.ChannelSet;
import net.sourceforge.czt.circus.ast.ChaosAction;
import net.sourceforge.czt.circus.ast.CircusAction;
import net.sourceforge.czt.circus.ast.CircusActionList;
import net.sourceforge.czt.circus.ast.CircusProcess;
import net.sourceforge.czt.circus.ast.CommPattern;
import net.sourceforge.czt.circus.ast.CommUsage;
import net.sourceforge.czt.circus.ast.Communication;
import net.sourceforge.czt.circus.ast.ExtChoiceAction;
import net.sourceforge.czt.circus.ast.ExtChoiceActionIte;
import net.sourceforge.czt.circus.ast.FieldList;
import net.sourceforge.czt.circus.ast.GuardedAction;
import net.sourceforge.czt.circus.ast.HideAction;
import net.sourceforge.czt.circus.ast.IntChoiceAction;
import net.sourceforge.czt.circus.ast.IntChoiceActionIte;
import net.sourceforge.czt.circus.ast.InterleaveAction;
import net.sourceforge.czt.circus.ast.InterleaveActionIte;
import net.sourceforge.czt.circus.ast.MuAction;
import net.sourceforge.czt.circus.ast.OnTheFlyDefAnn;
import net.sourceforge.czt.circus.ast.ParAction;
import net.sourceforge.czt.circus.ast.ParProcess;
import net.sourceforge.czt.circus.ast.ParallelAction;
import net.sourceforge.czt.circus.ast.ParallelActionIte;
import net.sourceforge.czt.circus.ast.ParamProcess;
import net.sourceforge.czt.circus.ast.PrefixingAction;
import net.sourceforge.czt.circus.ast.ProcessPara;
import net.sourceforge.czt.circus.ast.RenameAction;
import net.sourceforge.czt.circus.ast.SeqAction;
import net.sourceforge.czt.circus.ast.SeqActionIte;
import net.sourceforge.czt.circus.ast.SkipAction;
import net.sourceforge.czt.circus.ast.StopAction;
import net.sourceforge.czt.circus.impl.CircusActionImpl;
import net.sourceforge.czt.circus.impl.ExtChoiceActionImpl;
import net.sourceforge.czt.circus.impl.PrefixingActionImpl;
import net.sourceforge.czt.circus.util.Factory;
import net.sourceforge.czt.util.Visitor;
import net.sourceforge.czt.z.ast.Expr;
import net.sourceforge.czt.z.ast.LatexMarkupPara;
import net.sourceforge.czt.z.ast.NarrPara;
import net.sourceforge.czt.z.ast.NarrSect;
import net.sourceforge.czt.z.ast.Para;
import net.sourceforge.czt.z.ast.ParaList;
import net.sourceforge.czt.z.ast.RefExpr;
import net.sourceforge.czt.z.ast.Spec;
import net.sourceforge.czt.z.ast.ZDeclList;
import net.sourceforge.czt.z.ast.ZExprList;
import net.sourceforge.czt.z.ast.ZName;
import net.sourceforge.czt.z.ast.ZNameList;
import net.sourceforge.czt.z.ast.ZParaList;
import net.sourceforge.czt.z.ast.ZSect;

import java.lang.*;

import javax.swing.JOptionPane;

import jcircus.environment.ChanInfoEnv;
import jcircus.environment.ProcChanEnv;

public class ParallelismVisitor {

	/*Atributos*/
	int counterHash = 0;
	static ParallelismFactory pf = new ParallelismFactory ();
	static HashMap <String, String> call2call = new LinkedHashMap <String, String> ();
	static HashMap <String, HashMap <String, FriendshipSets>> call2pfe = new HashMap <String, HashMap <String, FriendshipSets>> ();
	static String complementaryActionAnn = "complementaryAction";
	/*Atributos*/
	
	public boolean parallelismBeingUsed = false;
	public HiddenFromGUIInfo hid = new HiddenFromGUIInfo ();
	public ProcHiddenFromGUIEnv prochid = new ProcHiddenFromGUIEnv ();
	private void hiddenPut (String chan, Integer [] renamingIndexes) {
		String [] hidden = arrayOfChannels (chan, renamingIndexes);
		hid.put(chan, HiddenFromGUIInfo.toVector (hidden));
	}
	public static boolean isComplementaryActionPara (ActionPara para) {
		if (para.getCircusAction().getAnn(String.class).equals(complementaryActionAnn)) {
			return true;
		}
		return false;
	}
	public static boolean isMainActionPara (ActionPara para) {
		if (para.getName().toString().contains("MainAction") && para.getName().toString().contains("$$")) {
			return true;
		}
		return false;
	}
    private static boolean containsChannel (String channel, Object [] str) {
    	boolean aux = false;
    	for (int i = 0; i < str.length; i++) {
    		if (str [i] == channel) {
    			aux = true;
    		}
    	}
    	return aux;
    }
    private static String [] arrayOfChannels (String chanName, Integer [] x) {
    	String [] str = new String [x.length];
    	for (int i = 0; i < str.length; i++) {
    		str [i] = chanName + x [i];
    	}
    	return str;
    }
    private static Vector <String> vectorOfChannels (String chanName, Integer [] x) {
    	Vector <String> str = new Vector <String> ();
    	//String [] str = new String [x.length];
    	for (int i = 0; i < x.length; i++) {
    		str.addElement(chanName + x [i]);
    	}
    	return str;
    }
    public static boolean contains (String str, String [] strs) {
    	boolean aux = false;
    	for (int i = 0; i < strs.length; i++) {
    		if (strs [i].equals(str))
    			aux = true;
    	}
    	return aux;
    }
    
    private static boolean channelIsOnNameList (String channel, ZNameList channelList) {
    	boolean aux = false;
    	for (int i = 0; i < channelList.size(); i++) {
    		if (channelList.get(i).toString().equals(channel)) {
    			aux = true;
    		}
    	}
    	return aux;
    }
    public static boolean channelIsOnChannelDecl (String channel, ChannelDecl channelDecl) {
    	ZNameList nameList = channelDecl.getZChannelNameList();
    	return channelIsOnNameList (channel, nameList);
    }

    private boolean hasMainChannelOnDecl (String channel, ChannelDecl cdecl) {
    	boolean aux = false;
    	ZNameList names = cdecl.getZChannelNameList();
    	int size = names.size();
    	for (int i = 0; i < size; i++) {
    		String name = names.get(i).toString();
    		if (name.equals(this.hid.get(channel))) {
    			aux = true;
    		}
    	}
    	return aux;
    }

    private ChannelDecl updateChannelDecl (HashMap <String, FriendshipSets> map, Factory f, Expr expr, ChannelDecl cdecl) {
    	for (int k = 0; k < map.keySet().size(); k++) {
    		int iSize = map.get(map.keySet().toArray()[k]).getFriendshipSets().size();
    		HashMap <String, Integer []> mapstrint = FriendshipSets.renamingIndexes(map, k);

    		for (int i = 0; i < iSize; i++) {
    			Integer [] allindexes = objectToInteger (FriendshipSets.allIndexes((String) mapstrint.keySet().toArray() [k], map).toArray());
    			Object [] channelKeys = arrayOfChannels ((String) mapstrint.keySet().toArray() [k], allindexes);

    			hiddenPut ((String) mapstrint.keySet().toArray() [k], allindexes);

    			for (int j = 0; j < channelKeys.length; j++) {
    				if (!channelIsOnChannelDecl ((String)channelKeys [j], cdecl) && hasMainChannelOnDecl ((String)channelKeys [j], cdecl))
    					cdecl.getZChannelNameList().add(f.createZName((String)channelKeys [j]));
    			}
    			System.out.print("");
    		}
    	}
    	return cdecl;
    }
    public static String [] objectToString (Object [] o) {
    	String [] str = new String [o.length];
    	for (int i = 0; i < str.length; i++) {
    		str [i] = (String) o [i];
    	}
    	return str;
    }
    public static Integer [] objectToInteger (Object [] o) {
    	Integer [] str = new Integer [o.length];
    	for (int i = 0; i < str.length; i++) {
    		str [i] = (Integer) o [i];
    	}
    	return str;
    }
    private static Expr [] objectToExpr (Object [] o) {
    	Expr [] str = new Expr [o.length];
    	for (int i = 0; i < str.length; i++) {
    		str [i] = (Expr) o [i];
    	}
    	return str;
    }

    private void addAsPreviousActionPara (ActionPara para, ZParaList previousParas) { //TODO TESTAR!
    	//Adiciona a versão original do parágrafo de ação, a que estava antes da mudança por causa do paralelismo, caso ele exista. 
    		//A intenção aqui é permitir que um mesmo parágrafo de ação possa ser modificado mais de uma vez
    	Factory f = new Factory ();
    	ActionPara previous = f.createActionPara();
    	String name =
    		(para.getZName().toString().contains("mainAction") && !para.getZName().toString().contains("Previous"))?
    			  "MA"
    			: (para.getZName().toString().contains("mainAction"))? "PreviousMA" : para.getZName().toString();
    	previous.setName(f.createZName("Previous" + name));
    	previous.setCircusAction(/*pf.createCircusAction*/(para.getCircusAction()));
    	previousParas.add(previous);
    }

    public boolean needsParallelismRenamingMethod (CircusAction action, CircusProcess process, String actionName) {
    	action = CallUtil.expandAction (action, process, new Consumer (new Vector <String> ()));
		addAnnsToActionBranches (action, /*false,*/ process);
		HashMap <String, FriendshipSets> map = ultimateConstructFriendshipSets (action, process, actionName);
    	Vector <String> visibleChannels = getVisibleChannels (action, process, actionName);
    	boolean aux = false;
    	for (int i = 0; i < visibleChannels.size(); i++) {
        	if (map.get(visibleChannels.elementAt(i)).getFriendshipSets().size() > 1) {
        		aux = true;
        	}
    	}
    	removeAnnsFromActionBranches (action, process);
    	return aux;
    	/*if (action instanceof ParAction) {
    		CircusAction leftAction = ((ParAction)action).getLeftAction();
    		CircusAction rightAction = ((ParAction)action).getRightAction();    		
    		Vector <String> chanleft = getVisibleChannels (leftAction, process, actionName);
    		Vector <String> chanright = getVisibleChannels (rightAction, process, actionName);
    	}*/
    }

    public boolean needsParallelismRenamingMethod (CircusProcess process, Spec spec) {
    	CircusAction action = ParallelismProcessUtil.resultingMainAction2 (process, spec);
    	return needsParallelismRenamingMethod (action, process, "mainAction");
    	/*if (process instanceof BasicProcess) {
    		CircusAction action = ((BasicProcess)process).getMainAction();
    		return needsParallelismRenamingMethod (action, process, "mainAction");
    	}
    	else if (process instanceof ParProcess) {
    		
    	}*/
    }
    
    public void updateSpec (Spec spec) {
    	ZSect zSect;
    	if (spec.getSect().get(0) instanceof NarrSect)
    		zSect = (ZSect) spec.getSect().get(1);
    	else
    		zSect = (ZSect) spec.getSect().get(0);
        ZParaList paras = (ZParaList) zSect.getParaList();
		for (int i = 0; i < paras.size(); i++) {
			if (paras.get(i) instanceof ProcessPara) {
            	ProcessPara para = (ProcessPara) paras.get(i); //Aqui vai invocar os visitadores dos par�grafos que n�o forem narrativos (com texto), ou de tags de Latex
            	if (needsParallelismRenamingMethod (para.getCircusProcess(), spec)) {
            		parallelismBeingUsed = true;
            		para.setCircusProcess(ParallelismProcessUtil.transformToBasicProcess(para.getCircusProcess(), spec));
            		updateProcessPara (para, zSect);
            	}
            	System.out.print ("");
			}
        }
		System.out.print ("");
		//JOptionPane.showMessageDialog (null, "updateSpec terminado");
    }
    public void updateProcessPara (ProcessPara processPara, ZSect zSect) {
    	ZParaList paras = (ZParaList) zSect.getParaList();
    	ParallelismPrinter.printProcessPara(processPara);
    	Factory f = new Factory ();
    	ZParaList newParas = f.createZParaList();
    	ChannelDecl channelDecl = f.createChannelDecl();
    	HashMap <String, FriendshipSets> map = new HashMap <String, FriendshipSets> ();
    	ZParaList previousActionParas = f.createZParaList();
    	BasicProcess process = processPara.getCircusBasicProcess();
    	ParaList paraList = process.getParaList();
    	for (int i = 0; i < ((ZParaList)paraList).size(); i++) {
    		Para para = (Para) ((ZParaList) paraList).get(i);
    		if (para instanceof ActionPara) {
    			this.counterHash = 0;
    			CircusAction action = ((ActionPara)para).getCircusAction();
    			String actionName = ((ActionPara)para).getName().toString();
    			para = CallUtil.similarRecursiveActionPara ((ActionPara)para, process);
    			//CircusAction
    			//if (needsParallelismRenamingMethod (((ActionPara) para).getCircusAction(), process, ((ActionPara) para).getName().toString())) {
        			((ActionPara)para).setCircusAction(CallUtil.seqVersionOfAction(((ActionPara) para).getCircusAction()));    				
    			//}
    			//else {}
    			//((ActionPara)para).setCircusAction(CallUtil.seqVersionOfAction(((ActionPara) para).getCircusAction()));
    			((ZParaList) paraList).set(i, para);
    			addAsPreviousActionPara ((ActionPara)para, previousActionParas);
    	    	System.out.print("");
    		}
    	}
    	for (int i = 0; i < ((ZParaList)paraList).size(); i++) {
    		Para para = (Para) ((ZParaList) paraList).get(i);
    		if (para instanceof ActionPara) {
    			this.counterHash = 0;
    			CircusAction action = ((ActionPara)para).getCircusAction();
    			String actionName = ((ActionPara)para).getName().toString();
    			addAnnsToActionBranches (action, /*false,*/ process);
    			if (!actionName.contains("Previous")) {
    				map = ultimateConstructFriendshipSets (action, process, actionName);
        			CircusAction cA = updatedParAction (action, process, map, ((ActionPara)para).getName().toString(), newParas);
        			if (action instanceof ParAction)
        				((ActionPara)para).setCircusAction(cA);
    			}
    		}
    	}
    	System.out.print("");
    	for (int i = 0; i < newParas.size(); i++) {
    		Para para = (Para) newParas.get(i);
    		if (para instanceof ActionPara) {
    			this.counterHash = 0;
    			CircusAction action = ((ActionPara)para).getCircusAction();
    			String actionName = ((ActionPara)para).getName().toString();
    			map = ultimateConstructFriendshipSets (action, process, actionName);
    			
    			//action = CallUtil.seqVersionOfAction(action); //TODO descomentar, quem sabe

    			CircusAction cA = updatedParAction (action, process, map, ((ActionPara)para).getName().toString(), f.createZParaList());
    			if (action instanceof ParAction)
    				((ActionPara)para).setCircusAction(cA);
    			newParas.set(i, para);
    			System.out.print ("");
    		}
    	}
    	((ZParaList)paraList).addAll(previousActionParas);
    	System.out.print("");
		updateChannelDecls (processPara.getZName().toString(), paras, map);
    	//Atualiza os canais declarados na especifica��o.
    	ParallelismPrinter.printProcessPara(processPara);
    }

    private void updateChannelDecls (String proc, ZParaList paras, HashMap <String, FriendshipSets> map) {
    	Factory f = new Factory ();
    	Vector <String> allchannels = new Vector <String> ();
    	Vector <Expr> allexpressions = new Vector <Expr> ();
    	for (int i = 0; i < paras.size(); i++) {
    		Para para = paras.get(i);
    		if (para instanceof ChannelPara) {
    			ChannelPara para2 = (ChannelPara) para;
    			ZDeclList declList = para2.getZDeclList();
    			int size = declList.size();
    			Expr cDeclExpr = f.createRefExpr();
    			for (int j = 0; j < size; j++) {
    				ChannelDecl channelDecl2 = (ChannelDecl) declList.get(j);
    				cDeclExpr = channelDecl2.getExpr();
        			ZNameList genFormals = channelDecl2.getZGenFormals();
        			ZNameList channelNames = channelDecl2.getZChannelNameList();
					declList.set(0, updateChannelDecl (map, f, cDeclExpr, channelDecl2));
        			System.out.print("");
    			}
    			this.prochid.put(proc, this.hid);
    			this.hid = new HiddenFromGUIInfo ();
    			para2.setDeclList(declList);
    		}
    	}
		System.out.print("");
    }

    public static Vector <String> getVisibleChannels (CircusAction action, CircusProcess process, String actionParaName) {
		if (action instanceof PrefixingAction) {
			String chan = ((PrefixingAction)action).getCommunication().getChannelExpr().getName().toString();
			CircusAction ca = ((PrefixingAction)action).getCircusAction();
			Vector <String> vec = getVisibleChannels (ca, process, actionParaName);
			vec.add(chan);
			return vec;
		}
		else if (action instanceof Action2) {
			Vector <String> vec1 = getVisibleChannels (((Action2)action).getLeftAction(), process, actionParaName);
			Vector <String> vec2 = getVisibleChannels (((Action2)action).getRightAction(), process, actionParaName);
			vec1.addAll(vec2);
			return vec1;
		}
		else if (action instanceof Action1) {
			return getVisibleChannels (((Action1)action).getCircusAction(), process, actionParaName);			
		}
		/*else if (action instanceof GuardedAction) {
			return getVisibleChannels (((GuardedAction)action).getCircusAction(), process, actionParaName);
		}
		else if (action instanceof HideAction) {
			return getVisibleChannels (((HideAction)action).getCircusAction(), process, actionParaName);
		}*/
		else if (action instanceof CallAction) {
			CircusAction action2 = CallUtil.getContentOfCallAction (((CallAction)action), process);
			String newName = ((CallAction)action).getName().toString();
			if (newName.equals(actionParaName)) {
				return new Vector <String> ();
			}
			return getVisibleChannels (action2, process, newName);
		}
		else {
			return new Vector <String> ();
		}
	}

    public void removeAnnsFromActionBranches (CircusAction action, /*boolean extOrIntChoice,*/ CircusProcess process) {
    	if (action instanceof PrefixingAction) {
    		action.getAnns().remove(new Integer (this.counterHash));
    		CircusAction action2 = ((PrefixingAction)action).getCircusAction();
    		removeAnnsFromActionBranches (action2, /*false,*/ process);
    	}
    	else if (action instanceof CallAction) {
    		action.getAnns().remove(new Integer (this.counterHash));
    	}
    	else if (action instanceof Action2) {
    		removeAnnsFromActionBranches (((Action2)action).getLeftAction(), /*false,*/ process);
    		removeAnnsFromActionBranches (((Action2)action).getRightAction(), /*false,*/ process);
    	}
    }
    public void addAnnsToActionBranches (CircusAction action, /*boolean extOrIntChoice,*/ CircusProcess process) {
    	if (action instanceof PrefixingAction) {
    		action.getAnns().add(new Integer (this.counterHash));
    		CircusAction action2 = ((PrefixingAction)action).getCircusAction();
    		if (action2 instanceof ParAction)
    			this.counterHash++;
    		addAnnsToActionBranches (action2, /*false,*/ process);
    	}
    	else if (action instanceof CallAction) {
    		action.getAnns().add(new Integer (this.counterHash));
    		//CircusAction action2 = CallUtil.getContentOfCallAction (((CallAction)action), process);
    		//addAnnsToActionBranches (action2, extOrIntChoice, process);
    	}
    	/*else if (action instanceof Action1) {
    		action.getAnns().add(new Integer (this.counterHash));
    		CircusAction action2 = ((PrefixingAction)action).getCircusAction();
    		addAnnsToActionBranches (action2, false, process);
    	}*/
    	else if (action instanceof ParAction) {
    		addAnnsToActionBranches (((ParAction)action).getLeftAction(), /*false,*/ process);
    		this.counterHash++;
    		addAnnsToActionBranches (((ParAction)action).getRightAction(), /*false,*/ process);
    	}
    	else if (action instanceof ExtChoiceAction || action instanceof IntChoiceAction) {
    		addAnnsToActionBranches (((Action2)action).getLeftAction(), /*true,*/ process);
    		addAnnsToActionBranches (((Action2)action).getRightAction(), /*true,*/ process);
    	}
    	else if (action instanceof Action2) {
    		addAnnsToActionBranches (((Action2)action).getLeftAction(), /*false,*/ process);
    		addAnnsToActionBranches (((Action2)action).getRightAction(), /*false,*/ process);
    	}
    }
    public HashMap <String, FriendshipSets> ultimateConstructFriendshipSets (CircusAction action, CircusProcess process, String actionParaName) {
		if (action instanceof PrefixingAction) {
			HashMap <String, FriendshipSets> map = new HashMap <String, FriendshipSets> ();
			Vector <String> visibleChannels = getVisibleChannels (action, process, actionParaName);
			for (int i = 0; i < visibleChannels.size(); i++) {
				FriendshipSets pfe = new FriendshipSets ();
				HashSet <HashSet <Integer>> friendshipSets = new HashSet <HashSet <Integer>> ();
				HashSet <Integer> fSet = new HashSet <Integer> ();
				fSet.add(action.getAnn(Integer.class)/*this.counterHash*/); //Com counterHash = 0, o id da a��o � 0, e fSet fica com {0};
				friendshipSets.add(fSet); //Para o caso acima, aqui fica friendshipSets = {{0}}
				pfe.setFriendshipSets(friendshipSets);
				map.put(visibleChannels.elementAt(i), pfe); //Para o canal vis�vel "a", aqui temos map = "a" --> {{0}}
			}
			return map;
		}
		else if (action instanceof ExtChoiceAction) {
			HashMap <String, FriendshipSets> map = ultimateConstructFriendshipSets (((ExtChoiceAction) action).getLeftAction(), process, actionParaName);
			HashMap <String, FriendshipSets> mapRight = ultimateConstructFriendshipSets (((ExtChoiceAction) action).getRightAction(), process, actionParaName);
			map.putAll(mapRight);
			return map;
		}
		else if (action instanceof IntChoiceAction) {
			HashMap <String, FriendshipSets> map = ultimateConstructFriendshipSets (((IntChoiceAction) action).getLeftAction(), process, actionParaName);
			HashMap <String, FriendshipSets> mapRight = ultimateConstructFriendshipSets (((IntChoiceAction) action).getRightAction(), process, actionParaName);
			map.putAll(mapRight);
			return map;
		}
		else if (action instanceof ParAction) { //TESTADO
			HashMap <String, FriendshipSets> map = new HashMap <String, FriendshipSets> ();
			Vector <String> channelSet = ParallelismUtil.channelSet(action);
			CircusAction leftAction;
			CircusAction rightAction;
			if (action instanceof ParallelAction) {
				leftAction = ((ParallelAction)action).getLeftAction();
				rightAction = ((ParallelAction)action).getRightAction();
			}
			else {
				leftAction = ((InterleaveAction)action).getLeftAction();
				rightAction = ((InterleaveAction)action).getRightAction();
			}
			
			Vector <String> leftVisible = getVisibleChannels (leftAction, process, actionParaName);
			Vector <String> rightVisible = getVisibleChannels (rightAction, process, actionParaName);
			Vector <String> alreadySeen = new Vector <String> ();
			for (int i = 0; i < leftVisible.size(); i++) {
				String chan = leftVisible.elementAt(i);
				if (rightVisible.contains(chan) && !channelSet.contains(chan)) {
					if (!alreadySeen.contains(chan)) {
						alreadySeen.add(chan);
						HashMap <String, FriendshipSets> ucfsleft = ultimateConstructFriendshipSets (leftAction, process, actionParaName);
						HashMap <String, FriendshipSets> ucfsright = ultimateConstructFriendshipSets (rightAction, process, actionParaName);
						HashSet <HashSet <Integer>> leftSet = 
							ucfsleft.keySet().contains(chan)? ucfsleft.get(chan).getFriendshipSets() : new HashSet <HashSet <Integer>> ();
						HashSet <HashSet <Integer>> rightSet = 
							ucfsright.keySet().contains(chan)? ucfsright.get(chan).getFriendshipSets() : new HashSet <HashSet <Integer>> ();
						map.put(
								chan,
								new FriendshipSets (FriendshipSets.interleave (
									leftSet,//ultimateConstructFriendshipSets (leftAction, process, actionParaName).get(chan).getFriendshipSets(),
									rightSet//ultimateConstructFriendshipSets (rightAction, process, actionParaName).get(chan).getFriendshipSets()
									)));
					}
				}
				else if (rightVisible.contains(chan) && channelSet.contains(chan)) {
					if (!alreadySeen.contains(chan)) {
						alreadySeen.add(chan);
						map.put(
								chan,
								new FriendshipSets (FriendshipSets.cartesianProduct (
									ultimateConstructFriendshipSets (leftAction, process, actionParaName).get(chan).getFriendshipSets(),
									ultimateConstructFriendshipSets (rightAction, process, actionParaName).get(chan).getFriendshipSets())));
					}
				}
				else {
					if (!alreadySeen.contains(chan)) {
						alreadySeen.add(chan);
						map.put(
								chan,
								new FriendshipSets (ultimateConstructFriendshipSets (leftAction, process, actionParaName).get(chan).getFriendshipSets())
						);
					}
				}
			}
			for (int i = 0; i < rightVisible.size(); i++) {
				String chan = rightVisible.elementAt(i);
				if (leftVisible.contains(chan) && !channelSet.contains(chan)) {
					if (!alreadySeen.contains(chan)) {
						alreadySeen.add(chan);
						map.put(
								chan,
								new FriendshipSets (FriendshipSets.interleave (
									ultimateConstructFriendshipSets (leftAction, process, actionParaName).get(chan).getFriendshipSets(),
									ultimateConstructFriendshipSets (rightAction, process, actionParaName).get(chan).getFriendshipSets())));
					}
				}
				else if (leftVisible.contains(chan) && channelSet.contains(chan)) {
					if (!alreadySeen.contains(chan)) {
						alreadySeen.add(chan);
						map.put(
								chan,
								new FriendshipSets (FriendshipSets.cartesianProduct (
									ultimateConstructFriendshipSets (leftAction, process, actionParaName).get(chan).getFriendshipSets(),
									ultimateConstructFriendshipSets (rightAction, process, actionParaName).get(chan).getFriendshipSets())));
					}
				}
				else {
					if (!alreadySeen.contains(chan)) {
						alreadySeen.add(chan);
						map.put(
								chan,
								new FriendshipSets (ultimateConstructFriendshipSets (rightAction, process, actionParaName).get(chan).getFriendshipSets())
						);
					}					
				}
			}
			return map;
		}
		else if (action instanceof SeqAction) {
			HashMap <String, FriendshipSets> map = ultimateConstructFriendshipSets (((SeqAction) action).getLeftAction(), process, actionParaName);
			HashMap <String, FriendshipSets> mapRight = ultimateConstructFriendshipSets (((SeqAction) action).getRightAction(), process, actionParaName);
			map.putAll(mapRight);
			return map;
		}
		else if (action instanceof CallAction) {
			String newName = ((CallAction)action).getName().toString();
			if (newName.equals(actionParaName)) {
				return new HashMap <String, FriendshipSets> ();
			}
			CircusAction action2 = CallUtil.getContentOfCallAction (((CallAction)action), process);
			HashMap <String, FriendshipSets> map = ultimateConstructFriendshipSets (action2, process, actionParaName);
			return map;
		}
		/*else if (action instanceof Action1) { //TODO N�O TESTADO
			return ultimateConstructFriendshipSets (((Action1)action).getCircusAction(), process, actionParaName);
		}*/
		else if (action instanceof GuardedAction) {
			return ultimateConstructFriendshipSets (((GuardedAction)action).getCircusAction(), process, actionParaName);
		}
		else if (action instanceof MuAction) {
			return ultimateConstructFriendshipSets (((MuAction)action).getCircusAction(), process, actionParaName);
		}
		else if (action instanceof HideAction) {
			return ultimateConstructFriendshipSets (((HideAction)action).getCircusAction(), process, actionParaName);
		}
		
		else /*if (action instanceof SkipAction)*/ {
			return new HashMap <String, FriendshipSets> ();
		}
    }
	public static Integer [] indFromTo (int x, int y, Integer [] indexes) {
		int r1 = x, r2 = y - x + 1, counter = 0;
		Integer [] z = new Integer [r2];
		for (int i = r1; i < r2; i++) {
			z[i] = indexes [counter];
			counter++;
		}
		return z;
	}
	public static PrefixingAction prefixingActionWithRenamedComm (PrefixingAction pa, int index, Integer [] indexes, CircusAction action, CircusProcess process, HashMap <String, FriendshipSets> spfemap, String actionParaName, ZParaList paraList) {
		String name = pa.getCommunication().getChannelExpr().getName().toString();
		if (spfemap.get(name).getFriendshipSets().size() > 1) {
			return RenamingUtil.prefixingActionWithRenamedComm(pa, name + indexes [index], action, process, spfemap, actionParaName, paraList);
		}
		else
			return RenamingUtil.prefixingActionWithRenamedComm(pa, name, action, process, spfemap, actionParaName, paraList);			
	}

	public static CircusAction prefActToExtChoiceActWithRenamedComms (PrefixingAction pa, Integer [] indexes,
			/*Daqui para diante � apenas para colocar como parâmetro de updatedParAction*/
			CircusAction action, CircusProcess process, HashMap <String, FriendshipSets> spfemap, String actionParaName, ZParaList paraList
		) {
		int length = (indexes == null? 0 : indexes.length);
		if (length == 1) {
			return prefixingActionWithRenamedComm (pa, 0, indexes, action, process, spfemap, actionParaName, paraList);
		}
		if (length == 0) {
			return pa;
		}
		else {
			Factory f = new Factory ();
			ExtChoiceActionImpl eca = (ExtChoiceActionImpl) f.createExtChoiceAction();
			eca.setLeftAction (prefActToExtChoiceActWithRenamedComms (pa, indFromTo (0, length - 2, indexes), action, process, spfemap, actionParaName, paraList)); //-2 porque ele exclui o �ltimo do array, que tem �ndice "length - 1".
			eca.setRightAction (prefixingActionWithRenamedComm (pa, length - 1, indexes, action, process, spfemap, actionParaName, paraList));
			return eca;
		}
	}
	public static void addActionParaToProcess (ActionPara para, ZParaList paraList) {
		List actionParas = null;
		paraList.add(para);
		/*if (process instanceof BasicProcess) {
			actionParas = (List) ((BasicProcess)process).getZParaList();
			actionParas.add(para);
			((BasicProcess)process).setParaList((ParaList)actionParas);
		}
		if (process instanceof ParamProcess) { //TODO BLOCO N�O TESTADO
			actionParas = (List) ((ParamProcess)process).getCircusBasicProcess().getZParaList(); //TODO falta testar esta linha
			actionParas.add(para);
			((ParamProcess)process).getCircusBasicProcess().setParaList((ParaList)actionParas);
		}*/
	}
	public static CircusAction updatedParAction (CircusAction action, CircusProcess process, HashMap <String, FriendshipSets> spfemap, String actionParaName, ZParaList paraList) {
		//Transforma uma prefixing action em uma seqaction. Ex: a -> b -> c -> SKIP vira a -> SKIP ; b -> SKIP; c -> SKIP; SKIP
		Factory f = new Factory ();
		SeqAction seq = f.createSeqAction();
		if (action instanceof PrefixingAction) {
			int index = 0;
			if (action.getAnn(Integer.class) != null)
				index = action.getAnn(Integer.class);
			Communication c = ((PrefixingAction)action).getCommunication();
			CircusAction ca = ((PrefixingAction)action).getCircusAction();
			HashMap <String, Integer []> mapstrint = FriendshipSets.renamingIndexes(spfemap, index);
			String commName = c.getChannelExpr().getName().toString();
			Integer [] indexes = mapstrint.get(commName);

			CircusAction circusaction = prefActToExtChoiceActWithRenamedComms ((PrefixingAction)action, indexes, action, process, spfemap, actionParaName, paraList);
			return circusaction;
			/*String commName = c.getChannelExpr().getName().toString();
			Integer [] indexes = mapstrint.get(commName);
			seq.setLeftAction (
					prefActToExtChoiceActWithRenamedComms (
							f.createPrefixingAction (f.createSkipAction(), c),
							indexes
					)
			);
			seq.setRightAction(updatedParAction (ca, process, spfemap, actionParaName, paraList));
			seq.getAnns().addAll(action.getAnns());
			return seq;*/
		}
		else if (action instanceof ExtChoiceAction) { //CASO TESTADO, E FUNCIONANDO
			ExtChoiceAction eca = f.createExtChoiceAction();
			eca.getAnns().addAll(action.getAnns());
			eca.setLeftAction (updatedParAction (((ExtChoiceAction)action).getLeftAction(), process, spfemap, actionParaName, paraList));
			eca.setRightAction (updatedParAction (((ExtChoiceAction)action).getRightAction(), process, spfemap, actionParaName, paraList));
			return eca;
		}
		else if (action instanceof IntChoiceAction) { //AN�LOGO AO DE CIMA, PORTANTO TAMB�M EST� FUNCIONANDO
			IntChoiceAction ica = f.createIntChoiceAction();
			ica.getAnns().addAll(action.getAnns());
			ica.setLeftAction (updatedParAction (((IntChoiceAction)action).getLeftAction(), process, spfemap, actionParaName, paraList));
			ica.setRightAction (updatedParAction (((IntChoiceAction)action).getRightAction(), process, spfemap, actionParaName, paraList));
			return ica;	
		}
		else if (action instanceof ParallelAction) { //TESTADO
			ParallelAction pa = f.createParallelAction();
			pa.getAnns().addAll(action.getAnns());
			pa.setLeftAction (updatedParAction (((ParallelAction)action).getLeftAction(), process, spfemap, actionParaName, paraList));
			pa.setRightAction (updatedParAction (((ParallelAction)action).getRightAction(), process, spfemap, actionParaName, paraList));
			Vector <String> visibleChannels = getVisibleChannels (pa, process, actionParaName);
			pa.setChannelSet(((ParallelAction)action).getChannelSet());
			pa.setLeftNameSet(((ParallelAction)action).getLeftNameSet());
			pa.setRightNameSet(((ParallelAction)action).getRightNameSet());
			return pa;
		}
		else if (action instanceof InterleaveAction) { //TESTADO
			InterleaveAction ia = f.createInterleaveAction();
			ia.getAnns().addAll(action.getAnns());
			ia.setLeftAction (updatedParAction (((InterleaveAction)action).getLeftAction(), process, spfemap, actionParaName, paraList));
			ia.setRightAction (updatedParAction (((InterleaveAction)action).getRightAction(), process, spfemap, actionParaName, paraList));
			ia.setLeftNameSet(((InterleaveAction)action).getLeftNameSet());
			ia.setRightNameSet(((InterleaveAction)action).getRightNameSet());
			return ia;
		}
		else if (action instanceof SeqAction) { //TESTADO
			SeqAction sa = f.createSeqAction();
			sa.getAnns().addAll(action.getAnns());
			sa.setLeftAction (updatedParAction (((SeqAction)action).getLeftAction(), process, spfemap, actionParaName, paraList));
			sa.setRightAction (updatedParAction (((SeqAction)action).getRightAction(), process, spfemap, actionParaName, paraList));
			return sa;
		}
		else if (action instanceof CallAction) { //TESTADO
			CallAction actionLinha = f.createCallAction();
			String actionParaName2 = actionParaName.contains("mainAction")? "MainAction" : actionParaName;
			String actionLinhaName = ((CallAction)action).getName().toString();// + actionParaName2 + action.getAnn(Integer.class);
			actionLinha.setName(f.createZName(actionLinhaName));
			actionLinha.setExprList(f.createZExprList());
			CircusAction contentOfActionLinha = CallUtil.getContentOfCallAction ((CallAction)action, process);
			ActionPara paraLinha = f.createActionPara();
			paraLinha.setName(f.createZName (actionLinhaName));
			paraLinha.setCircusAction(contentOfActionLinha);
			addActionParaToProcess (paraLinha, paraList); //TESTADO
			return actionLinha;
		}
		else if (action instanceof GuardedAction) { //TODO n�o testado
			GuardedAction ga = f.createGuardedAction();
			ga.setPred(((GuardedAction)action).getPred());
			ga.setCircusAction(updatedParAction (((GuardedAction)action).getCircusAction(), process, spfemap, actionParaName, paraList));
			return ga;
		}
		else if (action instanceof HideAction) { //TODO OBS: QUANDO E SE O HIDING FOR IMPLEMENTADO, ESTA LINHA TAMBÉM TERÁ QUE ATUALIZAR O CHANNELSET DA HIDEACTION
			return updatedParAction (((HideAction)action).getCircusAction(), process, spfemap, actionParaName, paraList);
		}
		else if (action instanceof SkipAction) {
			SkipAction skp = f.createSkipAction();
			skp.getAnns().addAll(action.getAnns());
			return skp;
		}
		else if (action instanceof ChaosAction) {
			ChaosAction skp = f.createChaosAction();
			skp.getAnns().addAll(action.getAnns());
			return skp;
		}
		else if (action instanceof MuAction) { //TODO N�O TESTADO
			MuAction mu = f.createMuAction();
			mu.setName(((MuAction)action).getName());
			mu.setCircusAction(
				updatedParAction (((MuAction)action).getCircusAction(), process, spfemap, actionParaName, paraList)
				//((MuAction)action).getCircusAction()
			);
			return mu;
		}
		/*else if (action instanceof RenameAction) {
			AssignmentPairs ap = ((RenameAction)action).getAssignmentPairs();
			ZNameList lhs = ap.getZLHS();
			ZExprList rhs = ap.getZRHS();
			String strlhs = "";
			for (int i = 0; i < lhs.size(); i++) {
				
			}
		}*/
		else {
			if (action != null) {
				StopAction stp = f.createStopAction();
				stp.getAnns().addAll(action.getAnns());
				return stp;
			}
			else {
				return f.createSkipAction();
			}
		}
	}
}
	/*else if (action instanceof ExtChoiceActionIte) {
		ExtChoiceActionIte ecaIte = f.createExtChoiceActionIte();
		ecaIte.setDeclList(f.createZDeclList());
		ZDeclList list = ((ExtChoiceActionIte)action).getZDeclList();
		for (int i = 0; i < list.size(); i++) {
			ecaIte.getZDeclList().add(sequencedAction (list.get(i)));
		}
		return ecaIte;
	}
	else if (action instanceof IntChoiceActionIte) {
		IntChoiceActionIte icaIte = f.createIntChoiceActionIte();
		icaIte.setDeclList(((IntChoiceActionIte)action).getZDeclList()); //TODO ainda n�o sei se � assim
		return icaIte;
	}
	else if (action instanceof ParallelActionIte) { //TODO n�o testado
		ParallelActionIte paIte = f.createParallelActionIte();
		
		return paIte;
	}
	else if (action instanceof InterleaveActionIte) { //TODO n�o testado
		InterleaveActionIte iaIte = f.createInterleaveActionIte();

		return iaIte;
	}
	else if (action instanceof SeqActionIte) { //TODO n�o testado
		SeqActionIte saIte = f.createSeqActionIte();

		return saIte;
	}*/
	//f.createHideAction()
