package jcircus.parallelism;

import java.math.BigInteger;
import java.util.HashMap;
import java.util.Vector;

import javax.swing.JOptionPane;

import net.sourceforge.czt.circus.ast.BasicProcess;
import net.sourceforge.czt.circus.ast.CircusAction;
import net.sourceforge.czt.circus.ast.CircusProcess;
import net.sourceforge.czt.circus.ast.CommPattern;
import net.sourceforge.czt.circus.ast.CommUsage;
import net.sourceforge.czt.circus.ast.ExtChoiceAction;
import net.sourceforge.czt.circus.ast.IntChoiceAction;
import net.sourceforge.czt.circus.ast.ParallelAction;
import net.sourceforge.czt.circus.ast.PrefixingAction;
import net.sourceforge.czt.circus.util.Factory;

public class ParallelismTestBuilders {
	private static PrefixingAction buildSimplePrefixingAction (String communication) { //TESTADO, E FUNCIONANDO
		Factory f = new Factory ();
		PrefixingAction pa = f.createPrefixingAction();
		pa.setCommunication(f.createCommunication ());
		pa.getCommunication().setChannelExpr(f.createRefExpr());
		pa.getCommunication().getChannelExpr().setExprList(f.createZExprList());
		pa.getCommunication().getChannelExpr().setName(f.createZName(communication));
		pa.getCommunication().getChannelExpr().setExplicit(false); //n�o sei o que significa "explicit"
		pa.getCommunication().getChannelExpr().setMixfix(false); //n�o sei o que significa "mixfix"
		pa.getCommunication().setFieldList(f.createCircusFieldList());
		pa.getCommunication().setCommPattern (CommPattern.Synch);
		pa.getCommunication().setCommUsage (CommUsage.Normal);
		pa.getCommunication().setIndexed(false);
		pa.getCommunication().setMultiSych(new BigInteger ("0"));
		pa.setCircusAction(f.createSkipAction());
		return pa;
	}
	public static PrefixingAction buildLargerPrefixingAction (String [] str) { //TESTADO, E FUNCIONA
		Factory f = new Factory ();
		PrefixingAction [] pa = new PrefixingAction [str.length]; //f.createPrefixingAction();
		for (int i = 0; i < pa.length; i++) {
			pa [i] = f.createPrefixingAction();
			pa [i].setCommunication (buildSimplePrefixingAction (str [i]).getCommunication());
		}
		for (int i = 1; i < pa.length; i++) {
			pa [i - 1].setCircusAction(pa [i]);
		}
		pa [pa.length - 1].setCircusAction(f.createSkipAction());
		return pa [0];
	}
	public static ExtChoiceAction buildSimpleExtChoiceAction (String [] str1, String [] str2) { //TESTADO, E FUNCIONA
		Factory f = new Factory ();
		ExtChoiceAction eca = f.createExtChoiceAction();
		eca.setLeftAction(buildLargerPrefixingAction (str1));
		eca.setRightAction(buildLargerPrefixingAction (str2));
		return eca;
	}
	public static ExtChoiceAction buildLargerExtChoiceAction (String [][] str) { //FUNCIONA
		Factory f = new Factory ();
		ExtChoiceAction [] ecaArray = new ExtChoiceAction [str.length];
		for (int i = 0; i < ecaArray.length; i++) {
			ecaArray [i] = f.createExtChoiceAction();
			ecaArray [i].setLeftAction(buildLargerPrefixingAction (str [i]));
		}
		for (int i = 1; i < ecaArray.length; i++) {
			ecaArray [i - 1].setRightAction(ecaArray [i]);
		}
		return ecaArray [0];
	}
	public static IntChoiceAction buildSimpleIntChoiceAction (String [] str1, String [] str2) { //TESTADO, E FUNCIONA
		Factory f = new Factory ();
		IntChoiceAction eca = f.createIntChoiceAction();
		eca.setLeftAction(buildLargerPrefixingAction (str1));
		eca.setRightAction(buildLargerPrefixingAction (str2));
		return eca;
	}
	public static IntChoiceAction buildLargerIntChoiceAction (String [][] str) { //FUNCIONA
		Factory f = new Factory ();
		IntChoiceAction [] ecaArray = new IntChoiceAction [str.length];
		for (int i = 0; i < ecaArray.length; i++) {
			ecaArray [i] = f.createIntChoiceAction();
			ecaArray [i].setLeftAction(buildLargerPrefixingAction (str [i]));
		}
		for (int i = 1; i < ecaArray.length; i++) {
			ecaArray [i - 1].setRightAction(ecaArray [i]);
		}
		return ecaArray [0];
	}
	public static ParallelAction buildSimpleParallelAction (String [] str1, String [] str2) { //TESTADO, E FUNCIONA
		Factory f = new Factory ();
		ParallelAction eca = f.createParallelAction();
		eca.setLeftAction(buildLargerPrefixingAction (str1));
		eca.setRightAction(buildLargerPrefixingAction (str2));
		return eca;
	}
	public static ParallelAction buildLargerParallelAction (String [][] str) { //FUNCIONA
		Factory f = new Factory ();
		ParallelAction [] ecaArray = new ParallelAction [str.length];
		for (int i = 0; i < ecaArray.length; i++) {
			ecaArray [i] = f.createParallelAction();
			ecaArray [i].setLeftAction(buildLargerPrefixingAction (str [i]));
		}
		for (int i = 1; i < ecaArray.length; i++) {
			ecaArray [i - 1].setRightAction(ecaArray [i]);
		}
		return ecaArray [0];
	}
/**/
	public static void opPrintAction (CircusAction action) {
		JOptionPane.showMessageDialog (null, ParallelismPrinter.printAction (action));
		//System.out.println (printAction (action) + "\n\n");
	}
	public static void main (String [] args) {
		Factory f = new Factory ();
		PrefixingAction pa = buildSimplePrefixingAction ("a");
		Integer [] indexes = new Integer [4];
		indexes [0] = 0; indexes [1] = 2; indexes [2] = 4; indexes [3] = 6;
		HashMap <String, FriendshipSets> map = new HashMap <String, FriendshipSets> ();
		//CircusAction result = makeTreeRecursively (pa, indexes);
		//CircusAction result = (new ParallelismVisitor()).prefActToExtChoiceActWithRenamedComms (pa, indexes);

		CircusProcess process = f.createBasicProcess();
		((BasicProcess) process).setParaList(f.createZParaList());

		//CircusAction result2 = (new ParallelismVisitor()).updatedAction (pa, process, new HashMap <String, ProcFriendshipEnv> ()); //Testa o primeiro if de sequencedAction

		String [] str = new String [4]; str [0] = "a"; str [1] = "b"; str [2] = "c"; str [3] = "d";
		String [] str2 = new String [4]; str2 [0] = "e"; str2 [1] = "f"; str2 [2] = "g"; str2 [3] = "h";
		String [][] strn = new String [4][4];
		strn [0][0] = "a1"; strn [0][1] = "b1"; strn [0][2] = "c1"; strn [0][3] = "d1";
		strn [1][0] = "a2"; strn [1][1] = "b2"; strn [1][2] = "c2"; strn [1][3] = "d2";
		strn [2][0] = "a3"; strn [2][1] = "b3"; strn [2][2] = "c3"; strn [2][3] = "d3";
		strn [3][0] = "a4"; strn [3][1] = "b4"; strn [3][2] = "c4"; strn [3][3] = "d4";

		CircusAction result3 = ParallelismTestBuilders.buildLargerPrefixingAction (str); //Testa o método buildLargerPrefixingAction. Constr�i a -> b -> c -> d -> SKIP
		//CircusAction result4 = (new ParallelismVisitor()).updatedAction (result3, process, new HashMap <String, ProcFriendshipEnv> ()); //Testa mais robustamente o primeiro if de sequencedAction
		CircusAction result5 = ParallelismTestBuilders.buildSimpleExtChoiceAction (str, str2); //Testa mais robustamente o primeiro if de sequencedAction
		CircusAction result6 = ParallelismTestBuilders.buildLargerExtChoiceAction (strn); //Testa mais robustamente o primeiro if de sequencedAction		
		//CircusAction result7 = (new ParallelismVisitor()).updatedAction (result6, process, new HashMap <String, ProcFriendshipEnv> ()); //Testa mais robustamente o primeiro if de sequencedAction		
		//Vector <String> vec = getVisibleChannels (result6, process, "");
		System.out.println ();
	}
}
