package jcircus.parallelism;

import java.util.Vector;

import javax.swing.JOptionPane;

import net.sourceforge.czt.circus.ast.ActionPara;
import net.sourceforge.czt.circus.ast.AssignmentPairs;
import net.sourceforge.czt.circus.ast.BasicProcess;
import net.sourceforge.czt.circus.ast.CallAction;
import net.sourceforge.czt.circus.ast.CallProcess;
import net.sourceforge.czt.circus.ast.ChannelSet;
import net.sourceforge.czt.circus.ast.ChaosAction;
import net.sourceforge.czt.circus.ast.CircusAction;
import net.sourceforge.czt.circus.ast.CircusProcess;
import net.sourceforge.czt.circus.ast.ExtChoiceAction;
import net.sourceforge.czt.circus.ast.ExtChoiceProcess;
import net.sourceforge.czt.circus.ast.GuardedAction;
import net.sourceforge.czt.circus.ast.HideAction;
import net.sourceforge.czt.circus.ast.HideProcess;
import net.sourceforge.czt.circus.ast.IntChoiceAction;
import net.sourceforge.czt.circus.ast.IntChoiceProcess;
import net.sourceforge.czt.circus.ast.MuAction;
import net.sourceforge.czt.circus.ast.ParAction;
import net.sourceforge.czt.circus.ast.ParProcess;
import net.sourceforge.czt.circus.ast.ParamProcess;
import net.sourceforge.czt.circus.ast.PrefixingAction;
import net.sourceforge.czt.circus.ast.ProcessPara;
import net.sourceforge.czt.circus.ast.RenameAction;
import net.sourceforge.czt.circus.ast.RenameProcess;
import net.sourceforge.czt.circus.ast.SeqAction;
import net.sourceforge.czt.circus.ast.SeqProcess;
import net.sourceforge.czt.circus.ast.SkipAction;
import net.sourceforge.czt.circus.ast.StopAction;
import net.sourceforge.czt.z.ast.ZNameList;
import net.sourceforge.czt.z.ast.ZParaList;

public class ParallelismPrinter {
	public static String printCalls (CircusAction action, CircusProcess process) {
		Vector <String> callsvec = CallUtil.recursiveCalls (/*action, */process);
		String str = "Action: " + printAction (action) + "\nCalls: ";
		for (int i = 0; i < callsvec.size(); i++) {
			str = str + callsvec.elementAt(i) + ", ";
		}
		return str;
	}
	public static void printCallsPane (CircusAction action, CircusProcess process) {
		JOptionPane.showMessageDialog (null, printCalls (action, process));
	}
	public static String printBasicProcess (BasicProcess process) { //OBS: Este m�todo pode ser aprimorado tbm para imprimir a��es de esquema e estados 
		String str = "";
		str = str + "begin\n";
		ZParaList paraList = process.getZParaList();
		for (int i = 0; i < paraList.size(); i++) {
			if (paraList.get(i) instanceof ActionPara) {
				ActionPara para = (ActionPara) paraList.get(i);
				//if (!para.getName().toString().contains("mainAction")) {
					str = str + "          " + para.getName().toString() + " ^= " + printAction (para.getCircusAction()) + "\n";
				//}
				/*else {
					str = str + "          " + "@ " + printAction (para.getCircusAction()) + "\n";
				}*/
			}
		}
		str = str + "end\n";
		return str;
	}
	public static String printParamProcess (ParamProcess process) { //TODO
		return "";
	}
	public static String processParaString (ProcessPara processPara) {
		String str = "";
		str = str + "process " + processPara.getName().toString() + " ^= " + printProcess (processPara.getCircusBasicProcess());
		return str;
	}
	public static void printProcessPara (ProcessPara processPara) {
		System.out.println (processParaString (processPara));
		JOptionPane.showMessageDialog (null, processParaString (processPara));
	}
	public static String printActionPara (ActionPara actionPara) {
		return actionPara.getName().toString() + " ^= " + printAction (actionPara.getCircusAction()) + "\n";
	}
	/*public static String printChannelSet (ChannelSet set) {
		//set.
	}*/
	public static String printAction (CircusAction action) {
		String str = "";
		if (action instanceof ExtChoiceAction) {
			return "(" + printAction (((ExtChoiceAction)action).getLeftAction()) + " [] " + printAction (((ExtChoiceAction)action).getRightAction()) + ")";
		}
		else if (action instanceof IntChoiceAction) {
			return "(" + printAction (((IntChoiceAction)action).getLeftAction()) + " |~| " + printAction (((IntChoiceAction)action).getRightAction()) + ")";
		}
		else if (action instanceof SeqAction) {
			return "(" + printAction (((SeqAction)action).getLeftAction()) + " ; " + printAction (((SeqAction)action).getRightAction()) + ")";
		}
		else if (action instanceof ParAction) {
			return "(" + printAction (((ParAction)action).getLeftAction()) + " || " + printAction (((ParAction)action).getRightAction()) + ")";
		}
		else if (action instanceof PrefixingAction) {
			String commName = ((PrefixingAction)action).getCommunication().getChannelExpr().getName().toString();
			return commName + " -> " + printAction (((PrefixingAction)action).getCircusAction());
		}
		else if (action instanceof GuardedAction) {
			return "((PREDICADO) & " + printAction (((GuardedAction)action).getCircusAction()) + ")";
		}
		else if (action instanceof MuAction) {
			return "u" + ((MuAction)action).getName().toString() + " @ " + printAction (((MuAction)action).getCircusAction());
		}
		else if (action instanceof HideAction) {
			return "(" + printAction (((HideAction)action).getCircusAction()) + ")";
		}
		else if (action instanceof SkipAction) {
			return "SKIP";
		}
		else if (action instanceof StopAction) {
			return "STOP";
		}
		else if (action instanceof ChaosAction) {
			return "CHAOS";
		}
		else if (action instanceof CallAction) {
			return ((CallAction)action).getZName().toString();
		}
		else if (action instanceof RenameAction) {
			return printAction (((RenameAction)action).getCircusAction()) + printAssignmentPairs (((RenameAction)action).getAssignmentPairs());
		}
		else {
			return "";//action.getClass().toString();
		}
	}
	public static String printProcess (CircusProcess process) {
		String str = "";
		if (process instanceof ExtChoiceProcess) {
			return "(" + printProcess (((ExtChoiceProcess)process).getLeftProcess()) + " [] " + printProcess (((ExtChoiceProcess)process).getRightProcess()) + ")";
		}
		else if (process instanceof IntChoiceProcess) {
			return "(" + printProcess (((IntChoiceProcess)process).getLeftProcess()) + " |~| " + printProcess (((IntChoiceProcess)process).getRightProcess()) + ")";
		}
		else if (process instanceof SeqProcess) {
			return "(" + printProcess (((SeqProcess)process).getLeftProcess()) + " ; " + printProcess (((SeqProcess)process).getRightProcess()) + ")";
		}
		else if (process instanceof ParProcess) {
			return "(" + printProcess (((ParProcess)process).getLeftProcess()) + " || " + printProcess (((ParProcess)process).getRightProcess()) + ")";
		}
		else if (process instanceof HideProcess) {
			return "(" + printProcess (((HideProcess)process).getCircusProcess()) + ")";
		}
		else if (process instanceof CallProcess) {
			return ((CallProcess)process).getCallExpr().getZName().toString();
		}
		else if (process instanceof RenameProcess) {
			return printProcess (((RenameProcess)process).getCircusProcess()) + printAssignmentPairs (((RenameProcess)process).getAssignmentPairs());
		}
		else if (process instanceof BasicProcess) {
			return printBasicProcess ((BasicProcess)process);
		}
		else {
			return "";//action.getClass().toString();
		}
	}
	public static String printAssignmentPairs (AssignmentPairs ap) {
		ZNameList lhs = (ZNameList) ap.getLHS();
		ZNameList rhs = (ZNameList) ap.getRHS();
		String str = "";
		for (int i = 0; i < lhs.size(); i++) {
			str = str + lhs.get(i).toString() + " <- " + rhs.get(i).toString();
			if (i < lhs.size() - 1) {
				str = str + ", ";
			}
		}
		return str;
	}
	public static String printAnns4Action (CircusAction action) { //TODO ERRADO
		String str = "";
		if (action instanceof ExtChoiceAction) {
			return "(" + printAnns4Action (((ExtChoiceAction)action).getLeftAction()) + " [] " + printAnns4Action (((ExtChoiceAction)action).getRightAction()) + ")";
		}
		else if (action instanceof IntChoiceAction) {
			return "(" + printAnns4Action (((IntChoiceAction)action).getLeftAction()) + " |~| " + printAnns4Action (((IntChoiceAction)action).getRightAction()) + ")";
		}
		else if (action instanceof SeqAction) {
			return "(" + printAnns4Action (((SeqAction)action).getLeftAction()) + " ; " + printAnns4Action (((SeqAction)action).getRightAction()) + ")";
		}
		else if (action instanceof ParAction) {
			return "(" + printAnns4Action (((ParAction)action).getLeftAction()) + " || " + printAnns4Action (((ParAction)action).getRightAction()) + ")";
		}
		else if (action instanceof PrefixingAction || action instanceof CallAction) {
			return " " + action.getAnn(Integer.class) + " ";
		}
		else if (action instanceof GuardedAction) {
			return "(" + printAction (((GuardedAction)action).getCircusAction()) + ")";
		}
		else if (action instanceof HideAction) {
			return "(" + printAction (((HideAction)action).getCircusAction()) + ")";
		}
		else if (action instanceof SkipAction) {
			return "SKIP";
		}
		else if (action instanceof ChaosAction) {
			return "CHAOS";
		}
		else {
			return "STOP";
		}
	}
}
