package jcircus.parallelism;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Vector;

public class HiddenFromGUIInfo {
	private HashMap <String, String> map;
	private HashMap <String, Vector <String>> reversemap;
	private HashMap <String, Boolean> hasHidden;
	private HashMap <String, Boolean> putChannelsDecl;
	private HashMap <String, Boolean> putChannelsAtt;
	private HashMap <String, Boolean> putChannelsActionPerformed;
	
	public void putPutDecl (String chan, Boolean put) {
		if (putChannelsDecl.containsKey(chan))
			this.putChannelsDecl.remove(chan);
		this.putChannelsDecl.put(chan, put);
	}
	public Boolean getPutDecl (String chan) {
		if (this.putChannelsDecl.get(chan) == null) {
			return false;
		}
		return this.putChannelsDecl.get(chan);
	}

	public void putPutAtt (String chan, Boolean put) {
		if (putChannelsAtt.containsKey(chan))
			this.putChannelsAtt.remove(chan);
		this.putChannelsAtt.put(chan, put);
	}
	public Boolean getPutAtt (String chan) {
		if (this.putChannelsAtt.get(chan) == null) {
			return false;
		}
		return this.putChannelsAtt.get(chan);
	}

	public void putPutActionPerformed (String chan, Boolean put) {
		if (putChannelsActionPerformed.containsKey(chan))
			this.putChannelsActionPerformed.remove(chan);
		this.putChannelsActionPerformed.put(chan, put);
	}
	public Boolean getPutActionPerformed (String chan) {
		if (this.putChannelsActionPerformed.get(chan) == null) {
			return false;
		}
		return this.putChannelsActionPerformed.get(chan);
	}

	private Vector <String> mainChannels = new Vector <String> ();
	private Vector <String> coadjChannels = new Vector <String> ();
	public HiddenFromGUIInfo () {
		this.map = new LinkedHashMap <String, String> ();
		this.reversemap = new LinkedHashMap <String, Vector <String>> ();
		this.hasHidden = new LinkedHashMap <String, Boolean> ();
		this.putChannelsDecl = new LinkedHashMap <String, Boolean> ();
		this.putChannelsAtt = new LinkedHashMap <String, Boolean> ();
		this.putChannelsActionPerformed = new LinkedHashMap <String, Boolean> ();
	}
	private void putMainChannel (String mainChannel) {
		if (!mainChannels.contains(mainChannel))
			mainChannels.add(mainChannel);
	}
	private void putCoadjChannel (String coadj) {
		if (!coadjChannels.contains(coadj))
			coadjChannels.add(coadj);		
	}
	public Vector <String> getMainChannels () {
		return this.mainChannels;
	}
	public Vector <String> getCoadjChannels () {
		return this.coadjChannels;
	}
	public void put (String hidden, String chan) {
		putMainChannel (chan);
		putCoadjChannel (hidden);
		if (!this.map.containsKey(hidden))
			this.map.put(hidden, chan);
	}
	public String get (String hidden) {
		return this.map.get(hidden);
	}
	public HashMap <String, String> getMap () {
		return this.map;
	}
	private void addWithoutDuplicate (Vector <String> target, Vector <String> add) {
		for (int i = 0; i < add.size(); i++) {
			if (!target.contains(add.elementAt(i))) {
				target.addElement(add.elementAt(i));
			}
		}
	}
	public void reversePut (String chan, Vector <String> hidden) {
		if (this.mainChannels.contains(chan)) {
			Vector <String> newhid = new Vector <String> ();
			if (this.reverseGet(chan) != null)
				newhid.addAll(this.reverseGet(chan));
			addWithoutDuplicate (newhid, hidden);
			this.reversemap.remove(chan);
			this.reversemap.put(chan, newhid);
		}
		else {
			this.reversemap.put(chan, hidden);
		}
	}
	public Vector <String> reverseGet (String chan) {
		Vector <String> reverseget = this.reversemap.get(chan);
		if (reverseget == null) {
			//Se reverseget for vazio, 
				//significa que o canal não tem canais coadjuvantes, e portanto não foi renomeado. 
				//Isso tudo significa que ele não precisou de intercalação forçada. Retornamos um vector com o seu nome por facilidade de implementação
			Vector <String> itself = new Vector <String> ();
			itself.addElement(chan);
			return itself;
		}
		else
			return reverseget;
	}
	public void put (String chan, Vector <String> hidden) {
		int vecsize = hidden.size();
		for (int i = 0; i < vecsize; i++) {
			this.put(hidden.elementAt (i), chan);
			this.reversePut(chan, hidden);
		}
		this.hasHidden.put(chan, true);
	}
	public boolean hiddenGet (String chan) {
		if (hasHidden.containsKey(chan))
			return hasHidden.get(chan);
		else {
			return false;
		}
	}
	public static Vector <String> toVector (String [] s) {
		Vector <String> vec = new Vector <String> ();
		for (int i = 0; i < s.length; i++) {
			vec.add(s [i]);
		}
		return vec;
	}
	public static String hiddenSyncCode (Vector <String> hiddenChans, String dimCode, String syncKind) {
		String str = "";
		for (int i = 0; i < hiddenChans.size(); i++) {
			str = str + 
				"\t\tCSProcess p_" + hiddenChans.elementAt(i) +
				" = new CSProcess () {public void run () {" + hiddenChans.elementAt(i) + "" + dimCode + "." + syncKind + ";}};\n";
		}
		//str = str +
			//"\t\t(new Parallel (new CSProcess [] {";
		for (int i = 0; i < hiddenChans.size(); i++) {
			str = str + 
			"		p_" + hiddenChans.elementAt(i) + "";
			//if (i != hiddenChans.size() - 1)
				str = str + ".run();\n";
		}
		//str = str + "})).run ();";
		return str;
	}
}
