package jcircus.newfrontendmethod;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Vector;

public class FrontEndMap {
	HashMap <String, Integer> counter;
	public FrontEndMap () {
		counter = new LinkedHashMap <String, Integer> ();
	}
	public void put (String channel) {
		Integer xis;
		if (this.counter.containsKey (channel)) {
			xis = this.counter.get(channel);
			this.counter.remove(channel);
			this.counter.put(channel, xis + 1);
		}
		else {
			this.counter.put(channel, 1);
		}
	}
	private void put (String channel, Integer x) {
		if (this.counter.containsKey (channel)) {
			this.counter.remove(channel);
		}
		this.counter.put(channel, x);
	}
	public Integer get (String channel) {
		if (this.counter.containsKey (channel))
			return this.counter.get(channel);
		else return new Integer (0);
	}
	public HashMap <String, Integer> getMap () {
		return this.counter;
	}
	private static Object [] withoutDuplicates (Object [] keys1, Object [] keys2) {
		Vector <Object> keysall = new Vector <Object> (); //new Object [keys1.length + keys2.length];
		for (int i = 0; i < keys1.length; i++) {
			keysall.addElement(keys1 [i]);
		}
		for (int i = 0; i < keys2.length; i++) {
			if (!keysall.contains (keys2 [i]))
				keysall.addElement(keys2 [i]);
		}
		return keysall.toArray();
	}
	public static FrontEndMap mergeParallel (FrontEndMap fem1, FrontEndMap fem2) {
		FrontEndMap fem = new FrontEndMap ();
		Object [] keys1 = fem1.getMap().keySet().toArray();
		Object [] keys2 = fem2.getMap().keySet().toArray();
		Object [] keysall = withoutDuplicates (keys1, keys2);
		for (int i = 0; i < keysall.length; i++) {
			Integer x1 = fem1.get((String) keysall [i]);
			Integer x2 = fem2.get((String) keysall [i]);
			fem.put((String)keysall [i], x1 + x2);
		}
		return fem;
	}
	public static void main (String args []) { //TESTE DE mergeParallel e mergeNormal
		FrontEndMap fem1 = new FrontEndMap ();
		FrontEndMap fem2 = new FrontEndMap ();
		FrontEndMap femparallel = new FrontEndMap ();
		FrontEndMap femnormal = new FrontEndMap ();
		fem1.put("a");
		fem1.put("a");
		fem1.put("a");
		fem1.put("b");
		fem1.put("b");
		fem2.put("a");
		fem2.put("a");
		fem2.put("b");
		femnormal = mergeNormal (fem1, fem2);
		femparallel = mergeParallel (fem1, fem2);
		System.out.println ("MergeNormal = \n" + frontEndMapAsString (femnormal)); //Como esperado
		System.out.println ("MergeParallel = \n" + frontEndMapAsString (femparallel)); //Como esperado
	}
	private static String frontEndMapAsString (FrontEndMap fem) {
		String str = "FrontEndMap {\n";
		Object [] allkeys = fem.getMap().keySet().toArray();
		for (int i = 0; i < allkeys.length; i++) {
			str = str + "	" + (String) allkeys [i] + " --> " + fem.get((String)allkeys [i]) + "\n";
		}
		str = str + "}";
		return str;
	}
	public static FrontEndMap mergeNormal (FrontEndMap fem1, FrontEndMap fem2) {
		FrontEndMap fem = new FrontEndMap ();
		Object [] keys1 = fem1.getMap().keySet().toArray();
		Object [] keys2 = fem2.getMap().keySet().toArray();
		Object [] keysall = withoutDuplicates (keys1, keys2);
		for (int i = 0; i < keysall.length; i++) {
			Integer x1 = fem1.get((String) keysall [i]);
			Integer x2 = fem2.get((String) keysall [i]);
			fem.put((String)keysall [i], (x1 > x2)? x1 : x2);
		}
		return fem;
	}
}
