package jcircus.newfrontendmethod;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

import jcircus.complementaryenvs.ChanDimEnv;
import jcircus.environment.ChanInfoEnv;
import jcircus.environment.ChanUseEnv;
import jcircus.environment.ProcChanEnv;
import jcircus.environment.ProcChanUseEnv;
import jcircus.exceptions.JCircusException;
import jcircus.util.Constants;
import jcircus.util.ProcInfo;
import jcircus.util.Util;
import jcircus.visitor.EnvLoadingVisitor;
import net.sourceforge.czt.circus.ast.CircusProcess;
import net.sourceforge.czt.circus.ast.ParamProcess;
import net.sourceforge.czt.circus.ast.ProcessPara;

public class FrontEndMainClassGenerator {
	EnvLoadingVisitor elv;
	boolean useBarriers = true;
	ChanDimEnv updatedChanDimEnv;
	public FrontEndMainClassGenerator (EnvLoadingVisitor elv, boolean useBarriers, ChanDimEnv updatedChanDimEnv) {
		this.elv = elv;
		this.useBarriers = useBarriers;
		this.updatedChanDimEnv = updatedChanDimEnv;
	}
    private String cspProcessCallCode(String name, String paramsCode) {
        return "new " + name + "(" + paramsCode + ")";
    }
    public static String brackets (int dim) {
        String r = "";
        for (int i = 0; i < dim; i++) {
            r = r + "[]";
        }
        return r;
    }
    private String channelCode(String channelName, Integer procId, ProcChanUseEnv chanMSEnv) {
        String code = "";
        String toChannel = "to_" + channelName;
        String fromChannel = "from_" + channelName;
        String chanInfo = "chanInfo_" + channelName;
        /**
         * The variables in the
         *
         */
        if (chanMSEnv.isMultiSync()) {
            if (!useBarriers) {
        		code = code + "org.jcsp.lang.Any2OneChannel[] " + fromChannel + " = org.jcsp.lang.Channel.any2oneArray (" + chanMSEnv.getCardinality() + ");\n		"; //Sam's, JCSP novo
        	}
        }
        if (!useBarriers) {
        	code = code + "org.jcsp.lang.Any2OneChannel " + toChannel + " = org.jcsp.lang.Channel.any2one ();\n		"; //Sam's, JCSP novo
        }
        List<Integer> ids = Util.resolveUndefinedChannels(chanMSEnv, true/*, channelName, this.getProcProcessParaEnv()*/); //By Angela Freitas
        code = code + Constants.CLS_CHINFO + " " + chanInfo + " = new " + Constants.CLS_CHINFO + "();\n		";
        /*for (int i = 0; i < ids.size(); i++) { //This loop was implemented by Angela Freitas
            Integer subProcId = (Integer) ids.get(i);
            code = code + chanInfo + ".put(new Integer(" + subProcId + "), new Integer(" + i + "));\n		";
        }*/
        for (int i = 0; i < ids.size(); i++) { //This loop was implemented by Samuel Barrocas, in 16/12/2010, 18:07hs
        	//System.out.println ("ids.size == " + ids.size());
            Integer subProcId = (Integer) ids.get(i);/*.get(j);*/
            code = code + chanInfo + ".put(new Integer(" + subProcId + "), new Integer(" + i + "));/*" + i + "*/\n		";
        }
        // general channel
        if (chanMSEnv.isMultiSync()) {
            // multisynchronization
        	code = code + "/*" + channelName + " é um canal multisincronizado!*/ \n";
        	int dimChannel = this.updatedChanDimEnv.get(channelName);
            code = code + "		GeneralChannel " + (brackets (dimChannel)) + " " + channelName + " = GCArray.create" + ((dimChannel < 0)? 0 : dimChannel) + "Array(";
            if (!useBarriers) {
            	code = code + toChannel + ",";
            	code = code +  fromChannel + ",";
        	}
            code = code +  chanInfo + ",";
            code = code +  "new Integer(" + procId + "));\n";
        } else {
            // not multisynchronization
        	code = code + "/*" + channelName + " NÃO é um canal multisincronizado! */ \n";
        	int dimChannel = this.updatedChanDimEnv.get(channelName);

            code = code + "\t\tGeneralChannel " + (brackets (dimChannel)) + " " + channelName + " = /*1*/" + "GCArray.create" + ((dimChannel < 0)? 0 : dimChannel) + "Array(";
            code = code + chanInfo + ","
            + "new Integer(" + procId + "));\n	";
            if (!useBarriers) {
            	code = code + toChannel + ",";
            }
        }
        return code;
    }
    private String controllersManagerCallCode(ChanInfoEnv chanInfoEnv) 
    throws JCircusException {
    	String code;

    	String call;
    	if (chanInfoEnv.noMultiSync() == 1) {
	    /**
	     * If there is only one controller, this is the call to the
	     * method run of the controller.
	     */
	    Iterator<String> it = chanInfoEnv.iteratorKeys();
	    
	    String channelName = "";
	    while(it.hasNext()) {
	        channelName = it.next();
	        ProcChanUseEnv syncEnv = chanInfoEnv.get(channelName);
	        if (syncEnv.isMultiSync())
	            break;
	    }
	    
	    call = "new " + Constants.CLS_MSCTRL + "(Channel.getOutputArray (from_" + channelName +
	            "), to_" + channelName + ".in())";
	    
	} else {
	    
	    /**
	     * If there is more than one, this is the call to the method
	     * run of the parallelism of the controllers.
	     *
	     */
	    
	    List<String> listProcessCode = new ArrayList<String>();
	    /**
	     * iterates over the environments and when it finds one
	     * channel that is multisynchronized,
	     * adds its name to the array
	     */
	    Iterator<String> it = chanInfoEnv.iteratorKeys();
	    while(it.hasNext()) {
	        
	        String channelName = it.next();
	        ProcChanUseEnv syncEnv = chanInfoEnv.get(channelName);
	        
	        if (syncEnv.isMultiSync()) {
	            
	            String processCode = "";
	            /**
	             * Multi synchronization.
	             */
	            processCode = "new " + Constants.CLS_MSCTRL + " (from_" +
	                    channelName + ", to_" + channelName + ")";
	            
	            listProcessCode.add(processCode);
	        }
	    }
	    call = parallelCallRunCode(listProcessCode, false);
	}

HashMap<String, String> hashMap = new HashMap<String, String>();
hashMap.put(Constants.C_CTRLMNGR_CALL, call);
code = Util.getCodeFromTemplate(Constants.TMP_CTRLMNGR, hashMap);

return code;
}
    private String parallelCallRunCode(List<String> processes, boolean run) throws JCircusException {
    	String code;
    	String listProcessesCode = "";
    	String comma = "";
    	for (int i=0; i < processes.size(); i++) {
    		listProcessesCode += comma + processes.get(i);
    		comma = ", ";
    	}
    	HashMap<String, String> hashMap = new HashMap<String, String>();
    	hashMap.put(Constants.C_PARCALL_LISTPROC, listProcessesCode);
    	code = Util.getCodeFromTemplate(Constants.TMP_PARCALL, hashMap);
    	if (run) {
    		code = code + ".run();";
    	}
    	return code;
    }
    private String processManagerCallCode (String processName, String params, 
            String processNameGui, String paramsGui) throws JCircusException {
        String code;
        List<String> listProcessesCode = new ArrayList<String>();
        listProcessesCode.add(cspProcessCallCode(processName, params));
        listProcessesCode.add(cspProcessCallCode(processNameGui, paramsGui));
        String parallelismCode = parallelCallRunCode(listProcessesCode, false);
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put(Constants.C_PROCMNGR_PROC, parallelismCode);
        code = Util.getCodeFromTemplate(Constants.TMP_PROCMNGR, hashMap);
        return code;
    }
    public boolean isTranslatedAsSimpleSynchronized (String chanName) {
        if (this.elv.getChanMultiSyncEnv().get(chanName)
            	|| this.elv.getChanComplexCommEnv().get(chanName)
            	//|| this._envLoadingVisitor.getChanForcedInterleavingEnv().get(chanName) //No paralelismo com Renaming, isso cai fora
            	|| this.elv.getChanDotFieldEnv().get(chanName)
        		|| this.elv.getChanExtChoiceEnv().get(chanName)
        		|| (this.elv.getChanDimEnv().get(chanName) <= 0) && this.elv.getChanMultiSyncEnv().get(chanName)) {
//!this._envLoadingVisitor.getChanDimEnv().get(chanName) == 0 && this._envLoadingVisitor.getChanMultiSyncEnv().get(chanName)
        	return false;
        }
    	return true;
    }
    private String getNameGui(String processName) {
        return "Gui_" + processName;
    }
    private String paramPassageCode(ProcessPara processParaMain) {
        String code = "";
        String processName = processParaMain.getZName()/*getDeclName()*/.toString();
        CircusProcess circusProcess = processParaMain.getCircusProcess();
        ChanInfoEnv channelMSEnv = Util.getChannelMSEnvAnn(processParaMain);
        Integer id = Util.getIdCircusProcessAnn(circusProcess).getId();
        ProcChanEnv procChanEnv = Util.getProcChanEnvAnn(processParaMain);
        ChanUseEnv chanUseEnvHid = procChanEnv.getChanUseEnvHid();
        String comma = "";
        Iterator it = channelMSEnv.iteratorKeys();
        // For each channel
        while(it.hasNext()) {
            String channelName = (String) it.next();
            if (!chanUseEnvHid.containsKey(channelName)) {
                // Hidden channels are not seen in main
                ProcChanUseEnv syncEnv = channelMSEnv.get(channelName);
                code = code + comma + channelName;
                comma = ", ";
            }
            /**
             * Don't think this is necessary anymore. Why create a new channel
             * for the process with the same id ?
             *
            if (!syncEnv.isSync()) {
                // This channel will synchronize with the GUI
                ChanUse chanUse = syncEnv.getChanUseGuiNotSyncChannel();
 
                code = code + comma + "new GeneralChannel(" + channelName +
                        ", new Integer(" + id.intValue() + "))";
            } else {
 
                code = code + comma + channelName;
            }
 
            if (comma.equals("")) comma = ", ";
             */
        }
        return code;
    }
    private String paramList(List<String> codeForActuals) {
        String code = "";

        String comma = "";
        for (int i = 0; i < codeForActuals.size(); i++) {
            code = code + comma + codeForActuals.get(i);
            comma = ", ";
        }
        return code;
    }
    private String paramsCode(ProcInfo procInfo) {
        String code = "";
        String processName = procInfo.getProcessName();
        CircusProcess circusProcess = procInfo.getProcessPara().getCircusProcess();
        String procParamCode = "";
        // parameters of the process
        if (circusProcess instanceof ParamProcess) {
            procParamCode = paramList(procInfo.getCodeForActuals());
        }
        // visible channels passed as parameters
        String chanParamCode = paramPassageCode(procInfo.getProcessPara());
        // Channels come first
        if (!chanParamCode.equals("") && !procParamCode.equals("")) {
            code = chanParamCode + ", " + procParamCode;
        } else {
            code = chanParamCode + procParamCode;
        }
        return code;
    }
    private String processCallCode(ProcInfo procInfo) throws JCircusException {
        String code = "";
        String processName = procInfo.getProcessName();
        CircusProcess circusProcess = procInfo.getProcessPara().getCircusProcess();
        ChanInfoEnv chanInfoEnv = Util.getChannelMSEnvAnn(procInfo.getProcessPara());
        Integer procId = Util.getIdCircusProcessAnn(circusProcess).getId();
        ProcessPara processPara = procInfo.getProcessPara();
        ProcChanEnv procChanEnv = Util.getProcChanEnvAnn(processPara);
        ChanUseEnv chanUseEnvHid = procChanEnv.getChanUseEnvHid();
        String params = paramsCode(procInfo);
        String processNameGui = getNameGui(processName);
        List<String> listProcessesCode = new ArrayList();
        /**
         * Builds the parameters for the GUI, that is, the code for the
         * passage of channels as parameters.
         */
        // c is the number of channels that take part in the gui
        int c = 0;
        String paramsGui = "";
        String comma = ", ";

        Iterator it = chanInfoEnv.iteratorKeys();

        String params4Par = ""; //Vari�vel criada por Samuel Barrocas
        String p_name = "p_", p_gui_name = "p_gui_"; //Vari�veis criada por Samuel Barrocas
        String list_of_gpse_p_channels = ""; //By Samuel Barrocas
        String list_of_gpse_gui_channels = ""; //By Samuel Barrocas
        int counter_gpse_channels = 1; //By Samuel Barrocas
        boolean atLeastOneDependentChannel = true; //By Samuel Barrocas

        while (it.hasNext()) {
            String channelName = (String) it.next();
            ProcChanUseEnv chanMSEnv = chanInfoEnv.get(channelName);
            if (!chanMSEnv.isSync() && !chanUseEnvHid.containsKey(channelName)) {
                /**
                 * Independent channels - they will synchronize only with the gui.
                 * They cannot be hidden otherwise the gui cannot see them.
                 */
            	atLeastOneDependentChannel = false; //Sam's
            	if (isTranslatedAsSimpleSynchronized (channelName)) {
            		paramsGui = paramsGui + comma + "/*V*/" + channelName +
        				"/*new " + Constants.CLS_GENCHAN + "(" + channelName + //Angela's
        				", new Integer(-1))*/"; // global id of gui is -1 //Angela's
            	}
            	else {
            		paramsGui = paramsGui + comma + "/*V*/ GPSE.getProcessSyncEnds (new Integer (-1), " + channelName + ")" +
            			"/*new " + Constants.CLS_GENCHAN + "(" + channelName + //Angela's
            			", new Integer(-1))*/"; // global id of gui is -1 //Angela's
            	}

                //int dimChannel = this._envLoadingVisitor.getChanDimEnv().get(channelName); //Sam's
            	
            	//paramsGui = paramsGui + comma + "GCArray.create" + dimChannel + "Array (" +  channelName + //Sam's
                	//", new Integer(-1))"; // global id of gui is -1 //Sam's
                c++;
            }
            /*Abaixo c�digo escrito por Samuel Barrocas (Sam's)*/
            if (useBarriers) {
            	p_name = p_name + channelName + "_";
            	p_gui_name = p_gui_name + channelName + "_";
            	if (!chanMSEnv.isSync()) {
            		if (!this.elv.getEnvLoadingParProcessEnv().get(processName)) {
            			if (!isTranslatedAsSimpleSynchronized (channelName)) {
            				list_of_gpse_p_channels = list_of_gpse_p_channels + "GPSE.getProcessSyncEnds (new Integer (" + procId + "), " + channelName + ")";
            				list_of_gpse_gui_channels = list_of_gpse_gui_channels + "GPSE.getProcessSyncEnds (new Integer (-1), " + channelName + ")";
            			}
            			else {
            				list_of_gpse_p_channels = list_of_gpse_p_channels + channelName;
            				list_of_gpse_gui_channels = list_of_gpse_gui_channels + channelName;
            			}
            		}
            		else {
                		list_of_gpse_p_channels = list_of_gpse_p_channels + channelName;
        				list_of_gpse_gui_channels = list_of_gpse_gui_channels + channelName;
            			/*if (!isTranslatedAsSimpleSynchronized (channelName))
            				list_of_gpse_gui_channels = list_of_gpse_gui_channels + "GPSE.getProcessSyncEnds (new Integer (-1), " + channelName + ")";
            			else
            				list_of_gpse_gui_channels = list_of_gpse_gui_channels + channelName;*/
            		}
            	}
            	else {
                	list_of_gpse_p_channels = list_of_gpse_p_channels + channelName;
            	}
            	if (counter_gpse_channels < chanInfoEnv.size()) {
            		list_of_gpse_p_channels = list_of_gpse_p_channels + ", ";
            		list_of_gpse_gui_channels = list_of_gpse_gui_channels + ", ";
            	}
            	counter_gpse_channels++;
            }
            /*Acima c�digo escrito por Samuel Barrocas (Sam's)*/
        }
    	listProcessesCode.add (p_name);
    	//if (!atLeastOneDependentChannel) //Sam's
    		listProcessesCode.add (p_gui_name);
    	
    	if (useBarriers) {
    		params4Par = params4Par + processName + " " + p_name + " = new " + processName + "(" + list_of_gpse_p_channels + ");\n";
    		//if (!atLeastOneDependentChannel)
    			params4Par = params4Par +
    				"\t\tGui_" + processName + " " + p_gui_name + " = new Gui_" + processName + "(\"" + processName + "\", " + list_of_gpse_gui_channels + ");\n";
    	}
        // c is the number of channels that take part in the gui
        paramsGui = "\"" + processName + "\"" + paramsGui;
        
        String parCodeLeft;
        String parCodeRight;
        if (chanInfoEnv.noMultiSync() == 0) {
            /**
             * If there is no multi-synchronization, the main call is the
             * parallelism of the main process and GUI.
             */
            parCodeLeft = cspProcessCallCode(processName, params);
            parCodeRight = cspProcessCallCode(processNameGui, paramsGui);

            System.out.println ();
        } else {

            /**
             * If there is multi-synchronization, the main call is the
             * parallelism of ProcessManagerMultiSync and ControllersManager.
             */
            parCodeLeft = processManagerCallCode(processName, params, processNameGui, 
                    paramsGui);
            parCodeRight = controllersManagerCallCode(chanInfoEnv);
        }
        /**
         * Creates the parallelism
         */
        if (!useBarriers) {
        	listProcessesCode.add(parCodeLeft);
        	listProcessesCode.add(parCodeRight);
        }
        else { //Samuel Barrocas (Sam's)
        	//listProcessesCode.add (channelName + "_" + processName);
        }
        code = code + params4Par; //Samuel Barrocas (Sam's)
        code = code + parallelCallRunCode(listProcessesCode, true);
        return code;
    }

}