package jcircus.generators;

import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;

import javax.swing.JOptionPane;

//@author: Samuel Lincoln Magalhes Barrocas
//GPSEGenerator is the abbreviation of "GetProcessSyncEndsGenerator".
//This class generates the GPSE class, which has the
	//various signatures and implementations of the getProcessSyncEnds method

public class GPSEGenerator {
	private int chanDim;
	private int maxValue;
	private int minValue;
	private String packageDecl;
	private String path;
	public GPSEGenerator (int dim, int minValue, int maxValue, String paper, String src, String projectDir, String specName) {
		this.chanDim = dim;
		this.maxValue = maxValue;
		this.packageDecl = "package " /*+ specName + "."*/ + paper + "." + src + "." + paper + "." + "typing" + ";\n";
		this.path = projectDir + "\\" + paper + "\\" + src + "\\" + paper + "\\typing\\GPSE.java";
	}
	public GPSEGenerator (int dim, int minValue, int maxValue) {
		this (dim, minValue, maxValue, "paper", "src", "", "Exemplo");
	}
	public static String emptyBrackets (int n) {
		String str = "";
		for (int i = 0; i < n; i++) {
			str = str + "[]";
		}
		return str;
	}

	public int potInt (int b, int e) { ////Servir para a gerao do mtodo getProcessSyncEnds na verso estendida
		int aux = 1;
		for (int i = 1; i <= e; i++) {
			aux = aux * b;
		}
		return aux;
	}
	public String potIntCode () { //Servir para a gerao do mtodo getProcessSyncEnds na verso reduzida
		return 
		"	public static int potInt (int b, int e) {\n" +
		"		int aux = 1;\n" +
		"		for (int i = 1; i <= e; i++) {\n" +
		"			aux = aux * b;\n" +
		"		}\n" +
		"		return aux;\n" +
		"	}\n";
	}
	
	public int indexOfEndPart (int line, int pos) {
		return (line / (potInt (this.maxValue - this.minValue + 1, this.chanDim - 1 - pos))) % (this.maxValue - this.minValue + 1);
	}
	public String indexOfEndPartCode () { //A ser utilizado na verso reduzida
		return 
		"	public static int indexOfEndPart (int line, int pos, int chanDim, int maxValue) {\n" +
		"		return (line / (potInt (maxValue, chanDim - 1 - pos))) % maxValue;\n" +
		"	}\n";
	}
	
	public int numberOfEnds () {
		int total = 1;
		for (int i = 1; i <= this.chanDim; i++) {
			total = total * this.maxValue;
		}
		return total;
	}
	
	public String numberOfEndsCode () {
		return
		"	public static int numberOfEnds () {\n" +
		"		int total = 1;\n" +
		"		for (int i = 1; i <= " + this.chanDim + "; i++) {\n" +
		"			total = total * " + (this.maxValue - this.minValue + 1) + ";\n" +
		"		}\n" +
		"		return total;\n" +
		"	}\n";
	}
	
	public String bracketizeds (int x, String s) {
		String str = "";
		for (int i = 0; i < x; i++) {
			str = str + bracketized (s);
		}
		return str;
	}
	
	public String reducedChannelCode (int dim) {
		String str = "";
		if (dim != 0){
			str = str + "	public static GeneralChannel " + emptyBrackets (dim) + " getProcessSyncEnds (int x, GeneralChannel " + emptyBrackets (dim) + " gc/*, ChannelInfo chanInfo*/) {\n";
			str = str + "		GeneralChannel " +
					emptyBrackets (dim) + " b = new GeneralChannel " +
					bracketizeds (dim, (new Integer(this.maxValue - this.minValue + 1)).toString()) +
					";\n";
			str = str + forOfGPSE(dim);
			str = str + "		return b;\n";
			str = str + "	}\n";

			str = str + "	/*public static GeneralChannel " + emptyBrackets (dim) + " getProcessSyncEndsToBeReset (int x, GeneralChannel " + emptyBrackets (dim) + " gc) {\n";
			str = str + "		GeneralChannel " +
					emptyBrackets (dim) + " b = new GeneralChannel " +
					bracketizeds (dim, (new Integer(this.maxValue - this.minValue + 1)).toString()) +
					";\n";
			str = str + forOfGPSEWithEndToBeReset(dim);
			str = str + "		return b;\n";
			str = str + "	}*/\n";
		}
		else {
			str = str + "	public static GeneralChannel " + " getProcessSyncEnds (int x, GeneralChannel " + " gc/*, ChannelInfo chanInfo*/) {\n";
			str = str + "		GeneralChannel b = new GeneralChannel (gc.getChannelInfo(), gc.getChannelInfo().get(x));\n" +
						"		b.setEnd (gc.getBarrier () [gc.getChannelInfo().get(x)]);\n" +
						"		return b;\n" +
						"	}\n";
			str = str + "	/*public static GeneralChannel " + " getProcessSyncEndsToBeReset (int x, GeneralChannel " + " gc) {\n";
			str = str + "		GeneralChannel b = (new GeneralChannel (gc.getChannelInfo(), gc.getChannelInfo().get(x))).thisWithEndToBeReset();\n" +
						"		b.setEnd (gc.getBarrier () [gc.getChannelInfo().get(x)]);\n" +
						"		return b;\n" +
						"	}\n*/";
		}
		return str;
	}

	public String reducedCode () {
		String str = "";
		for (int i = 0; i <= this.chanDim; i++) {
			str = str + reducedChannelCode (i);
		}
		return str;
	}
	
	public void generateClass () {
		try {
			BufferedWriter bw = new BufferedWriter (new FileWriter (this.path));
			bw.write(this.getReducedClassCode());
			bw.close();
		} catch (IOException e) {
			e.printStackTrace();
		}
	}
	
	public String endParts (int dim) {
		String str = "";
		for (int j = 0; j < dim; j++) {
			str = str + bracketized ("indexOfEndPart (i, " + j + ", " + this.chanDim + ", " + (this.maxValue - this.minValue + 1) + ")");
		}
		return str;
	}
	
	public String forOfGPSE (int dim) {
		return
		"		for (int i = 0; i < numberOfEnds(); i++) {\n" +
		"			b " + endParts(dim) + " = new GeneralChannel (gc" + bracketizeds (dim, "0") + ".getChannelInfo(), gc" + bracketizeds (dim, "0") + ".getChannelInfo().get(x));\n" +
		"			b " + endParts(dim) + ".setEnd (gc " + endParts (dim) + ".getBarrier() [gc" + bracketizeds (dim, "0") + ".getChannelInfo().get(x)]);\n" +
		"		}\n";
	}

	public String forOfGPSEWithEndToBeReset (int dim) {
		return
		"		for (int i = 0; i < numberOfEnds(); i++) {\n" +
		"			b " + endParts(dim) + " = (new GeneralChannel (gc" + bracketizeds (dim, "0") + ".getChannelInfo(), gc" + bracketizeds (dim, "0") + ".getChannelInfo().get(x))).thisWithEndToBeReset();\n" +
		"			b " + endParts(dim) + ".setEnd (gc " + endParts (dim) + ".getBarrier() [gc" + bracketizeds (dim, "0") + ".getChannelInfo().get(x)]);\n" +
		"		}\n";
	}
	
	public static String bracketized (String x) {
		return "[" + x + "]";
	}

	public String end (int line) {
		String st = "";
		for (int i = 0; i < this.chanDim; i++) {
			st = st + bracketized ((new Integer (indexOfEndPart (line, i))).toString());
		}
		st = st + ".getBarrier () [x]";
		return st;
	}
	
	public String getReducedClassCode () {
		String st =
			packageDecl +
			"import org.jcsp.lang.*;\n" +
			"import newjcircusutil.multisync.GeneralChannel;\n" +
			"import newjcircusutil.multisync.ChannelInfo;\n" +
			"public class GPSE {\n" +
			potIntCode () + indexOfEndPartCode () + numberOfEndsCode () +
			reducedCode () + "}\n";
		return st;
	}

	public String ends () {
		String st = "";
		int endsNum = this.numberOfEnds();
		for (int i = 0; i < endsNum - 1; i++) {
			st = st + "			" + "gc " + end (i) + ",\n";
		}
		st = st + "			" + "gc " + end (endsNum - 1) + "\n";
		return st;
	}
	
	public static String parametersOfMethod (int dimChannel) {
		return "int x, GeneralChannel " + emptyBrackets (dimChannel) + " gc";
	}
	public String getExpandedClassCode () {
		String st =
			packageDecl +
			"import org.jcsp.lang.*;\n" +
			"import newjcircusutil.multisync.GeneralChannel;\n" +
			"public class GPSE {\n" +
			gpseMethodCode ();
		return st;
	}
	public String gpseMethodCode () {
		String str = "	public AltingBarrier " + emptyBrackets (this.chanDim) + " getProcessSyncEnds (" + parametersOfMethod (this.chanDim) + ") {\n";
		str = str +  "		AltingBarrier " + emptyBrackets (this.chanDim) + " b = new AltingBarrier " + emptyBrackets (this.chanDim) + "{\n";
		str = str + ends();
		str = str + "		}\n	}\n";
		return str;
	}
	public static void main (String args []) {
		//GPSEGenerator gp = new GPSEGenerator (3, 5);
	}
}
