package jcircus.generators;

import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;

import newjcircusutil.multisync.ChannelInfo;
import newjcircusutil.multisync.GeneralChannel;

import org.jcsp.lang.AltingBarrier;
import org.jcsp.lang.Any2OneChannel;

public class GCArrayGenerator {
	public static String brackets (int n) {
		String s = "";
		for (int i = 1; i <= n; i++) {
			s = s + "[]";
		}
		return s;
	}
	public static String bracketized (String x) {
		return "[" + x + "]";
	}
	public static String bracketizeds (int n, String x) {
		String s = "";
		for (int i = 0; i < n; i++) {
			s = s + bracketized (x);
		}
		return s;
	}
	public static String paramDecls1 () {
		return "ChannelInfo channelInfo, Integer procId, AltingBarrier [] barrier, int size";
	}
	public static String paramDecls2 () {
		return "ChannelInfo channelInfo, Integer procId";
	}
	public static String paramDecls3 (int x) {
		return (x != 0? "GeneralChannel " + brackets (x) + "generalChannel, Integer procId, int size" : "GeneralChannel " + brackets (x) + "generalChannel, Integer procId");
	}
	public static String paramCalls4 (int x) {
		return (x != 0? "generalChannel, procId, size" : "generalChannel, procId");
	}
	
	public static String paramCalls3 () {
		return "channelInfo, procId, AltingBarrier.create (channelInfo.getTable().size()), 10";
	}
	public static String paramCalls2 () {
		return "channelInfo, procId, barrier, size";
	}
	public static String paramCalls1 () {
		return "channelInfo, procId, barrier";
	}
	
	public static String createArrayCode (int dim) {
		if (dim == 0) {
			return
			"	public static GeneralChannel create0Array (ChannelInfo channelInfo, Integer procId, AltingBarrier [] barrier) {\n" +
			"		return new GeneralChannel (channelInfo, procId);\n" +
			"	}\n" +
			"	public static GeneralChannel create0Array (GeneralChannel generalChannel, Integer procId) {\n" +
			"		return new GeneralChannel (generalChannel, procId);\n" +
			"	}\n" +
			"	public static GeneralChannel create0Array (ChannelInfo chanInfo, Integer procId) {\n" +
			"		return new GeneralChannel (chanInfo, procId);\n" +
			"	}\n";
		}
		else return
			"	public static GeneralChannel " + brackets (dim) + " create" + dim + "Array (" + paramDecls1() + ") {\n" +
			"		GeneralChannel " + brackets (dim) + " c = new GeneralChannel " + bracketizeds (dim, "size") + ";\n" +
			"		for (int i = 0; i < size; i++) {\n" +
			"			c [i] = create" + (dim - 1) + "Array (" + ((dim == 1)? paramCalls1() : paramCalls2()) + ");\n" +
			"		}\n" +
			"		return c;\n" +
			"	}\n" +
			"	public static GeneralChannel " + brackets (dim) + " create" + dim + "Array (" + paramDecls2() + ") {\n" +
			"		return create" + dim + "Array (" + paramCalls3() + ");\n" +
			"	}\n\n" +
		"	public static GeneralChannel " + brackets (dim) + " create" + dim + "Array (" + paramDecls3(dim) + ") {\n" +
		"		GeneralChannel " + brackets (dim) + " c = new GeneralChannel " + bracketizeds (dim, "size") + ";\n" +
		"		for (int i = 0; i < size; i++) {\n" +
		"			c [i] = create" + (dim - 1) + "Array (generalChannel [i], procId);\n" +
		"		}\n" +
		"		return c;\n" +
		"	}\n" +
		"	public static GeneralChannel " + brackets (dim) + " create" + dim + "Array (GeneralChannel " + brackets (dim) + " generalChannel, Integer procId) {\n" +
		"		return create" + dim + "Array (" + paramCalls4(0) + ", 10);\n" +
		"	}\n\n";

	}
	public static String createArrayCodes (int dim) {
		String s = "";
		for (int i = 0; i <= dim; i++) {
			s = s + createArrayCode (i);
		}
		return s;
	}
	public static String getPackage (String name, String paper, String src) {
		return "package " + /*name + "." +*/ paper + "." + src + "." + paper;
	}
	public static String totalCode (int dim, String name, String paper, String src) {
		return
		getPackage (name, paper, src) + ".typing;\n\n" +
		"import newjcircusutil.multisync.*;\nimport newjcircusutil.*;\nimport org.jcsp.lang.*;\n\n" +
		"public class GCArray {\n" +
		createArrayCodes (dim) +
		"}\n";
	}
	public static String totalCode (int dim, String specName) {
		return totalCode (dim, specName, "paper", "src");
	}
	public static void generate (int dim, String path, String specName) {
		try {
			BufferedWriter bw = new BufferedWriter (new FileWriter (path));
			bw.write (GCArrayGenerator.totalCode(dim, specName));
			bw.close();
		} catch (IOException e) {
			e.printStackTrace();
		}

	}
	public static void main (String args []) {
		System.out.println (GCArrayGenerator.totalCode (4, "Exemplo"));
	}
}
