package jcircus.exceptions;

import java.util.List;
import jcircus.util.Error;

/**
 * ChanUseUnificationException.java
 *
 * @author Angela Freitas
 */
public class FailTranslationException extends JCircusException {
    
    private List<Error> errors;
    
    public FailTranslationException(List<Error> errors) {
        super("Fail translation");
        this.errors = errors;
    }

    public FailTranslationException(List<Error> errors, Throwable cause) {
        super("Fail translation", cause);
        this.errors = errors;
    }
    
    public List<Error> getErrors() {
        return this.errors;
    }
    
}
