package jcircus.environment;

import java.util.Stack;
import jcircus.util.CircusType;
import jcircus.util.NameType;

/**
 * ScopeStack.java
 *
 * @author Angela Freitas
 *
 */
public class ScopeStack {
    
    /*
     * The stack of scopes (NameTypeEnv)
     */
    private Stack scopeStack_;
    
    /**
     * Creates an empty stack.
     *
     */
    public ScopeStack() {
        this.scopeStack_ = new Stack();
    }
    
    /**
     * Coloca um ambiente de tipos no topo da pilha.
     *
     */
    public void push(NameTypeEnv nameTypeEnv) {
        this.scopeStack_.push(nameTypeEnv);
    }
    
    /**
     *
     * @return
     */
    public boolean isEmpty() {
        return this.scopeStack_.isEmpty();
    }
    
    /**
     *
     * @param i
     * @return
     */
    public NameTypeEnv elementAt(int i) {
        return (NameTypeEnv) this.scopeStack_.elementAt(i);
    }
    
    /**
     * Retira o ambiente de tipos que est topo da pilha.
     *
     */
    public NameTypeEnv pop() {
        return (NameTypeEnv) this.scopeStack_.pop();
    }
    
    /**
     * Procura por um nome em todos os ambientes de tipo que esto na pilha,
     * comeando pelo que est no topo. Se encontrar o nome, retorna o seu tipo,
     * caso contrrio, retorna null.
     *
     *
     */
    public CircusType getType(String name) {
        
        CircusType r = null;
        NameTypeEnv typeEnvironment;
        
        for (int i=this.scopeStack_.size(); i>0; i--) {
            
            typeEnvironment = (NameTypeEnv) this.scopeStack_.elementAt(i-1);
            r = typeEnvironment.getCircusType(name);
            if (r != null)
                break;
        }
        
        return r;
    }
    
    /**
     *
     * @param name
     * @return
     */
    public NameType getNameType(String name) {
        
        NameType r = null;
        NameTypeEnv typeEnvironment;
        
        int t = this.scopeStack_.size();
        
        for (int i=this.scopeStack_.size(); i>0; i--) {
            
            typeEnvironment = (NameTypeEnv) this.scopeStack_.elementAt(i-1);
            r = typeEnvironment.getNameType(name);
            if (r != null)
                break;
        }
        
        return r;
    }
    
    /**
     *
     * @return
     */
    public int size() {
        return this.scopeStack_.size();
    }
    
}
