package jcircus.environment;


import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

import jcircus.exceptions.runtime.NoNameTypeAnnotationException;
import jcircus.util.CircusType;
import jcircus.util.NameType;
import jcircus.util.Util;
import net.sourceforge.czt.z.ast.Expr;
import net.sourceforge.czt.z.ast.ZName/*DeclName*/;
import net.sourceforge.czt.z.ast.Name;
import net.sourceforge.czt.z.util.Factory;

/**
 * NameTypeEnv.java
 *
 * @author Angela Freitas
 */
public class NameTypeEnv {
    
    private Map<ZName/*DeclName*/, CircusType> _map;
    private Factory _factory;
    
    /**
     * Constructor
     *
     */
    public NameTypeEnv() {
        _map = new LinkedHashMap<ZName/*DeclName*/, CircusType>();
        _factory = new Factory();
    }
    
    /**
     * Insert a name and type in the environment.
     *
     * @param nameEnv
     * @param circusType
     *
     * @throws Exception	If the name does hot have an NameType annotation.
     */
    public void put(ZName/*DeclName*/ declName, CircusType circusType) 
            throws NoNameTypeAnnotationException {
        
        if (declName.getAnn(NameType.class) == null) {
            throw new NoNameTypeAnnotationException(declName.toString());
        }
        
        _map.put(declName, circusType);
        if (declName.toString().equals("x")) {
        	System.out.print ("");
        }
    }
    
    /**
     *
     * @param string
     * @return
     */
    public CircusType getCircusType(String string) {
        if (string.equals ("x")) {
        	System.out.print ("");
        }
        CircusType circusType = null;
        
        ZName/*DeclName*/ n = _factory.createZName(string)/*createDeclName*/; //new DeclName(string);
        ZName/*DeclName*/ t;
        boolean equals;
        Iterator<ZName/*DeclName*/> it = _map.keySet().iterator();

        if (string.equals ("x")) {
        	System.out.print ("");
        }
        
        while (it.hasNext()) {
            
            t = it.next();
            equals = t.equals (n);
            
            if (string.equals ("x")) {
            	System.out.print ("x\n");
            }
            if (t.toString().equals(n.toString())) {
                
                circusType = (CircusType) _map.get(t);
                if (string.equals ("x")) {
                	System.out.print ("x\n");
                }
                break;
            }
        }

        if (string.equals ("State")) {
        	System.out.print ("");
        }

        return circusType;
    }
    
    /**
     * Returns the NameType associated with the given declName.
     * In case the declName is not defined in this environment, returns null.
     * 
     * @param string
     * @return
     */
    public NameType getNameType(String string) { //Aqui o mapa _map est sendo vazio
    	if (string.equals ("x")) {
        	System.out.print ("");
        }
        
        NameType nameType = null;
        
        ZName/*DeclName*/ t;
        
        Iterator<ZName/*DeclName*/> it = _map.keySet().iterator();

    	if (string.equals ("x")) {
        	System.out.print ("");
        }
        
        while (it.hasNext()) {
            
            t = it.next();
            
        	if (string.equals ("x")) {
            	System.out.print ("");
            }

            if (t.toString().equals(string)) {

            	if (string.equals ("x")) {
                	System.out.print ("");
                }
                
                nameType = (NameType) t.getAnn(NameType.class);
                break;
            }
        }
        
        return nameType;
    }
    
    /**
     *
     * @param channelName
     */
    public void remove(String channelName) {
        _map.remove(channelName);
    }
    
    /**
     * Substitute the old channel names for the new channel names.
     * @param newChannels
     * @param oldChannels
     * @return
     *
     * Why is Name instead of DeclName ?
     */
    public NameTypeEnv substitute(List<Expr> newChannels, List<Name> oldChannels) {

        // Creates a new environment, which will be returned
        NameTypeEnv r = new NameTypeEnv();
        
        Name oldChannelName, newChannelName;
        ZName/*DeclName*/ declName;
        CircusType circusType;
        NameType nameType;
        int index;
        
        r.putAll(this);
        
        for (int i = 0; i < oldChannels.size(); i++) {
            
            oldChannelName = oldChannels.get(i);
            newChannelName = (Name) newChannels.get(i);
            
            if (r.containsKey(oldChannelName.toString())) { 
                
                nameType = r.getNameType(oldChannelName.toString());
                circusType = r.getCircusType(oldChannelName.toString());
                
                r.remove(oldChannelName.toString());
                
                declName = _factory.createZName(newChannelName.toString());
                Util.addNameTypeAnn(declName, nameType);
                
                r.put(declName, circusType);
            }
        }
        
        return r;
    }
    
    /**
     *
     */
    public void putAll(NameTypeEnv nameTypeEnv) {
        
        Iterator<ZName/*DeclName*/> it = nameTypeEnv.iteratorKeys();
        ZName/*DeclName*/ declName;
        CircusType circusType;
        
        while(it.hasNext()) {
            declName = it.next();
            circusType = nameTypeEnv.getCircusType(declName.toString());
            put(declName, circusType);
        }
    }
    
    /**
     *
     * @param declName
     * @return
     */
    public boolean containsKey(String declName) {
        
        boolean r = false;
        
        ZName/*DeclName*/ t;
        Iterator<ZName/*DeclName*/> it = _map.keySet().iterator();
        
        while (it.hasNext()) {
            
            t = it.next();
            if (t.toString().equals(declName)) {
                r = true;
            }
        }
        return r;
    }
    
    /**
     * Substituir este metodo nos lugares onde ele  usado por iteratorKeys() ?
     * @return
     */
    public Set<ZName/*DeclName*/> keys() {
        return _map.keySet();
    }
   
    /**
     *
     */
    public Iterator<ZName/*DeclName*/> iteratorKeys() {
        return _map.keySet().iterator();
    }
    
    /**
     *
     */
    public void print() {
        
        ZName/*DeclName*/ declName;
        CircusType type;
        Iterator<ZName/*DeclName*/> it = _map.keySet().iterator();
        
        System.out.println("-------------");
        while (it.hasNext()) {
            
            declName = it.next();
            type = _map.get(declName);
            
            System.out.println("DeclName: " + declName + ", CircusType: " + type);
        }
        System.out.println("-------------");
    }
    
}