package jcircus.environment;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Iterator;
import java.util.List;
import jcircus.exceptions.ChanSyncUnificationException;

import jcircus.util.ChanSync;
import net.sourceforge.czt.base.ast.ListTerm;
import net.sourceforge.czt.z.ast.Name;
import net.sourceforge.czt.z.ast.ZExprList;
import net.sourceforge.czt.z.ast.ZNameList;


/**
 * ChanSyncEnv.java
 *
 * @author Angela Freitas
 */
public class ChanSyncEnv {
    
    /**
     * String (channelName) -> ChanSync
     */
    private Map<String, ChanSync> _map;
    
    /**
     * Constructor.
     */
    public ChanSyncEnv() {
        _map = new LinkedHashMap<String, ChanSync>();
    }
    
    /**
     * 
     * @param channelName
     * @param chanSync
     * @throws ChannelAlreadyDefinedException
     */
    public void put(String channelName, ChanSync chanSync) {
        
        if (chanSync == null)
            throw new NullPointerException();
        
        _map.put(channelName, chanSync);
    }
    
    /**
     *
     * @param channelName
     * @return
     */
    public ChanSync get(String channelName) {
        
        return (ChanSync) _map.get(channelName);
    }
    
    /**
     *
     * @param channelName
     */
    public void remove(String channelName) {
        
        _map.remove(channelName);
    }
    
    /**
     *
     * @param channelName
     * @return
     */
    public boolean containsKey(String channelName) {
        return _map.containsKey(channelName);
    }
    
    /**
     *
     * @param channelSyncEnvironment
     * @throws ChannelAlreadyDefinedException
     */
    private void putAll(ChanSyncEnv channelSyncEnvironment) {
        
        Iterator iterator = channelSyncEnvironment.iteratorKeys();
        String channelName;
        ChanSync syncTypeChannel;
        
        while(iterator.hasNext()) {
            channelName = (String) iterator.next();
            syncTypeChannel = channelSyncEnvironment.get(channelName);
            
            put(channelName, syncTypeChannel);
        }
    }
    
    /**
     *
     * @param newChannels
     * @param oldChannels
     * @return
     * @throws ChannelAlreadyDefinedException
     */
    public ChanSyncEnv substitute(ZExprList/*ListTerm*/ newChannels, ZNameList/*ListTerm*/ oldChannels) {
        
        ChanSyncEnv r = new ChanSyncEnv();
        String channelName, newChannelName;
        Name name;
        ChanSync syncTypeChannel;
        int index;
        
        r.putAll(this);
        
        for (int i = 0; i < oldChannels.size(); i++) {
            
            name = (Name) oldChannels.get(i);
            newChannelName = ((Name) newChannels.get(i)).toString();
            
            if (r.containsKey(name.toString())) {
                syncTypeChannel = r.get(name.toString());
                r.remove(name.toString());
                r.put(newChannelName, syncTypeChannel);
            }
        }
        
        return r;
    }

    /**
     *
     */
    public ChanSyncEnv merge(ChanSyncEnv other) /*throws ChanSyncUnificationException*/ {
        
        ChanSyncEnv r = new ChanSyncEnv();
        
        r.putAll(this);
        
        Iterator iterator = other.iteratorKeys();
        
        while(iterator.hasNext()) {
            String chanName = (String) iterator.next();
            ChanSync chanSync = other.get(chanName);
            
            if (r.containsKey(chanName)) {
                ChanSync chanSyncInEnv = r.get(chanName);
                /*if (!chanSync.equals(chanSyncInEnv)) {
                    throw new ChanSyncUnificationException();
                }*/
            }
            
            r.put(chanName, chanSync);
        }
       
        return r;
    }
    
    /**
     *
     * @return
     */
    public Iterator iteratorKeys() {
        
        return _map.keySet().iterator();
    }
       
    /**
     *
     */
    public void print() {

        String name;
        ChanSync type;
        Iterator it = iteratorKeys();
        
        System.out.println("-------------");
        while (it.hasNext()) {
            
            name = (String) it.next();
            type = (ChanSync) this._map.get(name);
            
            System.out.println("Name: " + name + ", Type: " + type);
        }
        System.out.println("-------------");
    }
        
}
