package jcircus.complementaryenvs;

import java.util.HashMap;
import java.util.LinkedHashMap;

//Created by Samuel Lincoln Magalhes Barrocas, to map a channel name to its minimum/maximum pair of values to be communicated.
public class MinMaxEnv {
	class Pair {
		int min;
		int max;
		public Pair (int min, int max) {
			this.min = min;
			this.max = max;
		}
	}
	Pair pair;
	private HashMap <String, Pair> _map;
	
	public MinMaxEnv () {
		this._map = new LinkedHashMap <String, Pair> ();
	}
	public void put (String channelName, int min, int max) {
		this._map.put(channelName, new Pair (min, max));
	}
	public int getMin (String channelName) {
		return this._map.get(channelName).min;
	}
	public int getMax (String channelName) {
		return this._map.get(channelName).max;
	}
}
