package jcircus.complementaryenvs;

import java.util.HashMap;
import java.util.LinkedHashMap;

import jcircus.interleaving.SetOfProcessIdSets;

//@author: Samuel Lincoln Magalhes Barrocas
public class ChanSetOfProcessIdSetsEnv {
	//Maps a channel to a SetOfProcessNameSets
	private HashMap <String, SetOfProcessIdSets> _map;
    public ChanSetOfProcessIdSetsEnv () {
        this._map = new LinkedHashMap <String, SetOfProcessIdSets> ();
    }
	public void put (String channelName, SetOfProcessIdSets setofsets) {
		this._map.put(channelName, setofsets);
	}
	public void set (String channelName, SetOfProcessIdSets setofsets) {
		this._map.remove(channelName);
		this._map.put(channelName, setofsets);
	}
	public void remove (String channelName) {
		this._map.remove (channelName);
	}
	public void putAll (ChanSetOfProcessIdSetsEnv env) {
		this._map.putAll (env.getMap());
	}
	public SetOfProcessIdSets get (String channelName) {
		return (SetOfProcessIdSets) this._map.get(channelName);
	}
	public HashMap <String, SetOfProcessIdSets> getMap () {
		return this._map;
	}
}