package jcircus.complementaryenvs;
import jcircus.interleaving.ProcessIdSet;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Vector;

//@author: Samuel Lincoln Magalhes Barrocas
//Maps a channel to a set of process name sets.
	//Each set of processes is supposed to share a front-end on the channel of the mapping (this is for channels with forced interleaving)
public class ChanProcessNameSetEnv {
	private HashMap <String, Vector <ProcessIdSet>> _map;
	public ChanProcessNameSetEnv () {
		this._map = new LinkedHashMap <String, Vector <ProcessIdSet>> ();
	}
	public void put (String channel, Vector <ProcessIdSet> set) {
		this._map.put(channel, set);
	}
	public Vector <ProcessIdSet> get (String channel) {
		return this._map.get(channel);
	}
}