package jcircus.complementaryenvs;

import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;

//Created by Samuel Lincoln Magalhes Barrocas, to map a channel name to its dimension in the translation strategy.
public class ChanDimEnv {
	private HashMap <String, Integer> _map;
	
    public ChanDimEnv() {
        this._map = new LinkedHashMap<String, Integer>();
    }
	public void put (String channelName, int dim) {
		this._map.put(channelName, dim);
	}
	public int get (String channelName) {
		if (this._map.get(channelName) != null)
			return (int) this._map.get(channelName);
		return -2;
	}
	public HashMap <String, Integer> getMap () {
		return this._map;
	}
	public void set (String channelName, int dim) {
		if (this._map.containsKey(channelName)//this.get (channelName) != (new Integer (null)).intValue()
		) {
			this._map.remove(channelName);
		}
		this.put(channelName, dim);
	}
    public Iterator<String> iteratorKeys() {
        return this._map.keySet().iterator();
    }

}
