// Decompiled by DJ v3.11.11.95 Copyright 2009 Atanas Neshkov  Date: 22/10/2010 00:21:23
// Home Page: http://members.fortunecity.com/neshkov/dj.html  http://www.neshkov.com/dj.html - Check often for new version!
// Decompiler options: packimports(3) 

//package org.jcsp.lang; DJ
package jcircus.classesdescompiladas;

import java.io.PrintStream;
import java.util.*;

import org.jcsp.lang.*;

// Referenced classes of package org.jcsp.lang:
//            Barrier, CSProcess, ParThread, ProcessInterruptedException

public class CSPParallel
    implements CSProcess
{
    private final Object sync;
    private CSProcess processes[];
    private int nProcesses;
    private ParThread parThreads[];
    private int nThreads;
    private Barrier barrier;
    private boolean priority;
    private boolean processesChanged;
    private static final Set allParThreads = Collections.synchronizedSet(new HashSet());
    private static boolean destroyCalled = false;
    private static boolean displayExceptions = true;
    private static boolean displayErrors = true;

    static void addToAllParThreads(Thread thread)
        throws InterruptedException
    {
        synchronized(allParThreads)
        {
            if(destroyCalled)
                throw new InterruptedException("Parallel.destroy() has been called");
            allParThreads.add(thread);
        }
    }

    static void removeFromAllParThreads(Thread thread)
    {
        synchronized(allParThreads)
        {
            allParThreads.remove(thread);
        }
    }

    public static void destroy()
    {
        synchronized(allParThreads)
        {
            if(!destroyCalled)
            {
                System.out.println("*** org.jcsp.lang.Parallel: stopping " + allParThreads.size() + " threads");
                for(Iterator iterator = allParThreads.iterator(); iterator.hasNext();)
                {
                    Thread thread = (Thread)iterator.next();
                    try
                    {
                        thread.interrupt();
                    }
                    catch(SecurityException securityexception)
                    {
                        System.out.println("*** org.jcsp.lang.Parallel: couldn't stop thread " + thread + " - security exception");
                    }
                }

                destroyCalled = true;
            }
        }
    }

    public static void resetDestroy()
    {
        synchronized(allParThreads)
        {
            destroyCalled = false;
        }
    }

    public CSPParallel()
    {
        this(null, false);
    }

    CSPParallel(boolean flag)
    {
        this(null, flag);
    }

    public CSPParallel(CSProcess acsprocess[])
    {
        this(acsprocess, false);
    }

    public CSPParallel(CSProcess acsprocess[][])
    {
        sync = new Object();
        nProcesses = 0;
        nThreads = 0;
        barrier = new Barrier();
        if(acsprocess != null)
        {
            int i = 0;
            for(int j = 0; j < acsprocess.length; j++)
                if(acsprocess[j] != null)
                    i += acsprocess[j].length;

            nProcesses = i;
            processes = new CSProcess[nProcesses];
            i = 0;
            for(int k = 0; k < acsprocess.length; k++)
                if(acsprocess[k] != null)
                {
                    int l = acsprocess[k].length;
                    System.arraycopy(acsprocess[k], 0, processes, i, l);
                    i += l;
                }

            parThreads = new ParThread[nProcesses];
        } else
        {
            nProcesses = 0;
            processes = new CSProcess[0];
            parThreads = new ParThread[0];
        }
        processesChanged = true;
        priority = false;
    }

    CSPParallel(CSProcess acsprocess[], boolean flag)
    {
        sync = new Object();
        nProcesses = 0;
        nThreads = 0;
        barrier = new Barrier();
        if(acsprocess != null)
        {
            nProcesses = acsprocess.length;
            processes = new CSProcess[nProcesses];
            System.arraycopy(acsprocess, 0, processes, 0, nProcesses);
            parThreads = new ParThread[nProcesses];
        } else
        {
            nProcesses = 0;
            processes = new CSProcess[0];
            parThreads = new ParThread[0];
        }
        processesChanged = true;
        priority = flag;
    }

    public void addProcess(CSProcess csprocess)
    {
        synchronized(sync)
        {
            if(csprocess != null)
            {
                int i = nProcesses + 1;
                if(i > processes.length)
                {
                    CSProcess acsprocess[] = processes;
                    processes = new CSProcess[2 * i];
                    System.arraycopy(acsprocess, 0, processes, 0, nProcesses);
                }
                processes[nProcesses] = csprocess;
                nProcesses = i;
                processesChanged = true;
            }
        }
    }

    public void addProcess(CSProcess acsprocess[])
    {
        synchronized(sync)
        {
            if(processes != null)
            {
                int i = acsprocess.length;
                int j = nProcesses + i;
                if(j > processes.length)
                {
                    CSProcess acsprocess1[] = processes;
                    processes = new CSProcess[2 * j];
                    System.arraycopy(acsprocess1, 0, processes, 0, nProcesses);
                }
                System.arraycopy(acsprocess, 0, processes, nProcesses, i);
                nProcesses = j;
                processesChanged = true;
            }
        }
    }

    public void insertProcessAt(CSProcess csprocess, int i)
    {
        synchronized(sync)
        {
            if(i >= nProcesses + 1)
                throw new ArrayIndexOutOfBoundsException(i + " > " + (nProcesses + 1));
            if(csprocess != null)
            {
                int j = nProcesses + 1;
                if(j > processes.length)
                {
                    CSProcess acsprocess[] = processes;
                    processes = new CSProcess[2 * j];
                    System.arraycopy(acsprocess, 0, processes, 0, i);
                    System.arraycopy(acsprocess, i, processes, i + 1, nProcesses - i);
                } else
                if(i < nProcesses)
                    System.arraycopy(processes, i, processes, i + 1, nProcesses - i);
                processes[i] = csprocess;
                nProcesses = j;
                processesChanged = true;
            }
        }
    }
    
    public void removeProcess (CSProcess csprocess) {
    	
    }
/*    public void removeProcess(CSProcess csprocess)
    {
        Object obj = sync;
        //JVM INSTR monitorenter ; //DJ
        int i = 0;
_L2:
        if(i >= nProcesses)
            break MISSING_BLOCK_LABEL_94;
        if(processes[i] != csprocess)
            break MISSING_BLOCK_LABEL_88;
        if(i < nProcesses - 1)
            System.arraycopy(processes, i + 1, processes, i, nProcesses - (i + 1));
        nProcesses--;
        processes[nProcesses] = null;
        processesChanged = true;
        return;
        i++;
        //if(true) goto _L2; //comentado
        //else goto _L1; //comentado
_L1:
        break MISSING_BLOCK_LABEL_106;
        Exception exception 
        	= new Exception(); //<--Sam
        //exception; //DJ
        throw exception;
    }
*/
    public void removeAllProcesses()
    {
        synchronized(sync)
        {
            for(int i = 0; i < nProcesses; i++)
                processes[i] = null;

            nProcesses = 0;
            processesChanged = true;
        }
    }

    protected void finalize()
        throws Throwable
    {
        releaseAllThreads();
    }

    public void releaseAllThreads()
    {
        synchronized(sync)
        {
            for(int i = 0; i < nThreads; i++)
            {
                parThreads[i].terminate();
                parThreads[i] = null;
            }

            nThreads = 0;
            processesChanged = true;
        }
    }

    public int getNumberProcesses()
    {
        int i;
        synchronized(sync)
        {
            i = nProcesses;
        }
        return i;
    }

    public void run()
    {
        boolean flag = true;
        CSProcess csprocess = null;
        synchronized(sync)
        {
            if(nProcesses > 0)
            {
                flag = false;
                int i = 0;
                int j = 0;
                if(priority)
                {
                    Thread thread = Thread.currentThread();
                    i = thread.getPriority();
                    j = Math.min((i + nProcesses) - 1, Math.min(10, thread.getThreadGroup().getMaxPriority()));
                }
                barrier.reset(nProcesses);
                csprocess = processes[nProcesses - 1];
                if(processesChanged)
                {
                    if(nThreads < nProcesses - 1)
                    {
                        if(parThreads.length < nProcesses - 1)
                        {
                            ParThread aparthread[] = parThreads;
                            parThreads = new ParThread[processes.length];
                            System.arraycopy(aparthread, 0, parThreads, 0, nThreads);
                        }
                        for(int l = 0; l < nThreads; l++)
                        {
                            parThreads[l].reset(processes[l], barrier);
                            if(priority)
                                parThreads[l].setPriority(Math.max(i, j - l));
                            parThreads[l].release();
                        }

                        for(int i1 = nThreads; i1 < nProcesses - 1; i1++)
                        {
                            parThreads[i1] = new ParThread(processes[i1], barrier);
                            if(priority)
                                parThreads[i1].setPriority(Math.max(i, j - i1));
                            parThreads[i1].start();
                        }

                        nThreads = nProcesses - 1;
                    } else
                    {
                        for(int j1 = 0; j1 < nProcesses - 1; j1++)
                        {
                            parThreads[j1].reset(processes[j1], barrier);
                            if(priority)
                                parThreads[j1].setPriority(Math.max(i, j - j1));
                            parThreads[j1].release();
                        }

                    }
                    processesChanged = false;
                } else
                {
                    for(int k1 = 0; k1 < nProcesses - 1; k1++)
                    {
                        if(priority)
                            parThreads[k1].setPriority(Math.max(i, j - k1));
                        parThreads[k1].release();
                    }

                }
            }
        }
        if(!flag)
        {
            try
            {
                csprocess.run();
            }
            catch(ProcessInterruptedException processinterruptedexception)
            {
                synchronized(sync)
                {
                    for(int k = 0; k < nThreads; k++)
                        try
                        {
                            parThreads[k].interrupt();
                        }
                        catch(Throwable throwable1)
                        {
                            System.out.println("*** org.jcsp.lang.Parallel: couldn't stop thread " + throwable1 + " - security exception");
                        }

                }
            }
            catch(Throwable throwable)
            {
                uncaughtException("org.jcsp.lang.Parallel", throwable);
            }
            barrier.sync();
        }
    }

    public static void setUncaughtExceptionDisplay(boolean flag)
    {
        displayExceptions = flag;
    }

    public static void setUncaughtErrorDisplay(boolean flag)
    {
        displayErrors = flag;
    }

    static void uncaughtException(String s, Throwable throwable)
    {
        if((throwable instanceof Error) && displayErrors || (throwable instanceof Exception) && displayExceptions)
            synchronized(System.err)
            {
                System.err.println("\n*** " + s + ": A process threw the following exception :");
                throwable.printStackTrace();
                System.err.println();
            }
    }

}
