package circusRefine.util.zstring;

import java.util.Map;
import java.util.Set;
import java.util.Hashtable;

import net.sourceforge.czt.circus.util.CircusString;
import net.sourceforge.czt.z.util.ZString;


public class ZtoLatex  {
	
	protected Hashtable<String, String> table;
	
	
	public ZtoLatex() {
		
		//S�mbolos L�gicos
		
		table = new Hashtable<String, String>();
		
		table.put(ZString.AND, "\\land");
		table.put("land", "\\land");
		table.put(ZString.OR, "\\lor");
		table.put("lor", "\\lor");
		table.put(ZString.TRUE, "\\true");
		table.put(ZString.FALSE, "\\false");
		table.put(ZString.ALL, "\\forall");
		table.put(ZString.EXI, "\\exists");
		table.put(ZString.EXIONE, "\\exists_1");
		table.put(ZString.IFF, "\\iff");
		table.put(ZString.IMP, "\\implies");
		table.put(ZString.NOT, "\\lnot");
		table.put(ZString.SPOT, "@");
		table.put(ZString.SYMDIFF,"\\ominus");
		table.put(ZString.CONJECTURE,"\\conjecture");
		table.put(ZString.ARITHMOS,"\\arithmos");
		
		//Numbers
		
		table.put(ZString.NEQ , "\\neq");
		table.put(ZString.LEQ , "\\leq");
		table.put(ZString.GEQ , "\\geq");
		table.put(ZString.CROSS , "\\times");
		table.put(ZString.NAT , "\\nat");
		table.put(ZString.NUM , "\\num");
		//TODO
		table.put("mod","\\mod");
		table.put("div","\\div");
		table.put("\u227B","\\succ");
		
		//Conjuntos
		
		
		table.put(ZString.FINSET , "\\finset");
		table.put(ZString.POWER , "\\power");
		table.put(ZString.CUP , "\\cup");
		table.put(ZString.CAP , "\\cap");
		table.put(ZString.SETMINUS , "\\setminus");
		table.put(ZString.SUBSETEQ , "\\subseteq");
		table.put(ZString.SUBSET , "\\subset");
		table.put(ZString.MEM , "\\in");
		table.put(ZString.NOTMEM , "\\notin");
		table.put(ZString.NUMBER , "\\#");
		table.put(ZString.CROSS , "\\cross");
		table.put(ZString.EMPTYSET , "\\emptyset");
		//TODO
		table.put(".." , "\\upto");
		table.put("partition","\\partition");
		
		
		// Rela��es
		table.put(ZString.REL , "\\rel");
		table.put(ZString.MAPSTO , "\\mapsto");
		table.put(ZString.ZPROJ , "\\project");
		table.put(ZString.DRES , "\\dres");
		table.put(ZString.RRES , "\\rres");
		table.put(ZString.NDRES , "\\ndres");
		table.put(ZString.NRRES , "\\nrres");
		table.put(ZString.COMP , "\\comp");
		table.put(ZString.OPLUS , "\\oplus");
		
		//Funcoes
		
		table.put(ZString.FUN , "\\fun");
		table.put(ZString.PFUN , "\\pfun");
		table.put(ZString.PINJ , "\\pinj");
		table.put(ZString.INJ , "\\inj");
		table.put(ZString.PSURJ , "\\psurj");
		table.put(ZString.SURJ , "\\surj");
		table.put(ZString.BIJ , "\\bij");
		table.put(ZString.FFUN , "\\ffun");
		table.put(ZString.FINJ , "\\finj");
		table.put(ZString.LAMBDA , "\\lambda");
		table.put(ZString.CIRC , "\\circ");
		table.put(ZString.RIMG , "\\rimg");
		table.put(ZString.LIMG , "\\limg");
		//TODO
		table.put("dom" , "\\dom");
		table.put("id" , "\\id");
		table.put("ran" , "\\ran");
		table.put("inv" , "\\inv");
		
		//Sequencias
		
		table.put(ZString.CAT , "\\cat");
		table.put(ZString.LANGLE,"\\langle");
		table.put(ZString.RANGLE,"\\rangle");
		table.put(ZString.EXTRACT , "\\extract");
		table.put(ZString.FILTER, "\\filter");
		//TODO
		table.put("seq","\\seq");
		table.put("iseq","\\iseq");
		
		//Esquemas
		
		table.put(ZString.VDASH,"\\vdash");
		table.put(ZString.DELTA,"\\Delta");
		table.put(ZString.XI,"\\Xi");
		table.put(ZString.LET,"\\LET");
		table.put(ZString.IF,"\\IF");
		table.put(ZString.THEN, "\\THEN");
		table.put(ZString.ELSE ,"\\ELSE");
		table.put(ZString.PRE,"\\pre");
		table.put(ZString.THETA,"\\theta");
		table.put(ZString.LDATA,"\\ldata");
		table.put(ZString.RDATA,"\\rdata");
		table.put(ZString.LBIND,"\\lblot");
		table.put(ZString.RBIND,"\\rblot");
		table.put("\u03B1","\\alpha");
		table.put(CircusString.ZPIPE , "\\pipe");
		
	}
	
	public String get(String key) {
		return table.get(key);
	}
	public Set keySet(){
		return table.keySet();
	}
	public Set<Map.Entry<String, String>> entradas() {
		return this.table.entrySet();
	}
	
}
