package circusRefine.util.zstring;

import java.util.Hashtable;
import java.util.Map;
import java.util.Set;

import net.sourceforge.czt.circus.util.CircusString;
import net.sourceforge.czt.z.util.ZString;

	public class LatexToZ {
		
		private Hashtable<String, String> table;
		
		public LatexToZ () {
			
			//Smbolos Lgicos
			table = new Hashtable<String, String>();
			
			
			
			table.put("\\land", ZString.AND);
			table.put("\\lor", ZString.OR);
			table.put("\\true", ZString.TRUE);
			table.put("\\false", ZString.FALSE);
			table.put("\\forall", ZString.ALL);
			table.put("\\exists", ZString.EXI);
			table.put("\\exists_1", ZString.EXIONE);
			table.put("\\iff", ZString.IFF);
			table.put("\\implies", ZString.IMP);
			table.put("\\lnot", ZString.NOT);
			table.put("@", ZString.SPOT);
			table.put("\\conjecture",ZString.CONJECTURE);
			table.put("\\arithmos", ZString.ARITHMOS);
			
			//Numbers
			
			table.put("\\neq", ZString.NEQ);
			table.put("\\leq", ZString.LEQ);
			table.put("\\geq", ZString.GEQ);
			table.put("\\times", ZString.CROSS);
			table.put("\\nat", ZString.NAT);
			table.put("\\num", ZString.NUM);
			//TODO
			table.put("\\mod","mod");
			table.put("\\div","div");
			table.put("\\succ","\u227B");
			
			//Conjuntos
			
			table.put("\\finset", ZString.FINSET);
			table.put("\\power", ZString.POWER);
			table.put("\\cup", ZString.CUP);
			table.put("\\cap", ZString.CAP);
			table.put("\\setminus", ZString.SETMINUS);
			table.put("\\subseteq", ZString.SUBSETEQ);
			table.put("\\subset", ZString.SUBSET);
			table.put("\\in", ZString.MEM);
			table.put("\\notin", ZString.NOTMEM);
			table.put("\\#", ZString.NUMBER);
			table.put("\\cross", ZString.CROSS);
			table.put("\\emptyset", ZString.EMPTYSET);
			table.put("\\upto","..");
			table.put("\\partition","partition");
			
//			 Relaes
			table.put("\\rel" , ZString.REL);
			table.put("\\mapsto" , ZString.MAPSTO);
			table.put("\\project" , ZString.ZPROJ);
			table.put("\\dres" , ZString.DRES);
			table.put("\\rres" , ZString.RRES);
			table.put("\\ndres" , ZString.NDRES);
			table.put("\\nrres" , ZString.NRRES);
			table.put("\\comp" , ZString.COMP );
			table.put("\\oplus" , ZString.OPLUS);
			
//			Funcoes
			
			table.put("\\fun" , ZString.FUN);
			table.put("\\pfun" , ZString.PFUN );
			table.put("\\pinj" , ZString.PINJ);
			table.put("\\inj" , ZString.INJ);
			table.put("\\psurj" , ZString.INJ);
			table.put("\\surj" , ZString.SURJ);
			table.put("\\bij" , ZString.BIJ);
			table.put("\\ffun" , ZString.FFUN);
			table.put("\\finj" , ZString.FINJ);
			table.put("\\lambda" , ZString.LAMBDA);
			table.put("\\circ" , ZString.CIRC);
			table.put("\\rimg" , ZString.RIMG);
			table.put("\\limg" , ZString.LIMG);
			//TODO
			table.put("dom" , "\\dom");
			table.put("id" , "\\id");
			table.put("ran" , "\\ran");
			table.put("inv" , "\\inv");
			
			//Sequencias
			
			table.put("\\cat" , ZString.CAT);
			table.put("\\langle" , ZString.LANGLE);
			table.put("\\rangle" , ZString.RANGLE);
			table.put("\\extract" , ZString.EXTRACT);
			table.put("\\filter", ZString.FILTER);
			//TODO
			table.put("\\seq","seq");
			table.put("\\iseq","iseq");
			
			 
//			Esquemas
			
			table.put("\\vdash" , ZString.VDASH);
			table.put("\\Delta" , ZString.DELTA);
			table.put("\\Xi" , ZString.XI);
			table.put("\\LET" , ZString.LET);
			table.put("\\IF" , ZString.IF);
			table.put("\\ELSE" , ZString.ELSE);
			table.put("\\pre" , ZString.PRE);
			table.put("\\then" , ZString.THEN);
			table.put("\\theta" , ZString.THETA);
			table.put("\\ldata" , ZString.LDATA);
			table.put("\\rdata" , ZString.RDATA);
			table.put("\\lblot" ,ZString.LBIND);
			table.put("\\rblot" , ZString.RBIND);
			table.put("\\alpha" , "\u03B1");
			table.put("\\pipe" , CircusString.ZPIPE);
			
		}
		
		public String get(String key) {
			return table.get(key);
		}
		public Set keySet(){
			return table.keySet();
		}
		public Set<Map.Entry<String, String>> entradas() {
			return this.table.entrySet();
		}
	

}
