package circusRefine.util.docgenerator;

import java.util.ArrayList;

import javax.swing.JOptionPane;

import net.sourceforge.czt.circus.ast.ChannelSetPara;
import net.sourceforge.czt.circus.ast.TransformerPara;
import net.sourceforge.czt.circus.util.CircusUtils;
import net.sourceforge.czt.z.ast.AxPara;
import net.sourceforge.czt.z.ast.LatexMarkupPara;
import net.sourceforge.czt.z.ast.NarrPara;
import net.sourceforge.czt.z.ast.Para;
import net.sourceforge.czt.z.ast.ZParaList;
import net.sourceforge.czt.z.ast.ZSect;
import net.sourceforge.czt.z.util.ZUtils;
import circusRefine.core.print.Printer;
import circusRefine.core.print.ProgramPrint;

public class ProgramPrintLatex extends ProgramPrint{

	public ProgramPrintLatex(DocGenerator printer) {
		super(printer);
	}

	/**
	 * Foi adicionado uma variavel auxiliar booleana para colocar paragrafos
	 * de um mesmo tipo (circus, zed, axdef) em um mesmo ambiente.
	 */
	public Object visitZSect(ZSect zSect)
	{
		getPercurso().append("ZSect\n");

		//Guarda-se o termo ZSect para que as referencias
		// as implicits processes sejam guardada
		this.setCurrentZSection(zSect);
		ZParaList paras= zSect.getZParaList();
		
		String strInicCircus = "\\begin{circus}";
		String strFimCircus =  "\\end{circus}";

		String strInitZed = "\\begin{zed}";
		String strFimZEd = "\\end{zed}";

		/*
		 * Lista que ira conter o texto em se de cada paragrafo
		 */
		ArrayList<String[]> strParas = new ArrayList<String[]>();
		/*
		 * Contera os tipos de paragrafos e suas sequencias.
		 */
		ArrayList<Integer> tiposParas = new ArrayList<Integer>();
		
		
		final int CIRCUSPARA = 1;
		final int ZPARA = 2;
		final int AXPARA = -1;
		boolean first = true;
		boolean captCircus = false;
		boolean captZ = false;
		int incr = 0; // guarda o numero de paragrafos que sao do mesmo tipo
					  //em sequencia
		int counterAXPARAS = 0; //Conta o numero de AXPARAS.
		getPercurso().append("paragrafos: " + paras.size() + "\n");
		for (Para para : paras) {
			if (!(para instanceof LatexMarkupPara || para instanceof NarrPara || this.isImplicitPara(para))) {
				getPercurso().append("Chamando o ParaPrint\n");
				String[] strPara = (String[])para.accept(paraPrint());
				for (int i=0;i<strPara.length;i++) {
					getPercurso().append(strPara[i] + "\n");
				}
				strParas.add(strPara);
				/*
				 * Em caso de AxPara o proprio metodo visit, defini o ambiente Latex
				 * que ele esta enquadrado, pode ser zed, circus, gendef, axdef
				 */
				if ((para instanceof AxPara) && first) {
					tiposParas.add(AXPARA);
					counterAXPARAS++;
					captCircus = false;
					captZ = false;
				}
				/*
				 * Caso ele encontra um AxPara quando o mesmo esta no meio 
				 * de uma contagem
				 */
				else if ((para instanceof AxPara) && !first) {
					tiposParas.add(incr);
					tiposParas.add(AXPARA);
					counterAXPARAS++;
					incr = 0;
					first = true;
					captCircus = false;
					captZ = false;
				}
				/*
				 * Caso em que se encontra um primeiro paragrafo de Circus.
				 * Os paragrafos subsequentes de circus ficarao no mesmo ambiente que este.
				 */
				else if ( first && CircusUtils.isCircusGlobalPara(para) && !captCircus) {
					tiposParas.add(CIRCUSPARA);
					first = false;
					captCircus = true;
					incr = 1;
				}
				/*
				 * Caso analogo com paragrafos de Z
				 */
				else if (first && ZUtils.isZPara(para) && !captZ ){
					tiposParas.add(ZPARA);
					first = false;
					captZ = true;
					incr = 1;
				}
				/*
				 * Mesmo tipo de paragrafo em sequencia
				 */
				else if (!first && captCircus && CircusUtils.isCircusGlobalPara(para) ||
						(!first && captZ && ZUtils.isZPara(para) )){
					incr++;
				}
				else if (!first && captCircus && !CircusUtils.isCircusGlobalPara(para) ||
						(!first && captZ && !ZUtils.isZPara(para))){
					tiposParas.add(incr);
					incr = 0;
					first = true;
					captCircus = false;
					captZ = false;
				}
			}
		}
		
		/*
		 * Nesse caso o lao for nao adicionou o ultimo incremento, isso fora a 
		 * adio deste numero.
		 */
		if ((tiposParas.size() - counterAXPARAS)%2!=0) {
			tiposParas.add(incr);
		}
		
		String[] result = null;
		ArrayList<String> text = new ArrayList<String>();
		/*
		 * Ajustando os Paragrafos de acordo com o Ambiente
		 */
		int index = 0;
		for (int i=0;i < strParas.size();i++) {
			int choice = tiposParas.get(index);
			
			if (choice != AXPARA) {
					index++;
					int quant = tiposParas.get(index);
					
					if (quant == 1) {
						if (choice == CIRCUSPARA)
							text.add(strInicCircus);
						else
							text.add(strInitZed);
						for (int k=0;k<strParas.get(i).length;k++) {
							text.add(strParas.get(i)[k]);
						}
						if (choice == CIRCUSPARA)
							text.add(strFimCircus);
						else
							text.add(strFimZEd);
					}
					else {
						if (choice == CIRCUSPARA)
							text.add(strInicCircus);
						else
							text.add(strInitZed);
						for (int j=0;j<quant-1;j++) {
							for (int k=0;k<strParas.get(i).length;k++) {
								text.add(strParas.get(i)[k]);
							}
							i++;
							text.add("\\also");
						}
						
							for (int k=0;k<strParas.get(i).length;k++) {
							text.add(strParas.get(i)[k]);
						}
						
						if (choice == CIRCUSPARA)
							text.add(strFimCircus);
						else
							text.add(strFimZEd);
					}
					index++;
			}
			else { //CASO AXPARA
				boolean aux = false;
				if (!strParas.get(i)[0].startsWith("\\begin")){
					text.add(strInicCircus);
					aux = true;
				}
				for (int q=0;q<strParas.get(i).length;q++) {
					text.add(strParas.get(i)[q]);
				}
				if (aux) {
					text.add(strFimCircus);
				}
				index++;
			}
			
		}
		result = new String[text.size()];
		for (int i=0;i< text.size();i++) {
			result[i] = text.get(i);
		}
		
		return result;
	}
	
}
