package circusRefine.util.docgenerator;

import java.util.List;

import javax.swing.JOptionPane;

import net.sourceforge.czt.circus.ast.ActionTransformerPred;
import net.sourceforge.czt.circus.ast.ProcessTransformerPred;
import net.sourceforge.czt.circus.ast.Transformation;
import net.sourceforge.czt.z.ast.And;
import net.sourceforge.czt.z.ast.AndPred;
import net.sourceforge.czt.z.ast.Exists1Pred;
import net.sourceforge.czt.z.ast.ExistsPred;
import net.sourceforge.czt.z.ast.Expr;
import net.sourceforge.czt.z.ast.ForallPred;
import net.sourceforge.czt.z.ast.IffPred;
import net.sourceforge.czt.z.ast.ImpliesPred;
import net.sourceforge.czt.z.ast.MemPred;
import net.sourceforge.czt.z.ast.NegPred;
import net.sourceforge.czt.z.ast.OrPred;
import net.sourceforge.czt.z.ast.Pred2;
import net.sourceforge.czt.z.ast.QntPred;
import net.sourceforge.czt.z.ast.RefExpr;
import net.sourceforge.czt.z.ast.SetExpr;
import net.sourceforge.czt.z.ast.TupleExpr;
import net.sourceforge.czt.z.ast.ZName;
import net.sourceforge.czt.z.util.ZString;
import circusRefine.core.print.PredPrint;

public class PredPrintLatex extends PredPrint {

	public PredPrintLatex(DocGenerator printer) {
		super(printer);
	}



	/**
	 * Quebra depois do @
	 */
	public Object visitQntPred(QntPred qntPred)
	{
		String[] result = null;

		getPercurso().append("QntPred\n");

		String str = "";
		int index = 1;

		if(qntPred instanceof ForallPred) {
			str = str + "\\forall ";
		}
		else if(qntPred instanceof ExistsPred) {
			str = str + "\\exists ";
		}
		else if(qntPred instanceof Exists1Pred) {
			str = str + "\\exists_1 ";
		}

		String[] strPred = (String[])qntPred.getPred().accept(this);
		String[] strSchText = (String[])qntPred.getSchText().accept(exprPrint());
		result = new String[strPred.length + strSchText.length];

		result[0] = str + strSchText[0];
		for(int i=1; i<strSchText.length; i++) {
			result[index] = strSchText[i];
			index++;
		}
		
		result[index] = " @ " + strPred[0];

		index++;
		for(int i=1; i<strPred.length; i++) {
			result[index] = strPred[i];
			index++;
		}

		return result;
	}


	/**
	 * Quebra no operador binario 
	 */
	public Object visitPred2(Pred2 pred2)
	{
		String[] result = null;

		getPercurso().append("Pred2\n");

		String str = "";
		String[] strPredL = (String[])pred2.getLeftPred().accept(this);
		String[] strPredR = (String[])pred2.getRightPred().accept(this);
		result = new String[strPredL.length + strPredR.length];

		int index = 1;
		result[0] = "(" + strPredL[0];
		for(int i=1; i< strPredL.length; i++) {
			result[index++] = strPredL[i];
		}

		if(pred2 instanceof IffPred) {
			str = " \\iff ";
		}
		else if(pred2 instanceof ImpliesPred) {
			str = " \\implies ";
		}
		else if(pred2 instanceof OrPred) {
			str = " \\lor ";
		}

		result[index] = str + strPredR[0] ;
		index++;
		for(int i=1; i<strPredR.length; i++) {
			result[index++] = strPredR[i];
		}
		index--;
		result[index] = result[index] + ") " ;

		return result;
	}

	/**
	 * AndPred instances are visited separately from Pred2 instances
	 * because they have extra requires if they are a chain relation.
	 */
	public Object visitAndPred(AndPred andPred)
	{		
		//TODO ve as operacoes
		String[] result = null;
		getPercurso().append("AndPred\n");

		String str = " \\land ";
		String[] strPredL = (String[])andPred.getLeftPred().accept(this);
		String[] strPredR = (String[])andPred.getRightPred().accept(this);
		result = new String[strPredL.length + strPredR.length];

		int index = 1;
		result[0] = "(" + strPredL[0];
		for(int i=1; i< strPredL.length; i++) {
			result[index++] = strPredL[i] ;
		}

		result[index] = str + strPredR[0];
		index++;
		for(int i=1; i<strPredR.length; i++) {
			result[index++] = strPredR[i];
		}
		index--;
		result[index] = result[index] + ")";

		return result;
	}
	
	
	
	public Object visitActionTransformerPred(ActionTransformerPred term) {
		  
		  getPercurso().append("ActionTransformerPred\n");
		  
		  String[] result= null;
		  String[] spec = null;
		  String[] impl = null;
		  
		  Transformation symbolTrans = term.getTransformation();
		  /* symbol - Refinamento, Equivalncia ou Simulao*/
		  String symbol = this.getSymbol(symbolTrans);
		  
		  /* spec \circrefines impl*/
		  spec = (String[])term.getSpec().accept(actionPrint());
		  impl = (String[])term.getImpl().accept(actionPrint());
		  
		  result = new String[spec.length + impl.length + 1];
		  
		  int index = 0;
		  for (int i =0;i< spec.length;i++) {
			  result[index++] =  BRANCO + "\\t1 " + spec[i];
		  }
		  result[index++]= symbol;
		  for (int i = 0; i< impl.length;i++) {
			  result[index++]= BRANCO + "\\t1 " + impl[i]; 
		  }
		  
		  
		  return result;
	  }

	  public Object visitProcessTransformerPred(ProcessTransformerPred term) {
		  getPercurso().append("ProcessTransformerPred\n");
		  
		  String[] result= null;
		  String[] spec = null;
		  String[] impl = null;
		  
		  
		  Transformation symbolTrans = term.getTransformation();
		  /* symbol - Refinamento, Equivalncia ou Simulao*/
		  String symbol = this.getSymbol(symbolTrans);
		  
		  /* spec \circrefines impl*/
		  spec = (String[])term.getSpec().accept(processPrint());
		  impl = (String[])term.getImpl().accept(processPrint());
		  
		  /* Verifica qual sera o maior tamanho do actionTransformerPred*/
		  result = new String[spec.length + impl.length + 1];
		  
		  int index = 0;
		  for (int i =0;i< spec.length;i++) {
			  result[index++] =  BRANCO + "\\t1 " + spec[i];
		  }
		  result[index++]= symbol;
		  for (int i = 0; i< impl.length;i++) {
			  result[index++]= BRANCO + "\\t1 " + impl[i]; 
		  }
		  
		  
		  return result;
		  

		  
	  }
	
	


}
