package circusRefine.util.docgenerator;

import java.util.List;

import net.sourceforge.czt.z.ast.ConstDecl;
import net.sourceforge.czt.z.ast.Name;
import net.sourceforge.czt.z.ast.VarDecl;
import circusRefine.core.print.DeclPrint;

public class DeclPrintLatex extends DeclPrint {

	public DeclPrintLatex(DocGenerator printer) {
		super(printer);
	}
	
	/**
	 * ConstDecl tera agora quebra de linha, isso deve-se ao fato
	 * de que em Latex ele nao quebrar a linha automaticamente
	 * quando se h um grande comprimento horizonal de caracteres.
	 */
	public Object visitConstDecl(ConstDecl constDecl)
	  {
		  String[] result = null;
		  getPercurso().append("ConstDEclLatex\n");
		 
		  String str = constDecl.getZName().getWord();
		  
		  if (str.startsWith("$$defaultSt")) {
			  str = "Default";
		  }
		  str = str + this.Space + "==" + Space + "\\\\";
		  
		  String[] strExprs = (String [])constDecl.getExpr().accept(exprPrint());
		  
		  result = new String[strExprs.length + 1];
		  result[0] = str;
		  //Caso - AndPred igual a AndPred.NewLine
		  int index =1 ;
		  for (int i=0;i<strExprs.length;i++) {
			  result[index++] = BRANCO + "\\t1 "+ strExprs[i];
		  }
		  return result;
	  }
	
}
