package circusRefine.util.docgenerator;

import java.util.List;

import javax.swing.JOptionPane;

import net.sourceforge.czt.base.ast.Term;
import net.sourceforge.czt.circus.ast.Action2;
import net.sourceforge.czt.circus.ast.CallAction;
import net.sourceforge.czt.circus.ast.ChannelSet;
import net.sourceforge.czt.circus.ast.CircusAction;
import net.sourceforge.czt.circus.util.CircusString;
import net.sourceforge.czt.circus.util.CircusUtils;
import net.sourceforge.czt.z.ast.Decl;
import net.sourceforge.czt.z.ast.ZDeclList;
import net.sourceforge.czt.z.ast.ZName;
import net.sourceforge.czt.z.ast.ZRenameList;
import net.sourceforge.czt.z.util.ZString;
import net.sourceforge.czt.zpatt.ast.JokerDeclList;
import net.sourceforge.czt.zpatt.ast.JokerName;
import circusRefine.core.NoPrograma;
import circusRefine.core.Relacionamento;
import circusRefine.core.idt.IdtAnn;
import circusRefine.core.idt.IdtUtils;
import circusRefine.core.print.ActionPrint;
import circusRefine.core.print.Printer;
import circusRefine.core.relations.RelationsAnn;
import circusRefine.core.relations.RelationsUtils;
import circusRefine.core.util.Text;
import circusRefine.util.ComentariosUtils;
import circusRefine.util.Identificador;
import circusRefine.util.NatToRoman;

public class ActionPrintLatex extends ActionPrint {

	public ActionPrintLatex(DocGenerator printer) {
		super(printer);
	}	

	public Object visitAction2(Action2 term)
	{
		getPercurso().append("Action2\n");
		String[] result = null;

		int index = 0;

		String[] strActL = (String[])term.getLeftAction().accept(this);

		this.addCounterRow(1); 
		//Como o "\\extchoice" encontra-se ao meio dos outros termos o incremento
		// o incremento so podera ser realizado apos o visit da primeira parte

		String[] strActR = (String[])term.getRightAction().accept(this);

		result = new String[strActL.length + strActR.length + 1];

		for(int i=0; i<strActL.length; i++) {
			result[index++] = BRANCO + "\\t1 " + strActL[i];
		}

		result[index] = ((String[])term.accept(action2Print()))[0];

		index++;
		for(int i=0; i<strActR.length; i++) {
			result[index++] = BRANCO  + "\\t1 " + strActR[i];
		}

		//Identificador Utilizado para verificar se o termo em questao
		//Possui algum identificador de comentario
		IdtAnn identificadorComentario = new IdtAnn(-1, Identificador.COMENTARIO);
		result[0] = inserindoIdentificador(term, result[0], identificadorComentario);

		if (identificadorComentario.getIdt() != -1){
			result = inserirComentario (result , identificadorComentario);
		}

		return result;
	}

//	ok
	public Object visitAlphabetisedParallelActionIte(net.sourceforge.czt.circus.ast.AlphabetisedParallelActionIte term)
	{
		getPercurso().append("AlphabetisedParallelActionIte\n");
		String[] result = null;

		int linhaInicial = this.getCounterRow();
		List<Decl> decls = term.getZDeclList();
		String strDecls = "";
		int size = decls.size();
		int counter = 0;
		for(Decl decl : decls) {
			strDecls = strDecls + ((String[])decl.accept(declPrint()))[0];
			if(counter < size-1) {
				strDecls = strDecls + ";";
			}
			counter++;
		}

		this.addCounterRow(1);

		String[] strAct = (String[])term.getCircusAction().accept(this);
		result = new String[strAct.length + 1];
		String strNS = ((String[])term.getNameSet().accept(exprPrint()))[0];
		String strCS = ((String[])term.getChannelSet().accept(exprPrint()))[0];

		result[0] = "\\Parallel " + strDecls + " \\circspot " + "\\lpar " + strNS + " | " + strCS + " \\rpar";
		result[0] = "\\Parallel" + Space + strDecls + Space + "\\circspot" + Space + "\\lpar"+ Space + strNS
		+ Space + "|" + Space + strCS + Space + "\\rpar";


		NoPrograma noProg = new NoPrograma(term);
		int length = result.length;
		Relacionamento rel = new Relacionamento(linhaInicial, linhaInicial + length - 1, noProg);

		addRelacionamento(rel);
		RelationsUtils.insertRelation(new RelationsAnn(linhaInicial, linhaInicial + length -1)
		, term, this.isToInsertingRelAnn());
		this.setCounterRow(length +  linhaInicial);

//		Identificador Utilizado para verificar se o termo em questao
		//Possui algum identificador de comentario
		IdtAnn identificadorComentario = new IdtAnn(-1, Identificador.COMENTARIO);
		result[0] = inserindoIdentificador(term, result[0], identificadorComentario);

		if (identificadorComentario.getIdt() != -1){
			result = inserirComentario (result , identificadorComentario);
		}

		return result;
	}
	public Object visitMuAction(net.sourceforge.czt.circus.ast.MuAction term)
	{
		getPercurso().append("MuAction\n");
		String[] result = null;

		String[] strAct = (String[])term.getCircusAction().accept(this);
		result = new String[strAct.length + 1];

		String name = ((String[])term.getName().accept(namePrint()))[0];

		result[0]  = "\\circmu " + name + " \\circspot ";

		int index = 1;
		for(int i=0; i<strAct.length; i++) {
			result[index++] = BRANCO  + "\\t1 " + strAct[i];
		}

//		Identificador Utilizado para verificar se o termo em questao
		//Possui algum identificador de comentario
		IdtAnn identificadorComentario = new IdtAnn(-1, Identificador.COMENTARIO);
		result[0] = inserindoIdentificador(term, result[0], identificadorComentario);

		if (identificadorComentario.getIdt() != -1){
			result = inserirComentario (result , identificadorComentario);
		}

		return result;
	}


	public Object visitPrefixingAction(net.sourceforge.czt.circus.ast.PrefixingAction term)
	{
		getPercurso().append("PrefixingAction\n");
		String[] result = null;

		String[] strComm = (String[])term.getCommunication().accept(communPrint());
		String[] strAct = (String[])term.getCircusAction().accept(this);
		result = new String[strComm.length + strAct.length];

		int index = 0;
		for(int i=0; i<strComm.length; i++) {
			result[index++] = strComm[i];
		}
		index--;
		result[index] = result[index] + Space + "\\then" + Space;
		index++;

		for(int i=0; i<strAct.length; i++) {
			result[index++] = BRANCO + "\\t1 "  + strAct[i];
		}
//		Identificador Utilizado para verificar se o termo em questao
		//Possui algum identificador de comentario
		IdtAnn identificadorComentario = new IdtAnn(-1, Identificador.COMENTARIO);
		result[0] = inserindoIdentificador(term, result[0], identificadorComentario);

		if (identificadorComentario.getIdt() != -1){
			result = inserirComentario (result , identificadorComentario);
		}	

		return result;
	}


	public Object visitSubstitutionAction(net.sourceforge.czt.circus.ast.SubstitutionAction term)
	{
		getPercurso().append("SubstitutionAction\n");
		String[] result = null;

		int index = 1;
		String[] strAct = (String[])term.getCircusAction().accept(this);
		result = new String[strAct.length + 1];
		result[0] = "(" + strAct[0];
		for(int i=1; i<strAct.length; i++) {
			result[index++] = BRANCO + "\\t1 " + strAct[i];
		}
		index--;
		result[index] = result[index] + ")";

		ZRenameList NewOldNames = term.getZRenameList().getNewOldPair();
		String strOld = "";
		String strRename = "";
		//TODO testar
		for(Term name : NewOldNames) {
			strRename = strRename + name.accept(exprPrint());
		}
		index++;
		//result[index] = "[" + strOld + ":=" + strNew + "]";
		result[index] = "[" + strRename + "]";

//		Identificador Utilizado para verificar se o termo em questao
		//Possui algum identificador de comentario
		IdtAnn identificadorComentario = new IdtAnn(-1, Identificador.COMENTARIO);
		result[0] = inserindoIdentificador(term, result[0], identificadorComentario);

		if (identificadorComentario.getIdt() != -1){
			result = inserirComentario (result , identificadorComentario);
		}

		return result;
	}

	public Object visitGuardedAction(net.sourceforge.czt.circus.ast.GuardedAction term)
	{
		getPercurso().append("GuardedAction\n");
		String[] result = null;

		int index = 0;
		String[] strPred = (String[])term.getPred().accept(predPrint());	  
		String[] strAct = (String[])term.getCircusAction().accept(this);

		result = new String[strPred.length + strAct.length];

		if (strPred.length > 1) {
			result[0] = "\\lcircguard"  + Space + strPred[0];

			for(int i=1; i<strPred.length; i++) {
				result[index++] = strPred[i];
			}

			index--;
			result[index] = result[index] + Space + "\\rcircguard"  
			+Space + "\\circguard" + Space;

			index++;
		}
		else {
			result[0] = "\\lcircguard" + Space + strPred[0] 
			                                             + Space + "\\rcircguard" + Space + "\\circguard" + Space;
			index = 1;
		}

		for(int i=0; i<strAct.length; i++) {
			result[index++] = BRANCO  + "\\t1 "+ strAct[i];
		}

//		Identificador Utilizado para verificar se o termo em questao
		//Possui algum identificador de comentario
		IdtAnn identificadorComentario = new IdtAnn(-1, Identificador.COMENTARIO);
		result[0] = inserindoIdentificador(term, result[0], identificadorComentario);

		if (identificadorComentario.getIdt() != -1){
			result = inserirComentario (result , identificadorComentario);
		}

		return result;
	}


	public Object visitParamAction(net.sourceforge.czt.circus.ast.ParamAction term)
	{
		getPercurso().append("ParamAction\n");
		String[] result = null;

		List<Decl> decsLaw = term.getZDeclList();
		String strDec = "";
		int size = decsLaw.size();
		int counter = 0;
		for(Decl vDec: decsLaw) {
			strDec = strDec + ((String[])vDec.accept(declPrint()))[0];
			if(counter < size-1) {
				strDec = strDec + ";";
			}
			counter++;
		}

		String[] strAct = (String[])term.getCircusAction().accept(this);
		result = new String[strAct.length + 2];
		result[0] = "(" + strDec + Space + "\\circspot" + Space;
		int index = 1;
		for(int i=0; i<strAct.length; i++) {
			result[index++] = BRANCO + "\\t1" + strAct[i];
		}
		result[index] = ")";

//		Identificador Utilizado para verificar se o termo em questao
		//Possui algum identificador de comentario
		IdtAnn identificadorComentario = new IdtAnn(-1, Identificador.COMENTARIO);
		result[0] = inserindoIdentificador(term, result[0], identificadorComentario);

		if (identificadorComentario.getIdt() != -1){
			result = inserirComentario (result , identificadorComentario);
		}

		return result;
	}

	public Object visitExtChoiceActionIte(net.sourceforge.czt.circus.ast.ExtChoiceActionIte term)
	{
		getPercurso().append("ExtChoiceActionIte\n");
		String[] result = null;
		String strDecls = "";
		int linhaInicial = this.getCounterRow();

		if (term.getDeclList() instanceof JokerDeclList) {
			JokerDeclList jokersDecl = (JokerDeclList) term.getDeclList();
			strDecls = jokersDecl.getName();
		}
		else if (term.getDeclList() instanceof ZDeclList) {
			List<Decl> decls = term.getZDeclList();

			int size = decls.size();
			int counter = 0;
			for(Decl decl : decls) {
				strDecls = strDecls + ((String[])decl.accept(declPrint()))[0];
				if(counter < size-1) {
					strDecls = strDecls + ";";
				}
				counter++;
			}
		}

		String[] strAct = (String[])term.getCircusAction().accept(this);

		result = new String[strAct.length + 1];
		result[0] = "\\Extchoice" + Space + strDecls + Space + "\\circspot" + Space;
		int index = 1;
		for(int i=0; i<strAct.length; i++) {
			result[index++] = BRANCO + "\\t1 " + strAct[i];
		}

		//Identificador Utilizado para verificar se o termo em questao
		//Possui algum identificador de comentario
		IdtAnn identificadorComentario = new IdtAnn(-1, Identificador.COMENTARIO);
		result[0] = inserindoIdentificador(term, result[0], identificadorComentario);

		if (identificadorComentario.getIdt() != -1){
			result = inserirComentario (result , identificadorComentario);
		}

		return result;
	}
	//ok
	public Object visitIntChoiceActionIte(net.sourceforge.czt.circus.ast.IntChoiceActionIte term)
	{
		getPercurso().append("IntChoiceActionIte\n");
		String[] result = null;

		List<Decl> decls = term.getZDeclList();
		String strDecls = "";
		int size = decls.size();
		int counter = 0;
		for(Decl decl : decls) {
			strDecls = strDecls + ((String[])decl.accept(declPrint()))[0];
			if(counter < size-1) {
				strDecls = strDecls + ";";
			}
			counter++;
		}

		String[] strAct = (String[])term.getCircusAction().accept(this);
		result = new String[strAct.length + 1];
		result[0] = "\\Intchoice" + Space + strDecls + Space + "\\circspot" + Space;
		int index = 1;
		for(int i=0; i<strAct.length; i++) {
			result[index++] = BRANCO + "\\t1 " + strAct[i];
		}

//		Identificador Utilizado para verificar se o termo em questao
		//Possui algum identificador de comentario
		IdtAnn identificadorComentario = new IdtAnn(-1, Identificador.COMENTARIO);
		result[0] = inserindoIdentificador(term, result[0], identificadorComentario);

		if (identificadorComentario.getIdt() != -1){
			result = inserirComentario (result , identificadorComentario);
		}
		return result;
	}

	public Object visitSeqActionIte(net.sourceforge.czt.circus.ast.SeqActionIte term)
	{
		getPercurso().append("SeqActionite\n");
		String[] result = null;

		List<Decl> decls = term.getZDeclList();
		String strDecls = "";
		int size = decls.size();
		int counter = 0;
		for(Decl decl : decls) {
			strDecls = strDecls + ((String[])decl.accept(declPrint()))[0];
			if(counter < size-1) {
				strDecls = strDecls + ";";
			}
			counter++;
		}

		String[] strAct = (String[])term.getCircusAction().accept(this);
		result = new String[strAct.length + 1];
		result[0] = "\\Semi" + Space + strDecls + Space + "\\circspot" + Space;
		int index = 1;
		for(int i=0; i<strAct.length; i++) {
			result[index++] = BRANCO + "\\t1" + strAct[i];
		}

//		Identificador Utilizado para verificar se o termo em questao
		//Possui algum identificador de comentario
		IdtAnn identificadorComentario = new IdtAnn(-1, Identificador.COMENTARIO);
		result[0] = inserindoIdentificador(term, result[0], identificadorComentario);

		if (identificadorComentario.getIdt() != -1){
			result = inserirComentario (result , identificadorComentario);
		}
		return result;
	}

	public Object visitInterleaveActionIte(net.sourceforge.czt.circus.ast.InterleaveActionIte term)
	{
		getPercurso().append("InterleaveAction\n");
		String[] result = null;

		List<Decl> decls = term.getZDeclList();
		String strDecls = "";
		int size = decls.size();
		int counter = 0;
		for(Decl decl : decls) {
			strDecls = strDecls + ((String[])decl.accept(declPrint()))[0];
			if(counter < size-1) {
				strDecls = strDecls + ";";
			}
			counter++;
		}

		String[] strAct = (String[])term.getCircusAction().accept(this);
		String strNS = ((String[])term.getNameSet().accept(exprPrint()))[0];
		result = new String[strAct.length + 1];
		result[0] = "\\Interleave" + Space + strDecls + Space + "\\circspot"+ Space 
		+ "\\linter" + Space + strNS + Space + "\\rinter";

		int index = 1;
		for(int i=0; i<strAct.length; i++) {
			result[index++] = BRANCO + strAct[i];
		}

//		Identificador Utilizado para verificar se o termo em questao
		//Possui algum identificador de comentario
		IdtAnn identificadorComentario = new IdtAnn(-1, Identificador.COMENTARIO);
		result[0] = inserindoIdentificador(term, result[0], identificadorComentario);

		if (identificadorComentario.getIdt() != -1){
			result = inserirComentario (result , identificadorComentario);
		}
		return result;
	}

	public Object visitParallelActionIte(net.sourceforge.czt.circus.ast.ParallelActionIte term)
	{
		getPercurso().append("ParallelActionIte\n");
		String[] result = null;

		List<Decl> decls = term.getZDeclList();
		String strDecls = "";
		int size = decls.size();
		int counter = 0;
		for(Decl decl : decls) {
			strDecls = strDecls + ((String[])decl.accept(declPrint()))[0];
			if(counter < size-1) {
				strDecls = strDecls + ";";
			}
			counter++;
		}

		String[] strAct = (String[])term.getCircusAction().accept(this);
		String strCS = ((String[])term.getChannelSet().accept(exprPrint()))[0];
		String strNS = ((String[])term.getNameSet().accept(exprPrint()))[0];
		result = new String[strAct.length + 1];
		result[0] = "\\lpar" + Space + strCS + Space + "\\rpar" + Space + strDecls 
		+ Space + "\\circspot" + Space + "\\lpar" + Space + strNS + Space + "\\rpar";
		int index = 1;
		for(int i=0; i<strAct.length; i++) {
			result[index++] = BRANCO + "\\t1 " + strAct[i];
		}

//		Identificador Utilizado para verificar se o termo em questao
		//Possui algum identificador de comentario
		IdtAnn identificadorComentario = new IdtAnn(-1, Identificador.COMENTARIO);
		result[0] = inserindoIdentificador(term, result[0], identificadorComentario);

		if (identificadorComentario.getIdt() != -1){
			result = inserirComentario (result , identificadorComentario);
		}
		return result;
	}

	public Object visitCallAction(CallAction term)
	{
		String[] result = new String[1];
		getPercurso().append("CallAction\n");
		result[0] = ((String[])term.getName().accept(namePrint()))[0];
		String str = ((String[])term.getExprList().accept(exprListPrint()))[0];
		
		if (result[0].startsWith(CircusUtils.DEFAULT_IMPLICIT_PROCESS_NAME_PREFIX.substring(0, 2))){
			result[0] = "Implicit Action" + result[0].charAt(result[0].length()-1);
		}
		if(str!=null && str!= "( )") {
			result[0] = result[0] + str;
		}

//		Identificador Utilizado para verificar se o termo em questao
		//Possui algum identificador de comentario
		IdtAnn identificadorComentario = new IdtAnn(-1, Identificador.COMENTARIO);
		result[0] = inserindoIdentificador(term, result[0], identificadorComentario);
		if (identificadorComentario.getIdt() != -1){
			result = inserirComentario (result , identificadorComentario);
		}
		return result;
	}

	public Object visitSkipAction(net.sourceforge.czt.circus.ast.SkipAction term)
	{
		String[] result = new String[1];
		getPercurso().append("SkipAction\n");
		result[0] = "\\Skip";
		int linhaInicial = this.getCounterRow();

		NoPrograma noProg = new NoPrograma(term);
		int length = result.length;
		Relacionamento rel = new Relacionamento(linhaInicial, linhaInicial + length -1, noProg);

		RelationsUtils.insertRelation(new RelationsAnn(linhaInicial, linhaInicial + length -1)
		, term, isToInsertingRelAnn());

		this.setCounterRow(length +  linhaInicial );

		addRelacionamento(rel);

//		Identificador Utilizado para verificar se o termo em questao
		//Possui algum identificador de comentario
		IdtAnn identificadorComentario = new IdtAnn(-1, Identificador.COMENTARIO);
		result[0] = inserindoIdentificador(term, result[0], identificadorComentario);
		if (identificadorComentario.getIdt() != -1){
			result = inserirComentario (result , identificadorComentario);
		}

		return result;
	}

	public Object visitStopAction(net.sourceforge.czt.circus.ast.StopAction term)
	{
		getPercurso().append("StopAction\n");
		String[] result = new String[1];
		result[0] = "\\Stop";
		int linhaInicial = this.getCounterRow();

		NoPrograma noProg = new NoPrograma(term);
		int length = result.length;
		Relacionamento rel = new Relacionamento(linhaInicial, linhaInicial + length -1, noProg);

		RelationsUtils.insertRelation(new RelationsAnn(linhaInicial, linhaInicial + length -1)
		, term, isToInsertingRelAnn());

		this.setCounterRow(length +  linhaInicial );

		addRelacionamento(rel);

		//Identificador Utilizado para verificar se o termo em questao
		//Possui algum identificador de comentario
		IdtAnn identificadorComentario = new IdtAnn(-1, Identificador.COMENTARIO);
		result[0] = inserindoIdentificador(term, result[0], identificadorComentario);
		if (identificadorComentario.getIdt() != -1){
			result = inserirComentario (result , identificadorComentario);
		}

		return result;
	}

	public Object visitHideAction(net.sourceforge.czt.circus.ast.HideAction term)
	{	
		getPercurso().append("HideAction\n");
		String[] result = null;
		int index = 1;
		int linhaInicial = this.getCounterRow();    

		String[] strAct = (String[])term.getCircusAction().accept(this);
		ChannelSet aux = term.getChannelSet();
		String[] strCS = (String[])aux.accept(exprPrint());
		result = new String[strAct.length + strCS.length ];

		result[0] = "(" + strAct[0];

		for(int i=1; i<strAct.length; i++) {
			result[index++] = strAct[i];
		}
		result[index] = ")" + Space + "\\circhide" + Space + strCS[0];
		index++;

		NoPrograma noProg = new NoPrograma(term);
		int length = result.length;
		Relacionamento rel = new Relacionamento(linhaInicial, linhaInicial + length -1, noProg);
		addRelacionamento(rel);

		RelationsUtils.insertRelation(new RelationsAnn(linhaInicial, linhaInicial + length -1)
		, term, isToInsertingRelAnn());

		this.setCounterRow(length +  linhaInicial);

		//Identificador Utilizado para verificar se o termo em questao
		//Possui algum identificador de comentario
		IdtAnn identificadorComentario = new IdtAnn(-1, Identificador.COMENTARIO);
		result[0] = inserindoIdentificador(term, result[0], identificadorComentario);
		if (identificadorComentario.getIdt() != -1){
			result = inserirComentario (result , identificadorComentario);
		}

		return result;
	}

//	ok
	public Object visitChaosAction(net.sourceforge.czt.circus.ast.ChaosAction term)
	{ 
		getPercurso().append("ChaosAction\n");
		String[] result = new String[1];
		result[0] = "\\Chaos";
		int linhaInicial = this.getCounterRow();

		NoPrograma noProg = new NoPrograma(term);
		int length = result.length;
		Relacionamento rel = new Relacionamento(linhaInicial, linhaInicial + length -1, noProg);

		RelationsUtils.insertRelation(new RelationsAnn(linhaInicial, linhaInicial + length -1)
		, term, isToInsertingRelAnn());

		this.setCounterRow(length +  linhaInicial );

		addRelacionamento(rel);

		//Identificador Utilizado para verificar se o termo em questao
		//Possui algum identificador de comentario
		IdtAnn identificadorComentario = new IdtAnn(-1, Identificador.COMENTARIO);
		result[0] = inserindoIdentificador(term, result[0], identificadorComentario);
		if (identificadorComentario.getIdt() != -1){
			result = inserirComentario (result , identificadorComentario);
		}
		return result;
	}


	public Object visitSchExprAction(net.sourceforge.czt.circus.ast.SchExprAction term)
	{
		getPercurso().append("SchExprAction\n");

		int linhaInicial = this.getCounterRow();
		String[] result = (String[])term.getExpr().accept(exprPrint());

		NoPrograma noProg = new NoPrograma(term);
		int length = result.length;
		Relacionamento rel = new Relacionamento(linhaInicial, linhaInicial + length - 1, noProg);

		addRelacionamento(rel);

		RelationsUtils.insertRelation(new RelationsAnn(linhaInicial, linhaInicial + length -1)
		, term, isToInsertingRelAnn());

		this.setCounterRow(length +  linhaInicial);

		//Identificador Utilizado para verificar se o termo em questao
		//Possui algum identificador de comentario
		IdtAnn identificadorComentario = new IdtAnn(-1, Identificador.COMENTARIO);
		result[0] = inserindoIdentificador(term, result[0], identificadorComentario);
		if (identificadorComentario.getIdt() != -1){
			result = inserirComentario (result , identificadorComentario);
		}

		return result;
	}





}
