package circusRefine.util;

import java.awt.Font;
import java.awt.FontMetrics;

import javax.swing.JLabel;
import javax.swing.JOptionPane;

public class SchemaUtils {

	
	protected static String Space = " ";
	
	/**
	 * Metodo auxiliar para pegar o tamanho(largura) de uma String. Como
	 * esse tamanho tambm depende do comprimento de cada caracter em sua Fonte,
	 * a fonte tb  passada como parametro
	 * @param text Texto que se deseja saber o tamanho
	 * @param font A Font em que o texto esta sendo impresso
	 * @return Largura do texto
	 */
	public static int getWidthOfString (String text, Font font){

		JLabel label = new JLabel(text);
		label.setFont(font);
		int count = 0;
		FontMetrics metrics = label.getFontMetrics(label.getFont());
		char [] c = label.getText().toCharArray();
		for (int i = 0; i < c.length; i++) {
		   int width = metrics.charWidth(c[i]);
		   count += width;
		}
		return count; 
	}
	
	/**
	 * Metodo que me retorna a parte de Cima do Schema em Unicode
	 * @param exprs Expressoes que seram utilizadas para medir o tamanho
	 * da parte de cima do Schema
	 * @param name Nome do Schema
	 * @return Parte de cima do Schema que sera utilizada no pacote printer
	 */
	public static String StringSchemaUP(String[] strExprs, String name) {
		int maxTam =0;
		String result = "";
		result = SchemaString.lEFTUP + Space + name + Space + SchemaString.ROW + SchemaString.ROW;
		Font font = new  Font("CZT", Font.PLAIN, 12);
		
		
		//compara o tamanho do nome do Schema
		int aux1 = getWidthOfString(result, font);
		if (aux1 > maxTam){
			maxTam = aux1;
		}
		
		if (strExprs.length > 0) {
			for (int i =0; i< strExprs.length; i++) {
					int aux = getWidthOfString(strExprs[i], font);
					if (aux > maxTam){
						maxTam = aux;
					}
			}
		}
		while (getWidthOfString(result, font) < maxTam){
			result += SchemaString.ROW;
		}
		
		result += SchemaString.RIGHTUP;
		
		return result;
	}
	
	
	public static String StringSchemaCENTER(String[] strExprs, String name) {
		String result = SchemaString.BARRINHADOMEIO + SchemaString.ROW + SchemaString.ROW;
		Font font = new  Font("CZT", Font.PLAIN, 12);
		
		String stringUP = SchemaUtils.StringSchemaUP(strExprs, name);
		
		while (getWidthOfString(result, font) < 0.5*getWidthOfString(stringUP, font)){;
			result += SchemaString.ROW;
		}
		return result;
	}
	
	
	/**
	 * Metodo que me retorna a baixo de Cima do Schema em Unicode
	 * @param exprs Expressoes que seram utilizadas para medir o tamanho
	 * da parte de baixo do Schema
	 * @param name Nome do Schema
	 * @return Parte de baixo do Schema que sera utilizada no pacote printer
	 */
	public static String StringSchemaDOWN(String[] strExprs, String name) {
		
		String result = SchemaString.lEFTDOW;
		String SchemaUP = SchemaUtils.StringSchemaUP(strExprs, name);
		
		/**
		 * Lembrando que essa fonte deve ser a mesma do Tela Desenvolvimento;
		 */
		Font fonte = new Font("CZT", Font.PLAIN, 12);
		
		int counter = SchemaUtils.getWidthOfString(SchemaUP, fonte);
		
		int aux = SchemaUtils.getWidthOfString(SchemaString.RIGHTDOWN, fonte);
		
		while (SchemaUtils.getWidthOfString(result, fonte) < counter - aux) {
			result+= SchemaString.ROW;
		}
		result += SchemaString.RIGHTDOWN;
		
		return result;
	}
	
}
