package circusRefine.util;

public class NatToRoman {
	/**
	 * Mtodo que transforma um nmero natural em um nmero romano.
	 *
	 * @param nat        O nmero natural que ser transformado em romano.
	 * @param quant      Quantidade de vezes que este mtodo foi chamado
	 *                   recursivamente (este parmetro  til para o controle de
	 *                   parnteses que sero impressos na tela).
	 *
	 * @return           Uma String que representa o nmero romano.
	 *
	 */
	public static String natToRom(int nat, int quant) {
		String rom = "";

		if ((nat < 1000) && (nat >= 900)) {
			rom = "cm" + natToRom(nat%900, 1);
		} else if((nat < 900) && (nat >= 500)) {
			rom = "d" + natToRom(nat%500, 1);
		} else if((nat < 500) && (nat >= 400)) {
			rom = "cd" + natToRom(nat%400, 1);
		} else if((nat < 400) && (nat >=100)) {
			for(int i = 0; i < (nat/100); i++) {
				rom = rom + "c";
			}
		} else if((nat < 100) && (nat >= 90)) {
			rom = "xc" + natToRom(nat%90, 1);
		} else if((nat <90) && (nat >= 50)) {
			rom = "l" + natToRom(nat%50, 1);
		} else if((nat < 50) && (nat >= 40)) {
			rom = "xl" + natToRom(nat%40, 1);
		} else if((nat < 40) && (nat >= 10)) {
			for(int i = 0; i < (nat/10); i++) {
				rom = rom + "x";
			}
			rom = rom + natToRom(nat%10, 1);
		} else if(nat == 9) {
			rom = "ix";
		} else if((nat < 9) && ( nat >= 5)) {
			rom = "v" + natToRom(nat%5, 1);
		} else if((nat == 4)) {
			rom = "iv";
		} else {
			for(int i=0; i<nat; i++) {
				rom = rom + "i";
			}
		}
		if(quant == 0){
			rom = "(" + rom + ")";
		}
		return rom;
	}
	
}
