/*
 * Cristiano Gurgel
 * 
 * Projeto: Circus Refine
 */
package circusRefine.storage;

import java.util.LinkedList;

import net.sourceforge.czt.base.ast.Term;
import circusRefine.core.UndoRedoTerms;

/**
 * Armazena o status do gerenciador interno do Circus Refine.
 * Utilizado no salvamento de um programa
 * 
 * @author Cristiano Gurgel
 * @version 1.1 22/12/06
 */
public class StatusInterno {

	/** A AST atual do desenvolvimento */
	private Term programaAtual;
	
	/** A pilha para o Undo */
	private LinkedList<UndoRedoTerms> undo;
	
	/** A pilha para o Redo */
	private LinkedList<UndoRedoTerms> redo;
	
	/** O id corrente */
	private int id;
	
	/** O id pai corrente */
	private int idPai;
	
	/**
	 * Inicializa o status interno com valores inciais padrao.
	 */
	public StatusInterno() {
		this(null, null, null, 0, -1);
	}
	
	/**
	 * Inicializa o StatusInterno com valores iniciais definidos.
	 * 
	 * @param prog o termo representando o programa atual
	 * @param pilhaUndo a pilha com os termos do undo
	 * @param pilhaRedo a pilha com os termos do redo
	 * @param idProg o id corrente do programa
	 * @param idProgPai o id corrente do programa pai
	 */
	public StatusInterno(Term prog, LinkedList<UndoRedoTerms> pilhaUndo, 
			LinkedList<UndoRedoTerms> pilhaRedo, int idProg, int idProgPai) {
		this.setProgramaAtual(prog);
		this.setUndo(pilhaUndo);
		this.setRedo(pilhaRedo);
		this.setId(idProg);
		this.setIdPai(idProgPai);
	}
	
	/**
	 * Acessa a AST com o programa atual do refinamento
	 * 
	 * @return o termo representado a AST com o estagio atual do 
	 * 	refinamento
	 */
	public Term getProgramaAtual() {
		return programaAtual;
	}
	
	/**
	 * Seta o programa atual do refinamento.
	 * 
	 * @param programaAtual o novo termo que representa a raiz da 
	 * 	AST
	 */
	public void setProgramaAtual(Term programaAtual) {
		this.programaAtual = programaAtual;
	}
	
	/**
	 * Acessa a pilha com os elementos de undo.
	 * 
	 * @return a pilha de undo do gerenciador interno
	 */
	public LinkedList<UndoRedoTerms> getUndo() {
		return undo;
	}
	
	/**
	 * Seta a pilha de undo do StatusInterno
	 * 
	 * @param undo a nova pilha de undo vinda do gerenciador interno
	 */
	public void setUndo(LinkedList<UndoRedoTerms> undo) {
		this.undo = undo;
	}
	
	/**
	 * Acessa a pilha de redo do StatusInterno
	 * 
	 * @return a pilha com os elementos de redo
	 */
	public LinkedList<UndoRedoTerms> getRedo() {
		return redo;
	}
	
	/**
	 * Seta a pilha de redo do StatusInterno
	 * 
	 * @param redo a nova pilha de redo advinda do gerenciador 
	 * 	interno
	 */
	public void setRedo(LinkedList<UndoRedoTerms> redo) {
		this.redo = redo;
	}
	
	/**
	 * Acessa o id do programa atual
	 * 
	 * @return o id atual do status do gerenciador interno
	 */
	public int getId() {
		return id;
	}
	
	/**
	 * Seta o id atual do gerenciador interno
	 * 
	 * @param id o novo id do status do gerenciador interno
	 */
	public void setId(int id) {
		this.id = id;
	}
	
	/**
	 * Acessa o campo idPai do status do Gerenciador Interno
	 * 
	 * @return o idPai atual do status do gerenciador interno
	 */
	public int getIdPai() {
		return idPai;
	}
	
	/**
	 * Seta o idPai atual do Status do Gerenciador Interno
	 * 
	 * @param idPai o novo idPai do gerenciador interno
	 */
	public void setIdPai(int idPai) {
		this.idPai = idPai;
	}
}
