/*
 * Cristiano Gurgel
 * 
 * Projeto: Circus Refine
 */
package circusRefine.storage;

import java.util.Stack;

/**
 * Armazena o status da tela de desenvolvimento
 * 
 * @author Cristiano Gurgel
 * @version 1.1 26/12/06
 */
public class StatusDesenvolvimento {
	
	/** O consteudo da tela de desenvolvimento */
	private Object[] conteudo;
	
	/** Valor que indica o numero da proxima lei */
	private int indentificador;
	
	/** Os limites antigos da lista de desenvolvimento */
	private Stack<Integer> textoPosAntigo;
	
	/** 
	 * Armazena as posioes de insercao das leis na lista, 
	 * utilizado no undo/redo
	 */
	private Stack<Integer> linhaLeiPos;
	
	/** As posicoes de insero de leis que foram desfeitas */
	private Stack<Integer> redoLinhaLeiPos;
	
	/**
	 * Inicializa a classe com valores em <code>null</code>.
	 */
	public StatusDesenvolvimento() {
		this(null, 1, null, null, null);
	}
	
	/**
	 * Iniucializa a classe com todos os valores definidos
	 * 
	 * @param novoConteudo o novo conteudo da lista
	 * @param novoIdentificador o novo numero do identificador
	 * @param novoTextoPosAntigo a nova pilha de posicoes no texto
	 * @param novoLinhaLeiPos a nova pilha de posicoes de leis no 
	 * 	texto
	 * @param novoRedoLinhaLeiPos a nova pilha de posicoes de leis 
	 * 	desfeitas no texto
	 */
	public StatusDesenvolvimento(Object[] novoConteudo, int novoIdentificador,
			Stack<Integer> novoTextoPosAntigo, Stack<Integer> novoLinhaLeiPos,
			Stack<Integer> novoRedoLinhaLeiPos) {
		this.setConteudo(novoConteudo);
		this.setIndentificador(novoIdentificador);
		this.setTextoPosAntigo(novoTextoPosAntigo);
		this.setLinhaLeiPos(novoLinhaLeiPos);
		this.setRedoLinhaLeiPos(novoRedoLinhaLeiPos);
	}
	
	/**
	 * Acessa o conteudo da tela de desenvolvimento
	 * 
	 * @return um array com o conetdo da lista da tela de 
	 * 	desenvolvimento 
	 */
	public Object[] getConteudo() {
		return conteudo;
	}
	
	/**
	 * Seta o conteudo da tela de desenvolvimento
	 * 
	 * @param contents o novo conteudo da tela de desenvolvimento
	 */
	public void setConteudo(Object[] contents) {
		this.conteudo = contents;
	}
	
	/**
	 * Acessa o identificador
	 * 
	 * @return o identificador da proxima lei a ser aplicada
	 */
	public int getIndentificador() {
		return indentificador;
	}
	
	/**
	 * Seta o identificador
	 * 
	 * @param indentificador o novo numero do identificador
	 */
	public void setIndentificador(int indentificador) {
		this.indentificador = indentificador;
	}

	/**
	 * Acessa a pilha com as posicoes antigas no texto
	 * 
	 * @return a pilha com os limites antigos da lista da tela de
	 *  desenvolvimento
	 */
	public Stack<Integer> getTextoPosAntigo() {
		return textoPosAntigo;
	}
	
	/**
	 * Seta a pilha com as posicoes antigas no texto
	 * 
	 * @param textoPosAntigo
	 */
	public void setTextoPosAntigo(Stack<Integer> textoPosAntigo) {
		this.textoPosAntigo = textoPosAntigo;
	}
	
	/**
	 * Acessa as posicoes de insercao de leis na lista
	 * 
	 * @return a pilha com as posicoes de insercao de leis na lista
	 */
	public Stack<Integer> getLinhaLeiPos() {
		return linhaLeiPos;
	}
	
	/**
	 * Seta as posicoes de insercao de leis na lista
	 * 
	 * @param linhaLeiPos a nova pilha com as posicoes de insercao 
	 * 	de leis
	 */
	public void setLinhaLeiPos(Stack<Integer> linhaLeiPos) {
		this.linhaLeiPos = linhaLeiPos;
	}
	
	/**
	 * Acessa a posicao de leis no texto que foram desfeitas
	 * 
	 * @return a pilha com as posicoes de leis desfeitas no texto
	 */
	public Stack<Integer> getRedoLinhaLeiPos() {
		return redoLinhaLeiPos;
	}
	
	/**
	 * Seta a pilha de posicao de leis que foram desfeitas no texto
	 * 
	 * @param redoLinhaLeiPos a nova pilha com a posicao das leis 
	 * 	que foram desfeitas no texto
	 */
	public void setRedoLinhaLeiPos(Stack<Integer> redoLinhaLeiPos) {
		this.redoLinhaLeiPos = redoLinhaLeiPos;
	}
}
