package circusRefine.gui.stacks;

import java.util.Stack;

import circusRefine.core.util.TermoColetado;
/**
 * Guarda todas as pilhas referentes a Tela Principal
 * @author alessandro87
 *
 */

public class TelaPrincipalStacks {

	private Stack<TermoColetado> undoAcoesColetadas;//Guarda as Strings das acoes coletadas 
	private Stack<TermoColetado> redoAcoesColetadas;

	public TelaPrincipalStacks(Stack<TermoColetado> undoAcoesColetadas, Stack<TermoColetado> redoAcoesColetadas) {
		super();
		this.undoAcoesColetadas = undoAcoesColetadas;
		this.redoAcoesColetadas = redoAcoesColetadas;
	}

	public Stack<TermoColetado> getRedoAcoesColetadas() {
		return redoAcoesColetadas;
	}
	public Stack<TermoColetado> getUndoAcoesColetadas() {
		return undoAcoesColetadas;
	}

	public TelaPrincipalStacks(){
		undoAcoesColetadas = new Stack<TermoColetado>();
		redoAcoesColetadas = new Stack<TermoColetado>();
	}

	public void esvaziarPilhas() {
		this.undoAcoesColetadas.clear();
	}
	public void esvaziarRedoPilhas(){
		this.redoAcoesColetadas.clear();
	}
}
