/*
 * Projeto : Refine - Ferramenta Educacional para Refinamentos
 *
 * Tipo : TelaPrincipal
 * Animacao
 * Taticas
 */
package circusRefine.gui;

/*
 * Projeto : Refine - Ferramenta Educacional para Refinamentos
 *
 * Tipo : TelaPrincipal
 *
 */

import java.awt.Color;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;

import javax.swing.ButtonGroup;
import javax.swing.DefaultDesktopManager;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDesktopPane;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;

import jcircus.JCircusController;
import jcircus.JCircusControllerFrame;

import net.sourceforge.czt.base.ast.Term;
import net.sourceforge.czt.circuspatt.util.CircusLaw;
import net.sourceforge.czt.session.Markup;
import circusRefine.Tactic.Principal.Tatica;
import circusRefine.Tactic.Util.GerenciadorTaticas;
import circusRefine.core.CollectAnswer;
import circusRefine.core.ExternalManager;
import circusRefine.core.TipoColeta;
import circusRefine.core.crules.CRulesException;
import circusRefine.core.opsdischarge.OPsDischargeUtils;
import circusRefine.core.storage.CarregamentoEspecificacao;
import circusRefine.util.BareBonesBrowserLaunch;
import circusRefine.util.CRefineException;
import circusRefine.util.Internacional;


/**
 * TelaPrincipal é um tipo que representa a tela central da ferramenta. Nela são
 * encontrados botões e opções do menu.
 */
public class TelaPrincipal extends JFrame {


	private static final long serialVersionUID = -1523107225457752763L;

	private static final String ESPACO = "                      ";
	private static final String BRANCO = ESPACO + ESPACO + ESPACO;

	private String path = "images/";
	private ExternalManager gerInterface;

	JInternalFrame desenvolvimento;
	JInternalFrame codigo;
	JInternalFrame obrigacoes;
	JInternalFrame tatica;

	private boolean first = true;
	private TipoColeta option;

	private JDesktopPane theDesktopPane;
	private DefaultDesktopManager defaultDesktopManager;

	JMenuBar Menu1 = new JMenuBar();
	JMenu MArquivo = new JMenu();
	JMenuItem MNovo = new JMenuItem();

	JMenuItem MAbrir = new JMenuItem();
	JMenuItem MSalvar = new JMenuItem();
	JMenuItem MSalvarComo = new JMenuItem();
	JMenuItem MImprimir = new JMenuItem();

	JMenuItem MSair = new JMenuItem();
	JMenu MExibir = new JMenu();
	JMenu MAjuda = new JMenu();
	JMenuItem MDesenvolvimento = new JMenuItem();
	JMenu MEditar = new JMenu();
	JMenuItem MRefazer = new JMenuItem();
	JMenuItem MDesfazer = new JMenuItem();
	JMenuItem MCopiar = new JMenuItem();
	JMenuItem MCodigoAtual = new JMenuItem();
	JMenuItem MObrigacao = new JMenuItem();

	JMenuItem MTopicos = new JMenuItem();
	JMenuItem MSobre = new JMenuItem();
	JMenu menuLeis = new JMenu();
	JLabel lbStatus = new JLabel();

	JFileChooser saveFileDialog = new JFileChooser();
	JFileChooser openFileDialog = new JFileChooser();

	String currFileName = null;  // path plus filename. null means new / untitled
	boolean dirty = false;  // true means modified text

	private GridBagConstraints cons = new GridBagConstraints();
	GridBagLayout gridBagLayout = new GridBagLayout();  

/**Autor: Samuel Lincoln Magalhães Barrocas**/
	/**
	 * Para abrir o tradutor de Circus para Java, JCircus
	 * */
    JMenuItem abrirTradutor = new JMenuItem ();
    JMenu tradutor = new JMenu ();
    
	/**
	   Para a manipulação das táticas ArcAngelC
	 */

	JMenu MArcAngelC = new JMenu();
	JMenu MTactics = new JMenu();
	JMenuItem MNovaTactics = new JMenuItem();
	JMenuItem MOpenTactics = new JMenuItem();
	JMenu MRemoveTactics = new JMenu();
	List<Tatica> taticas = null;

	//	botoes
	JButton image_open  = new JButton();
	JButton image_help  = new JButton();
	JButton image_save  = new JButton();
	JButton image_new   = new JButton();
	JButton image_print = new JButton();
	JButton image_undo = new JButton();
	JButton image_redo = new JButton();
	JButton image_gabriel = new JButton();
	JButton image_aplicar = new JButton();

	//	gifs
	ImageIcon image1;
	ImageIcon image2;
	ImageIcon image3;
	ImageIcon image4;
	ImageIcon image5;
	ImageIcon image6;
	ImageIcon image7;
	ImageIcon image8;
	ImageIcon image9;

	JRadioButton unicode;
	JRadioButton latex;
	ButtonGroup radioGroup;

	JToolBar imagensBar = new JToolBar();
	private JComboBox termsParag;
	/**
	 * JComboBox que servir� para selecionar uma 
	 * cole�ão de a��es ou de processos
	 */
	private JComboBox opt;
	private CaixaLeis laws;
	JPanel panelMenu = new JPanel();
	JLabel labelMenu;
	JLabel labelLaw;
	JFileChooser fileChooser = new JFileChooser();
	TelaPrincipal_actionsParag_ItemAdapter actionParagAdapter = new TelaPrincipal_actionsParag_ItemAdapter(this);

	private JProgressBar progressBar;
	private JDialog loading;
	/**
	 * Construtor da classe TelaPrincipal.
	 *
	 * @param gerInterface       Gerenciador de todas as telas do sistema.
	 * @param des a janela de desenvolvimento
	 * @param cod a janela de codigo
	 * @param obri a janela referente a obrigacoes de prova
	 */
	public TelaPrincipal(ExternalManager gerInterface, JInternalFrame des,
			JInternalFrame cod, JInternalFrame obri,  CaixaLeis leis) {
		try {
			this.gerInterface = gerInterface;
			theDesktopPane = new JDesktopPane();
			defaultDesktopManager = new DefaultDesktopManager();
			theDesktopPane.setDesktopManager(defaultDesktopManager);
			option = TipoColeta.ACAO;
			laws = leis;
			this.setarJanelasInternas(des, cod, obri);

			// valores minimos e maximos do progressBar 
			this.progressBar = new JProgressBar(0, 0);
			progressBar.setValue(0);
			progressBar.setIndeterminate(false);
			progressBar.setStringPainted(true);

			loading = new JDialog(this, this.retornarMensagem("COD0605"), true);
			loading.add(progressBar);
			loading.pack();
			loading.setResizable(false);

			jbInit();

			this.setExtendedState(TelaPrincipal.MAXIMIZED_BOTH);

		} catch (Exception except) {
			except.printStackTrace();
			CRefineException e = new CRefineException(except, except.getMessage());
			ErrorDialog errorDialog = new ErrorDialog(this.gerInterface, path,
					e);
			errorDialog.setVisible(true);
		}

	}
	/**
	 * Metodo que me retorna se sera disponibilizado uma cole�ão 
	 * de A�ão ou de Termos
	 *
	 */
	public TipoColeta getOption() {
		return option;
	}

	void image_help_actionPerformed(ActionEvent e) {
		this.MAjuda_actionPerformed(e);
	}
	void image_new_actionPerformed(ActionEvent e) {
		this.MNovo_actionPerformed(e);
	}
	void image_open_actionPerformed(ActionEvent e) {
		this.MAbrir_actionPerformed(e);
	}
	void image_print_actionPerformed(ActionEvent e) {
		this.MImprimir_actionPerformed(e);
	}
	void aplicar_actionPerformed(ActionEvent e) {
		this.gerInterface.retornarCaixaLeis().aplicarLei();
		this.gerInterface.desceRoll();
	}

	void image_redo_actionPerformed(ActionEvent e) {
		this.MRefazer_actionPerformed(e);
	}
	void image_save_actionPerformed(ActionEvent e) {
		this.MSalvar_actionPerformed(e);
	}
	void image_undo_actionPerformed(ActionEvent e) {
		this.MDesfazer_actionPerformed(e);
	}


	/**
	 * Inicializa os atributos da tela principal.
	 *
	 */
	private void jbInit() throws Exception {
		gerInterface.setTamanhoMonitor(getToolkit().getScreenSize().width, getToolkit().getScreenSize().height);
		this.setLocation(0,0);
		this.setSize(gerInterface.getTamanhoHorizontal() , (gerInterface.getTamanhoVertical()*575)/600) ;
		this.setTitle("CIRCUS REFINE ");
		this.getContentPane().setLayout(gridBagLayout);

		this.addWindowListener(new java.awt.event.WindowAdapter() {
			public void windowClosing(WindowEvent e) {
				this_windowClosing(e);
			}

			public void windowDeiconified(WindowEvent e) {
				this_windowDeiconified(e);
			}

			public void windowIconified(WindowEvent e) {
				this_windowIconified(e);
			}
		});
		this.setResizable( true );
		this.getContentPane().setBackground(SystemColor.scrollbar);
		this.setJMenuBar(Menu1);
		MArquivo.setText(this.retornarMensagem("COD0001"));
		MArquivo.setMnemonic(this.retornarMensagem("COD0001").charAt(0));
		MNovo.setText(this.retornarMensagem("COD0002"));
		MNovo.setMnemonic(this.retornarMensagem("COD0002").charAt(0));
		MAbrir.setText(this.retornarMensagem("COD0003"));
		MAbrir.setMnemonic(this.retornarMensagem("COD0003").charAt(0));
		MSalvar.setText(this.retornarMensagem("COD0005"));
		MSalvar.setMnemonic(this.retornarMensagem("COD0005").charAt(0));
		MSalvarComo.setText(this.retornarMensagem("COD0006"));
		MSalvarComo.setMnemonic(this.retornarMensagem("COD0006").charAt(2));
		MImprimir.setText(this.retornarMensagem("COD0007"));
		MImprimir.setMnemonic(this.retornarMensagem("COD0007").charAt(0));

		MSair.setText(this.retornarMensagem("COD0008"));
		MSair.setMnemonic(this.retornarMensagem("COD0008").charAt(0));

		MExibir.setText(this.retornarMensagem("COD0011"));
		MExibir.setMnemonic(this.retornarMensagem("COD0011").charAt(1));
		MDesenvolvimento.setText(this.retornarMensagem("COD0012"));
		MDesenvolvimento.setMnemonic(this.retornarMensagem("COD0012").charAt(0));
		MEditar.setText(this.retornarMensagem("COD0272"));
		MEditar.setMnemonic(this.retornarMensagem("COD0272").charAt(0));
		MDesfazer.setText(this.retornarMensagem("COD0268"));
		MDesfazer.setMnemonic(this.retornarMensagem("COD0268").charAt(0));
		MRefazer.setText(this.retornarMensagem("COD0269"));
		MRefazer.setMnemonic(this.retornarMensagem("COD0269").charAt(0));

		MCopiar.setText(this.retornarMensagem("COD0631"));
		MCopiar.setMnemonic(this.retornarMensagem("COD0631").charAt(0));

		MCodigoAtual.setText(this.retornarMensagem("COD0013"));
		MCodigoAtual.setMnemonic(this.retornarMensagem("COD0013").charAt(0));
		MObrigacao.setText(this.retornarMensagem("COD0014"));
		MObrigacao.setMnemonic(this.retornarMensagem("COD0014").charAt(0));

		inicializarJMenuItensLeis(menuLeis);

		MAjuda.setText(this.retornarMensagem("COD0018"));
		MAjuda.setMnemonic(this.retornarMensagem("COD0018").charAt(0));
		MTopicos.setText(this.retornarMensagem("COD0019"));
		MTopicos.setMnemonic(this.retornarMensagem("COD0019").charAt(0));
		MSobre.setText(this.retornarMensagem("COD0020"));
		MSobre.setMnemonic(this.retornarMensagem("COD0020").charAt(0));
		MNovo.setActionCommand("Novo");


		/**
		 * Parte para a crição da Interface para o Parser
		 */
		MArcAngelC.setText(this.retornarMensagem("ArcAngelC"));
		MArcAngelC.setMnemonic(this.retornarMensagem("ArcAngelC").charAt(0));

		MTactics.setText(this.retornarMensagem("Tactics"));
		MTactics.setMnemonic(this.retornarMensagem("Tactics").charAt(0));
		MNovaTactics.setText(this.retornarMensagem("NewT"));
		MNovaTactics.setMnemonic(this.retornarMensagem("NewT").charAt(0));
		MOpenTactics.setText(this.retornarMensagem("OpenT"));
		MOpenTactics.setMnemonic(this.retornarMensagem("OpenT").charAt(0));
		MRemoveTactics.setText(this.retornarMensagem("RemoveT"));
		MRemoveTactics.setMnemonic(this.retornarMensagem("RemoveT").charAt(0));



	    abrirTradutor.setText("Open JCircus");
	    abrirTradutor.addActionListener (
	    	new ActionListener () {
	    		public void actionPerformed (ActionEvent e) {
	    	        JCircusController controller = new JCircusControllerFrame(); //Este é o conteúdo do método "main" de JCircusPlusPlus
	    		}
	    	}
	    );
	    tradutor.setText("Translator to Java");
	    tradutor.setEnabled(true);
	    tradutor.add(abrirTradutor);
	    tradutor.addActionListener (
	    	new ActionListener () {
	    		public void actionPerformed (ActionEvent e) {
	    	        if (e.getSource() instanceof JMenuItem) {
	    	        	
	    	        }
	    		}
	    	}
	    );
		MNovo.addActionListener(new java.awt.event.ActionListener() {
			public void actionPerformed(ActionEvent e) {
				MNovo_actionPerformed(e);
			}
		});
		MAbrir.setActionCommand("Abrir");
		MAbrir.addActionListener(new java.awt.event.ActionListener() {
			public void actionPerformed(ActionEvent e) {
				MAbrir_actionPerformed(e);
			}
		});
		MSalvar.addActionListener(new java.awt.event.ActionListener() {
			public void actionPerformed(ActionEvent e) {
				MSalvar_actionPerformed(e);
			}
		});
		MSalvarComo.setActionCommand("Salvar Como");
		MSalvarComo.addActionListener(new java.awt.event.ActionListener() {
			public void actionPerformed(ActionEvent e) {
				MSalvarComo_actionPerformed(e);
			}
		});
		MImprimir.addActionListener(new java.awt.event.ActionListener() {
			public void actionPerformed(ActionEvent e) {
				MImprimir_actionPerformed(e);
			}
		});
		MSair.addActionListener(new java.awt.event.ActionListener() {
			public void actionPerformed(ActionEvent e) {
				MSair_actionPerformed(e);
			}
		});
		MDesenvolvimento.addActionListener(new java.awt.event.ActionListener() {
			public void actionPerformed(ActionEvent e) {
				MDesenvolvimento_actionPerformed(e);
			}
		});
		MCodigoAtual.addActionListener(new java.awt.event.ActionListener() {
			public void actionPerformed(ActionEvent e) {
				MCodigoAtual_actionPerformed(e);
			}
		});
		MObrigacao.addActionListener(new java.awt.event.ActionListener() {
			public void actionPerformed(ActionEvent e) {
				MObrigacao_actionPerformed(e);
			}
		});
		MAjuda.addActionListener(new java.awt.event.ActionListener() {
			public void actionPerformed(ActionEvent e) {
				MAjuda_actionPerformed(e);
			}
		});
		MSobre.addActionListener(new java.awt.event.ActionListener() {
			public void actionPerformed(ActionEvent e) {
				MSobre_actionPerformed(e);
			}
		});		
		MTopicos.addActionListener(new java.awt.event.ActionListener() {
			public void actionPerformed(ActionEvent e) {
				MTopicos_actionPerformed(e);
			}
		});		
		MDesfazer.addActionListener(new java.awt.event.ActionListener() {
			public void actionPerformed(ActionEvent e) {
				MDesfazer_actionPerformed(e);
			}
		});
		MRefazer.addActionListener(new java.awt.event.ActionListener() {
			public void actionPerformed(ActionEvent e) {
				MRefazer_actionPerformed(e);
			}
		});
		MCopiar.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent e) {
				copiarTextoSelecionado();
			}
		});
		image_new.addActionListener(new java.awt.event.ActionListener() {
			public void actionPerformed(ActionEvent e) {
				image_new_actionPerformed(e);
			}
		});
		image_open.addActionListener(new java.awt.event.ActionListener() {
			public void actionPerformed(ActionEvent e) {
				//image_open_actionPerformed(e);
			}
		});
		image_undo.addActionListener(new java.awt.event.ActionListener() {
			public void actionPerformed(ActionEvent e) {
				image_undo_actionPerformed(e);
			}
		});
		image_redo.addActionListener(new java.awt.event.ActionListener() {
			public void actionPerformed(ActionEvent e) {
				image_redo_actionPerformed(e);
			}
		});
		image_save.addActionListener(new java.awt.event.ActionListener() {
			public void actionPerformed(ActionEvent e) {
				image_save_actionPerformed(e);
			}
		});
		image_help.addActionListener(new java.awt.event.ActionListener() {
			public void actionPerformed(ActionEvent e) {
				image_help_actionPerformed(e);
			}
		});
		image_print.addActionListener(new java.awt.event.ActionListener() {
			public void actionPerformed(ActionEvent e) {
				image_print_actionPerformed(e);
			}
		});
		image_aplicar.setEnabled(false);
		image_aplicar.addActionListener(new java.awt.event.ActionListener() {
			public void actionPerformed(ActionEvent e) {
				aplicar_actionPerformed(e);
			}
		});

		theDesktopPane.addHierarchyBoundsListener(new java.awt.event.HierarchyBoundsListener () {
			public void ancestorMoved(java.awt.event.HierarchyEvent e) {
			}
			public void ancestorResized(java.awt.event.HierarchyEvent e) {
				RedimensionarJanelasInternas(e);
			}
		}
		);


		/* 
		 * Para aa Taticas 
		 */

		MNovaTactics.addActionListener(new java.awt.event.ActionListener() {

			public void actionPerformed(ActionEvent e) {
				MNovaTatica_actionPerformed(e);

			}
		});

		MOpenTactics.addActionListener(new java.awt.event.ActionListener() {

			public void actionPerformed(ActionEvent e) {
				MOpenTactics_actionPerformed(e);
			}
		});

		MRemoveTactics.addActionListener(new java.awt.event.ActionListener() {

			public void actionPerformed(ActionEvent e) {
				MRemoveTactics_actionPerformed(e);
			}
		});


		//JToolBar imagensBar
		image1 = new ImageIcon(path + "new.gif");
		image2 = new ImageIcon(path + "open.gif");
		image3 = new ImageIcon(path + "save.gif");
		image4 = new ImageIcon(path + "help.gif");
		image5 = new ImageIcon(path + "print.gif");
		image6 = new ImageIcon(path + "undo.gif");
		image7 = new ImageIcon(path + "redo.gif");
		image8 = new ImageIcon(path + "asa.gif");
		image9 = new ImageIcon(path + "generate.gif");

		image_aplicar.setIcon(image9);
		image_aplicar.setBackground(SystemColor.scrollbar);
		image_aplicar.setMaximumSize(new Dimension(30, 27));
		image_aplicar.setMinimumSize(new Dimension(30, 27));
		image_aplicar.setPreferredSize(new Dimension(30, 27));
		image_aplicar.setToolTipText("Aplicar Lei");
		// O botao de aplicar lei so sera habilitado quando houver carregamento
		// de alguma especifica�ão
		image_aplicar.setEnabled(false);


		//		Coloca�ão das imagens sobre os bot�es
		image_gabriel.setIcon(image8);
		image_gabriel.setBackground(SystemColor.scrollbar);
		image_gabriel.setMaximumSize(new Dimension(30, 27));
		image_gabriel.setMinimumSize(new Dimension(30, 27));
		image_gabriel.setPreferredSize(new Dimension(30, 27));
		image_gabriel.setToolTipText("Gabriel");

		image_undo.setIcon(image6);
		image_undo.setBackground(SystemColor.scrollbar);
		image_undo.setMaximumSize(new Dimension(30, 27));
		image_undo.setMinimumSize(new Dimension(30, 27));
		image_undo.setPreferredSize(new Dimension(30, 27));
		image_undo.setToolTipText("Undo");
		image_undo.setEnabled(false);

		image_redo.setIcon(image7);
		image_redo.setBackground(SystemColor.scrollbar);
		image_redo.setMaximumSize(new Dimension(30, 27));
		image_redo.setMinimumSize(new Dimension(30, 27));
		image_redo.setPreferredSize(new Dimension(30, 27));
		image_redo.setToolTipText("Redo");
		image_redo.setEnabled(false);

		image_open.setIcon(image2);
		image_open.setBackground(SystemColor.scrollbar);
		image_open.setMaximumSize(new Dimension(30, 27));
		image_open.setMinimumSize(new Dimension(30, 27));
		image_open.setPreferredSize(new Dimension(30, 27));
		image_open.setToolTipText("Open File");

		image_save.setIcon(image3);
		image_save.setBackground(SystemColor.scrollbar);
		image_save.setMaximumSize(new Dimension(30, 27));
		image_save.setMinimumSize(new Dimension(30, 27));
		image_save.setPreferredSize(new Dimension(30, 27));
		image_save.setToolTipText("Save");

		image_help.setIcon(image4);
		image_help.setBackground(SystemColor.scrollbar);
		image_help.setMaximumSize(new Dimension(30, 27));
		image_help.setMinimumSize(new Dimension(30, 27));
		image_help.setPreferredSize(new Dimension(30, 27));
		image_help.setToolTipText("Help");

		image_print.setIcon(image5);
		image_print.setBackground(SystemColor.scrollbar);
		image_print.setMaximumSize(new Dimension(30, 27));
		image_print.setMinimumSize(new Dimension(30, 27));
		image_print.setPreferredSize(new Dimension(30, 27));
		image_print.setToolTipText("Print");

		image_new.setIcon(image1);
		image_new.setBackground(SystemColor.scrollbar);
		image_new.setMaximumSize(new Dimension(30, 27));
		image_new.setMinimumSize(new Dimension(30, 27));
		image_new.setPreferredSize(new Dimension(30, 27));
		image_new.setToolTipText("New");

		imagensBar.setBackground(SystemColor.scrollbar);
		imagensBar.setBorder(null);

		lbStatus.setForeground(Color.red);

		Menu1.add(MArquivo);
		Menu1.add(MEditar);
		Menu1.add(MExibir);
		// Para a tática
		Menu1.add(MArcAngelC);
		Menu1.add(tradutor);
		Menu1.add(MAjuda);

		MArquivo.add(MNovo);
		MArquivo.add(MAbrir);
		MArquivo.addSeparator();
		MArquivo.add(MSalvar);
		MArquivo.add(MSalvarComo);
		MArquivo.addSeparator();
		MArquivo.add(MImprimir);
		MArquivo.addSeparator();
		MArquivo.add(MSair);

		MEditar.add(MRefazer);
		MEditar.add(MDesfazer);
		MEditar.add(MCopiar);

		MExibir.add(MDesenvolvimento);
		MExibir.add(MCodigoAtual);
		MExibir.add(MObrigacao);

		MExibir.add(menuLeis);
		MAjuda.add(MTopicos);
		MAjuda.add(MSobre);

		/**
		 *  Parte das Tática
		 */
		MArcAngelC.add(MTactics);
		MTactics.add(MNovaTactics);
		MTactics.add(MOpenTactics);
		MTactics.add(MRemoveTactics);
		MRemoveTactics.setEnabled(false);


		this.setConstraints(0,0,8,62,1.00,0.0);
		cons.fill = cons.HORIZONTAL;
		this.getContentPane().add(imagensBar, cons);

		this.setConstraints(0, 9, 88, 62, 1.00, 1.00);
		cons.fill = cons.BOTH;
		this.getContentPane().add(theDesktopPane, cons);

		laws.setVisible(true);
		laws.setEditable(false);
		this.laws.setEnabled(true);


		labelLaw = new JLabel("  " + this.retornarMensagem("COD0021") + ":");

		latex = new JRadioButton("LaTeX", true);
		latex.setBackground(SystemColor.scrollbar);
		latex.setToolTipText(this.retornarMensagem("COD0587"));

		unicode = new JRadioButton("Unicode", false);
		unicode.setBackground(SystemColor.scrollbar);
		unicode.setToolTipText(this.retornarMensagem("COD0588"));

		unicode.addActionListener(new ActionListener(){

			public void actionPerformed(ActionEvent e) {
				if (!unicode.isSelected()){
					mudarExibicao(Markup.LATEX);
				}
				else{
					mudarExibicao(Markup.UNICODE);
				}
			}

		});

		latex.addActionListener(new ActionListener(){

			public void actionPerformed(ActionEvent e) {
				if (!latex.isSelected()){
					mudarExibicao(Markup.UNICODE);
				}
				else{
					mudarExibicao(Markup.LATEX);
				}
			}

		});

		//		radioGroup trata a unica selecao das op��es
		radioGroup = new ButtonGroup();
		radioGroup.add(latex);
		radioGroup.add(unicode);


		termsParag = new JComboBox();
		termsParag.setMinimumSize(new Dimension(gerInterface.getTamanhoHorizontal()*8/100, 20));
		termsParag.setMaximumSize(new Dimension(gerInterface.getTamanhoHorizontal()*35/100, 20));
		termsParag.setPreferredSize(new Dimension(gerInterface.getTamanhoHorizontal()*20/100, 20));		
		termsParag.addItemListener(actionParagAdapter);
		termsParag.setEditable(false);
		termsParag.setVisible(true);
		termsParag.setEnabled(false);

		opt = new JComboBox();
		opt.setMinimumSize(new Dimension(gerInterface.getTamanhoHorizontal()*5/100, 20));
		opt.setMaximumSize(new Dimension(gerInterface.getTamanhoHorizontal()*9/100, 20));
		opt.setPreferredSize(new Dimension(gerInterface.getTamanhoHorizontal()*9/100, 20));
		opt.setEditable(false);
		opt.setVisible(true);
		opt.setEnabled(false);
		opt.addItemListener( new java.awt.event.ItemListener() {
			public void itemStateChanged(ItemEvent e) {
				AtualizarColecao(e);
			}
		}
		);

		this.adicionandoImagensBar();

		saveFileDialog.setDialogType(JFileChooser.SAVE_DIALOG);
		saveFileDialog.setMultiSelectionEnabled(false);
		saveFileDialog.setDialogTitle("Save");
		openFileDialog.setDialogType(JFileChooser.OPEN_DIALOG);
		openFileDialog.setMultiSelectionEnabled(false);
		openFileDialog.setDialogTitle("Open");
		//modificacoes adicionadas porque o sentido eh diferente do Word
		MSalvarComo.setEnabled(false);
		MSalvar.setEnabled(false);

		fileChooser.setMultiSelectionEnabled(false);
		fileChooser.setDialogType(JFileChooser.OPEN_DIALOG);
		fileChooser.setDialogTitle("Abrir Especifica�ão");


		loading.setLocation(this.getWidth()/4, this.getHeight()/4);

	}

	protected void selecionarTexto() {
		this.gerInterface.retornarTelaDesenvolvimento().selecionarLinhas();
	}
	protected void copiarTextoSelecionado() {
		this.gerInterface.copiarTextoSelecionado();
	}
	protected void mudarExibicao(Markup latex2) {
		new ChangeFormatThread(latex2, gerInterface).start();

	}
	public void ExibirDetalhes_actionPerformed(ActionEvent e) {
		if (e.getSource() instanceof JMenuItem) {
			String lawName = ((JMenuItem)e.getSource()).getText();
			CircusLaw leiSelecionada = null;
			if (lawName != null) {
				List<CircusLaw> laws = this.gerInterface.getLaws();
				for (CircusLaw law : laws) {
					if (law.getName() == lawName) {
						leiSelecionada = law;
					}
				}

				if (leiSelecionada != null) {
					InfoLei infoLei = new InfoLei(leiSelecionada, this.gerInterface);
					infoLei.setVisible(true);
				}
			}
		}
	}

	/**
	 * Metodo que faz a chamada para identificar e separar
	 * as leis que sao de Acoes e de Processos. Os detalhes 
	 * dessas leis sao vistos a parte do actionPerformed do
	 * JMenuItem correspondente
	 */
	private void inicializarJMenuItensLeis(JMenu menu) {

		ActionListener action = new ActionListener(){

			public void actionPerformed(ActionEvent e) {
				if (e.getSource() instanceof JMenuItem) {
					ExibirDetalhes(((JMenuItem)e.getSource()).getText());
				}
			}

		};


		this.gerInterface.inicializarMenuDeLeis(menu, action);
	}


	protected void ExibirDetalhes(String text) {
		for (CircusLaw lei : this.gerInterface.getLaws()) {
			if (text == lei.getName()) {
				InfoLei infoLei = new InfoLei(lei, this.gerInterface);
				infoLei.setVisible(true);
				break;
			}
		}
	}



	/**
	 * Metodo que muda a marca dependendo do que foi selecionado
	 * @param e
	 */
	protected void AtualizarColecao(ItemEvent e) {
		if (e.getStateChange() == e.SELECTED) {
			String key = (String)opt.getSelectedItem();
			if (key.equals(this.retornarMensagem("COD0503"))) {
				option = TipoColeta.ACAO;
			}
			else if (key.equals(this.retornarMensagem("COD0504"))){
				option = TipoColeta.PROCESSO;
			}
			else {
				option = TipoColeta.TERMO_INICIAL;
				this.gerInterface.coletarTermoInicial();
				this.gerInterface.adicionarColetaInitialTermHist();
				this.gerInterface.updateScreen();
				this.gerInterface.atualizarOpcoes();
			}

			this.gerInterface.atualizarOpcoesColeta();
		}	
	}
	public void HabilitarndoAplicarLei() {
		this.gerInterface.retornarTelaDesenvolvimento().atualizar_Selecao();
	}
	/**
	 * Evento do menu que � respons�vel pela exibi�ão de uma outra tela que
	 * proporciona a abertura de algum arquivo da ferramenta.
	 *
	 * @param e         Evento da op�ão menu da tela principal.
	 *
	 */
	public void MAbrir_actionPerformed(ActionEvent e) {

		File currentDir = new File(".");
		fileChooser = new JFileChooser(currentDir);
		fileChooser.setMultiSelectionEnabled(false);
		fileChooser.setDialogType(JFileChooser.OPEN_DIALOG);
		fileChooser.setDialogTitle(this.retornarMensagem("COD0111"));
		int choice = fileChooser.showOpenDialog(this);
		File file = fileChooser.getSelectedFile();

		if (file != null && choice == JFileChooser.APPROVE_OPTION) {
			String fileName = file.getPath();
			System.out.println("==> "+fileName);

			progressBar.setValue(0);
			new OpenThread(gerInterface,fileName).start();

		}
	}
	/**
	 * Evento do menu que chama o m�todo da classe PrincipalAlto para mostrar
	 * a tela de Help.
	 *
	 * @param e         Evento da op�ão menu da tela principal.
	 *
	 */
	public void MAjuda_actionPerformed(ActionEvent e) {
		File aux = new File("");
		Internacional intn = gerInterface.getInternacional();
		//Verifica qual se o programa corrente esta em portugues
		//ou ingles e dependendo modifica o path
		String pais = intn.getLocalizacao().getCountry();
		String path = "";
		String osName = System.getProperty("os.name");
		if (pais.equals("BR")) {
			if (osName.startsWith("Windows")) {
				path = ".\\help\\pt_br\\index.html";
			}
			else {
				path = "/help/pt_br/index.html";
			}
		}
		else {	
			if (osName.startsWith("Windows")) {
				path = ".\\help\\en_uk\\index.html";
			}
			else {
				path = "/help/en_uk/index.html";
			}
		}
		String strPath = aux.getAbsolutePath() + path;
		BareBonesBrowserLaunch.openURL(strPath); 
		//JOptionPane.showMessageDialog(null, this.gerInterface.retornarTelaDesenvolvimento().getTextoDes().size());
		//this.gerInterface.retornarTelaDesenvolvimento().getList().repaint();
		//this.gerInterface.retornarTelaDesenvolvimento().getTextoDes().addElement("pq1p");
		//this.gerInterface.retornarTelaDesenvolvimento().teste();


	}
	/**
	 * Evento do menu que chama o m�todo da classe PrincipalAlto para mostrar
	 * a tela com o c�digo atual do programa que est� sendo refinado.
	 *
	 * @param e          Evento da op�ão menu da tela principal.
	 *
	 */
	public void MCodigoAtual_actionPerformed(ActionEvent e) {
		//		gerInterface.mostrarTelaCodigoAtual();
	}
	/**
	 * Evento do menu que chama o metodo da classe PrincipalAlto para mostrar
	 * a tela de desenvolvimento.
	 *
	 * @param e          Evento da op�ão menu da tela principal.
	 *
	 */
	public void MDesenvolvimento_actionPerformed(ActionEvent e) {
		//		gerInterface.mostrarTelaDesenvolvimento();
	}
	/**
	 * Evento do menu que chama o m�todo para desfazer uma a�ão.
	 *
	 * @param e         Evento da op�ão menu da tela principal.
	 *
	 */
	public void MDesfazer_actionPerformed(ActionEvent e) {

		
		this.gerInterface.tirarSelecao();
		
		 int type = gerInterface.retornarPilhaAplicacao();
		 if (type == new Integer(0)) {
	
		if (!(this.gerInterface.getLastAction() instanceof CarregamentoEspecificacao)) {
			try {
				gerInterface.desfazer();
				gerInterface.undoIdentGUI();
				gerInterface.updateScreen();
				gerInterface.atualizarTelaObrigacoes();
				image_redo.setEnabled(true);

				if (this.gerInterface.getSizeOfHistorico()< 2) {
					//No caso so podera contar com o carregamento do programa e do novo
					image_undo.setEnabled(false);
				}
				this.gerInterface.desceRoll();
			}
			catch (CRefineException ex) {
				ex.printStackTrace();
				ErrorDialog error = new ErrorDialog(gerInterface,"",ex);
				error.setVisible(true);
			}
			catch (CRulesException ex){
				ex.printStackTrace();
				ErrorDialog error = new ErrorDialog(gerInterface,"",ex);
				error.setVisible(true);
			}
		}
		 } else if (type == new Integer(1)) {

			 if (gerInterface.verificarPilhaTaticas()) {

				 gerInterface.desfazerAplicarTatica();
				 try {

					 gerInterface.undoIdentGUITatica();
					 gerInterface.updateScreen();
					 gerInterface.atualizarTelaCodigo();
				 } catch (CRefineException e1) {
					 // TODO Auto-generated catch block
					 e1.printStackTrace();
				 }

				 gerInterface.updateScreen();
				 gerInterface.atualizarTelaObrigacoes();
				 image_redo.setEnabled(true);

				 if (!gerInterface.getPilhaAplicacao())
					 image_undo.setEnabled(false);

				 this.gerInterface.desceRoll();
			 }
		 }


	}
	/**
	 * Evento do menu que chama o m�todo da classe PrincipalAlto para mostrar
	 * a tela de resumo das leis.
	 *
	 * @param e         Evento da op�ão menu da tela principal.
	 *
	 */
	public void MExplicacao_actionPerformed(ActionEvent e) {
		//		gerInterface.mostrarTelaExplicacao();
	}
	/**
	 * Evento do menu que � respons�vel pelo fechamento da tela principal.
	 *
	 * @param e         Evento da op�ão menu da tela principal.
	 *
	 */
	public void MFechar_actionPerformed(ActionEvent e) {
		MSalvarComo.setEnabled(false);
		MSalvar.setEnabled(false);
	}
	/**
	 * Evento do menu que � respons�vel pela impressão do programa corrente.
	 *
	 * @param e         Evento da op�ão menu da tela principal.
	 *
	 */
	public void MImprimir_actionPerformed(ActionEvent e) {
		PrintOptionsFrame newFrame = new PrintOptionsFrame(this.gerInterface);
		newFrame.setVisible(true);
	}
	/**
	 * Evento do menu que chama o m�todo da classe PrincipalAlto para mostrar
	 * a tela de leis.
	 *
	 * @param e         Evento da op�ão menu da tela principal.
	 *
	 */
	public void MLeis_actionPerformed(ActionEvent e) {
		//		gerInterface.mostrarTelaLeis();
	}
	/**
	 * Evento do menu que � respons�vel pela tela de leis da ferramenta.
	 *
	 * @param e         Evento da op�ão menu da tela principal.
	 *
	 */
	public void MMorgan_actionPerformed(ActionEvent e) {
		//this.gerInterface.testNormalization();
		//		gerInterface.mostrarTelaLeis();
	}

	private class OpenThread extends Thread{
		private String fileN;
		private ExternalManager externo;
		public OpenThread(ExternalManager ext, String file) {
			fileN = file;
			externo = ext;
		}
		public void run(){

			externo.openFile(fileN);
			updateGUI();
			finish();
			inicializarOptComboBox();
		}
	}	

	private class ChangeFormatThread extends Thread{
		private Markup marca;
		private ExternalManager externo;

		public ChangeFormatThread(Markup marc, ExternalManager ext){
			marca = marc;
			externo = ext;
		}

		public void run() {
			externo.mudarMarkup(marca);
			updateSelectedGUI(); // Deve dar update apenas 
			finish();
		}

	}



	/**
	 * Evento do menu que chama o m�todo da classe PrincipalAlto para mostrar
	 * a tela de nova especifica�ão.
	 *
	 * @param e         Evento da op�ão menu da tela principal.
	 *
	 */

	public void MNovo_actionPerformed(ActionEvent e) {

		File currentDir = new File(".");
		fileChooser = new JFileChooser(currentDir);
		fileChooser.setMultiSelectionEnabled(false);
		fileChooser.setDialogType(JFileChooser.OPEN_DIALOG);
		fileChooser.setDialogTitle(this.retornarMensagem("COD0521"));
		int choice = fileChooser.showOpenDialog(this);
		File file = fileChooser.getSelectedFile();

		if (file != null && choice == JFileChooser.APPROVE_OPTION) {
			String fileName = file.getPath();
			gerInterface.setFilePath (fileName); //By Samuel Barrocas
			try {
				int id = gerInterface.openSpecification(fileName);
				gerInterface.updateScreen(id);
				this.inicializarOptComboBox();
				this.gerInterface.atualizarOpcoesColeta();
			}
			catch (CRefineException e1) {
				ErrorDialog errorDialog = new ErrorDialog(gerInterface, fileName , 
						e1);
				errorDialog.setVisible(true);
			}
			catch (Exception e2){
				e2.printStackTrace();
				ErrorDialog errorDialog = new ErrorDialog(gerInterface , 
						e2);
				errorDialog.setVisible(true);
			}

		}

	}
	public void updateSelectedGUI() {
		SwingUtilities.invokeLater(new Runnable(){

			public void run() {
				try {
					if (gerInterface.getDevelopmentsCount() > 0) {
						gerInterface.updateSelectedScreen();
						gerInterface.atualizarTelaCodigo();
						gerInterface.desceRoll();
					}
				} catch (CRefineException e) {
					e.printStackTrace();
				}
			}

		});

	}
	public void updateGUI() {
		SwingUtilities.invokeLater(new Runnable(){

			public void run() {
				try {
					if (gerInterface.getDevelopmentsCount() > 0) {
						gerInterface.updateScreenALL();
						gerInterface.atualizarTelaCodigo();
						gerInterface.desceRoll();
					}
				} catch (CRefineException e) {
					e.printStackTrace();
				}
			}

		});

	}
	public void incrementProgress() {
		SwingUtilities.invokeLater(new Runnable() {  
			public void run() {
				if (!loading.isVisible()) {  
					loading.setVisible(true);
				}
				progressBar.setValue(progressBar.getValue() + 1);
				if (progressBar.getValue() == progressBar.getMaximum()){
					finish();
				}
			}
		});  

	}
	public void finish() {
		SwingUtilities.invokeLater(new Runnable() {  
			public void run() {
				progressBar.setValue(0);
				loading.setVisible(false);
			}  
		});  
	}
	/**
	 * Metodo que inicializa o JComboBox. 
	 * Como default as Ações sao selecionadas
	 */
	public void inicializarOptComboBox() {
		opt.setEnabled(true);
		opt.setEditable(false);
		opt.setVisible(true);
		opt.removeAllItems();
		if (this.gerInterface.hasProgram()) {
			opt.addItem(this.retornarMensagem("COD0503"));
			opt.addItem(this.retornarMensagem("COD0504"));
			if (this.gerInterface.isPODevelopment()){
				opt.addItem(this.retornarMensagem("COD0505"));
			}

		}
	}
	/**
	 * Evento do menu que chama o m�todo da classe PrincipalAlto para mostrar
	 * a tela de obriga�ão de prova.
	 *
	 * @param e         Evento da op�ão menu da tela principal.
	 *
	 */
	public void MObrigacao_actionPerformed(ActionEvent e) {
		//		gerInterface.mostrarTelaObrigacao();
	}

	/**
	 * Evento do menu que chama o m�todo para refazer uma a�ão.
	 *
	 * @param e         Evento da op�ão menu da tela principal.
	 *
	 */
	public void MRefazer_actionPerformed(ActionEvent e) {

		if (!gerInterface.isRedoHistoricoEmpty()) {
			try {
				gerInterface.refazer();
				gerInterface.redoIdentGUI();
				image_undo.setEnabled(true);

				if (gerInterface.isRedoHistoricoEmpty()) {
					image_redo.setEnabled(false);
				}
				gerInterface.updateScreen();
				gerInterface.atualizarTelaObrigacoes();
				this.gerInterface.desceRoll();
			}
			catch (CRefineException ex){
				ErrorDialog error = new ErrorDialog(this.gerInterface,"",ex);
				error.setVisible(true);
			}
			catch (CRulesException ex){
				ErrorDialog error = new ErrorDialog(this.gerInterface,"",ex);
				error.setVisible(true);
			}
		}

	}
	/**
	 * Evento do menu que � respons�vel pelo fim da utiliza�ão da ferramenta.
	 *
	 * @param e         Evento da op�ão menu da tela principal.
	 *
	 */
	public void MSair_actionPerformed(ActionEvent e) {

		this.gerInterface.fecharAbas();

		this.setVisible(false);
		this.dispose();
		System.exit(1);


	}
	/**
	 * Evento do menu que � respons�vel pelo salvamento do programa corrente.
	 *
	 * @param e         Evento da op�ão menu da tela principal.
	 *
	 */
	public void MSalvar_actionPerformed(ActionEvent e) {


		File currentDir = new File(".");
		fileChooser = new JFileChooser(currentDir);
		fileChooser.setMultiSelectionEnabled(false);
		fileChooser.setDialogType(JFileChooser.SAVE_DIALOG);
		fileChooser.setDialogTitle(this.retornarMensagem("COD0005"));
		fileChooser.showSaveDialog(this);
		File file = fileChooser.getSelectedFile();

		if (file != null) {
			String fileName = file.getPath();
			try {
				this.gerInterface.save(fileName);
				JOptionPane.showMessageDialog(null
						, this.retornarMensagem("COD0622"), "Save", JOptionPane.INFORMATION_MESSAGE);

			} 
			catch (CRefineException ex) {
				ErrorDialog errorDialog = new 
				ErrorDialog(this.gerInterface, path , ex);
				errorDialog.setVisible(true);
			}
		}


	}
	/**
	 * Evento do menu que � respons�vel pelo salvamento do programa corrente.
	 *
	 * @param e         Evento da op�ão menu da tela principal.
	 *
	 */
	public void MSalvarComo_actionPerformed(ActionEvent e) {
		this.setarStatus(this.retornarMensagem("COD0105"));
		int		defMode         = saveFileDialog.getDialogType();
		String	defTitle        = saveFileDialog.getDialogTitle();
		File defDirectory     = saveFileDialog.getCurrentDirectory();
		File defFile          = saveFileDialog.getSelectedFile();

		try{
			//saveFileDialog = new JFileChooser(this, defTitle, defMode);
			saveFileDialog = new JFileChooser(defDirectory);
			saveFileDialog.setDialogTitle(defTitle);
			saveFileDialog.setDialogType(defMode);
			saveFileDialog.setSelectedFile(defFile);
			saveFileDialog.setVisible(true);

			String fileName = saveFileDialog.getCurrentDirectory().getName() + saveFileDialog.getSelectedFile().getName();
			//if(saveFileDialog.getFile() != null){
			//			gerInterface.salvarPrograma(fileName);
			//}
			this.setarStatus("");
		}catch(Exception ex){
			JOptionPane.showMessageDialog(null, this.retornarMensagem("COD0263"), "Erro", JOptionPane.ERROR_MESSAGE);
			ex.printStackTrace();
		}
	}
	/**
	 * Evento do menu que chama o m�todo da classe PrincipalAlto para mostrar
	 * a tela Sobre.
	 *
	 * @param e         Evento da op�ão menu da tela principal.
	 *
	 */
	public void MSobre_actionPerformed(ActionEvent e) {
		TelaSobre sobre = new TelaSobre(gerInterface);
		sobre.setVisible(true);
	}
	/**
	 * Evento do menu que chama o m�todo da classe PrincipalAlto para mostrar
	 * a tela de topicos da ajuda.
	 *
	 * @param e         Evento da op�ão menu da tela principal.
	 *
	 */
	public void MTopicos_actionPerformed(ActionEvent e) {
		MAjuda_actionPerformed(e);
	}
	/**
	 * Evento do menu que chama o m�todo da classe PrincipalAlto para mostrar
	 * a tela de obriga�ão de prova.
	 *
	 * @param e         Evento da op�ão menu da tela principal.
	 *
	 */
	public void MTaticas_actionPerformed(ActionEvent e) {
		//		gerInterface.mostrarTelaTaticas();
	}
	/**
	 * M�todo que retorna uma mensagem que ser� impressa na tela, tanto na forma
	 * de t�tulo quanto na forma de mensagem de erro.
	 *
	 * @param codigo     O c�digo da mensagem que ser� retornada.
	 *
	 * @return           Uma String que representa a mensagem de retorno.
	 *
	 */
	public String retornarMensagem(String codigo) {
		String mensagem = gerInterface.getMessage(codigo);
		return mensagem;
	}

	public void setarStatus(String status) {
		lbStatus.setText(BRANCO+BRANCO+status);
	}


	public void this_MudarExibicao(Markup mark) throws ChangeFormatException {
		try {
			progressBar.setValue(0);
			int cont = this.gerInterface.getSizeOfRedoHistorico();

			//Indica que esta ocorrendo uma Mudanca no Formato;
			this.gerInterface.setMundandoFormato(true);

			progressBar.setMaximum(gerInterface.getSizeOfHistorico()*2);

			Stack<Term> termosApli = this.gerInterface.getTermosAplicados();
			/* 
			 * Desfaz a o hist�rico do desenvolvimento at� a abertura 
			 * especifica�ão 
			 */
			this.desfazerAteOriginal();

			int quantRefaz = this.gerInterface.getSizeOfRedoHistorico() - cont;
			// retirando programa inicial em Latex e coloca-lo em Unicode/Latex
			//			Guardando os comentarios

			/* Abrindo novamente a especifica�ão */
			this.gerInterface.MudandoProgramaOriginal();
			this.gerInterface.refazerTudo(quantRefaz);

			this.gerInterface.atualizarHistorico(termosApli, mark);
		}
		catch (Exception e) {
			e.printStackTrace();
			throw new ChangeFormatException(e.getMessage(),e);
		}

	}
	void this_windowClosing(WindowEvent e) {
		this.gerInterface.fecharAbas();
		this.setVisible(false);
		this.dispose();
		System.exit(1);
	}
	void this_windowDeiconified(WindowEvent e) {
		gerInterface.maximizarTelas();
	}
	void this_windowIconified(WindowEvent e) {
		gerInterface.minimizarTelas();
	}
	/**
	 * Metodo utilizado para atualizar o JComboBox que contem as a��es/processos a serem coletadas
	 * @param nomes
	 */
	public void listarNomesTermsPara(java.util.List<String> nomes) {
		//		try {
		if(nomes != null) {
			this.termsParag.removeAllItems();

			if(termsParag != null) {
				Menu1.remove(termsParag);
			}
			this.termsParag.removeItemListener(this.actionParagAdapter);
			for (String str : nomes) {
				termsParag.addItem(str);
			}
			termsParag.addItemListener(actionParagAdapter);
			//Arrumadinho para controlar se foi adicionado algo a lastaction indevidamente
			termsParag.setEditable(false);
			termsParag.setVisible(true);
			termsParag.setEnabled(true);

			this.repaint();
			this.setVisible(true);

		}
	}


	/**
	 * M�todo que realiza a cole�ão de uma a�ão ou de um processo
	 */
	void termsParag_actionPerformed(ItemEvent e) {

		if (e.getStateChange() == e.SELECTED) {
			String key = (String)termsParag.getSelectedItem();
			termsParag.setEnabled(true);
			if(key != null && !((key.equals(this.retornarMensagem("COD0472")) || (key.equals(this.retornarMensagem("COD0514")))))) {
				//ACTION
				//Permite que o Printer insira os relacionamentos dos termos a serem 
				//coletado.
				if (option.equals(TipoColeta.ACAO)) {
					CollectAnswer resposta  = this.gerInterface.coletarCodigoAcao(key);
					if (resposta != null) {
						this.gerInterface.adicionarColetaAoHistorico(resposta);
					}


				}
				//PROCESS
				else if (option.equals(TipoColeta.PROCESSO)) {
					CollectAnswer resposta = this.gerInterface.coletarCodigoProcesso(key);
					if (resposta != null) {
						this.gerInterface.adicionarColetaAoHistorico(resposta);
					}
				}
				this.gerInterface.esvaziarRedoPilhas();
			}

			else if (key != null && key.equals(this.retornarMensagem("COD0743"))) {
				/* TERMO INICIAL DE UM SUBDESENVOLVIMENTO*/
				if (option.equals(TipoColeta.TERMO_INICIAL))
				{
					this.gerInterface.coletarTermoInicial();
					this.gerInterface.adicionarColetaInitialTermHist();
				}

			}


			this.gerInterface.updateScreen();
			this.habilitarUndo();
			this.gerInterface.desceRoll();
		}
	}
	/**
	 * Metodo que seta o astributos do Layout, no caso um GridBagLayout 
	 *
	 * @param gridx Permite especificar qual a posi�ão absoluta horizontalmente que o componente ser� adicionado.
	 * @param gridy Permite especificar qual a posi�ão absoluta verticalmente que o componente ser� adicionado.
	 * @param gridheight Especifica o n�mero de c�lulas que o componente ocupar� verticalmente
	 * @param gridwidth Especifica o n�mero de c�lulas que o componente ocupar� horizontalmente.
	 * @param weightx Peso em x. Especifica um peso no redimensionamento.
	 * @param weighty Peso em y. Especifica um peso no redimensionamento.
	 */	
	private void setConstraints (int gridx, int gridy,int gridheight,
			int gridwidth, double weightx, double weighty) {

		cons.gridx = gridx;
		cons.gridy = gridy;
		cons.gridheight = gridheight;
		cons.gridwidth = gridwidth;
		cons.weightx =weightx;
		cons.weighty = weighty;
	}


	/**
	 * Acessa o status atual da tela principal do circus Refine. 
	 * Utilizado no salvamento do refinamento.
	 * 
	 * @return o Status da Tela Principal do Circus Refine
	 */
	/*	public StatusPrincipal retornarStatus() {
		return new StatusPrincipal(this.lastAction, this.redolastAction, 
				this.undoAcoesColetadas, this.redoAcoesColetadas);
	}*/
	/**
	 * Metodo publico que seta as janelas internas
	 * @param des a janela de desenvolvimento
	 * @param cod a janela de codigo
	 * @param obri a janela referente a obrigacoes de prova
	 */
	public void setarJanelasInternas (JInternalFrame des, JInternalFrame cod, JInternalFrame obri) {
		this.desenvolvimento = des;
		this.codigo = cod;
		this.obrigacoes = obri;
		//this.taticas = tac;

		theDesktopPane.add(obri);
		theDesktopPane.add(des);
		theDesktopPane.add(cod);
		//theDesktopPane.add(tac);

		this.theDesktopPane.setVisible(true);
	}

	/**
	 * Metodo que configurara e adicionara os componentes do ImagensBar
	 *
	 */
	private void adicionandoImagensBar(){
		imagensBar.setLayout(gridBagLayout);

		cons.fill = cons.HORIZONTAL;
		cons.insets = new Insets(0,0,0,0);

		this.setConstraints(0, 0, 1, 2, 0.75, 0.15);
		imagensBar.add(image_new, cons);

		this.setConstraints(2, 0, 1, 2, 0.75, 0.15);
		imagensBar.add(image_open,cons);

		this.setConstraints(4, 0, 1, 2, 0.75, 0.15);
		imagensBar.add(image_save,cons);

		this.setConstraints(6, 0, 1, 2, 0.75, 0.15);
		imagensBar.add(image_print,cons);

		this.setConstraints(8, 0, 1, 2, 0.75, 0.15);
		imagensBar.add(image_undo,cons);

		this.setConstraints(10, 0, 1, 2, 0.75, 0.15);
		imagensBar.add(image_redo,cons);

		this.setConstraints(12, 0, 1, 2, 0.75, 0.15);
		imagensBar.add(image_help,cons);

		this.setConstraints(14, 0, 1, 7, 0.75, 0.15);
		imagensBar.add(latex,cons);

		this.setConstraints(21, 0, 1, 9, 0.75, 0.15);
		imagensBar.add(unicode,cons);

		labelMenu = new JLabel(this.retornarMensagem("COD0513") + " ");

		this.setConstraints(32, 0, 1, 5, 0.75, 0.15);
		imagensBar.add(labelMenu,cons);

		this.setConstraints(37, 0, 1, 5, 0.75, 0.15);
		imagensBar.add(opt,cons);
		JLabel labelPoint = new JLabel("  : ");

		this.setConstraints(42, 0, 1, 3, 0.75, 0.15);
		imagensBar.add(labelPoint,cons);

		this.setConstraints(45, 0, 1, 18, 0.75, 0.15);
		imagensBar.add(termsParag,cons);

		this.setConstraints(66, 0, 1, 3, 0.75, 0.15);
		imagensBar.add(labelLaw,cons);

		this.setConstraints(69, 0, 1, 22, 0.75, 0.15);
		imagensBar.add(laws,cons);

		this.setConstraints(91, 0, 1, 2, 0.75, 0.15);
		imagensBar.add(image_aplicar,cons);

	}

	/**
	 * Metodo utilizado para redimensionar as janelas internas 
	 * @param e evento de onde o container pai foi de alguma forma alterado
	 */
	private void RedimensionarJanelasInternas(java.awt.event.HierarchyEvent e) {
		//		No caso se o tamamnho da Janela Principal tiver sido alterado
		if (first) {
			this.gerInterface.getInfoTelas().setInfoDesktop(theDesktopPane.getHeight(), theDesktopPane.getWidth());
			first = false;
		}
		else if (e.getChanged() == this) {

			int newWidth = theDesktopPane.getWidth();
			int newHeight = theDesktopPane.getHeight();

			float fatorHeight = (float)newHeight/(float)this.gerInterface.getInfoTelas().getDesktopHeight();
			float fatorWidth = (float)newWidth/(float)this.gerInterface.getInfoTelas().getDesktopWidth();

			Float desAlt = this.gerInterface.getInfoTelas().getDesHeight()*fatorHeight;
			Float desLar = this.gerInterface.getInfoTelas().getDesWidth()*fatorWidth;

			Float desY = this.gerInterface.getInfoTelas().getDesY()*fatorHeight;
			Float desX = this.gerInterface.getInfoTelas().getDesX()*fatorWidth;

			Float codAlt = this.gerInterface.getInfoTelas().getCodHeight()*fatorHeight;
			Float codLar = this.gerInterface.getInfoTelas().getCodWidth()*fatorWidth;

			Float codY = this.gerInterface.getInfoTelas().getCodY()*fatorHeight;
			Float codX = this.gerInterface.getInfoTelas().getCodX()*fatorWidth;

			Float obriAlt = this.gerInterface.getInfoTelas().getObriHeight()*fatorHeight;
			Float obriLar = this.gerInterface.getInfoTelas().getObriWidth()*fatorWidth;

			Float obriY = this.gerInterface.getInfoTelas().getObriY()*fatorHeight;
			Float obriX = this.gerInterface.getInfoTelas().getObriX()*fatorWidth;


			//Redimensionando Desenvolvimento
			defaultDesktopManager.setBoundsForFrame(desenvolvimento, desX.intValue()
					, desY.intValue(), desLar.intValue(), desAlt.intValue() );

			//Redimensionando Codigo

			defaultDesktopManager.setBoundsForFrame(codigo, codX.intValue() 
					, codY.intValue(), codLar.intValue(), codAlt.intValue());

			//Redimensionando Tela Obrigacao
			defaultDesktopManager.setBoundsForFrame(obrigacoes, obriX.intValue(),obriY.intValue() 
					, obriLar.intValue(), obriAlt.intValue());		


			this.gerInterface.getInfoTelas().AtualizarDes(desenvolvimento);
			this.gerInterface.getInfoTelas().AtualizarCod(codigo);
			this.gerInterface.getInfoTelas().AtualizarObri(obrigacoes);
			this.gerInterface.getInfoTelas().AtualizarDesktop(theDesktopPane);

			for (JInternalFrame f : theDesktopPane.getAllFrames()) {
				//Se a mesma janela estiver na forma de icon;
				if (f.isIcon()) {
					JInternalFrame.JDesktopIcon icon =  f.getDesktopIcon();
					Float iconX = icon.getX()*fatorWidth;
					Float iconY = icon.getY()*fatorHeight;
					icon.setLocation(iconX.intValue(), iconY.intValue());
				}
			}

		}
		this.repaint();
	}


	/**
	 * Seta o status Atual da Tela Principal do Circus Refine.
	 * Utilizado na abertura de um refinamento.
	 * 
	 * @param novoStatus o novo Status da tela Principal
	 * @param acoes uma lista de Strings com as acoes do programa
	 */
	/*	public void setarStatus(StatusPrincipal novoStatus, List<String> acoes) {
		this.lastAction = novoStatus.getLastAction();
		this.redolastAction = novoStatus.getRedoLastAction();
		this.undoAcoesColetadas = novoStatus.getUndoAcoesColetadas();
		this.redoAcoesColetadas = novoStatus.getRedoAcoesColetadas();

		 Lista as acoes do programa na lista de "Coletar A�ão" 
		acoes.add(0, "");
		this.listarNomesActionsPara(acoes);

		 Habilita os botoes de undo/redo dependendo dos tamanhos das pilhas 
		this.image_undo.setEnabled(!this.lastAction.isEmpty());
		this.image_redo.setEnabled(!this.redolastAction.isEmpty());
	}*/

	/**
	 * Metodo que retorna o JCombox ActionsPara que possui as A��es Coletadas
	 * @return JCombox ActionsPara
	 */
	public JComboBox getActionsPara () {
		return this.termsParag;
	}
	/**
	 * Metodo que retorna o JCombox Laws que contera as a��es
	 * @return JCombox laws
	 */
	public JTextField getLaws () {
		return this.laws;
	}

	public class TelaPrincipal_actionsParag_ItemAdapter implements java.awt.event.ItemListener {
		TelaPrincipal adaptee;

		TelaPrincipal_actionsParag_ItemAdapter(TelaPrincipal adaptee) {
			this.adaptee = adaptee;
		}

		public void itemStateChanged(ItemEvent e) {
			try {
				adaptee.termsParag_actionPerformed(e);
			}
			catch (Exception ex){
				ex.printStackTrace();
				CRefineException except = new 
				CRefineException(ex.getMessage(),ex,"COD0635");
				ErrorDialog error = new 
				ErrorDialog(this.adaptee.gerInterface,"",except);
				error.setVisible(true);
			}
		}
	}

	public void HabilitarAplicarLei() {
		this.image_aplicar.setEnabled(true);
	}
	public void DesabilitarAplicarLei() {
		this.image_aplicar.setEnabled(false);
	}
	public void habilitarUndo() {
		this.image_undo.setEnabled(true);
	}
	public void habilitarRedo() {
		this.image_redo.setEnabled(true);
	}
	public boolean UndoIsEnabled() {
		return image_undo.isEnabled();
	}
	public boolean RedoIsEnabled() {
		return image_redo.isEnabled();
	}
	public void desabilitarUndo() {
		this.image_undo.setEnabled(false);
	}
	public void desabilitarRedo() {
		this.image_redo.setEnabled(false);
	}

	public void desfazerAteOriginal() throws CRefineException, CRulesException {
		this.gerInterface.desfazerAteOriginal();
	}
	public void setarMarkUp(Markup temp) {
		if (temp.equals(Markup.LATEX)) {
			latex.setSelected(true);
			unicode.setSelected(false);
		}
		else {
			latex.setSelected(false);
			unicode.setSelected(true);
		}
	}
	public void setarMaximumProgressBar(int size) {
		progressBar.setValue(0);
		progressBar.setMaximum(size);
	}

	/**
	 * Limpa opcoes de Coleta
	 *
	 */
	public void limparOpcoesColeta() {
		this.termsParag.removeAllItems();
		this.termsParag.setEnabled(false);

		this.opt.removeAllItems();
		this.opt.setEnabled(false);
	}
	/**
	 * Verifica se o desenvolvimento selecionado 
	 * pode ter as funcionalidades de Desfazer e Refazer
	 * habilitadas e qual a marca utilizada: Unicode ou Latex
	 * @param canUndo Indica se h� a possibildade de Desfazer
	 * @param canRedo Indica se h� a possibildade de Refazer
	 * @param marca Indica o formato de impressão utilizado
	 */
	public void atualizarOpcpes(boolean canUndo, boolean canRedo, Markup marca) {
		if (canUndo){
			this.image_undo.setEnabled(true);
		}
		else{
			this.image_undo.setEnabled(false);
		}

		if (canRedo) this.image_redo.setEnabled(true);
		else this.image_redo.setEnabled(false);

		this.setarMarkUp(marca);
	}
	/**
	 * Desabilita Desfazer, Refazer.
	 *
	 */
	public void limparOpcoes() {
		this.image_undo.setEnabled(false);
		this.image_redo.setEnabled(false);
		this.setarMarkUp(Markup.LATEX);
	}
	public Markup getMarkUp() {
		if (unicode.isSelected()) 
			return Markup.UNICODE;
		else 
			return Markup.LATEX;
	}


	/**
	 * Exibe meu e verifica se o usuario deseja
	 *@param toQuit indica se � uma a�ão de se fechar todo o programa CREfine
	 */
	private SaveChanges askforSaveBefore(boolean toQuit) {
		DialogSave janela = new DialogSave(this.gerInterface
				, this.gerInterface.getDevelopmentName(), toQuit);
		janela.setVisible(true);
		return janela.getAnswer();
	}

	public boolean askforSaveDevelopment(boolean toQuit) {
		SaveChanges save = SaveChanges.CANCELAR;
		save = askforSaveBefore(toQuit);
		if (save.equals(SaveChanges.DESCARTAR_ALTERACOES)) {
			return true;
		}
		else if (save.equals(SaveChanges.SALVAR_ALTERACOES)) {
			MSalvar_actionPerformed(null);
			return true;
		}
		else if (save.equals(SaveChanges.DESCARTAR_TODOS)) {
			this.setVisible(false);
			this.dispose();
			System.exit(1);
			return true;
		}
		else {
			return false;
		}
	}

	/**
	 * Esse metodo desabilita as op��es de salvar o programa na tela de Crefine com
	 * o objetivo de evitar que subdesenvolvimentos possam ser salvos isoladamente.
	 *
	 */
	public void desabilitarSalvar() {
		image_save.setEnabled(false);
	}
	public void habilitarSalvar() {
		image_save.setEnabled(true);
	}
	public void setProgressBar(int i) {
		progressBar.setValue(0);
	}


	/**
	 * Evento do menu que chama o método para mostrar a janela
	 * para a adição de uma nova tática
	 * @param e
	 */
	public void MNovaTatica_actionPerformed(ActionEvent e) {
		gerInterface.mostrarTelaTaticas();

	}

	public void MRemoveTactics_actionPerformed(ActionEvent e) {
		List<Tatica> lista = gerInterface.retornarListaTaticas();
	}

	/**
	 * Atualizar a lista de táticas que podem ser removidas
	 * no Menu Remove Taricas
	 * @param tatica Tática a ser adicionada no menu de Remove
	 */
	public void updateTacticList(Tatica tatica) {

		//taticas = gerInterface.retornarListaTaticas();
		final Tatica tac = tatica;
		if ( tatica != null){

			MRemoveTactics.setEnabled(true);

			JMenuItem newMenu = new JMenuItem(tatica.getId());
			MRemoveTactics.add(newMenu);
			newMenu.addActionListener(new ActionListener() {

				public void actionPerformed(ActionEvent e) {
					if (e.getSource() instanceof JMenuItem) {
						if (((JMenuItem) e.getSource()).getText().equals(tac.getId())) {
							if (removerTatica(tac))
							MRemoveTactics.remove((JMenuItem) e.getSource());
						}
					}
				}
			});

		}
	}


	public void updateTacticList() {

		taticas = gerInterface.retornarListaTaticas();
		if (taticas.size() != 0){

			MRemoveTactics.setEnabled(true);

			for (Tatica tatica : taticas) {
				JMenuItem newMenu = new JMenuItem(tatica.getId());
				MRemoveTactics.add(newMenu);
				newMenu.addActionListener(new ActionListener() {

					public void actionPerformed(ActionEvent e) {
						if (e.getSource() instanceof JMenuItem) {
							for (Tatica tatica : taticas) {
								if (((JMenuItem) e.getSource()).getText().equals(tatica.getId())) {
									if (removerTatica(tatica)){
									MRemoveTactics.remove((JMenuItem) e.getSource());
									}
									break;

								}

							}
						}
					}
				});

			}
		}
	}


	public void updateTacticListInicio(final Tatica tatica) {

		if (tatica != null){

			MRemoveTactics.setEnabled(true);

			JMenuItem newMenu = new JMenuItem(tatica.getId());
			MRemoveTactics.add(newMenu);
			newMenu.addActionListener(new ActionListener() {

				public void actionPerformed(ActionEvent e) {
					if (e.getSource() instanceof JMenuItem) {				
						if (((JMenuItem) e.getSource()).getText().equals(tatica.getId())) {
							removerTatica(tatica);
							MRemoveTactics.remove((JMenuItem) e.getSource());
						}
					}
				}
			});

		}
	}

	/**
	 * Método responsavel para abrir uma tática no sistema
	 * @param e
	 */
	protected void MOpenTactics_actionPerformed(ActionEvent e) {
		String codigo = null;
		gerInterface.retornarTelaTatica().opened = 1;

		GerenciadorTaticas gerTatica = new GerenciadorTaticas(gerInterface);
		gerInterface.retornaTelaTatica().file = gerTatica.abrirTatica();

		if (gerInterface.retornaTelaTatica().file != null) {
			gerInterface.mostrarTelaTaticas();
			try {
				codigo = gerInterface.retornarEspecificacao(gerInterface.retornaTelaTatica().file);
			} catch (IOException e1) {

				System.out.println("ERRO NO MOpenTactics_actionPerformed TELA PRINCIPAL");
			}
			gerInterface.updateTelaTatica(codigo);
		}

	}

	/**
     Metodo responsável por mostrar a mensagem para confirmar a remoção
     da tática
     @param tatica Tática a ser removida
	 */
	public boolean removerTatica(Tatica tatica) {
		boolean remove = false;
		Object[] botoes = {"Yes", "No"};
		int opcao =
			JOptionPane.showOptionDialog(
					null, "Do you really want to remove this tactic : " + tatica.getId() + " ? [Y/N]",
					"Remove Tactic",
					JOptionPane.DEFAULT_OPTION,
					JOptionPane.INFORMATION_MESSAGE,
					null, botoes, botoes[1]);
		if (opcao == 0) {
			gerInterface.removerTatica(tatica);
			remove = true;
		}
		return remove;
	}

}

