package circusRefine.gui;

/*
* Projeto : Refine - Ferramenta Educacional para Refinamentos
*
* Tipo : TelaPredParametro
*
*/

import circusRefine.core.ExternalManager;
import circusRefine.util.CodigoParametro;
import circusRefine.util.circusstring.CircusToLatex;
import circusRefine.util.circusstring.LatexToCircus;
import circusRefine.util.zstring.LatexToZ;
import circusRefine.util.zstring.ZtoLatex;
import java.awt.BorderLayout;
import javax.swing.JButton;
import java.awt.Color;
import javax.swing.JDialog;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridLayout;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextArea;
import javax.swing.JScrollPane;
import javax.swing.ImageIcon;
import net.sourceforge.czt.session.Markup;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.KeyEvent;
import java.util.Set;

/**
* TelaPredParametro � um tipo que representa a tela de parametro para algumas leis da
* ferramenta.
*/
public class TelaParametro extends JDialog {

	private ExternalManager gerInterface;
	private CodigoParametro codigo;
	private String path = "images/";
	private TecladoVirtual tecl;
	private String argument;
	
	private Markup marca; /* To unicode/Latex */
	private JRadioButton unicode;
	private JRadioButton latex;
	private ButtonGroup radioGroup;
	
	protected static String Space = " ";
	
  	JPanel panel1 = new JPanel();
  	JButton btnOK = new JButton();
  	JButton btnCancel = new JButton();
  	JTextArea tfEspec = new JTextArea();
  	JScrollPane rolagem;
  	JLabel labelEntrada = new JLabel();
  	JButton btnDigitacao = new JButton();
  	JButton btnTecladoVirtual = new JButton();
	JPanel panel2 = new JPanel();
	BorderLayout borderLayout1 = new BorderLayout();
	BorderLayout borderLayout2 = new BorderLayout();
	JPanel panel3 = new JPanel();
	GridLayout gridLayout1 = new GridLayout();
	JPanel panel4 = new JPanel();
	BorderLayout borderLayout3 = new BorderLayout();
	FlowLayout flowLayout1 = new FlowLayout();
	
	JPanel panel5 = new JPanel();
	JPanel panel6 = new JPanel();
	JPanel panel7 = new JPanel();
	JPanel panel8 = new JPanel();
	JPanel panel9 = new JPanel();


   /**
	* Construtor da classe TelaPredParametro.
	*
	* @param telaLeis           Um objeto da classe FLeis.
	* @param gerInterface       Gerenciador de todas as telas do sistema.
	*
	*/
  	public TelaParametro(ExternalManager gerInterface) {
		super(gerInterface.retornarTelaPrincipal());
		try  {
			this.gerInterface = gerInterface;
			this.tecl = new TecladoVirtual(this);
			marca = Markup.LATEX;
			jbInit();
		}
		catch (Exception e) {
	  		e.printStackTrace();
		}
  	}  
   /**
	* Construtor da classe TelaPredParametro.
	*
	* @param telaLeis           Um objeto da classe FLeis.
	* @param gerInterface       Gerenciador de todas as telas do sistema.
	*
	*/
  	public TelaParametro(ExternalManager gerInterface, CodigoParametro cod, String str ) {
  		super(gerInterface.retornarTelaPrincipal());
  		try  {
  			this.gerInterface = gerInterface;
  			this.codigo = cod;
  			this.tecl = new TecladoVirtual(this);
  			jbInit();
  		}
  		catch (Exception e) {
  			e.printStackTrace();
  		}
  	}  
    
  	/**
  	 * Metodo que retorna o argumento digitado
  	 * @return o argumento digitado
  	 */
  	public String getArgument() {
  		return argument;
  	}
  	
   /**
	* M�todo respons�vel pela a��o do bot�o Cancel da tela.
	*
	* @param e          Evento do bot�o Cancel.
	*
	*/
  	public void btnCancel_actionPerformed(ActionEvent e) {
	   	this.setVisible(false);
  	}  
 
   /**
	* M�todo respons�vel pela a��o do bot�o digita��o.
	*
	* @param e          O evento do bot�o digita��o.
	*
	*/
	void btnTecladoVirtual_actionPerformed(ActionEvent e) {
			tecl.pack();
			tecl.setLocation(490, 200);
			tecl.setVisible(true);
	}  
  	
  	
	/**
	 * M�todo respons�vel pela a��o do bot�o OK da tela.
	 *
	 * @param e          Evento do bot�o OK.
	 *
	 */
	public void btnOK_actionPerformed(ActionEvent e) {
		
		if(marca.equals(Markup.UNICODE)) {
			this.mudarExibicao(Markup.LATEX);
		}
				
		this.setArgument(tfEspec.getText());
		
		this.setVisible(false);
		gerInterface.setarFocus();

	}  
	private void testarSimbolos() {
		String resul = new String();
		ZtoLatex zLatex = new ZtoLatex ();
		CircusToLatex circusToLatex = new CircusToLatex();
		
		Set<String> ZKeySet = zLatex.keySet();
		Set<String> CircusKeySet = circusToLatex.keySet();
		
		
		for (String str: ZKeySet) {
			resul += str + "     " + zLatex.get(str) + " z\n";
		}
		for (String str : CircusKeySet) {
			resul += str + "    " + circusToLatex.get(str) + " circus\n";
		}
		
		tfEspec.setText(resul);
		
	}
	/**
	 * M�todo utilizado para digitar com o auxilio de FDigitacao.
	 *
	 * @param carac      ........
	 *
	 */
	public void escrever(String carac) {
		
		/* captura posicao do cursor na tela Parametro*/
		int position = tfEspec.getCaret().getDot();

		this.tfEspec.insert(carac, position);
		
	}
	
	/**
	 * Metodo que reinicializa a string latex que representa o latex do simbolo
	 * que sera digitado 
	 *
	 */
	public void AtualizarTfEspec (String texto) {
		String result = new String();
		result = texto;
		LatexToZ latexZ = new LatexToZ ();
		LatexToCircus latexCircus = new LatexToCircus();
		
		Set<String> ZKeySet = latexZ.keySet();
		Set<String> CircusKeySet = latexCircus.keySet();
		
		String[] StrLatexOrdenado = new String[ZKeySet.size() + CircusKeySet.size()];
		int index = 0;
		
		for (String str: ZKeySet) {
			StrLatexOrdenado[index++] = str;
		}
		for (String str : CircusKeySet) {
			StrLatexOrdenado[index++] = str;
		}//Lista Completa Desordenada -> Ordenar!
		for (int i = 0; i < StrLatexOrdenado.length; i++) {
			for (int j=0; j< StrLatexOrdenado.length; j++) {
				if (StrLatexOrdenado[j].length() < StrLatexOrdenado[i].length()){
					String aux = StrLatexOrdenado[i];
					StrLatexOrdenado[i] = StrLatexOrdenado[j];
					StrLatexOrdenado[j] = aux;
				}
				
			}
		}
		for (int i = 0; i < StrLatexOrdenado.length; i++) {
			if (latexZ.get(StrLatexOrdenado[i])!= null) {
				result = result.replace(StrLatexOrdenado[i], latexZ.get(StrLatexOrdenado[i]));
			}
			else if (latexCircus.get(StrLatexOrdenado[i]) != null) {
				result = result.replace(StrLatexOrdenado[i], latexCircus.get(StrLatexOrdenado[i]));
			}
			
		}
		
		tfEspec.setText(result);
		tfEspec.repaint();
	}
	
	public void btnRefresh_actionPerformed(ActionEvent e) {
		this.AtualizarTfEspec(tfEspec.getText());
	}
	
   /**
	* Inicializa os atributos da tela de parametro.
	*
	*/
  	private void jbInit() throws Exception {
  		this.setModal	(true);
   		this.setLocation(240,220);
   		this.setSize(420, 210);
   		this.setTitle(this.retornarMensagem("COD0109"));
		
   		tfEspec.setFont(new Font ("CZT", Font.PLAIN, 12));
   		tfEspec.setText("");
		rolagem = new JScrollPane(tfEspec);
		tfEspec.setToolTipText(this.retornarMensagem("COD0509"));
		
		tfEspec.addKeyListener(new java.awt.event.KeyAdapter() {
			public void keyPressed(KeyEvent e) {
				tfEspec_keyPressed(e);
			}
		});
		
		btnOK.setForeground(Color.green);
		btnOK.setFont(new Font("Dialog", 1, 12));
		btnOK.setText(this.retornarMensagem("COD0072"));
		btnOK.addActionListener(new java.awt.event.ActionListener() {
	    	public void actionPerformed(ActionEvent e) {
				btnOK_actionPerformed(e);
	  		}
		});
		
		ImageIcon teclicon = new ImageIcon(path + "teclado.gif");
		
		btnTecladoVirtual.setIcon(teclicon);
		btnTecladoVirtual.setToolTipText("TecladoVirtual"); 
		btnTecladoVirtual.setEnabled(false);
		
		btnTecladoVirtual.addActionListener(new ActionListener(){

			public void actionPerformed(ActionEvent e) {
				btnTecladoVirtual_actionPerformed(e);
			}
			
		});
		
		
		btnCancel.setForeground(Color.red);
		btnCancel.setFont(new Font("Dialog", 1, 12));
		btnCancel.setText(this.retornarMensagem("COD0078"));
		btnCancel.addActionListener(new java.awt.event.ActionListener() {
	  		public void actionPerformed(ActionEvent e) {
				btnCancel_actionPerformed(e);
	  		}
		});
		
		
		latex = new JRadioButton("LaTeX", true);
		//latex.setBackground(SystemColor.scrollbar);
		latex.setToolTipText(this.retornarMensagem("COD0587"));

		unicode = new JRadioButton("Unicode", false);
		//unicode.setBackground(SystemColor.scrollbar);
		unicode.setToolTipText(this.retornarMensagem("COD0588"));
		
		latex.addItemListener( new java.awt.event.ItemListener() {
			public void itemStateChanged(ItemEvent e) {
				if (e.getStateChange() == e.SELECTED) {
					mudarExibicao(Markup.LATEX);
				} else {
					mudarExibicao(Markup.UNICODE);
				}
			}
		}
		);
		
		
		radioGroup = new ButtonGroup();
		radioGroup.add(latex);
		radioGroup.add(unicode);
		
		
		labelEntrada.setText("   Entre com tal parametro:");
		panel1.setLayout(borderLayout1);
		panel2.setLayout(borderLayout2);
		panel3.setLayout(gridLayout1);
		panel4.setLayout(borderLayout3);
		panel9.setLayout(flowLayout1);
		
		this.getContentPane().add(panel1, BorderLayout.CENTER);
		panel1.add(panel2, BorderLayout.CENTER);
		panel2.add(rolagem,  BorderLayout.CENTER);
		panel2.add(panel5, BorderLayout.WEST);
		panel2.add(panel6,  BorderLayout.SOUTH);
		panel2.add(panel7,  BorderLayout.EAST);
		panel2.add(panel8, BorderLayout.NORTH);
		panel1.add(panel3,  BorderLayout.SOUTH);
		panel3.add(btnOK, null);
		panel3.add(btnTecladoVirtual);
		panel3.add(btnCancel, null);
		panel1.add(panel4, BorderLayout.NORTH);
		panel9.add(latex);
		panel9.add(unicode);
		panel4.add(labelEntrada,  BorderLayout.CENTER);
		panel4.add(panel9,  BorderLayout.EAST);
  	}
  	
  	/**
  	 * Este metodo muda forma de se conseguir um parametro.
  	 * Um usuario podera inserir um parametro tanto na forma 
  	 * latex ou unicode (com auxilio do Teclado Virtual)
  	 * @param marcaN 
  	 */
  	protected void mudarExibicao(Markup marcaN) {
  		marca = marcaN;
  		
  		String result = new String();
		result = tfEspec.getText();
  		
  		if(marca == Markup.LATEX) {
  			LatexToZ latexZ = new LatexToZ ();
  			LatexToCircus latexCircus = new LatexToCircus();
  			
  			Set<String> ZKeySet = latexZ.keySet();
  			Set<String> CircusKeySet = latexCircus.keySet();
  			
  			String[] StrLatexOrdenado = new String[ZKeySet.size() + CircusKeySet.size()];
  			int index = 0;
  			
  			for (String str: ZKeySet) {
  				StrLatexOrdenado[index++] = str;
  			}
  			for (String str : CircusKeySet) {
  				StrLatexOrdenado[index++] = str;
  			}//Lista Completa Desordenada -> Ordenar!
  			
  			for (int i = 0; i < StrLatexOrdenado.length; i++) {
  				for (int j=0; j< StrLatexOrdenado.length; j++) {
  					if (StrLatexOrdenado[j].length() < StrLatexOrdenado[i].length()){
  						String aux = StrLatexOrdenado[i];
  						StrLatexOrdenado[i] = StrLatexOrdenado[j];
  						StrLatexOrdenado[j] = aux;
  					}
  					
  				}
  			}
  			String resul = "";
  			for (int i = 0; i < StrLatexOrdenado.length; i++) {
  				resul += i + " " + StrLatexOrdenado[i] + "\n";
  				if (latexZ.get(StrLatexOrdenado[i])!= null) {
  					result = result.replace(latexZ.get(StrLatexOrdenado[i]), StrLatexOrdenado[i]);
  				}
  				else if (latexCircus.get(StrLatexOrdenado[i]) != null) {
  					result = result.replace(latexCircus.get(StrLatexOrdenado[i]), StrLatexOrdenado[i] );
  				}
  				
  			}
  			btnTecladoVirtual.setEnabled(false);
  		}
  		else if (marca == Markup.UNICODE){
  			ZtoLatex latexZ = new ZtoLatex ();
  			CircusToLatex latexCircus = new CircusToLatex();
  			
  			Set<String> ZKeySet = latexZ.keySet();
  			Set<String> CircusKeySet = latexCircus.keySet();
  			
  			String[] StrLatexOrdenado = new String[ZKeySet.size() + CircusKeySet.size()];
  			int index = 0;
  			
  			for (String str: ZKeySet) {
  				StrLatexOrdenado[index++] = str;
  			}
  			for (String str : CircusKeySet) {
  				StrLatexOrdenado[index++] = str;
  			}//Lista Completa Desordenada -> Ordenar!
  			
  			for (int i = 0; i < StrLatexOrdenado.length; i++) {
  				for (int j=0; j< StrLatexOrdenado.length; j++) {
  					if (StrLatexOrdenado[j].length() < StrLatexOrdenado[i].length()){
  						String aux = StrLatexOrdenado[i];
  						StrLatexOrdenado[i] = StrLatexOrdenado[j];
  						StrLatexOrdenado[j] = aux;
  					}
  					
  				}
  			}
  			String resul = "";
  			for (int i = 0; i < StrLatexOrdenado.length; i++) {
  				resul += i + " " + StrLatexOrdenado[i] + "\n";
  				if (latexZ.get(StrLatexOrdenado[i])!= null) {
  					result = result.replace(latexZ.get(StrLatexOrdenado[i]), StrLatexOrdenado[i]);
  				}
  				else if (latexCircus.get(StrLatexOrdenado[i]) != null) {
  					result = result.replace(latexCircus.get(StrLatexOrdenado[i]), StrLatexOrdenado[i] );
  				}
  				
  			}
  			btnTecladoVirtual.setEnabled(true);
  		}
  		tfEspec.setText(result);
		tfEspec.repaint();
  	}
  	
	/**
  	 * M�todo que inicializa a tela de parametro com o codigo do parametro
  	 * para a lei aplicada e mostra o layout certo para a janela.
  	 *
  	 * @param codigo         Inteiro que representa o c�digo do par�metro.
  	 *
  	 */
  	public void mostrarTelaParametro(CodigoParametro codigo, String str) {
  		this.codigo = codigo;
  		if(codigo == CodigoParametro.PREDICATE) {
  			this.mostrarTelaPredicate(str);
  		} 
  		else if(codigo == CodigoParametro.EXPRESSION) {
  			this.mostrarTelaExpression(str);
  		} 
  		else if(codigo == CodigoParametro.ACTION) {
  			this.mostrarTelaAction(str);
  		}
  		else if(codigo == CodigoParametro.NAMESET) {
  			this.mostrarTelaNameSet(str);
  		}
  		else if(codigo == CodigoParametro.CHANSET) {
  			this.mostrarTelaChannelSet(str);
  		}
  		else if(codigo == CodigoParametro.COMMUN) {
  			this.mostrarTelaCommunication(str);
  		}
  		else if(codigo == CodigoParametro.DECLLIST) {
  			this.mostrarTelaDeclList(str);
  		}
  		else if(codigo == CodigoParametro.EXPRLIST) {
  			this.mostrarTelaExprList(str);
  		}
  		else if(codigo == CodigoParametro.STROKE) {
  			this.mostrarTelaStroke(str);
  		}
  		else if(codigo == CodigoParametro.RENAMELIST) {
  			this.mostrarTelaRenameList(str);
  		}
  		else if(codigo == CodigoParametro.NAMELIST) {
  			this.mostrarTelaNameList(str);
  		}
  		else if(codigo == CodigoParametro.NAME) {
  			this.mostrarTelaName(str);
  		}
  		else if(codigo == CodigoParametro.PROCESS) {
  			this.mostrarTelaProcess(str);
  		}
  		else if (codigo == CodigoParametro.PARA) {
  			this.mostrarTelaPara(str);
  		}
  		else if (codigo == CodigoParametro.PARALIST) {
  			this.mostrarTelaParaList(str);
  		}
  		
  	}
  	private void mostrarTelaParaList(String str) {
  		String msg = Space + this.retornarMensagem("COD0531")+ Space + "(" + str + ")";
  		this.setarLabel(msg);
  		this.setTitle(this.retornarMensagem("COD0109"));
  		this.setLocation(130, 200);
  		this.setVisible(true);
  		this.codigo = CodigoParametro.PARALIST;
	}
	public void mostrarTelaPara(String str) {
		String msg = Space + this.retornarMensagem("COD0530")+ Space + "(" + str + ")";
  		this.setarLabel(msg);
  		this.setTitle(this.retornarMensagem("COD0109"));
  		this.setLocation(130, 200);
  		this.setVisible(true);
  		this.codigo = CodigoParametro.PARA;
	}
	/**
  	 * M�todo que exibe a tela de predicado.
  	 *
  	 */
  	private void mostrarTelaPredicate(String str) {
  		String msg =  Space + this.retornarMensagem("COD0110") + Space  + "(" + str + ")";
  		this.setarLabel(msg);
  		this.setTitle(this.retornarMensagem("COD0109"));
  		this.setLocation(130, 200);
  		this.setVisible(true);
  		this.codigo = CodigoParametro.PREDICATE;
  	}

  	private void mostrarTelaExpression(String str) {
  		String msg = Space + this.retornarMensagem("COD0460")+ Space + "(" + str + ")";
  		this.setarLabel(msg);
  		this.setTitle(this.retornarMensagem("COD0109"));
  		this.setLocation(130, 200);
  		this.setVisible(true);
  		this.codigo = CodigoParametro.EXPRESSION;
  	}

  	private void mostrarTelaAction(String str) {
  		String msg =  Space + this.retornarMensagem("COD0461")+ Space + "(" + str + ")";
  		this.setarLabel(msg);
  		this.setTitle(this.retornarMensagem("COD0109"));
  		this.setLocation(130, 200);
  		this.setVisible(true);
  		this.codigo = CodigoParametro.ACTION;
  	}

  	private void mostrarTelaNameSet(String str) {
  		String msg = Space + this.retornarMensagem("COD0462")+ Space + "(" + str + ")";
  		this.setarLabel(msg);
  		this.setTitle(this.retornarMensagem("COD0109"));
  		this.setLocation(130, 200);
  		this.setVisible(true);
  		this.codigo = CodigoParametro.NAMESET;
  	}

  	private void mostrarTelaChannelSet(String str) {
  		String msg = Space + this.retornarMensagem("COD0463")+ Space + "(" + str + ")";
  		this.setarLabel(msg);
		this.setTitle(this.retornarMensagem("COD0109"));
		this.setLocation(130, 200);
		this.setVisible(true);
		this.codigo = CodigoParametro.CHANSET;
	}

  	private void mostrarTelaCommunication(String str) {
  		String msg = Space + this.retornarMensagem("COD0469")+ Space + "(" + str + ")";
  		this.setarLabel(msg);
  		this.setTitle(this.retornarMensagem("COD0109"));
  		this.setLocation(130, 200);
  		this.setVisible(true);
  		this.codigo = CodigoParametro.COMMUN;
  	}

  	private void mostrarTelaNameList(String str) {
  		String msg = Space + this.retornarMensagem("COD0494")+ Space + "(" + str + ")";
  		this.setarLabel(msg);
  		this.setTitle(this.retornarMensagem("COD0109"));
  		this.setLocation(130, 200);
  		this.setVisible(true);
  		this.codigo = CodigoParametro.NAMELIST;
  	}
  	
  	private void mostrarTelaProcess(String str) {
  		String msg = Space + this.retornarMensagem("COD0500")+ Space + "(" + str + ")";
  		this.setarLabel(msg);
  		this.setTitle(this.retornarMensagem("COD0109"));
  		this.setLocation(130, 200);
  		this.setVisible(true);
  		this.codigo = CodigoParametro.PROCESS;
  	}
  	
  	private void mostrarTelaName(String str) {
  		String msg = Space + this.retornarMensagem("COD0495")+ Space + "(" + str + ")";
  		this.setarLabel(msg);
  		this.setTitle(this.retornarMensagem("COD0109"));
  		this.setLocation(130, 200);
  		this.setVisible(true);
  		this.codigo = CodigoParametro.NAME;
  	}
  	
  	private void mostrarTelaRenameList(String str) {
  		String msg = Space + this.retornarMensagem("COD0496")+ Space + "(" + str + ")";
  		this.setarLabel(msg);
  		this.setTitle(this.retornarMensagem("COD0109"));
  		this.setLocation(130, 200);
  		this.setVisible(true);
  		this.codigo = CodigoParametro.RENAMELIST;
  	}
  	
  	private void mostrarTelaDeclList(String str) {
  		String msg = Space + this.retornarMensagem("COD0497")+ Space + "(" + str + ")";
  		this.setarLabel(msg);
  		this.setTitle(this.retornarMensagem("COD0109"));
  		this.setLocation(130, 200);
  		this.setVisible(true);
  		this.codigo = CodigoParametro.DECLLIST;
  	}
  	private void mostrarTelaStroke(String str) {
  		String msg = Space + this.retornarMensagem("COD0498")+ Space + "(" + str + ")";
  		this.setarLabel(msg);
  		this.setTitle(this.retornarMensagem("COD0109"));
  		this.setLocation(130, 200);
  		this.setVisible(true);
  		this.codigo = CodigoParametro.STROKE;
  	}
  	private void mostrarTelaExprList(String str) {
  		String msg = Space + this.retornarMensagem("COD0499")+ Space + "(" + str + ")";
  		this.setarLabel(msg);
  		this.setTitle(this.retornarMensagem("COD0109"));
  		this.setLocation(130, 200);
  		this.setVisible(true);
  		this.codigo = CodigoParametro.EXPRLIST;
  	}
  	

  
   /**
	* M�todo que retorna uma mensagem que ser� impressa na tela, tanto na forma
	* de t�tulo quanto na forma de mensagem de erro.
	*
	* @param codigo     O c�digo da mensagem que ser� retornada.
	*
	* @return           Uma String que representa a mensagem de retorno.
	*
	*/
	public String retornarMensagem(String codigo) {
		String mensagem = gerInterface.getMessage(codigo);
		return mensagem;
	}
   /**
	* M�todo que seta o label da tela.
	*
	* @param label      String que representa o label que ser� exibido.
	*
	*/
  	public void setarLabel(String label){
		labelEntrada.setText(label);
  	}  
    
    public TecladoVirtual getTecladoVirtual() {
    	return tecl;
    }
   
    
    
    /**
     *  Metodo que gerencia eventos de teclado relacionado a TelaParametro
     */
    private void tfEspec_keyPressed(KeyEvent e){
    	 
    	 if (e.getKeyCode() == e.VK_F12) {
    		 this.AtualizarTfEspec(tfEspec.getText());
    	 }
    	
    }
    /**
     * Metodo que realiza a traducao dos simbolos presentes no tfEspec (JTextArea)
     * para a string interna que sera passado pro parser de argumentos
     * @param str texto presente mp tfEspec
     * @return
     */	
    public String TraduzirToLatex (String str) {
    	
    	String result = new String();
    	int i = 0;
    	ZtoLatex Zlatex = new ZtoLatex();
    	CircusToLatex CircusLatex = new CircusToLatex();
    	
    	
    	while  ( i < str.length()) {
    		
    		if (Character.isWhitespace(str.charAt(i)) 
    				|| Character.isLetterOrDigit(str.charAt(i)) ) {

    			result += str.charAt(i);
    			
    		}
    		else {
    			
    			String aux = "" + str.charAt(i);
    			if (Zlatex.get(aux)!= null) {
    				
    				result += Zlatex.get(aux);
    			
    			}
    			else if (CircusLatex.get(aux) != null) {
    				
    				result += CircusLatex.get(aux);
    			}

    		}
    		i++;
    	}
    	
    	return result;
    }
	private void setArgument(String argument) {
		this.argument = argument;
	}
}
