package circusRefine.gui;

/*
 * Projeto : Refine - Ferramenta Educacional para Refinamentos
 *
 * Tipo : TelaObrigacao
 *
 */
//http://forum.java.sun.com/thread.jspa?forumID=57&threadID=604783
import circusRefine.core.ExternalManager;
import circusRefine.core.ObrigacaoProva;
import circusRefine.gui.util.UnicodeCharacterCodeUtils;
import circusRefine.util.OPTipos;

import java.awt.BorderLayout;
import java.awt.Font;
import java.awt.SystemColor;

import javax.swing.ImageIcon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JInternalFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JTabbedPane;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.LinkedList;

import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

import net.sourceforge.czt.base.ast.Term;

/**
 * TelaObrigacao � um tipo que representa a tela de obriga��o de prova
 * da ferramenta. Apenas a janela Interna
 */
public class TelaObrigacao extends JInternalFrame {

    /**
     *
     */
    private static final long serialVersionUID = 1L;
    private ExternalManager gerInterface;

    /* Valor que sera substituido por romano e que indica */

    /* Menu de tipo de ops*/
    private JMenuBar barra;
    private JMenuItem menuTiposOP;
    private JCheckBoxMenuItem checkedTrue;
    private JCheckBoxMenuItem checkedFalse;
    private JCheckBoxMenuItem unchecked;
    private JCheckBoxMenuItem manualCheckedTrue;
    private JCheckBoxMenuItem manualCheckedFalse;
    private JCheckBoxMenuItem proving;
    private String path = "images/";
    private JTabbedPane opsDevelopments;

    /**
     * Construtor da classe TelaObrigacao.
     *
     * @param gerInterface       Gerenciador de todas as telas do sistema.
     *
     */
    public TelaObrigacao(ExternalManager gerInterface) {

        super(gerInterface.getMessage("COD0084"), true, false, true, true);

        //resizeble
        //maximizable
        //iconifiable
        try {
            this.gerInterface = gerInterface;
            jbInit();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    public String colocarEspacos(int linha) {
        String retorno = "(" + linha + ")";
        for (int i = 0; i < 8 - retorno.length(); i++) {
            retorno = retorno + " ";
        }
        return retorno;
    }

    public void atualizarInfoTela() {
        this.gerInterface.getInfoTelas().AtualizarObri(this);
    }

    /**
     * M�todo que inicializa os componentes da tela de obriga��o de prova.
     *
     */
    private void jbInit() throws Exception {

        this.setLocation((gerInterface.getTamanhoHorizontal() * 10) / 800, ((gerInterface.getTamanhoVertical() * 318) / 600));
        this.setSize(((gerInterface.getTamanhoHorizontal() * 520) / 800), ((gerInterface.getTamanhoVertical() * 165) / 600));
        this.setLayout(new BorderLayout());
        this.setBackground(SystemColor.scrollbar);

        opsDevelopments = new JTabbedPane();
        opsDevelopments.addChangeListener(new ChangeListener() {

            public void stateChanged(ChangeEvent e) {
                mudarAba(e);
            }
        });

        //Tal metodo � utilizado para para redimensionamento da janela
        this.addHierarchyBoundsListener(new java.awt.event.HierarchyBoundsListener() {

            @Override
            public void ancestorMoved(java.awt.event.HierarchyEvent e) {
            }

            @Override
            public void ancestorResized(java.awt.event.HierarchyEvent e) {
                atualizarInfoTela();
            }
        });

        /*
         * Configurando Menu de Tipos de OPs.
         */

        barra = new JMenuBar();
        menuTiposOP = new JMenu(this.retornarMensagem("COD0011") + ": ");

        checkedTrue = new JCheckBoxMenuItem(new ImageIcon(path + "trueM.gif"));
        checkedTrue.setSelected(true);
        checkedTrue.addActionListener(new ActionListener() {

            public void actionPerformed(ActionEvent e) {
                atualizarPOs();
            }
        });

        checkedFalse = new JCheckBoxMenuItem(new ImageIcon(path + "falseM.gif"));
        checkedFalse.setSelected(true);
        checkedFalse.addActionListener(new ActionListener() {

            public void actionPerformed(ActionEvent e) {
                atualizarPOs();
            }
        });
        unchecked = new JCheckBoxMenuItem(new ImageIcon(path + "interM.gif"));
        unchecked.setSelected(true);
        unchecked.addActionListener(new ActionListener() {

            public void actionPerformed(ActionEvent e) {
                atualizarPOs();
            }
        });
        manualCheckedTrue = new JCheckBoxMenuItem(new ImageIcon(path + "maotrue.gif"));
        manualCheckedTrue.setSelected(true);
        manualCheckedTrue.addActionListener(new ActionListener() {

            public void actionPerformed(ActionEvent e) {
                atualizarPOs();
            }
        });
        manualCheckedFalse = new JCheckBoxMenuItem(new ImageIcon(path + "maofalse.gif"));
        manualCheckedFalse.setSelected(true);
        manualCheckedFalse.addActionListener(new ActionListener() {

            public void actionPerformed(ActionEvent e) {
                atualizarPOs();
            }
        });
        proving = new JCheckBoxMenuItem(new ImageIcon(path + "work2.gif"));
        proving.setSelected(true);
        proving.addActionListener(new ActionListener() {

            public void actionPerformed(ActionEvent e) {
                atualizarPOs();
            }
        });

        menuTiposOP.add(checkedTrue);
        menuTiposOP.add(checkedFalse);
        menuTiposOP.add(unchecked);
        menuTiposOP.add(manualCheckedTrue);
        menuTiposOP.add(manualCheckedFalse);
        menuTiposOP.add(proving);

        barra.add(menuTiposOP);
        this.add(opsDevelopments);
        this.setJMenuBar(barra);

    }

    /**
     * Trata o evento de mudar a aba
     * @param e
     */
    protected void mudarAba(ChangeEvent e) {
        int id = opsDevelopments.getSelectedIndex();
        this.gerInterface.mudarAbaODes(id);
    }

    /**
     * Atualiza a exibi��o das OBrigacoes de Prova em cada aba
     *
     */
    protected void atualizarPOs() {
        for (int i = 0; i < opsDevelopments.getTabCount(); i++) {
            PanelObrigacao panel = (PanelObrigacao) this.opsDevelopments.getComponentAt(i);
            panel.updateScreen(true);
        }
    }

    /**
     * M�todo que retorna uma mensagem que ser� impressa na tela, tanto na forma
     * de t�tulo quanto na forma de mensagem de erro.
     *
     * @param codigo     O c�digo da mensagem que ser� retornada.
     *
     * @return           Uma String que representa a mensagem de retorno.
     *
     */
    public String retornarMensagem(String codigo) {
        String mensagem = gerInterface.getMessage(codigo);
        return mensagem;
    }

    public void setSelectionType(OPTipos tipoSelecionado, boolean valor) {
        if (tipoSelecionado.equals(OPTipos.OP_CHECADA_TRUE)) {
            checkedTrue.setSelected(valor);
        } else if (tipoSelecionado.equals(OPTipos.OP_CHECADA_FALSE)) {
            checkedFalse.setSelected(valor);
        } else if (tipoSelecionado.equals(OPTipos.OP_MANUAL_CHECADA_TRUE)) {
            manualCheckedTrue.setSelected(valor);
        } else if (tipoSelecionado.equals(OPTipos.OP_MANUAL_CHECADA_FALSE)) {
            manualCheckedFalse.setSelected(valor);
        } else if (tipoSelecionado.equals(OPTipos.OP_SENDO_PROVADA)) {
            proving.setSelected(valor);
        } else {
            unchecked.setSelected(valor);
        }
    }

    /**
     * Adiciona uma nova aba relacionada a um novo desenvolvimento
     * @param id
     */
    public void adicionarNovoObrigacao(int id) {

        PanelObrigacao panel = new PanelObrigacao(this, gerInterface, this.getWidth(), this.getHeight());
        String nome = gerInterface.getDevelopment(id).getNome();
        opsDevelopments.addTab(nome, null, panel, nome);
        opsDevelopments.setSelectedIndex(id);

    }

    /**
     * Lista as Obrigacoes passadas como parametro na
     * aba correspondente
     * @param obrigations lista de op a serem listadas
     */
    public void listarObrigacoes(LinkedList<ObrigacaoProva> obrigations) {
        PanelObrigacao panel = (PanelObrigacao) this.opsDevelopments.getComponentAt(opsDevelopments.getSelectedIndex());
        panel.listarObrigacoes(obrigations);
    }

    /**
     *
     * @return Identificador da proxima OP da aba selecionada
     */
    public int getIdentificador() {
        PanelObrigacao panel = (PanelObrigacao) this.opsDevelopments.getComponentAt(opsDevelopments.getSelectedIndex());
        return panel.getIdentificador();
    }

    public boolean isCheckedTrueSelected() {
        return checkedTrue.isSelected();
    }

    public boolean isCheckedFalseSelected() {
        return checkedFalse.isSelected();
    }

    public boolean isUncheckedSelected() {
        return unchecked.isSelected();
    }

    public boolean isManualCheckedTrueSelected() {
        return manualCheckedTrue.isSelected();
    }

    public boolean isManualCheckedFalseSelected() {
        return manualCheckedFalse.isSelected();
    }

    public boolean isProving() {
        return proving.isSelected();
    }

    /**
     * Retirar a selecao da linha da OP
     *
     */
    public void tirarSelecao() {
        PanelObrigacao panel = (PanelObrigacao) this.opsDevelopments.getComponentAt(opsDevelopments.getSelectedIndex());
        panel.tirarSelecao();
    }

    /**
     * Muda a sele��o da aba na tela Obriga��o para que
     * corresponda com a aba selecionada na Tela Desenvolvimento
     * @param id id da aba selecionada
     */
    public void mudarAba(int id) {
        if (id < opsDevelopments.getTabCount()) {
            opsDevelopments.setSelectedIndex(id);
        }

    }

    /**
     * Chama o desfazer da aba indexado pelo par�metro
     * @param i
     */
    public void desfazer(int i) {
        PanelObrigacao panel = (PanelObrigacao) this.opsDevelopments.getComponentAt(opsDevelopments.getSelectedIndex());
        panel.desfazer(i);
    }

    /**
     * Faz com que a tela Obriga��o remova a tab indexada
     * pelo indice tabNumber
     * @param tabNumber numero da aba a ser removida
     */
    public void removeAbaObri(int tabNumber) {
        this.opsDevelopments.removeTabAt(tabNumber);
    }

    public void setarValorOP(OPTipos tipoSetadoAnterior, int indiceOP, boolean b) {
        PanelObrigacao panel = (PanelObrigacao) this.opsDevelopments.getComponentAt(opsDevelopments.getSelectedIndex());
        panel.setarValorOP(tipoSetadoAnterior, indiceOP, b);
    }

    public void mudarFormatoImpressaoOP(int indiceOP, boolean inserirHistorico) {
        PanelObrigacao panel = (PanelObrigacao) this.opsDevelopments.getComponentAt(opsDevelopments.getSelectedIndex());
        panel.mudarFormatoImpressaoOP(indiceOP, inserirHistorico);
    }

    public LinkedList<ObrigacaoProva> getOps() {
        PanelObrigacao panel = (PanelObrigacao) this.opsDevelopments.getComponentAt(opsDevelopments.getSelectedIndex());
        return panel.getOps();
    }

    public int getTabCount() {
        return opsDevelopments.getTabCount();
    }

    public void updateScreen() {
        PanelObrigacao panel = (PanelObrigacao) this.opsDevelopments.getComponentAt(opsDevelopments.getSelectedIndex());
        panel.updateScreen(false);
    }

    public void updateScreen(int i) {
        PanelObrigacao panel = (PanelObrigacao) this.opsDevelopments.getComponentAt(i);
        panel.updateScreen(false);
    }

    /**
     *
     * @param pai
     * @param indiceOp
     * @return o Contexto em que foi gerado a OP de indiceOP
     * do desenvolvimento indexado pelo valor de pai
     */
    public Term getContextoAt(int pai, int indiceOp) {
        PanelObrigacao panel = (PanelObrigacao) this.opsDevelopments.getComponentAt(pai);

        return panel.getContexto(indiceOp);
    }

    /**
     * Metodo chamado quando o SubDesenvolvimento selecionado
     * atinge seu alvo
     *
     */
    public void subDesenvolvimentProvado(int pai, int indiceOp) {

        this.showProvedTitle();

        PanelObrigacao panel = (PanelObrigacao) this.opsDevelopments.getComponentAt(pai);
        panel.opProvada(pai, indiceOp);
    }

    public void showProvedTitle() {
        /**
         * Mudando o Title;
         */
        int index = this.opsDevelopments.getSelectedIndex();
        this.opsDevelopments.setTitleAt(index, this.opsDevelopments.getTitleAt(index)
                + UnicodeCharacterCodeUtils.heavyCheckedMark);

    }

    public void showProvedTitle(int index) {
        /**
         * Mudando o Title;
         */
        this.opsDevelopments.setTitleAt(index, this.opsDevelopments.getTitleAt(index)
                + UnicodeCharacterCodeUtils.heavyCheckedMark);

    }

    /**
     *
     * @return True caso todas Ops foram consideradas verdadeiras
     */
    public boolean checkOPs() {
        PanelObrigacao panel = (PanelObrigacao) this.opsDevelopments.getComponentAt(opsDevelopments.getSelectedIndex());

        return panel.checkOPs();
    }

    public Term getContextoAposAt(int pai, int indiceOp) {
        PanelObrigacao panel = (PanelObrigacao) this.opsDevelopments.getComponentAt(pai);

        return panel.getContextoApos(indiceOp);
    }

    public ObrigacaoProva getOp(Integer indexDev, int indiceOP) {

        PanelObrigacao panel = (PanelObrigacao) this.opsDevelopments.getComponentAt(indexDev);
        return panel.getOps().get(indiceOP);
    }
}
