package circusRefine.gui;

/*
 * Projeto : Refine - Ferramenta Educacional para Refinamentos
 *
 * Tipo : FDesenvolvimento
 *
 */

import circusRefine.Tactic.Principal.Tatica;
import circusRefine.core.ExternalManager;
import circusRefine.core.InsertAnswer;
import circusRefine.core.InsertCommentAnswer;
import circusRefine.core.NoPrograma;
import circusRefine.core.RemoveCommentAnswer;
import circusRefine.core.developments.PODevelopmentTree;
import circusRefine.gui.util.UnicodeCharacterCodeUtils;
import circusRefine.util.CRefineException;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.SystemColor;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Stack;

import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JInternalFrame;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JOptionPane;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;


import net.sourceforge.czt.base.ast.Term;



/**
 * TelaDesenvolvimento � um tipo que representa a tela de desenvolvimento da
 * ferramenta. Apenas a Janela Interna
 * @author Alessandro
 * @author Manuela Xavier
 */
public class TelaDesenvolvimento extends JInternalFrame {

	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;


	/* gerenciador de interface */
	private ExternalManager gerInterface;


	/* Abas de Desenvolvimento*/
	private JTabbedPane desenvolvimentos;


	private String path = "images/";



	/**
	 * Construtor da classe TelaDesenvolvimento
	 *
	 * @param gerInterface       Gerenciador de todas as telas do sistema.
	 *
	 */
	public TelaDesenvolvimento(ExternalManager gerInterface) {

		super (gerInterface.getMessage("COD0001"),true,false,true,true);
		//resizeble
		//maximizable
		//iconifiable
		try  {
			this.gerInterface = gerInterface;
			jbInit();

		} catch (Exception e) {

			e.printStackTrace();

		}
	}

	/**
	 * Atualiza os campos de InfoTelas referentes a janela de Desenvolvimento
	 */
	public void atualizarInfoTela () {
		this.gerInterface.getInfoTelas().AtualizarDes(this);
	}


	/**
	 * Inicializa os atributos da tela de desenvolvimento.
	 *
	 */
	private void jbInit() throws Exception {

		this.setLocation((gerInterface.getTamanhoHorizontal()*10)/800,(gerInterface.getTamanhoVertical()*6)/600);
		this.setSize( ( (gerInterface.getTamanhoHorizontal()*520) /800) , ( (gerInterface.getTamanhoVertical()*300)/600) );
		this.setBackground(SystemColor.scrollbar);
		this.addHierarchyBoundsListener(new java.awt.event.HierarchyBoundsListener () {
			public void ancestorMoved(java.awt.event.HierarchyEvent e) {
			}
			public void ancestorResized(java.awt.event.HierarchyEvent e) {
				atualizarInfoTela();
			}
		}
		);

		desenvolvimentos = new JTabbedPane();

		desenvolvimentos.addChangeListener(new ChangeListener(){

			public void stateChanged(ChangeEvent e) {
				mudarAba(e);
			}

		});

		desenvolvimentos.addMouseListener(new MouseListener(){

			public void mouseClicked(MouseEvent e) {
				//JOptionPane.showMessageDialog (null, "Clicou no botão direito do mouse");
				int tabNumber=desenvolvimentos.getUI().tabForCoordinate(desenvolvimentos, e.getX(), e.getY());
				if (tabNumber < 0) return ;  
				Rectangle rect=((CloseTabIcon)desenvolvimentos.getIconAt(tabNumber)).getBounds();  
				if (rect.contains(e.getX(), e.getY())) {
					close(tabNumber, true);

				}  
			}

			public void mouseEntered(MouseEvent e) {
			}

			public void mouseExited(MouseEvent e) {
			}

			public void mousePressed(MouseEvent e) {
			}

			public void mouseReleased(MouseEvent e) {
			}

		});

		this.add(desenvolvimentos);

	}
	/**
	 *Fecha o desenvolvimento perguntando se o usu�rio deseja salvar 
	 *alguma coisa
	 */
	public void close(int tabNumber, boolean askForSave) {
		/* Verifica se o usu�rio deseja salvar o desenvolvimento */
		boolean close = true;
		if (gerInterface.isSubDevelopment(tabNumber)){
			askForSave = false;
		}
		if (askForSave) {
			close = gerInterface.askforSaveDevelopment(false);
		}
		if (close){
			
			gerInterface.removeDevelopment(tabNumber);
			desenvolvimentos.removeTabAt(tabNumber); 
			gerInterface.removeAbaObri(tabNumber);
			if (desenvolvimentos.getTabCount() == 0){
				gerInterface.limparTelaCodigo();
				gerInterface.limparOpcoesColeta();
				gerInterface.limparOpcoes();
			}
		}

	}

	/**
	 * M�todo que realiza as mudan�as necess�rias quando h� alguma mudan�a de aba
	 *@param e evento de Mudanca de Aba
	 */
	protected void mudarAba(ChangeEvent e) {
		if (desenvolvimentos.getTabCount() > 0) {
			int id = desenvolvimentos.getSelectedIndex();

			try {
				this.gerInterface.verificarHabilitacaoSalvar(id);
				this.gerInterface.mudarAbaObri(id);
				this.gerInterface.atualizarOpcoes();
				this.gerInterface.atualizarTelaCodigo(id);
				this.gerInterface.inicializarOptComboBox();
				this.gerInterface.atualizarOpcoesColeta();
			} catch (CRefineException e1) {
				e1.printStackTrace();
			}
		}

	}

	/**
	 * M�todo que retorna uma mensagem que ser� impressa na tela, tanto na forma
	 * de t�tulo quanto na forma de mensagem de erro.
	 *
	 * @param codigo     O c�digo da mensagem que ser� retornada.
	 *
	 * @return           Uma String que representa a mensagem de retorno.
	 *
	 */
	public String retornarMensagem(String codigo) {
		String mensagem = gerInterface.getMessage(codigo);
		return mensagem; 
	}

	public void showError(String title, String str, int tipo) {
		JOptionPane.showMessageDialog(null, str, title, tipo);
		gerInterface.setarStatus("");
		gerInterface.setarFocus();
	}



	/**
	 * Adiciona uma aba com o desenvolvimento referenciado pelo 
	 * identificador id
	 * @param id
	 */
	public void adicionarNovoDesenvolvimento(int id) {
		PanelDesenvolvimento panel = new PanelDesenvolvimento(gerInterface
				,id, this.getWidth(), this.getHeight());
		String nome = gerInterface.getDevelopment(id).getNome();
		nome = verificarNome(nome);
		gerInterface.getDevelopment(id).setNome(nome);
		desenvolvimentos.addTab(nome, new CloseTabIcon(null), panel, nome);
		desenvolvimentos.setSelectedIndex(id);
		panel.specificationScreen(gerInterface.getDevelopment(id).getProgAtual());
	}

	/**
	 * Verifica se j� h� alguma aba com o mesmo nome
	 * @param nome nome da aba a ser inserida
	 */
	private String verificarNome(String nome) {
		int contnames = 0;
		for (int i=0;i< desenvolvimentos.getTabCount();i++){
			String nomeAba = desenvolvimentos.getTitleAt(i);
			if (contnames == 0) {
				if (nome.equals(nomeAba)){
					contnames++;
				}
			}
			else {
				if (nomeAba.equals(nome + "(" + contnames + ")")){
					contnames++;
				}
			}

		}
		if (contnames >0) nome += "(" + contnames + ")";
		return nome;
	}

	/**
	 * Atualiza a tela do Desenvolvimento identificado por i 
	 * @param id
	 */
	public void updateScreen(int id) {
		PanelDesenvolvimento des = (PanelDesenvolvimento)desenvolvimentos.getComponentAt(id);
		des.updateScreen();

	}


	/** 
	 * The class which generates the 'X' icon for the tabs. The constructor 
	 * accepts an icon which is extra to the 'X' icon, so you can have tabs 
	 * like in JBuilder. This value is null if no extra icon is required. 
	 */  
	class CloseTabIcon implements Icon {  
		private int x_pos;  
		private int y_pos;  
		private int width;  
		private int height;  
		private Icon fileIcon;  

		public CloseTabIcon(Icon fileIcon) {  
			this.fileIcon=fileIcon;  
			width=16;  
			height=16;  
		}  

		public void paintIcon(Component c, Graphics g, int x, int y) {  
			this.x_pos=x;  
			this.y_pos=y;  

			Color col=g.getColor();  

			g.setColor(Color.black);  
			int y_p=y+2;  
			g.drawLine(x+1, y_p, x+12, y_p);  
			g.drawLine(x+1, y_p+13, x+12, y_p+13);  
			g.drawLine(x, y_p+1, x, y_p+12);  
			g.drawLine(x+13, y_p+1, x+13, y_p+12);  
			g.drawLine(x+3, y_p+3, x+10, y_p+10);  
			g.drawLine(x+3, y_p+4, x+9, y_p+10);  
			g.drawLine(x+4, y_p+3, x+10, y_p+9);  
			g.drawLine(x+10, y_p+3, x+3, y_p+10);  
			g.drawLine(x+10, y_p+4, x+4, y_p+10);  
			g.drawLine(x+9, y_p+3, x+3, y_p+9);  
			g.setColor(col);  
			if (fileIcon != null) {  
				fileIcon.paintIcon(c, g, x+width, y_p);  
			}  
		}  

		public int getIconWidth() {  
			return width + (fileIcon != null? fileIcon.getIconWidth() : 0);  
		}  

		public int getIconHeight() {  
			return height;  
		}  

		public Rectangle getBounds() {  
			return new Rectangle(x_pos, y_pos, width, height);  
		}  
	}

	/**
	 * Atualiza a sele��o da aba selecionada
	 */
	public void atualizar_Selecao() {

		PanelDesenvolvimento des = (PanelDesenvolvimento)desenvolvimentos.getSelectedComponent();
		des.atualizar_Selecao();
	}

	/**
	 * Seleciona linhas da Aba selecionada
	 */
	public void selecionarLinhas() {
		PanelDesenvolvimento des = (PanelDesenvolvimento)desenvolvimentos.getSelectedComponent();
		des.selecionarLinhas();
	}

	/**
	 * Pega o indice da aba selecionada.
	 */
	public int getSelectedDevelopment() {
		return desenvolvimentos.getSelectedIndex();
	}

	/**
	 * Pega o indice da aba selecionado
	 * @param  .
	 */
	public NoPrograma retornarProgSelecionado(int id) {
		PanelDesenvolvimento des = (PanelDesenvolvimento)desenvolvimentos.getSelectedComponent();
		return des.retornarProgSelecionado(id);
	}
	/**
	 * 
	 * @return as linhas selecionadas da aba selecionada
	 */
	public int[] retornarLinhasSelecionadas() {
		PanelDesenvolvimento des = (PanelDesenvolvimento)desenvolvimentos.getSelectedComponent();
		return des.retornarLinhaSelecionada();
	}

	/**
	 * 
	 * @param i linha inicial
	 * @param j linha final
	 * @return se h� coment�rio que compreende as linhas i e j
	 */
	public boolean temComentario(int i, int j) {
		PanelDesenvolvimento des = (PanelDesenvolvimento)desenvolvimentos.getSelectedComponent();
		return des.temComentario(i, j);
	}

	/**
	 * Atualiza a aba selecionada
	 *
	 */
	public void updateSelectedScreen() {
		PanelDesenvolvimento des = (PanelDesenvolvimento)desenvolvimentos.getSelectedComponent();
		des.updateScreen();
	}

	public boolean hasProgram() {
		if (desenvolvimentos.getTabCount() > 0) return true;
		return false;
	}
	/**
	 * Atualiza identificador de Lei do texto da aba Selecionada
	 * @param b caso esse m�todo tenha sido invocado numa a��o de undo
	 */
	public void updateLawIdentifierGUI(boolean b) {
		PanelDesenvolvimento des = (PanelDesenvolvimento)desenvolvimentos.getSelectedComponent();
		des.updateLawIdentifierGUI(b);
	}

	/**
	 * Constroi o texto resultante de alguma  a��o do programa no
	 * PanelDesenvolvimento
	 * @param termoResultante termo de que se extrair� o texto
	 * @param string indica o tipo de a��o
	 * @param linhaInicial a linha Identificada por uma possivel lei
	 * @param b booleano auxiliar que indica se haver� armazenamento 
	 * de rela��o
	 */
	public void buildProgText(Term termoResultante, String string, int linhaInicial, boolean b) {
		PanelDesenvolvimento des = (PanelDesenvolvimento)desenvolvimentos.getSelectedComponent();
		des.buildProgText(termoResultante, string, linhaInicial, b);

	}

	/**
	 * 
	 * @return Identificador de Lei
	 */
	public int getIdt() {
		PanelDesenvolvimento des = (PanelDesenvolvimento)desenvolvimentos.getSelectedComponent();
		return des.getIdt();

	}

	/**
	 * Retira a sele��o do desenvolvimento utilizado
	 *
	 */
	public void tirarSelecao() {
		PanelDesenvolvimento des = (PanelDesenvolvimento)desenvolvimentos.getSelectedComponent();
		des.tirarSelecao();
	}

	public void esvaziarRedoPilhas() {
		PanelDesenvolvimento des = (PanelDesenvolvimento)desenvolvimentos.getSelectedComponent();
		des.esvaziarRedoPilhas();

	}

	/**
	 * M�todo que coloca a barrinha de rolagem pra baixo apos aplica��o de uma lei
	 */
	public void desceRoll() {
		PanelDesenvolvimento des = (PanelDesenvolvimento)desenvolvimentos.getSelectedComponent();
		JScrollBar bar = des.getRoll().getVerticalScrollBar();
		bar.setValue(bar.getMaximum());

	}

	/**
	 * Produz o texto do termo coletado
	 * @param termoColetado
	 */
	public void collectedScreen(Term termoColetado) {
		PanelDesenvolvimento des = (PanelDesenvolvimento)desenvolvimentos.getSelectedComponent();
		des.collectedScreen(termoColetado);
	}

	/**
	 * Esvazia as Pilhas do panel desenvolvimento
	 *
	 */
	public void esvaziarPilhas() {
		PanelDesenvolvimento des = (PanelDesenvolvimento)desenvolvimentos.getSelectedComponent();
		des.esvaziarPilhas();

	}

	/**
	 * Desfaz a aplicacao de Lei
	 *
	 */
	public void desfazerAplicLei() {
		PanelDesenvolvimento des = (PanelDesenvolvimento)desenvolvimentos.getSelectedComponent();
		des.desfazerAplicLei();
	}

	/**
	 * Atualiza identificadores de comentario na linha passado como par�metro
	 * @param linha
	 */
	public void updateCommentIdentifierGUI(int linha) {
		PanelDesenvolvimento des = (PanelDesenvolvimento)desenvolvimentos.getSelectedComponent();
		des.updateCommentIdentifierGUI(linha);
	}

	/**
	 * Invoca o metodo do pael Desenvolvimento para 
	 * recontruir o texto de um termo passado como par�metro
	 * @param progResultante termo resultante de aplica��o de uma lei
	 */
	public void reappplyScreen(Term progResultante) {
		PanelDesenvolvimento des = (PanelDesenvolvimento)desenvolvimentos.getSelectedComponent();
		des.reappplyScreen(progResultante);
	}

	/**
	 * Retira as ultimas Linhas do Desenvolvimento
	 *
	 */
	public void retirarUltimasLinhas() {
		PanelDesenvolvimento des = (PanelDesenvolvimento)desenvolvimentos.getSelectedComponent();
		des.retirarUltimasLinhas();
	}

	/**
	 * Seleciona a linha passada como par�metro do 
	 * Desenvolvimento utilizado
	 * @param toSelect linha a ser selecionada
	 */
	public void selecionarLinha(int toSelect) {
		PanelDesenvolvimento des = (PanelDesenvolvimento)desenvolvimentos.getSelectedComponent();
		des.selecionarLinha(toSelect);
	}

	public void normalizarSelecao(int toSelect) {
		PanelDesenvolvimento des = (PanelDesenvolvimento)desenvolvimentos.getSelectedComponent();
		des.normalizarSelecao(toSelect);
	}

	/**
	 * Seleciona a aba passada como par�metro
	 * @param id
	 */
	public void selecionarAba(int id) {
		if (id < desenvolvimentos.getTabCount()){
			desenvolvimentos.setSelectedIndex(id);
		}
	}

	/**
	 * Pega o comentario do desenvolvimento em quest�o
	 * cuja linha inicial � i a linha final � j
	 * @param i linha inicial do comentario
	 * @param j linha final do comentario
	 * @return comentario selecionado
	 */
	public Comentario getComentario(int i, int j) {
		PanelDesenvolvimento des = (PanelDesenvolvimento)desenvolvimentos.getSelectedComponent();
		return des.getComentario(i, j);
	}

	/**
	 *  Insere um coment�rio
	 * @param text texto do comentario
	 * @param linhaInicial 
	 * @param linhaFinal
	 * @return passo de execu��o do programa que representa a inser��o do coment�rio
	 */
	public InsertCommentAnswer inserirComentario(String text, int linhaInicial, int linhaFinal) {
		PanelDesenvolvimento des = (PanelDesenvolvimento)desenvolvimentos.getSelectedComponent();
		return des.inserirComentario(text, linhaInicial, linhaFinal);
	}

	/**
	 * Edita um coment�rio explicitando as linhas inicial e final do 
	 * coment�rio
	 * 
	 * @param text o novo conte�do do coment�rio
	 * @param linhaInicial a linha inicial do coment�rio
	 * @param linhaFinal a linha final do coment�rio
	 */
	public Comentario editarComentario(String text, int linhaInicial, int linhaFinal) {
		PanelDesenvolvimento des = (PanelDesenvolvimento)desenvolvimentos.getSelectedComponent();
		return des.editarComentario(text, linhaInicial, linhaFinal);
	}

	/**
	 * 
	 * @param comment comentario a ser removido
	 * @return passo de execu��o que representa a remo��o do coment�rio
	 */
	public RemoveCommentAnswer removerComentario(Comentario comment) {
		PanelDesenvolvimento des = (PanelDesenvolvimento)desenvolvimentos.getSelectedComponent();
		return des.removerComentario(comment);
	}
	/**
	 * desfaz a inser��o do �ltimo coment�rio
	 *
	 */
	public void desfazerAdicaoComentario() {
		PanelDesenvolvimento des = (PanelDesenvolvimento)desenvolvimentos.getSelectedComponent();
		des.desfazerAdicaoComentario();
	}

	/**
	 * refaz a inser��o do �ltimo coment�rio
	 *
	 */
	public void refazerAdicaoComentario() {
		PanelDesenvolvimento des = (PanelDesenvolvimento)desenvolvimentos.getSelectedComponent();
		des.refazerAdicaoComentario();

	}

	/**
	 * Desfaz a remo��o do �ltimo Coment�rio
	 *
	 */
	public void desfazerRemocaoComentario() {
		PanelDesenvolvimento des = (PanelDesenvolvimento)desenvolvimentos.getSelectedComponent();
		des.desfazerRemocaoComentario();

	}

	/**
	 * Refaz a remo��o do �ltimo Coment�rio
	 *
	 */
	public void refazerRemocaoComentario() {
		PanelDesenvolvimento des = (PanelDesenvolvimento)desenvolvimentos.getSelectedComponent();
		des.refazerRemocaoComentario();
	}


	/**
	 * 
	 * @return a lista de comentarios do aba selecionada
	 */
	public ArrayList<Comentario> getComentarios() {
		PanelDesenvolvimento des = (PanelDesenvolvimento)desenvolvimentos.getSelectedComponent();
		return des.getComentarios();
	}

	public Stack<Comentario> getRemovedComments() {
		PanelDesenvolvimento des = (PanelDesenvolvimento)desenvolvimentos.getSelectedComponent();
		return des.getRemovedComments();
	}

	/**
	 * Imprime o texto na tela como um carregamento inicial
	 * @param ast
	 */
	public void setarTelaTextoDePrograma(Term ast) {
		PanelDesenvolvimento des = (PanelDesenvolvimento)desenvolvimentos.getSelectedComponent();
		des.setarTelaTextoDePrograma(ast);
	}

	/**
	 * Exibi o paragrafo inserido na tela Desenvolvimento
	 * @param resposta
	 */
	public void displayParagraph(InsertAnswer resposta) {
		PanelDesenvolvimento des = (PanelDesenvolvimento)desenvolvimentos.getSelectedComponent();
		des.displayParagraph(resposta);
	}

	/**
	 * 
	 * @return Um array de Strign que contem o texto Selecionado na Tela Desenvolvimento
	 */
	public ArrayList<String> getTextoSelecionado() {
		PanelDesenvolvimento des = (PanelDesenvolvimento)desenvolvimentos.getSelectedComponent();
		return des.getTextoSelecionado();
	}

	/**
	 * 
	 * @return se todas as abas foram fechadas 
	 */
	public void fecharAbas() {
		int size = desenvolvimentos.getTabCount();
		for (int i=0; i < size;i++){
			desenvolvimentos.setSelectedIndex(i);
			gerInterface.askforSaveDevelopment(true);
		}
	}


	public void showProvedTitle() {
		/**
		 * Mudando o Title;
		 */
		int index = this.desenvolvimentos.getSelectedIndex();
		this.desenvolvimentos.setTitleAt(index, this.desenvolvimentos.getTitleAt(index) 
				+ UnicodeCharacterCodeUtils.heavyCheckedMark);
		
	}

	public void bloquearDesenvolvimento() {
		PanelDesenvolvimento des = (PanelDesenvolvimento)desenvolvimentos.getSelectedComponent();
		des.bloquearDesenvolvimento();
	}

	public void liberarDesenvolvimento() {
		PanelDesenvolvimento des = (PanelDesenvolvimento)desenvolvimentos.getSelectedComponent();
		des.liberarDesenvolvimento();
		
	}


	public void updateLawIdentifierGUITactic(boolean b, int linha) {
		PanelDesenvolvimento des = (PanelDesenvolvimento)desenvolvimentos.getSelectedComponent();
		des.updateLawIdentifierGUITactic(b, linha);
	}

	public void buildProgTextTatica(Term termoResultante, String string, int linhaInicial, boolean b, Tatica tatica) {
		PanelDesenvolvimento des = (PanelDesenvolvimento)desenvolvimentos.getSelectedComponent();
		des.buildProgTextTatica(termoResultante, string, linhaInicial, b, tatica);

	}
}