package circusRefine.gui;

import circusRefine.util.circusstring.CircusToLatex;
import circusRefine.util.zstring.ZtoLatex;

import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JButton;
import java.awt.event.ActionListener;
import java.awt.event.ActionEvent;
import java.awt.Container;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import javax.swing.border.TitledBorder;
import javax.swing.JDialog;

import net.sourceforge.czt.circus.util.CircusString;
import net.sourceforge.czt.z.util.ZString;

import java.awt.Component;

public class TecladoVirtual extends JDialog{
	
	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;
	private TelaParametro telaParam;
	private final char ESPACO = ' ';
	

	//BUTTONS
	
	//Z
	
	//Logics
	JButton And;
	JButton Or;
	JButton True;
	JButton	False;
	JButton	ForAll;
	JButton	Exists;
	JButton	Exists_1;
	JButton	Iff;
	JButton Implies; 
	JButton LNot;
	JButton Arroba;
	JButton Conjecture;
	JButton Arithmos;
	
//	Numbers
	
	
	JButton Leq;
	JButton Succ;
	JButton Nat;
	JButton Neq;
	JButton Num;
	JButton Geq;
	JButton Mod;
	JButton Div;
	JButton Times;
	JButton Ominus;
	
	//Sets

	JButton Power;
	JButton Finset;
	JButton Cup;
	JButton Cap;
	JButton SetMinus;
	JButton Subseteq;
	JButton Subset;
	JButton In;
	JButton NotIn;
	JButton Upto;
	JButton Partition;
	JButton JogoDaVelha;
	JButton Cross;
	JButton EmptySet;
	
	//Rela�oes
	
	JButton Rel;
	JButton Mapsto;
	JButton Project;
	
	JButton Rres;
	JButton Dres;
	JButton nRres;
	JButton nDres;
	JButton Comp;
	JButton Oplus;
	
	
	//Funcoes
	
	JButton Fun;
	JButton Pfun;
	JButton Pinj;
	JButton Inj;
	JButton Psurj;
	JButton Surj;
	JButton Bij;
	JButton Ffun;
	JButton Finj;
	JButton Lambda;
	JButton Circ;
	JButton Ran;
	JButton Id;
	JButton rIMG;
	JButton lIMG;
	JButton Dom;
	JButton Inv;
	
	
	//Sequencias
	
	JButton Seq;
	JButton Iseq;
	JButton Cat;
	JButton LAngle;
	JButton RAngle;
	JButton Extract;
	JButton Filter;
	
	//Esquemas
	
	JButton VDash;
	JButton Delta;
	JButton Xi;
	JButton Let;
	JButton IF;
	JButton Then;
	JButton Else;
	JButton Pre;
	JButton Theta;
	JButton lBlot;
	JButton rBlot;
	JButton Alpha;
	JButton Ldata;
	JButton Rdata;
	JButton pipe;
	
	//CIRCUS
	
	JButton Boolean;
	JButton CircAssertRef;
	JButton CircAssign;
	JButton CircBegin;
	JButton CircEnd;
	JButton CircHiding;
	JButton Defs;
	JButton Odot;
	JButton CircState;
	JButton CircNameSet;
	JButton Extchoice;
	JButton Intchoice;
	JButton Semi;
	JButton Parallel;
	JButton Hide;
	JButton Lpar;
	JButton Rpar;
	JButton Interleave;
	JButton Circmu;
	JButton Guard;
	JButton extchoice;
	JButton intchoice;
	JButton interleave;
	JButton circchannel;
	JButton circchannelFrom;
	JButton circchannelSet;
	JButton circChaos;
	JButton circSkip;
	JButton circStop;
	JButton circDo;
	JButton circOd;
	JButton circprocess;
	JButton circrefines;
	JButton circsimulates;
	JButton circval;
	JButton circres;
	JButton circvalres;
	JButton circthen;
	JButton then;
	JButton circfi;
	JButton circelse;
	JButton circvar;
	JButton linter;
	JButton rinter;
	JButton lchanset;
	JButton rchanset;
	JButton lcircrename;
	JButton rcircrename;
	JButton lcircguard;
	JButton rcircguard;
	
	
	
	//Gerenciador de Layout
	
	//TODO por enquanto esse GridbagLayout so esta sendo usado pelo JPanel ZSequencias,
	//expandir o uso dele para todos os outros panels.
	
	private GridBagLayout layout;
	private GridBagConstraints constraints;
	
	public TecladoVirtual() {
		jbInit();
		
	}
	public TecladoVirtual(TelaParametro telaParametro) {
		super(telaParametro);
		telaParam = telaParametro;
		this.setTitle("Teclado Virtual"); 
		jbInit();
		
	}
	
	private void jbInit() {
		
		
		JTabbedPane tabbedPane = new JTabbedPane();
		this.setResizable(false);
		
		//Tabela de S�mbolos Auxiliares
		
		ZtoLatex zLatex = new ZtoLatex();
		CircusToLatex circusLatex = new CircusToLatex();
		
		//Fonte CZT
		
		Font Czt = new Font("CZT",Font.PLAIN,11);
		
		//Tamanhos de Linhas e Colunas para gerenciamento de Layout
		
		//Para o panel Z
		
		int rowsZ = 2;
		int colsZ = 2;
		
		GridLayout gridLayoutZ = new GridLayout(rowsZ,colsZ);
		
		
		//Acidicionando aba de Z
		JPanel Z_1 = new JPanel();
		JPanel Z_2 = new JPanel();
		
		tabbedPane.addTab(" Z_1 ", null, Z_1, " Symbols of Z ");
		tabbedPane.addTab(" Z_2 ", null, Z_2, " More symbols of Z ");
		
		
		//PANELS
		JPanel Zlogic = new JPanel();
		JPanel ZNumbers = new JPanel();
		JPanel ZSets = new JPanel();
		JPanel ZRelations = new JPanel ();
		JPanel ZFuncoes = new JPanel ();
		JPanel ZSequencias = new JPanel ();
		JPanel ZEsquemas = new JPanel ();
		
		//Definindo Layout
		
		Z_1.setLayout(gridLayoutZ);
		Z_2.setLayout(gridLayoutZ);
		
		layout = new GridBagLayout();
		constraints = new GridBagConstraints();
		
		Zlogic.setLayout(new GridLayout(4,3));
		ZNumbers.setLayout(new GridLayout(4,3));
		ZSets.setLayout(new GridLayout(5,3));
		ZRelations.setLayout(new GridLayout(4,3));
		ZFuncoes.setLayout(new GridLayout(6,3));
		ZEsquemas.setLayout(new GridLayout(5,3));
		
		ZSequencias.setLayout(layout);
		
		
		//BORDERSS
		
		TitledBorder bordalogica = new TitledBorder("Logics");
		TitledBorder bordanumeros = new TitledBorder("Numbers");
		TitledBorder bordaconjuntos= new TitledBorder("Sets");
		TitledBorder bordarelacoes= new TitledBorder("Relations");
		TitledBorder bordafuncoes= new TitledBorder("Functions");
		TitledBorder bordasequencias= new TitledBorder("Sequences");
		TitledBorder bordaesquemas= new TitledBorder("Schemas");
		
		Zlogic.setBorder(bordalogica);
		ZNumbers.setBorder(bordanumeros);
		ZSets.setBorder(bordaconjuntos);
		ZRelations.setBorder(bordarelacoes);
		ZFuncoes.setBorder(bordafuncoes);
		ZSequencias.setBorder(bordasequencias);
		ZEsquemas.setBorder(bordaesquemas);
		
		//BUTTONS
		//Logics
		 And = new JButton();
		 Or = new JButton();
		 True = new JButton();
		 False = new JButton();
		 ForAll = new JButton();
		 Exists = new JButton();
		 Exists_1 = new JButton();
		 Iff = new JButton();
		 Implies = new JButton(); 
		 LNot = new JButton();
		 Arroba = new JButton();
		 Conjecture = new JButton();
		 Arithmos = new JButton();
		 
		
		//Numbers
		 Leq = new JButton();
		 Succ = new JButton();
		 Nat = new JButton();
		 Neq = new JButton();
		 Num = new JButton();
		 Geq = new JButton();
		 Mod = new JButton();
		 Div = new JButton();
		 Times = new JButton();
		 Ominus = new JButton();
		 
		 
		 
		
		//Sets
		
		 Power = new JButton();
		 Finset = new JButton();
		 Cup = new JButton();
		 Cap = new JButton();
		 SetMinus = new JButton();
		 Subseteq = new JButton();
		 Subset = new JButton();
		 In = new JButton();
		 NotIn = new JButton();
		 Upto = new JButton();
		 Partition = new JButton();
		 JogoDaVelha = new JButton();
		 Cross = new JButton();
		 EmptySet = new JButton();
		 
		 //Relations

		 Rel = new JButton();
		 Mapsto = new JButton();
		 Project = new JButton();
		 Rres = new JButton();
		 Dres = new JButton();
		 nRres = new JButton();
		 nDres = new JButton();
		 Comp = new JButton();
		 Oplus = new JButton();
		 
		 
		 //Functions
		 
		 Fun = new JButton();
		 Pfun = new JButton();
		 Pinj = new JButton();
		 Inj = new JButton();
		 Psurj = new JButton();
		 Surj = new JButton();
		 Bij = new JButton();
		 Ffun = new JButton();
		 Finj = new JButton();
		 Lambda = new JButton();
		 Circ = new JButton();
		 Ran = new JButton();
		 Id = new JButton();
		 rIMG = new JButton();
		 lIMG = new JButton();
		 Dom = new JButton();
		 Inv = new JButton();
		 
		 //Sequencias

		 Seq = new JButton();
		 Iseq = new JButton();
		 Cat = new JButton();
		 LAngle = new JButton();
		 RAngle = new JButton();
		 Extract = new JButton();
		 Filter = new JButton();

		 //Esquemas
		 
		 VDash = new JButton();
		 Delta = new JButton();
		 Xi = new JButton();
		 Let = new JButton();
		 IF = new JButton();
		 Then = new JButton();
		 Else = new JButton();
		 Pre = new JButton();
		 Theta = new JButton();
		 lBlot = new JButton();
		 rBlot = new JButton();
		 Alpha = new JButton();
		 Ldata = new JButton();
		 Rdata = new JButton();
		 pipe = new JButton();
		 
		//TEXTS
		//Logics
		And.setText(ZString.AND);
		And.setToolTipText(zLatex.get(And.getText()));
		Or.setText(ZString.OR);
		Or.setToolTipText(zLatex.get(Or.getText()));
		True.setText(ZString.TRUE);
		True.setToolTipText(zLatex.get(True.getText()));
		False.setText(ZString.FALSE);
		False.setToolTipText(zLatex.get(False.getText()));
		ForAll.setText(ZString.ALL);
		ForAll.setToolTipText(zLatex.get(ForAll.getText()));
		Exists.setText(ZString.EXI);
		Exists.setToolTipText(zLatex.get(Exists.getText()));
		Exists_1.setText(ZString.EXIONE);
		Exists_1.setToolTipText("exists_1");
		Iff.setText(ZString.IFF);
		Iff.setToolTipText(zLatex.get(Iff.getText()));
		Implies.setText(ZString.IMP);
		Implies.setToolTipText(zLatex.get(Implies.getText()));
		LNot.setText(ZString.NOT);
		LNot.setToolTipText(zLatex.get(LNot.getText()));
		Arroba.setText(ZString.SPOT);
		Arroba.setToolTipText(zLatex.get(Arroba.getText()));
		Conjecture.setText(ZString.CONJECTURE);
		Conjecture.setToolTipText(zLatex.get(Conjecture.getText()));
		Arithmos.setText(ZString.ARITHMOS);
		Arithmos.setToolTipText(zLatex.get(Arithmos.getText()));
		
		
		//Numbers
		Succ.setText("\u227B" );
		Succ.setToolTipText(zLatex.get(Succ.getText()));
		Leq.setText(ZString.LEQ);
		Leq.setToolTipText(zLatex.get(Leq.getText()));
		Nat.setText(ZString.NAT);
		Nat.setToolTipText(zLatex.get(Nat.getText()));
		Num.setText(ZString.NUM);
		Num.setToolTipText(zLatex.get(Num.getText()));
		Neq.setText(ZString.NEQ);
		Neq.setToolTipText(zLatex.get(Neq.getText()));
		Leq.setText(ZString.LEQ);
		Leq.setToolTipText(zLatex.get(Leq.getText()));
		Geq.setText(ZString.GEQ);
		Geq.setToolTipText(zLatex.get(Geq.getText()));
		Mod.setText("mod");
		Mod.setToolTipText(zLatex.get(Mod.getText()));
		Div.setText("div");
		Div.setToolTipText(zLatex.get(Div.getText()));
		Times.setText(ZString.CROSS);
		Times.setToolTipText(zLatex.get(Times.getText()));
		Ominus.setText(ZString.SYMDIFF);
		Ominus.setToolTipText(zLatex.get(Ominus.getText()));
		
		//Sets
		
		Power.setText(ZString.POWER);
		Power.setToolTipText(zLatex.get(Power.getText()));
		Finset.setText(ZString.FINSET);
		Finset.setToolTipText(zLatex.get(Finset.getText()));
		Cup.setText(ZString.CUP);
		Cup.setToolTipText(zLatex.get(Cup.getText()));
		Cap.setText(ZString.CAP);
		Cap.setToolTipText(zLatex.get(Cap.getText()));
		SetMinus.setText(ZString.SETMINUS);
		SetMinus.setToolTipText(zLatex.get(SetMinus.getText()));
		Subseteq.setText(ZString.SUBSETEQ);
		Subseteq.setToolTipText(zLatex.get(Subseteq.getText()));
		Subset.setText(ZString.SUBSET);
		Subset.setToolTipText(zLatex.get(Subset.getText()));
		In.setText(ZString.MEM);
		In.setToolTipText(zLatex.get(In.getText()));
		NotIn.setText(ZString.NOTMEM);
		NotIn.setToolTipText(zLatex.get(NotIn.getText()));
		Upto.setText("..");
		Upto.setToolTipText(zLatex.get(Upto.getText()));
		JogoDaVelha.setText(ZString.NUMBER);
		JogoDaVelha.setToolTipText(zLatex.get(JogoDaVelha.getText()));
		Partition.setText("partition");
		Partition.setToolTipText(zLatex.get(Partition.getText()));
		Cross.setText(ZString.CROSS);
		Cross.setToolTipText(zLatex.get(Cross.getText()));
		EmptySet.setText(ZString.EMPTYSET);
		EmptySet.setToolTipText(zLatex.get(EmptySet.getText()));
		
		//Rela��es
		
		Rel.setText(ZString.REL);
		Rel.setToolTipText(zLatex.get(Rel.getText()));
		Mapsto.setText(ZString.MAPSTO);
		Mapsto.setToolTipText(zLatex.get(Mapsto.getText()));
		Project.setText(ZString.ZPROJ);
		Project.setToolTipText(zLatex.get(Project.getText()));
		Rres.setText(ZString.RRES);
		Rres.setToolTipText(zLatex.get(Rres.getText()));
		Dres.setText(ZString.DRES);
		Dres.setToolTipText(zLatex.get(Dres.getText()));
		nRres.setText(ZString.NRRES);
		nRres.setToolTipText(zLatex.get(nRres.getText()));
		nDres.setText(ZString.NDRES);
		nDres.setToolTipText(zLatex.get(nDres.getText()));
		Comp.setText(ZString.COMP);
		Comp.setToolTipText(zLatex.get(Comp.getText()));
		Oplus.setText(ZString.OPLUS);
		Oplus.setToolTipText(zLatex.get(Oplus.getText()));
		
		
		//Funcoes
		
		Fun.setText(ZString.FUN);
		Fun.setToolTipText(zLatex.get(Fun.getText()));
		Pfun.setText(ZString.PFUN);
		Pfun.setToolTipText(zLatex.get(Pfun.getText()));
		Pinj.setText(ZString.PINJ);
		Pinj.setToolTipText(zLatex.get(Pinj.getText()));
		Inj.setText(ZString.INJ);
		Inj.setToolTipText(zLatex.get(Inj.getText()));
		Psurj.setText(ZString.PSURJ);
		Psurj.setToolTipText(zLatex.get(Psurj.getText()));
		Surj.setText(ZString.SURJ);
		Surj.setToolTipText(zLatex.get(Surj.getText()));
		Bij.setText(ZString.BIJ);
		Bij.setToolTipText(zLatex.get(Bij.getText()));
		Ffun.setText(ZString.FFUN);
		Ffun.setToolTipText(zLatex.get(Ffun.getText()));
		Finj.setText(ZString.FINJ);
		Finj.setToolTipText(zLatex.get(Finj.getText()));
		Lambda.setText(ZString.LAMBDA);
		Lambda.setToolTipText(zLatex.get(Lambda.getText()));
		Circ.setText(ZString.CIRC);
		Circ.setToolTipText(zLatex.get(Circ.getText()));
		Inv.setText("inv" );
		Inv.setToolTipText(zLatex.get(Inv.getText()));
		Dom.setText("dom" );
		Dom.setToolTipText(zLatex.get(Dom.getText()));
		rIMG.setText(ZString.RIMG);
		rIMG.setToolTipText(zLatex.get(rIMG.getText()));
		lIMG.setText(ZString.LIMG);
		lIMG.setToolTipText(zLatex.get(lIMG.getText()));
		Id.setText("id");
		Id.setToolTipText(zLatex.get(Id.getText()));
		Ran.setText("ran");
		Ran.setToolTipText(zLatex.get(Ran.getText()));
		
		//Sequencias
		
		Seq.setText("seq");
		Seq.setToolTipText(zLatex.get(Seq.getText()));
		Iseq.setText("iseq");
		Iseq.setToolTipText(zLatex.get(Iseq.getText()));
		Cat.setText(ZString.CAT);
		Cat.setToolTipText(zLatex.get(Cat.getText()));
		LAngle.setText(ZString.LANGLE);
		LAngle.setToolTipText(zLatex.get(LAngle.getText()));
		RAngle.setText(ZString.RANGLE);
		RAngle.setToolTipText(zLatex.get(RAngle.getText()));
		Extract.setText(ZString.EXTRACT);
		Extract.setToolTipText(zLatex.get(Extract.getText()));
		Filter.setText(ZString.FILTER);
		Filter.setToolTipText(zLatex.get(Filter.getText()));
		
		
		//Esquemas
		
		VDash.setText(ZString.VDASH);
		VDash.setToolTipText(zLatex.get(VDash.getText()));
		Delta.setText(ZString.DELTA);
		Delta.setToolTipText(zLatex.get(Delta.getText()));
		Xi.setText(ZString.XI);
		Xi.setToolTipText(zLatex.get(Xi.getText()));
		Let.setText(ZString.LET);
		Let.setToolTipText(zLatex.get(Let.getText()));
		IF.setText(ZString.IF);
		IF.setToolTipText(zLatex.get(IF.getText()));
		Then.setText(ZString.THEN);
		Then.setToolTipText(zLatex.get(Then.getText()));
		Else.setText(ZString.ELSE);
		Else.setToolTipText(zLatex.get(Else.getText()));
		Pre.setText(ZString.PRE);
		Pre.setToolTipText(zLatex.get(Pre.getText()));
		Theta.setText(ZString.THETA);
		Theta.setToolTipText(zLatex.get(Theta.getText()));
		lBlot.setText(ZString.LBIND);
		lBlot.setToolTipText(zLatex.get(lBlot.getText()));
		rBlot.setText(ZString.RBIND);
		rBlot.setToolTipText(zLatex.get(rBlot.getText()));
		Alpha.setText("\u03B1");
		Alpha.setToolTipText(zLatex.get(Alpha.getText()));
		Ldata.setText(ZString.LDATA);
		Ldata.setToolTipText(zLatex.get(Ldata.getText()));
		Rdata.setText(ZString.RDATA);
		Rdata.setToolTipText(zLatex.get(Rdata.getText()));
		pipe.setText(ZString.ZPIPE );
		pipe.setToolTipText(zLatex.get(pipe.getText()));
		
		//SETANDO A FONTA dos BOTOES
		
		//Logics
		
		And.setFont(Czt);
		Or.setFont(Czt);
		True.setFont(Czt);
		False.setFont(Czt);
		ForAll.setFont(Czt);
		Exists.setFont(Czt);
		Exists_1.setFont(Czt);
		Iff.setFont(Czt);
		Implies.setFont(Czt);
		LNot.setFont(Czt);
		Arroba.setFont(Czt);
		Conjecture.setFont(Czt);
		Arithmos.setFont(Czt);
		
		//Numbers
		
		Nat.setFont(Czt);
		Num.setFont(Czt);
		Neq.setFont(Czt);
		Leq.setFont(Czt);
		Geq.setFont(Czt);
		Mod.setFont(Czt);
		Div.setFont(Czt);
		Succ.setFont(Czt);
		Times.setFont(Czt);
		Ominus.setFont(Czt);
		
		//Conjuntos
		Finset.setFont(Czt);
		Power.setFont(Czt);
		Cup.setFont(Czt);
		Cap.setFont(Czt);
		SetMinus.setFont(Czt);
		Subseteq.setFont(Czt);
		Subset.setFont(Czt);
		In.setFont(Czt);
		NotIn.setFont(Czt);
		Upto.setFont(Czt);
		Partition.setFont(Czt);
		JogoDaVelha.setFont(Czt);
		Cross.setFont(Czt);
		EmptySet.setFont(Czt);
		
		//Rela��es
		
		Rel.setFont(Czt);
		Mapsto.setFont(Czt);
		Project.setFont(Czt);
		Rres.setFont(Czt);
		Dres.setFont(Czt);
		nRres.setFont(Czt);
		nDres.setFont(Czt);
		Comp.setFont(Czt);
		Oplus.setFont(Czt);
		
		//Funcoes
		
		Fun.setFont(Czt);
		Pfun.setFont(Czt);
		Pinj.setFont(Czt);
		Inj.setFont(Czt);
		Psurj.setFont(Czt);
		Surj.setFont(Czt);
		Bij.setFont(Czt);
		Ffun.setFont(Czt);
		Finj.setFont(Czt);
		Lambda.setFont(Czt);
		Circ.setFont(Czt);
		Inv.setFont(Czt);
		Dom.setFont(Czt);
		rIMG.setFont(Czt);
		lIMG.setFont(Czt);
		Id.setFont(Czt);
		Ran.setFont(Czt);
		
		//Sequencias
		
		Seq.setFont(Czt);
		Iseq.setFont(Czt);
		Cat.setFont(Czt);
		LAngle.setFont(Czt);
		RAngle.setFont(Czt);
		Extract.setFont(Czt);
		Filter.setFont(Czt);
		
		//Esquemas
		
		VDash.setFont(Czt);
		Delta.setFont(Czt);
		Xi.setFont(Czt);
		Let.setFont(Czt);
		IF.setFont(Czt);
		Then.setFont(Czt);
		Else.setFont(Czt);
		Pre.setFont(Czt);
		Theta.setFont(Czt);
		lBlot.setFont(Czt);
		rBlot.setFont(Czt);
		Alpha.setFont(Czt);
		Ldata.setFont(Czt);
		Rdata.setFont(Czt);
		pipe.setFont(Czt);
		
		
		//ADICIONANDO NO PANEL
		//Logics
		
		Zlogic.add(And);
		Zlogic.add(Or);
		Zlogic.add(True);
		Zlogic.add(False);
		Zlogic.add(ForAll);
		Zlogic.add(Exists);
		Zlogic.add(Exists_1);
		Zlogic.add(Iff);
		Zlogic.add(Implies);
		Zlogic.add(LNot);
		Zlogic.add(Arroba);
		Zlogic.add(Conjecture);
		Zlogic.add(Arithmos);
		
		//Numbers
		ZNumbers.add(Leq);
		ZNumbers.add(Succ);
		ZNumbers.add(Nat);
		ZNumbers.add(Num);
		ZNumbers.add(Neq);
		ZNumbers.add(Leq);
		ZNumbers.add(Geq);
		ZNumbers.add(Mod);
		ZNumbers.add(Div);
		ZNumbers.add(Ominus);
		
		
		//Sets
		
		ZSets.add(Power);
		ZSets.add(Finset);
		ZSets.add(Cup);
		ZSets.add(Cap);
		ZSets.add(SetMinus);
		ZSets.add(Subseteq);
		ZSets.add(Subset);
		ZSets.add(In);
		ZSets.add(NotIn);
		ZSets.add(Upto);
		ZSets.add(Partition);
		ZSets.add(JogoDaVelha);
		ZSets.add(Cross);
		ZSets.add(EmptySet);
		
		//Relacoes
		
		ZRelations.add(Rel);
		ZRelations.add(Mapsto);
		ZRelations.add(Project);
		ZRelations.add(Rres);
		ZRelations.add(Dres);
		ZRelations.add(nRres);
		ZRelations.add(nDres);
		ZRelations.add(Comp);
		ZRelations.add(Oplus);
		
		//Funcoes
		
		ZFuncoes.add(Fun);
		ZFuncoes.add(Pfun);
		ZFuncoes.add(Pinj);
		ZFuncoes.add(Inj);
		ZFuncoes.add(Psurj);
		ZFuncoes.add(Surj);
		ZFuncoes.add(Bij);
		ZFuncoes.add(Ffun);
		ZFuncoes.add(Finj);
		ZFuncoes.add(Lambda);
		ZFuncoes.add(Circ);
		ZFuncoes.add(Inv);
		ZFuncoes.add(Dom);
		ZFuncoes.add(rIMG);
		ZFuncoes.add(lIMG);
		ZFuncoes.add(Id);
		ZFuncoes.add(Ran);
		
		//Sequencias
		
		constraints.fill = GridBagConstraints.HORIZONTAL;
		
		addComponent(ZSequencias, Seq, 0, 0, 1, 1);
		addComponent(ZSequencias, Iseq, 0, 1, 1, 1);
		addComponent(ZSequencias, Cat, 0, 2, 1, 1);
		addComponent(ZSequencias, LAngle, 0, 3, 1, 1);
		addComponent(ZSequencias, RAngle, 0, 4, 1, 1);
		addComponent(ZSequencias, Filter, 0, 5, 1, 1);
		addComponent(ZSequencias, Extract, 0, 6, 1, 1);
		
		
		//Esquemas
		
		ZEsquemas.add(VDash);
		ZEsquemas.add(Delta);
		ZEsquemas.add(Xi);
		ZEsquemas.add(Let);
		ZEsquemas.add(IF);
		ZEsquemas.add(Then);
		ZEsquemas.add(Else);
		ZEsquemas.add(Pre);
		ZEsquemas.add(Theta);
		ZEsquemas.add(lBlot);
		ZEsquemas.add(rBlot);
		ZEsquemas.add(Ldata);
		ZEsquemas.add(Rdata);
		ZEsquemas.add(Alpha);
		ZEsquemas.add(pipe);
		
		
		Z_1.add(Zlogic);
		Z_1.add(ZNumbers);
		Z_1.add(ZSets);
		Z_1.add(ZSequencias);
		Z_2.add(ZRelations);
		Z_2.add(ZFuncoes);
		Z_2.add(ZEsquemas);
		
		
		
		//ADICIONANDO FUNCIONALIDADES NOS BOTOES
		//Z
		
		//Logics
		
		And.addActionListener(new allButtons());
		Or.addActionListener(new allButtons());
		True.addActionListener(new allButtons());
		False.addActionListener(new allButtons());
		Exists.addActionListener(new allButtons());
		Exists_1.addActionListener(new allButtons());
		ForAll.addActionListener(new allButtons());
		Iff.addActionListener(new allButtons());
		Implies.addActionListener(new allButtons());
		LNot.addActionListener(new allButtons());
		Arroba.addActionListener(new allButtons());
		Conjecture.addActionListener(new allButtons());
		Arithmos.addActionListener(new allButtons());
		
		
		//Numbers
		
		Leq.addActionListener(new allButtons());
		Succ.addActionListener(new allButtons());
		Nat.addActionListener(new allButtons());
		Num.addActionListener(new allButtons());
		Neq.addActionListener(new allButtons());
		Geq.addActionListener(new allButtons());
		Mod.addActionListener(new allButtons());
		Div.addActionListener(new allButtons());
		Times.addActionListener(new allButtons());
		Ominus.addActionListener(new allButtons());
		
		//Sets
		
		Finset.addActionListener(new allButtons());
		Power.addActionListener(new allButtons());
		Cup.addActionListener(new allButtons());
		Cap.addActionListener(new allButtons());
		SetMinus.addActionListener(new allButtons());
		Subseteq.addActionListener(new allButtons());
		Subset.addActionListener(new allButtons());
		In.addActionListener(new allButtons());
		NotIn.addActionListener(new allButtons());
		Upto.addActionListener(new allButtons());
		Partition.addActionListener(new allButtons());
		JogoDaVelha.addActionListener(new allButtons());
		Cross.addActionListener(new allButtons());
		EmptySet.addActionListener(new allButtons());
		
		
		//Relacoes
		
		Rel.addActionListener(new allButtons());
		Mapsto.addActionListener(new allButtons());
		Project.addActionListener(new allButtons());
		Dres.addActionListener(new allButtons());
		Rres.addActionListener(new allButtons());
		nDres.addActionListener(new allButtons());
		nRres.addActionListener(new allButtons());
		Comp.addActionListener(new allButtons());
		Oplus.addActionListener(new allButtons());
		
		//Funcoes
		
		Fun.addActionListener(new allButtons());
		Pfun.addActionListener(new allButtons());
		Pinj.addActionListener(new allButtons());
		Inj.addActionListener(new allButtons());
		Psurj.addActionListener(new allButtons());
		Surj.addActionListener(new allButtons());
		Bij.addActionListener(new allButtons());
		Ffun.addActionListener(new allButtons());
		Finj.addActionListener(new allButtons());
		Lambda.addActionListener(new allButtons());
		Circ.addActionListener(new allButtons());
		Inv.addActionListener(new allButtons());
		Dom.addActionListener(new allButtons());
		rIMG.addActionListener(new allButtons());
		lIMG.addActionListener(new allButtons());
		Id.addActionListener(new allButtons());
		Ran.addActionListener(new allButtons());
		
		
		//Sequencias
		
		Seq.addActionListener(new allButtons());
		Iseq.addActionListener(new allButtons());
		Cat.addActionListener(new allButtons());
		LAngle.addActionListener(new allButtons());
		RAngle.addActionListener(new allButtons());
		Extract.addActionListener(new allButtons());
		Filter.addActionListener(new allButtons());
		
		
		//Esquemas
		
		VDash.addActionListener(new allButtons());
		Delta.addActionListener(new allButtons());
		Xi.addActionListener(new allButtons());
		Let.addActionListener(new allButtons());
		IF.addActionListener(new allButtons());
		Then.addActionListener(new allButtons());
		Else.addActionListener(new allButtons());
		Pre.addActionListener(new allButtons());
		Theta.addActionListener(new allButtons());
		lBlot.addActionListener(new allButtons());
		rBlot.addActionListener(new allButtons());
		Alpha.addActionListener(new allButtons());
		Ldata.addActionListener(new allButtons());
		Rdata.addActionListener(new allButtons());
		pipe.addActionListener(new allButtons());
		
		
		//Adicionando aba de Circus
		JPanel Circus = new JPanel();
		tabbedPane.addTab(" Circus ",null, Circus, " Simbolos de Circus ");
		
		JPanel circus = new JPanel();
		
		//Layout
		
		circus.setLayout(new GridLayout(12,3));
		
		//Definindo Borda
		
		TitledBorder bordacircus = new TitledBorder("Circus");		
		circus.setBorder(bordacircus);
		
		//BUTTONS
		
		Defs = new JButton();
		Odot = new JButton();
		CircState = new JButton();
		CircNameSet = new JButton();
		Extchoice = new JButton();
		Intchoice = new JButton();
		Semi = new JButton();
		Parallel = new JButton();
		Lpar = new JButton();
		Rpar = new JButton();
		Interleave = new JButton();
		Circmu = new JButton();
		Guard = new JButton();
		extchoice = new JButton();
		intchoice = new JButton();
		interleave = new JButton();
		circchannel = new JButton();
		circchannelFrom = new JButton();
		circchannelSet = new JButton();
		circChaos = new JButton();
		circStop =  new JButton();
		circSkip =  new JButton();
		circDo =  new JButton();
		circOd =  new JButton();
		CircEnd = new JButton();
		CircHiding = new JButton();
		circprocess = new JButton();
		circsimulates = new JButton();
		circrefines = new JButton();
		circval = new JButton();
		circres = new JButton();
		circvalres = new JButton();
		circthen = new JButton();
		then = new JButton();
		circfi = new JButton();
		circelse = new JButton();
		circvar = new JButton();
		linter = new JButton();
		rinter = new JButton();
		lcircguard = new JButton();
		rcircguard = new JButton();
		lchanset = new JButton();
		rchanset = new JButton();
		lcircrename = new JButton();
		rcircrename = new JButton();
		Boolean = new JButton();
		CircAssertRef = new JButton();
		CircAssign = new JButton();
		CircBegin = new JButton();
		Hide = new JButton();
		//TEXTS AND TOOLTIPTEXTS
		
		Defs.setText(CircusString.CIRCDEF );
		Odot.setText(CircusString.CIRCINDEX );
		CircState.setText(CircusString.CIRCSTATE );
		CircNameSet.setText(CircusString.CIRCNAMESET);
		Extchoice.setText(CircusString.REPEXTCHOICE );
		Intchoice.setText(CircusString.REPINTCHOICE );
		Semi.setText(CircusString.SEMI );
		Parallel.setText(CircusString.REPPARALLEL );
		Lpar.setText(CircusString.LPAR );
		Rpar.setText(CircusString.RPAR );
		Interleave.setText(CircusString.REPINTERLEAVE );
		Circmu.setText(CircusString.CIRCMU );
		Guard.setText("&" );
		extchoice.setText(CircusString.EXTCHOICE );
		intchoice.setText(CircusString.INTCHOICE );
		interleave.setText(CircusString.INTERLEAVE );
		circchannel.setText(CircusString.CIRCCHAN );
		circchannelFrom.setText(CircusString.CIRCCHANFROM );
		circchannelSet.setText(CircusString.CIRCCHANSET);
		circChaos.setText(CircusString.CIRCCHAOS);
		circSkip.setText(CircusString.CIRCSKIP);
		circStop.setText(CircusString.CIRCSTOP);
		Hide.setText(ZString.ZHIDE);
		
		circDo.setText(CircusString.CIRCDO);
		circOd.setText(CircusString.CIRCOD);
		CircEnd.setText(CircusString.CIRCEND);
		CircHiding.setText(CircusString.CIRCHIDING);
		circprocess.setText(CircusString.CIRCPROC);
		circrefines.setText(CircusString.CIRCREFINES);
		circsimulates.setText(CircusString.CIRCSIMULATES);
		circval.setText(CircusString.CIRCVAL );
		circres.setText(CircusString.CIRCRES );
		circvalres.setText(CircusString.CIRCVRES );
		circthen.setText(CircusString.CIRCTHEN );
		then.setText(CircusString.THEN);
		circfi.setText(CircusString.CIRCFI );
		circelse.setText(CircusString.CIRCELSE );
		circvar.setText(CircusString.CIRCVAR );
		linter.setText(CircusString.LINTER );
		rinter.setText(CircusString.RINTER );
		lcircguard.setText(CircusString.LCIRCGUARD);
		rcircguard.setText(CircusString.RCIRCGUARD);
		lchanset.setText(CircusString.LCIRCCHANSET );
		rchanset.setText(CircusString.RCIRCCHANSET );
		lcircrename.setText(CircusString.LCIRCRENAME );
		rcircrename.setText(CircusString.RCIRCRENAME );
		Boolean.setText(CircusString.BOOLEAN);
		CircAssertRef.setText(CircusString.CIRCASSERTREF);
		CircAssign.setText(CircusString.CIRCASSIGN);
		CircBegin.setText(CircusString.CIRCBEGIN);
		
		
		
		
		Defs.setToolTipText(circusLatex.get(Defs.getText()));
		Odot.setToolTipText(circusLatex.get(Odot.getText()));
		CircState.setToolTipText(circusLatex.get(CircState.getText()));
		CircNameSet.setToolTipText(circusLatex.get(CircNameSet.getText()));
		Hide.setToolTipText(circusLatex.get(Hide.getText()));
		Extchoice.setToolTipText(circusLatex.get(Extchoice.getText()));
		Intchoice.setToolTipText(circusLatex.get(Intchoice.getText()));
		Semi.setToolTipText(circusLatex.get(Semi.getText()));
		Parallel.setToolTipText(circusLatex.get(Parallel.getText()));
		Lpar.setToolTipText(circusLatex.get(Lpar.getText()));
		Rpar.setToolTipText(circusLatex.get(Rpar.getText()));
		Interleave.setToolTipText(circusLatex.get(Interleave.getText()));
		Circmu.setToolTipText(circusLatex.get(Circmu.getText()));
		Guard.setToolTipText(circusLatex.get(Guard.getText()));
		extchoice.setToolTipText(circusLatex.get(extchoice.getText()));
		intchoice.setToolTipText(circusLatex.get(intchoice.getText()));
		interleave.setToolTipText(circusLatex.get(interleave.getText()));
		circchannel.setToolTipText(circusLatex.get(circchannel.getText()));
		circchannelFrom.setToolTipText(circusLatex.get(circchannelFrom.getText()));
		circchannelSet.setToolTipText(circusLatex.get(circchannelSet.getText()));
		circChaos.setToolTipText(circusLatex.get(circChaos.getText()));
		circSkip.setToolTipText(circusLatex.get(circSkip.getText()));
		circStop.setToolTipText(circusLatex.get(circStop.getText()));
		circDo.setToolTipText(circusLatex.get(circDo.getText()));
		circOd.setToolTipText(circusLatex.get(circOd.getText()));
		CircEnd.setToolTipText(circusLatex.get(CircEnd.getText()));
		CircHiding.setToolTipText(circusLatex.get(CircHiding.getText()));
		circprocess.setToolTipText(circusLatex.get(circprocess.getText()));
		circrefines.setToolTipText(circusLatex.get(circrefines.getText()));
		circsimulates.setToolTipText(circusLatex.get(circsimulates.getText()));
		circval.setToolTipText(circusLatex.get(circval.getText()));
		circres.setToolTipText(circusLatex.get(circres.getText()));
		circvalres.setToolTipText(circusLatex.get(circvalres.getText()));
		circthen.setToolTipText(circusLatex.get(circthen.getText()));
		then.setToolTipText(circusLatex.get(then.getText()));
		circfi.setToolTipText(circusLatex.get(circfi.getText()));
		circelse.setToolTipText(circusLatex.get(circelse.getText()));
		circvar.setToolTipText(circusLatex.get(circvar.getText()));
		linter.setToolTipText(circusLatex.get(linter.getText()));
		rinter.setToolTipText(circusLatex.get(rinter.getText()));
		lcircguard.setToolTipText(circusLatex.get(lcircguard.getText()));
		rcircguard.setToolTipText(circusLatex.get(rcircguard.getText()));
		lchanset.setToolTipText(circusLatex.get(lchanset.getText()));
		rchanset.setToolTipText(circusLatex.get(rchanset.getText()));
		lcircrename.setToolTipText(circusLatex.get(lcircrename.getText()));
		rcircrename.setToolTipText(circusLatex.get(rcircrename.getText()));
		Boolean.setToolTipText(circusLatex.get(Boolean.getText()));
		CircAssertRef.setToolTipText(circusLatex.get(CircAssertRef.getText()));
		CircAssign.setToolTipText(circusLatex.get(CircAssign.getText()));
		CircBegin.setToolTipText(circusLatex.get(CircBegin.getText()));
		
		//SETANDO AS FONTES DOS BUT�ES
		
		Defs.setFont(Czt);
		Odot.setFont(Czt);
		CircState.setFont(Czt);
		CircNameSet.setFont(Czt);
		Extchoice.setFont(Czt);
		Intchoice.setFont(Czt);
		Semi.setFont(Czt);
		Parallel.setFont(Czt);
		Lpar.setFont(Czt);
		Rpar.setFont(Czt);
		Interleave.setFont(Czt);
		Circmu.setFont(Czt);
		Guard.setFont(Czt);
		extchoice.setFont(Czt);
		intchoice.setFont(Czt);
		interleave.setFont(Czt);
		circchannel.setFont(Czt);
		circchannelFrom.setFont(Czt);
		circchannelSet.setFont(Czt);
		circChaos.setFont(Czt);
		circSkip.setFont(Czt);
		circStop.setFont(Czt);
		circDo.setFont(Czt);
		circOd.setFont(Czt);
		CircEnd.setFont(Czt);
		CircHiding.setFont(Czt);
		circprocess.setFont(Czt);
		circrefines.setFont(Czt);
		circsimulates.setFont(Czt);
		circval.setFont(Czt);
		circres.setFont(Czt);
		circvalres.setFont(Czt);
		circthen.setFont(Czt);
		circfi.setFont(Czt);
		circelse.setFont(Czt);
		circvar.setFont(Czt);
		linter.setFont(Czt);
		rinter.setFont(Czt);
		lcircguard.setFont(Czt);
		rcircguard.setFont(Czt);
		lchanset.setFont(Czt);
		rchanset.setFont(Czt);
		lcircrename.setFont(Czt);
		rcircrename.setFont(Czt);
		Boolean.setFont(Czt);
		CircAssertRef.setFont(Czt);
		CircAssign.setFont(Czt);
		CircBegin.setFont(Czt);
		Hide.setFont(Czt);
		
		//ADICIONANDO BUTOES AO PANEL CIRCUS
		
		circus.add(Boolean);
		circus.add(CircAssertRef);
		circus.add(CircAssign);
		circus.add(CircBegin);
		circus.add(circchannel);
		circus.add(circchannelFrom);
		circus.add(circchannelSet);
		circus.add(circChaos);
		circus.add(circSkip);
		circus.add(circStop);
		circus.add(circDo);
		circus.add(circOd);
		circus.add(CircEnd);
		circus.add(Defs);
		circus.add(CircHiding);
		circus.add(Odot);
		circus.add(CircState);
		circus.add(CircNameSet);
		circus.add(Extchoice);
		circus.add(Intchoice);
		circus.add(Semi);
		circus.add(Parallel);
		//circus.add(Lpar);
		circus.add(Hide);
		//circus.add(Rpar);
		circus.add(Interleave);
		circus.add(Circmu);
		circus.add(Guard);
		circus.add(extchoice);
		circus.add(intchoice);
		circus.add(interleave);
		circus.add(circprocess);
		circus.add(circsimulates);
		circus.add(circrefines);
		circus.add(circval);
		circus.add(circres);
		circus.add(circvalres);
		circus.add(circthen);
		circus.add(circfi);
		circus.add(circelse);
		circus.add(circvar);
		circus.add(linter);
		circus.add(rinter);
		circus.add(lchanset);
		circus.add(rchanset);
		circus.add(lcircrename);
		circus.add(rcircrename);
		circus.add(lcircguard);
		circus.add(rcircguard);
		
		
		
		Circus.add(circus);
		
//		ADICIONANDO FUNCIONALIDADES NOS BOTOES
		
		//CIRCUS
		
		Defs.addActionListener(new allButtons());
		Odot.addActionListener(new allButtons());
		CircState.addActionListener(new allButtons());
		CircNameSet.addActionListener(new allButtons());
		Extchoice.addActionListener(new allButtons());
		Intchoice.addActionListener(new allButtons());
		Semi.addActionListener(new allButtons());
		Parallel.addActionListener(new allButtons());
		Lpar.addActionListener(new allButtons());
		Rpar.addActionListener(new allButtons());
		Interleave.addActionListener(new allButtons());
		Circmu.addActionListener(new allButtons());
		Guard.addActionListener(new allButtons());
		extchoice.addActionListener(new allButtons());
		intchoice.addActionListener(new allButtons());
		interleave.addActionListener(new allButtons());
		circchannel.addActionListener(new allButtons());
		circchannelFrom.addActionListener(new allButtons());
		circchannelSet.addActionListener(new allButtons());
		circChaos.addActionListener(new allButtons());
		circSkip.addActionListener(new allButtons());
		circStop.addActionListener(new allButtons());
		circDo.addActionListener(new allButtons());
		circOd.addActionListener(new allButtons());
		CircEnd.addActionListener(new allButtons());
		CircHiding.addActionListener(new allButtons());
		circprocess.addActionListener(new allButtons());
		circrefines.addActionListener(new allButtons());
		circsimulates.addActionListener(new allButtons());
		circval.addActionListener(new allButtons());
		circres.addActionListener(new allButtons());
		circvalres.addActionListener(new allButtons());
		circthen.addActionListener(new allButtons());
		circfi.addActionListener(new allButtons());
		circelse.addActionListener(new allButtons());
		circvar.addActionListener(new allButtons());;
		linter.addActionListener(new allButtons());
		rinter.addActionListener(new allButtons());
		lcircguard.addActionListener(new allButtons());
		rcircguard.addActionListener(new allButtons());
		lchanset.addActionListener(new allButtons());
		rchanset.addActionListener(new allButtons());
		lcircrename.addActionListener(new allButtons());
		rcircrename.addActionListener(new allButtons());
		Boolean.addActionListener(new allButtons());
		CircAssertRef.addActionListener(new allButtons());
		CircAssign.addActionListener(new allButtons());
		CircBegin.addActionListener(new allButtons());
		Hide.addActionListener(new allButtons());
		
		//Adicionando aba de Templates
		JPanel Templates = new JPanel();
		tabbedPane.addTab(" Templates ",null, Templates, " Templates ");
		
		add(tabbedPane);
		
			}
		
		public TelaParametro getTelaParam () {
		
			return this.telaParam;
		}
	
		private class allButtons implements ActionListener {
			public void actionPerformed(ActionEvent event) {
				if (event.getSource() instanceof JButton){
					telaParam.escrever(ESPACO + ((JButton)event.getSource()).getText()
							+ ESPACO);
				}
			}	
		}
				 
		public static void main (String args[]) {
			
		
			
			TecladoVirtual a = new TecladoVirtual();
			a.setDefaultCloseOperation(JFrame.DISPOSE_ON_CLOSE);
			a.setSize(400,200);
			a.pack();
			a.setVisible(true);
			
		}
		
		private void addComponent(Container Container , Component component , int row, int column, int width, int height ){
			
			constraints.gridx = column; // Onde o canto superior
			constraints.gridy = row; // esquerdo da grade ficara posicionado
			constraints.gridwidth = width;// numero de colunas ocupadas
			constraints.gridheight = height;//numero de linhas ocupadas
			layout.setConstraints(component, constraints);
			
			Container.add(component);
		}
		
		
	
}
