package circusRefine.gui;

import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.LinkedList;
import java.util.Stack;

import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;



import circusRefine.core.ExternalManager;
import circusRefine.core.idt.IdtUtils;
import circusRefine.core.util.Text;
import circusRefine.util.CRefineException;
import circusRefine.util.DocCommentsType;
import circusRefine.util.docgenerator.DocGeneratorUtils;
import circusRefine.util.docgenerator.DocGenerator;

/**
 * Janela onde o usurario podera selecionar o que fara parte do arquivo de saida.
 * O arquivo podera conter : A Especificao Original, O Desenvolvimento, Comentarios e
 * as Obrigaes de Prova  
 * @author Alessandro
 *
 */
public class PrintOptionsFrame extends JDialog {

	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;
	private boolean code;
	private boolean originalSpec;
	private boolean des;
	private DocCommentsType comment;
	private boolean proofOb;
	/* Campo que determina se a impressao das OPs serao feitas 
	 * de forma Expandida ou Resumida*/
	private boolean formaExpandida;

	private boolean subdevelopments;
	private ButtonGroup comentarios = new ButtonGroup();
	private ButtonGroup opsGroup = new ButtonGroup();
	int aumento;

	JLabel apresentacao;

	private JCheckBox oriSpecBox;
	private JCheckBox desBox;
	private JCheckBox proofObBox;
	private JCheckBox expandedBox;
	private JCheckBox notExpandedBox;
	private JCheckBox commentBox;
	private JCheckBox commentBeforeBox;
	private JCheckBox commentAfterBox;
	private JCheckBox commentAtListBox;
	private JCheckBox codBox;
	private JCheckBox subdevelopmentsBox;

	private JButton ok;
	private JButton cancel;


	private ExternalManager gerInterface;


	public PrintOptionsFrame(ExternalManager gerExt) {
		super(gerExt.retornarTelaPrincipal());
		/* valores Default*/
		gerInterface = gerExt;
		originalSpec = true;
		code = true;
		des = true;
		proofOb = true;
		formaExpandida = false;
		subdevelopments = false;
		comment = DocCommentsType.EM_LISTA;
		jbInit();
	}

	/**
	 * Metodo que inicializa os componentes graficos
	 *
	 */
	private void jbInit() {

		this.setTitle(this.retornarMensagem("COD0007"));
		this.setLocation((this.gerInterface.getTamanhoHorizontal()*(15))/100, (this.gerInterface.getTamanhoVertical()*20)/100);
		this.setSize(250,320);
		this.setLayout(null);
		this.setResizable(true);

		//CONFIGURANDO COMPONENTES

		apresentacao = new JLabel(this.retornarMensagem("COD0522"));
		apresentacao.setToolTipText(this.retornarMensagem("COD0523"));
		apresentacao.setLocation(10, 10);
		apresentacao.setSize(this.getWidth(), 20);

		oriSpecBox = new JCheckBox(this.retornarMensagem("COD0524"), true);
		oriSpecBox.setLocation(apresentacao.getX(), apresentacao.getY() + apresentacao.getHeight() + 10);
		oriSpecBox.setSize(this.getWidth(),20);
		oriSpecBox.addItemListener(new ItemListener() {
			public void itemStateChanged(ItemEvent e) {
				oriSpecBox_ItemStateChanged(e);
			}
		});

		desBox = new JCheckBox(this.retornarMensagem("COD0001"), true);
		desBox.setLocation(oriSpecBox.getX(), oriSpecBox.getY() + oriSpecBox.getHeight() + 10);
		desBox.setSize(this.getWidth(),20);
		desBox.addItemListener(new ItemListener() {
			public void itemStateChanged(ItemEvent e) {
				desBox_ItemStateChanged(e);
			}
		});

		proofObBox = new JCheckBox(this.retornarMensagem("COD0525"), true);
		proofObBox.setLocation(desBox.getX(), desBox.getY() + desBox.getHeight() + 10);
		proofObBox.setSize(this.getWidth(),20);
		proofObBox.addItemListener(new ItemListener() {
			public void itemStateChanged(ItemEvent e) {
				proofObBox_ItemStateChanged(e);
			}
		});

		notExpandedBox = new JCheckBox(this.retornarMensagem("COD0595"), true);
		notExpandedBox.setLocation(proofObBox.getX() + 20, proofObBox.getY() + proofObBox.getHeight() + 10);
		notExpandedBox.setSize(this.getWidth(),20);
		notExpandedBox.addItemListener(new ItemListener() {

			public void itemStateChanged(ItemEvent e) {
				OPsOption_ItemStateChanged(e);
			}

		});

		expandedBox = new JCheckBox(this.retornarMensagem("COD0596"));
		expandedBox.setLocation(notExpandedBox.getX(), notExpandedBox.getY() + notExpandedBox.getHeight()+ 10);
		expandedBox.setSize(this.getWidth(),20);
		expandedBox.addItemListener(new ItemListener() {
			public void itemStateChanged(ItemEvent e) {
				OPsOption_ItemStateChanged(e);
			}

		});


		codBox = new JCheckBox(this.retornarMensagem("COD0083"), true);
		codBox.setLocation(proofObBox.getX(), expandedBox.getY() + expandedBox.getHeight() + 10);
		codBox.setSize(this.getWidth(),20);
		codBox.addItemListener(new ItemListener() {
			public void itemStateChanged(ItemEvent e) {
				codBox_ItemStateChanged(e);
			}
		});


		subdevelopmentsBox = new JCheckBox(this.retornarMensagem("SubDevelopment"), true);
		subdevelopmentsBox.setLocation(codBox.getX(), codBox.getY() +codBox.getHeight() + 10);
		subdevelopmentsBox.setSize(this.getWidth(),20);
		subdevelopmentsBox.addItemListener(new ItemListener() {
			public void itemStateChanged(ItemEvent e) {
				subDevelopmentBox_ItemStateChanged(e);
			}
		});



		commentBox = new JCheckBox(this.retornarMensagem("COD0279"), true);
		commentBox.setLocation(proofObBox.getX(), codBox.getY() + codBox.getHeight() + 10);
		commentBox.setSize(this.getWidth(),20);
		commentBox.addItemListener(new ItemListener() {
			public void itemStateChanged(ItemEvent e) {
				commentBox_ItemStateChanged(e);
			}
		});

		ok = new JButton(this.gerInterface.getMessage("COD0072"));
		ok.setBackground(this.getBackground());
		ok.setFont(new Font("Dialog", 1, 12));
		ok.setLocation(commentBox.getX() + 65, commentBox.getY() + commentBox.getHeight() + 10);
		ok.setSize(70,20);
		ok.addActionListener(new java.awt.event.ActionListener() {
			public void actionPerformed(ActionEvent e) {
				try {
					ok_actionPerformed(e);
				} catch (CRefineException e1) {
					ErrorDialog errorDialog = new ErrorDialog(gerInterface, "" , 
							e1);
					errorDialog.setVisible(true);
				}
			}
		});

		cancel = new JButton("Cancel");
		cancel.setLocation(ok.getX() + ok.getWidth() + 10, ok.getY());
		cancel.setSize(80, 20);
		cancel.addActionListener(new java.awt.event.ActionListener() {
			public void actionPerformed(ActionEvent e) {
				cancel_actionPerformed(e);
			}
		});


		//ADICIONANDO COMPONENTES
		add(apresentacao);
		add(oriSpecBox);
		add(desBox);
		add(proofObBox);
		add(codBox);
		add(commentBox);
		add(ok);
		add(cancel);
		
		if (this.gerInterface.getNumberOfDev() > 0) {

			if (this.gerInterface.hasChild()) {

				subdevelopments = true;
				add(subdevelopmentsBox);
				commentBox.setLocation(commentBox.getX(), commentBox.getY() + subdevelopmentsBox.getHeight() + 10);
				ok.setLocation(ok.getX(), ok.getY() + ok.getHeight() + 10);
				cancel.setLocation(cancel.getX(), cancel.getY() + cancel.getHeight() + 10);
				this.setSize(this.getWidth(), this.getHeight() + subdevelopmentsBox.getHeight() + 10);
				
			}
		}


		commentAtListBox = new JCheckBox(this.retornarMensagem("COD0526"), true);
		commentAtListBox.setLocation(commentBox.getX() + 20, commentBox.getY() + commentBox.getHeight() + 10);
		commentAtListBox.setSize(this.getWidth(),20);
		commentAtListBox.addItemListener(new ItemListener() {

			public void itemStateChanged(ItemEvent e) {
				commentOptionsBox_ItemStateChanged(e);
			}

		});
		//Opo default de comentario

		commentBeforeBox = new JCheckBox(this.retornarMensagem("COD0527"));
		commentBeforeBox.setLocation(commentAtListBox.getX(), commentAtListBox.getY() + commentAtListBox.getHeight()+ 10);
		commentBeforeBox.setSize(this.getWidth(),20);
		commentBeforeBox.addItemListener(new ItemListener() {
			public void itemStateChanged(ItemEvent e) {
				commentOptionsBox_ItemStateChanged(e);
			}

		});

		commentAfterBox = new JCheckBox(this.retornarMensagem("COD0528"));
		commentAfterBox.setLocation(commentBeforeBox.getX(), commentBeforeBox.getY() + commentBeforeBox.getHeight() + 10);;
		commentAfterBox.setSize(this.getWidth(),20);
		commentAfterBox.addItemListener(new ItemListener() {
			public void itemStateChanged(ItemEvent e) {
				commentOptionsBox_ItemStateChanged(e);
			}

		});

		aumento =  commentAtListBox.getHeight() + commentBeforeBox.getHeight() + commentAfterBox.getHeight() + 40;

		this.setSize(this.getWidth(), this.getHeight() + aumento );

		ok.setLocation(ok.getX(), ok.getY() + aumento);
		cancel.setLocation(cancel.getX(), cancel.getY() + aumento);

		add(commentAtListBox);
		add(commentBeforeBox);
		add(commentAfterBox);
		add(expandedBox);
		add(notExpandedBox);


		comentarios.add(commentAtListBox);
		comentarios.add(commentBeforeBox);
		comentarios.add(commentAfterBox);


		opsGroup.add(expandedBox);
		opsGroup.add(notExpandedBox);

		this.repaint();
	}

	protected void subDevelopmentBox_ItemStateChanged(ItemEvent e) {
		if (e.getStateChange() == ItemEvent.SELECTED) {
			subdevelopments = true;
		}
		else {
			subdevelopments = false;
		}

	}

	/**
	 * Metodo que realiza a selecao de como sera feita a impressao das
	 * Obrigacoes de Prova, podendo estar tanto na forma Resumida, quanto
	 * na forma Expandida.
	 * @param e
	 */
	protected void OPsOption_ItemStateChanged(ItemEvent e) {
		if (e.getStateChange() == ItemEvent.SELECTED) {
			if (e.getSource() == expandedBox) {
				formaExpandida = true;
			}
			else if (e.getSource() == notExpandedBox) {
				formaExpandida = false;
			}
		}

	}

	protected void codBox_ItemStateChanged(ItemEvent e) {
		if (e.getStateChange() == ItemEvent.SELECTED) {
			code = true;
		}
		else {
			code = false;
		}

	}

	protected void proofObBox_ItemStateChanged(ItemEvent e) {

		int aumentoJanela = notExpandedBox.getHeight() + expandedBox.getHeight() + 20;

		if (e.getStateChange() == ItemEvent.SELECTED) {
			proofOb = true;

			this.setSize(this.getWidth(), this.getHeight() + aumentoJanela);

			codBox.setLocation(codBox.getX(), codBox.getY() + aumentoJanela);
			commentBox.setLocation(commentBox.getX(), commentBox.getY() + aumentoJanela);
			commentAtListBox.setLocation(commentAtListBox.getX(), commentAtListBox.getY() + aumentoJanela);
			commentBeforeBox.setLocation(commentBeforeBox.getX(), commentBeforeBox.getY() + aumentoJanela);
			commentAfterBox.setLocation(commentAfterBox.getX(), commentAfterBox.getY() + aumentoJanela);
			ok.setLocation(ok.getX(), ok.getY() + aumentoJanela);
			cancel.setLocation(cancel.getX(), cancel.getY() + aumentoJanela);

			this.add(notExpandedBox);
			this.add(expandedBox);

		}
		else {

			proofOb = false;

			this.setSize(this.getWidth(), this.getHeight() - aumentoJanela);

			codBox.setLocation(codBox.getX(), codBox.getY() - aumentoJanela);
			commentBox.setLocation(commentBox.getX(), commentBox.getY() - aumentoJanela);
			commentAtListBox.setLocation(commentAtListBox.getX(), commentAtListBox.getY() - aumentoJanela);
			commentBeforeBox.setLocation(commentBeforeBox.getX(), commentBeforeBox.getY() - aumentoJanela);
			commentAfterBox.setLocation(commentAfterBox.getX(), commentAfterBox.getY() - aumentoJanela);
			ok.setLocation(ok.getX(), ok.getY() - aumentoJanela);
			cancel.setLocation(cancel.getX(), cancel.getY() - aumentoJanela);

			this.remove(notExpandedBox);
			this.remove(expandedBox);
		}
	}

	protected void desBox_ItemStateChanged(ItemEvent e) {

		if (e.getStateChange() == ItemEvent.SELECTED) {
			des = true;
		}
		else {
			des = false;
		}
	}

	protected void oriSpecBox_ItemStateChanged(ItemEvent e) {
		if (e.getStateChange() == ItemEvent.SELECTED) {
			originalSpec = true;
		}
		else {
			originalSpec = false;
		}
	}

	/**
	 * Metodo que abri a opo de imprimir onde os comentarios
	 * deverao ser inseridos no arquivo de saida .tex
	 * @param e
	 */
	protected void commentBox_ItemStateChanged(ItemEvent e) {

		if (e.getStateChange() == ItemEvent.SELECTED) {
			aumento =  commentAtListBox.getHeight() + commentBeforeBox.getHeight() + commentAfterBox.getHeight() + 40;

			this.setSize(this.getWidth(), this.getHeight() + aumento );

			ok.setLocation(ok.getX(), ok.getY() + aumento);
			cancel.setLocation(cancel.getX(), cancel.getY() + aumento);

			add(commentAtListBox);
			add(commentBeforeBox);
			add(commentAfterBox);
			this.repaint();

			comentarios.add(commentAtListBox);
			comentarios.add(commentBeforeBox);
			comentarios.add(commentAfterBox);

		}
		else {
			comment = DocCommentsType.NENHUM;
			OriginalFrame();
		}
	}

	protected void commentOptionsBox_ItemStateChanged(ItemEvent e) {
		if (e.getStateChange() == ItemEvent.SELECTED) {
			if (e.getSource() == commentAtListBox) {
				comment = DocCommentsType.EM_LISTA;
			}
			else if (e.getSource() == commentBeforeBox) {
				comment = DocCommentsType.ANTES_DE_LINHA;
			}
			//CommentAfter
			else {
				comment = DocCommentsType.DEPOIS_DE_LINHA;
			}

		}

	}

	/**
	 * Metodo utilizado para deselecionar as opes de comentarios;
	 *
	 */
	private void OriginalFrame() {
		this.remove(commentAtListBox);
		this.remove(commentAfterBox);
		this.remove(commentBeforeBox);

		this.setSize(this.getWidth(), this.getHeight() - aumento );

		ok.setLocation(ok.getX(), ok.getY() - aumento);
		cancel.setLocation(cancel.getX(), cancel.getY() - aumento);

		comment = DocCommentsType.NENHUM;

		this.repaint();

	}

	/**
	 * Cancela a impressao. Nada � gerado.
	 * @param e
	 */
	protected void cancel_actionPerformed(ActionEvent e) {
		this.setVisible(false);
	}

	/**
	 * Metodo que gera o arquivo de saida .tex. Para isso, 
	 * verifica os itens selecionados. 
	 */
	protected void ok_actionPerformed(ActionEvent e) throws CRefineException {

		StringBuffer strText = new StringBuffer();
		int redosize = this.gerInterface.getSizeOfRedoHistorico();
		try {
			DocGeneratorUtils doc = new DocGeneratorUtils(strText, redosize, gerInterface, 
					originalSpec, des, proofOb, comment, code, formaExpandida);
			strText = doc.getTextFromProgram();
		}
		catch (Exception e2) {
			e2.printStackTrace();
			throw new GenerateDocException(e2.getMessage(),e2);
		}

		/*
		 * Salvando Arquivo	
		 */
		criandoArquivo(strText.toString());
		
		if (subdevelopments) 
		{
			for( Integer i :  this.gerInterface.getFilhos()) {
				this.gerInterface.selecionarDesenvolvimento(i);
				
				StringBuffer strText2 = new StringBuffer();
				int redosize2 = this.gerInterface.getSizeOfRedoHistorico();
				try {
					DocGeneratorUtils doc = new DocGeneratorUtils(strText2, redosize2, gerInterface, 
							originalSpec, des, proofOb, comment, code, formaExpandida);
					strText2 = doc.getTextFromProgram();
				}
				catch (Exception e2) {
					e2.printStackTrace();
					throw new GenerateDocException(e2.getMessage(),e2);
				}

				/*
				 * Salvando Arquivo	
				 */
				criandoArquivo(strText2.toString());
				
			}
			
		}
		setVisible(false);
	}









	/**
	 * Mtodo utilizado para criar o arquivo .tex 
	 * @param str O texto do arquivo.tex
	 * @throws GenerateDocException 
	 */
	private void criandoArquivo(String str) throws GenerateDocException {

		try {

			JFileChooser fileChooser = new JFileChooser();

			File currentDir = new File(".");
			fileChooser = new JFileChooser(currentDir);
			fileChooser.setMultiSelectionEnabled(false);
			fileChooser.setDialogType(JFileChooser.SAVE_DIALOG);
			fileChooser.setDialogTitle(this.gerInterface.getMessage("COD0542"));
			fileChooser.showSaveDialog(this);
			File file = fileChooser.getSelectedFile();
			if (file != null) {
				String fileName = file.getPath();
				CopiandoStyles(file.getParent());
				File output;
				if (fileName.endsWith(".tex")) {
					output = new File(fileName);
				}
				else{
					output = new File(fileName + ".tex");
				}
				FileOutputStream out = new FileOutputStream(output);
				byte [] data = str.getBytes();
				try {
					out.write(data);
					out.close();

					JOptionPane.showMessageDialog(null
							, this.retornarMensagem("COD0622"), "DocGenerator", JOptionPane.INFORMATION_MESSAGE);

				} catch (IOException except) {
					CRefineException e = new CRefineException(except, except.getMessage());
					e.setTitleCode("COD0609");
					throw e;
				}
			}

		}
		catch(Exception exception) {
			throw new GenerateDocException(exception.getMessage(),exception);
		}
	}

	/**
	 * Metodo que copia os arquivos .sty necessarios para o
	 * arquivo .tex .
	 * @param parentFile pasta em que devera ser inserido
	 */
	private void CopiandoStyles(String parentFile) {

		try {

			String path;
			String zstyString;
			String circusstyString;
			String cspstyString;
			String cztstyString;

			String osName = System.getProperty("os.name");
			if (osName.startsWith("Windows")) {
				path = "novoSty\\";
				//path = "sty\\";
				zstyString = "\\zed.sty";
				circusstyString = "\\circus.sty";
				cztstyString = "\\czt.sty";
				cspstyString = "\\csp.sty";
			}
			else{
				//path = "sty/";
				path = "novoSty/"; 
				zstyString = "/zed.sty";
				circusstyString = "/circus.sty";
				cztstyString = "/czt.sty";
				cspstyString = "/csp.sty";

			}	
			FileInputStream zedSty = new FileInputStream(path + "zed.sty");
			FileInputStream circusSty = new FileInputStream(path + "circus.sty");
			FileInputStream cztSty = new FileInputStream(path + "czt.sty");
			FileInputStream cspSty = new FileInputStream(path + "csp.sty");

			File saidaZed = new File(parentFile + zstyString);
			FileOutputStream toZed = new FileOutputStream(saidaZed);

			File saidaCircus = new File(parentFile + circusstyString);
			FileOutputStream toCircus = new FileOutputStream(saidaCircus);

			File saidaCzt = new File(parentFile + cztstyString);
			FileOutputStream toCzt= new FileOutputStream(saidaCzt);

			File saidaCsp = new File(parentFile + cspstyString);
			FileOutputStream toCsp = new FileOutputStream(saidaCsp);

			int readBytes;
			try {
				while ((readBytes = zedSty.read())!= -1) {
					toZed.write(readBytes);
				}
				readBytes = 0;
				while ((readBytes = circusSty.read())!= -1) {
					toCircus.write(readBytes);
				}
				readBytes = 0;
				while ((readBytes = cztSty.read())!= -1) {
					toCzt.write(readBytes);
				}
				readBytes = 0;
				while ((readBytes = cspSty.read())!= -1) {
					toCsp.write(readBytes);
				}

			} catch (IOException e) {
				e.printStackTrace();
			}

		} catch (FileNotFoundException e) {
			e.printStackTrace();
		}

	}

	/**
	 * Metodo de intercionalizacao, utilizando os idiomas portugues e ingles
	 * @param string
	 * @return
	 */
	private String retornarMensagem(String string) {
		return gerInterface.getMessage(string);
	}


}
