package circusRefine.gui;

/*
 * Projeto : Refine - Ferramenta Educacional para Refinamentos
 *
 * Tipo : FDesenvolvimento
 *
 */

import net.sourceforge.czt.circus.util.CircusString;
import circusRefine.Tactic.Principal.Tatica;
import circusRefine.core.ExternalManager;
import circusRefine.core.InsertAnswer;
import circusRefine.core.InsertCommentAnswer;
import circusRefine.core.NoPrograma;
import circusRefine.core.Relacionamento;
import circusRefine.core.RemoveCommentAnswer;
import circusRefine.core.idt.IdtCommentAnn;
import circusRefine.core.idt.IdtUtils;
import circusRefine.core.print.Printer;
import circusRefine.core.relations.RelationRowLaw;
import circusRefine.core.relations.RelationsUtils;
import circusRefine.core.storage.AdicaoComentario;
import circusRefine.core.storage.Coleta;
import circusRefine.core.storage.LawApplication;
import circusRefine.core.storage.RemocaoComentario;
import circusRefine.gui.stacks.TelaDesStacks;
import circusRefine.util.CommentsType;
import circusRefine.util.Identificador;
import circusRefine.util.NatToRoman;

import java.awt.BorderLayout;
import java.awt.SystemColor;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.Font;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Stack;

import javax.swing.JList;
import javax.swing.DefaultListModel;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JOptionPane;
import javax.swing.JTabbedPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

import com.sun.corba.se.impl.orbutil.DenseIntMapImpl;


import net.sourceforge.czt.base.ast.Term;
import net.sourceforge.czt.circus.ast.Transformation;
import net.sourceforge.czt.circuspatt.util.CircusLaw;

import java.lang.StringBuilder;


/**
 * TelaDesenvolvimento � um tipo que representa a tela de desenvolvimento da
 * ferramenta.
 * @author Alessandro
 * @author Manuela Xavier
 */
public class PanelDesenvolvimento extends JPanel {

	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;

	/* gerenciador de interface */
	private ExternalManager gerInterface;

	/* Indica a posicao de insercao do texto */
	private int textoPos = 0;


	/* Indica o identificador textual mostrado no desenvolvimento das especificacaoes */
	/* Valor que sera substituido por romano e que indica a proxima lei a ser aplicada*/
	private int identificador = 1;

	private static final String BRANCO = "     ";
	/* Guarda todo o texto de desenvolvimento da tela */
	private DefaultListModel textoDes = new DefaultListModel();
	/* String de Texto na Tela */
	private LinkedList<String> desenvolvimento = new LinkedList<String>();
	/* Espa�o dado devido a insercao do numero da linha na tela Desenvolvimento*/
	private int currentSpace = 2;

	/* COmponente List que guardara a Lista do texto de desenvolvimento da tela*/
	private JList List = new JList(textoDes);
	/* Vetor que guarda os indices selecionados */
	private BorderLayout borderLayout1 = new BorderLayout();
	/* Lista que faz a associa��o entre as linhas do desenvolvimento e as */
	/* linhas do arquivo de impress�o */
	/* Guarda o n�mero de linhas selecionadas pela �ltima vez*/

	/* Atributos que refereciam a ultima acao do programa*/

	/* Barra de Rolagem da tela de Desenvolvimento*/
	private JScrollPane roll;

	private JTabbedPane codePaneTraducao; //By Samuel Barrocas

	
	/* Pilhas que guardam onde foram aplicadas as leis e onde foram colocados os indetificadores
	 * Como precisaremos do termo em que foi aplicado a Lei, guardaremos tb a linha final
	 * de aplicacao do termo,  uma vez que esse campo sao necessario na busca para se encontrar
	 * os termos na mudanca Latex/Unicode  */
	/* Constante para identar o programa */
	private TelaDesStacks pilhas;

	/*
	 * Lista que guarda os comentarios;
	 */
	private ArrayList<Comentario> comments;

	private int idtComment;

	
	/**
	 * Construtor da classe TelaDesenvolvimento
	 *
	 * @param gerInterface       Gerenciador de todas as telas do sistema.
	 *
	 */
	public PanelDesenvolvimento (ExternalManager gerInterface, int id, int width, int height) {

		try  {
			this.gerInterface = gerInterface;
			pilhas =  new TelaDesStacks();

			/* inicializa a primeira posicao com o numero zero */
			Integer textoPos = new Integer(0);
			pilhas.getTextoPosAntigo().add(textoPos);
			comments = new ArrayList<Comentario>();

			desenvolvimento.clear();
			idtComment = 1;
			currentSpace =2;
			
			jbInit(width, height);

		} catch (Exception e) {

			e.printStackTrace();

		}
	}

	/**
	 * Metodo que retorna a lista de comentarios armazenados
	 * @return
	 */
	public ArrayList<Comentario> getComentarios () {
		return comments;
	}


	/**
	 * Inicializa os atributos da tela de desenvolvimento.
	 *
	 */
	private void jbInit(int width, int height) throws Exception {

		this.setLocation(0,0);
		this.setSize(width, height);
		this.setBackground(SystemColor.scrollbar);
		this.setLayout(borderLayout1);

		List.addListSelectionListener(new ListSelectionListener() {

			public void valueChanged(ListSelectionEvent event) {
				atualizar_Selecao();
			}

		});
		List.addKeyListener(new java.awt.event.KeyAdapter() {
			public void keyPressed(KeyEvent e) {
				textoDes_keyPressed(e);
			}
		});
		List.addMouseListener(new java.awt.event.MouseAdapter() {
			public void mouseReleased(MouseEvent e) {
			}
			public void mouseClicked(MouseEvent e) {
				textoDes_mouseClicked(e);
			}
		});



		List.setFont(new Font("CZT", Font.PLAIN, 12));

		roll = new JScrollPane(List);
		
		this.add(roll);

	}

	/**
	 * Metodo que realizar a habilitacao do botao aplicar, dependendo do termo 
	 * Selecionado 
	 * @param event
	 */
	public void atualizar_Selecao() {	

		NoPrograma noPrograma = this.retornarProgSelecionado(this.gerInterface.getSelectedDevelopment());
		
		Term termoSelecionado = null;
		if (noPrograma != null) {
			termoSelecionado = noPrograma.getPrograma();
		}
		if (termoSelecionado != null) {
			CircusLaw leiInBox = this.gerInterface.retornarLeiSelecionada();
			if (this.gerInterface.aplicableLaws(termoSelecionado).contains(leiInBox)){
				this.gerInterface.HabilitarAplicarLei();
			}
			else {
				this.gerInterface.DesabilitarAplicarLei();
			}
		}
		else {
			this.gerInterface.DesabilitarAplicarLei();
		}
	}

	
	/**
	 * M�todo que funciona como uma esp�cie de reset da tela de desenvolvimento.
	 * Respons�vel por inicializar a maioria dos atributos desta tela.
	 *
	 * @param gerInterface       Gerenciador de todas as telas do sistema.
	 */
	public void novaTela(ExternalManager gerInterface) {
		this.textoPos = 0;
		this.identificador = 1;
		this.idtComment = 1;
		this.pilhas = new TelaDesStacks();
		pilhas.getTextoPosAntigo().add(textoPos);
		this.textoDes.removeAllElements();
		this.gerInterface = gerInterface;
		desenvolvimento.clear();
		currentSpace = 2;
		this.comments.clear();
	}

	public int retornarIdentificador(){
		return this.identificador;
	}
	/**
	 * M�todo que retorna as linhas que est�o selecionadas na tela de
	 * desenvolvimento.
	 *
	 * @return       Um array de inteiros que possui os indices das linhas
	 *               selecionadas.
	 *
	 */
	public int[] retornarLinhaSelecionada() throws java.lang.ArrayIndexOutOfBoundsException {

		int[] result = new int[2];
		int[] linhas = List.getSelectedIndices();

		if(linhas.length > 0) {
			result[0] = linhas[0];
			result[1] = linhas[linhas.length - 1];
		}

		return result;
	}
	/**
	 * M�todo que retorna uma mensagem que ser� impressa na tela, tanto na forma
	 * de t�tulo quanto na forma de mensagem de erro.
	 *
	 * @param codigo     O c�digo da mensagem que ser� retornada.
	 *
	 * @return           Uma String que representa a mensagem de retorno.
	 *
	 */
	public String retornarMensagem(String codigo) {
		String mensagem = gerInterface.getMessage(codigo);
		return mensagem; 
	}

	public void showError(String title, String str, int tipo) {
		JOptionPane.showMessageDialog(null, str, title, tipo);
		gerInterface.setarStatus("");
		gerInterface.setarFocus();
	}

	/**
	 * Retorna o programa selecionado na tela de desenvolvimento
	 * identificada por idt
	 *
	 * @return       O programa selecionado na tela de desenvolvimento.
	 *
	 */
	public NoPrograma retornarProgSelecionado(int idt) /*throws ProgramaSelecionadoInvalidoException, java.lang.ArrayIndexOutOfBoundsException */{
		NoPrograma result = null;
		int linha[] = this.retornarLinhaSelecionada();

		if(linha.length > 0) {
			int linhaI = linha[0];
			int linhaF = linha[1];
			result = gerInterface.retornarProgramaSelecionado(idt,linhaI, linhaF);
		}
		return result;

	} 
	/**
	 * Metodo que retorna o conteudo textual da janela de desenvolvimento
	 * em forma de um array de String.
	 *
	 * @return       Array de Strings com todo o desenvolvimento da tela
	 *               de desenvolvimento.
	 *
	 */
	public Object[] retornarTextoDesenvolvimento() {
		Object[] textoDesenvolvimento = this.textoDes.toArray();
		return textoDesenvolvimento;
	}
	/**
	 * Retorna uma lista que representa o texto da tela de desenvolvimento.
	 *
	 * @return       Uma lista que representa o texto da tela de desenvolvimento.
	 *
	 */
	public JList retTextoDes(){
		return List;
	}

	public void specificationScreen(Term programa) {
		this.comments.clear();
		this.buildProgText(programa, "novo", -1,true);
	}

	public void collectedScreen(Term programa) {
		this.buildProgText(programa, "coletar", -1,true);
	}

	public void reappplyScreen(Term programa) {
		boolean insertRelations;
		if (gerInterface.isMundandoFormato()) {
			insertRelations = true;
		}
		else {
			insertRelations = false;
		}
		this.buildProgText(programa, "reaplicar", -1, insertRelations);
	}

	/**
	 * M�todo utilizado para inserir identificadores na janela 
	 * de Desenvolvimento, alterando a GUI
	 * @param isUndoing : Boolean auxiliar para determinar o comportamento 
	 * do metodo. Se o mesmo � chamo durante um desfazer ou nao. 
	 */
	public void updateLawIdentifierGUI(boolean isUndoing){
		int linha = -1;
		if (isUndoing){
			linha = this.gerInterface.getLinhaRedoLastLawApplication();
		}
		else{
			linha = this.gerInterface.getLinhaLastLawApplication();
		}
		int spaceAtual = this.getContSpace(desenvolvimento.size() - 1) + 2;
		/*
		 * Nesse caso todo o texto tera de ser recarregado, aplicando-se
		 * o novo espa�o. 
		 */

		int aux = spaceAtual - getContSpace(linha);
		String spc = " ";
		for (int j=0;j<aux;j++){
			spc+= " "; 
		}
		textoDes.remove(linha);
		textoDes.add(linha,linha + spc + BRANCO + desenvolvimento.get(linha));

	}

	/**
	 * Metodo que atualizar o identificador de comentario na 
	 * tela Desenvolvimento.
	 * @param linha : linha a ter um identificador inserido
	 * ou removido
	 */
	public void updateCommentIdentifierGUI(int linha){
		int spaceAtual = this.getContSpace(desenvolvimento.size() - 1) + 2;
		/*
		 * Nesse caso todo o texto tera de ser recarregado, aplicando-se
		 * o novo espa�o. 
		 */

		int aux = spaceAtual - getContSpace(linha);
		String spc = " ";
		for (int j=0;j<aux;j++){
			spc+= " "; 
		}
		textoDes.remove(linha);
		textoDes.add(linha,linha + spc + BRANCO + desenvolvimento.get(linha));
	}


	/**
	 * Atualiza a tela Desenvolvimento baseado no texto de refinamento
	 * armazenado.
	 */
	public void updateScreen () {
		/*
		 *Numa acao de aplicacao de lei, coleta, redoing 
		 */
		if (textoDes.size() < desenvolvimento.size()) {
			int spaceAtual = this.getContSpace(textoPos-1) + 2;
			/*
			 * Nesse caso todo o texto tera de ser recarregado, aplicando-se
			 * o novo espa�o. 
			 */
			if (currentSpace != spaceAtual){
				textoDes.clear();
				for (int i=0;i < desenvolvimento.size();i++){
					int aux = spaceAtual - getContSpace(i);
					String spc = " ";
					for (int j=0;j<aux;j++){
						spc+= " "; 
					}
					textoDes.addElement(i + spc + BRANCO + desenvolvimento.get(i));
				}
				currentSpace = spaceAtual;
			}
			/*
			 * Nesse caso nao h� necessidade do texto ser recarregado, h� apenas
			 * a insercao na nova parte do texto
			 */
			else{

				for (int i = textoDes.size(); i< desenvolvimento.size();i++){
					int aux = spaceAtual - getContSpace(i);
					String spc = " ";
					for (int j=0;j<aux;j++){
						spc+= " "; 
					}
					textoDes.addElement(i + spc + BRANCO + desenvolvimento.get(i));
				}
			}
		}
		/*
		 * Caso haja algum undoing com atualizacao de telaDesenvolvimento
		 */
		else{
			while (textoDes.size() > desenvolvimento.size()){
				textoDes.removeElementAt(textoDes.size()-1);
			}
		}
		/* Testando para caso de PO desenvolvimento Bloqueados*/
		if (this.gerInterface.isPODevelopmentProved()) {
			this.List.setEnabled(false);
		}
		else {
			this.List.setEnabled(true);
		}

	}

	/**
	 * M�todo que pega uma String obtida a partir de um programa e seta na
	 * tela no formato padr�o de c�lculo de programas, dependendo do par�metro
	 * modo(novo ou aplicar) ele seta o layout diferentemente.
	 *
	 * @param programa               Programa a ser colocado na tela.
	 * @param modo                   Modo do programa a ser colocado na tela
	 *                               (novo ou aplicado uma lei).
	 * @param toInsert				 Paramatro que define se devera
	 * 								 guardar ou nao relacionamento no visitor de impressao                             
	 *
	 * @return                       Quantidade de linhas de programa colocada no
	 *                               texto de desenvolvimento.
	 *
	 */
	public void buildProgText(Term programa, String modo, 
			int linhaInicial, boolean toInsert) {

		int tamTexto;

		if (gerInterface.isMundandoFormato()) {
			RelationsUtils.removeRelationsAnn(programa);
		}
		Printer printer = new Printer(this.gerInterface.getMark()
				,toInsert);
		
		String[] strProg = (String[])printer.visitTerm(programa);
		
		
		//System.out.println(printer.getPercurso().toString());
		java.util.List<Relacionamento> relacionamentos = 
			printer.getRelacionamentos();

		// setando a quantidade de linhas que o programa requer pra ser colocado 
		tamTexto = strProg.length;
		
		
		// se o modo for de um novo programa 
		if(modo.equals("aplicar")) {
			String id = NatToRoman.natToRom(this.identificador, 0);
			/* Ira retornar a linha a qual o programa foi selecionado
			 *  a linha a qual o identificador de aplica��o sera colocado */

			int linhaId = linhaInicial;

			String strId = (String)desenvolvimento.get(linhaId);
			desenvolvimento.remove(linhaId);
			String append = BRANCO + BRANCO + BRANCO + BRANCO + BRANCO + id;
			desenvolvimento.add(linhaId , strId + append);

			// Podera ser refinamento, simulacao ou equivalencia

			CircusLaw leiAplicada = this.gerInterface.retornarTopoLei().getLaw();
			String symbol = "";
			Transformation tipo = this.gerInterface.getType(leiAplicada);

			/*Tipos de LEI : Equivalencia, Simul�ao ou Refinamento*/
			if (tipo.equals(Transformation.Equivalence)) {
				symbol  = CircusString.EQUALS; 
			}
			else if (tipo.equals(Transformation.Refinement)){
				symbol =  "  " + CircusString.CIRCREFINES;
			}
			else {
				symbol = CircusString.CIRCSIMULATES;
			}
			symbol += BRANCO +  "\"" +leiAplicada.getName() + "\"";

			desenvolvimento.add(id + symbol);
			//Guarda o TextoPosAntigo para utilizar no Desfazer
			pilhas.getTextoPosAntigo().push(textoPos);

			//Seta linha de aplicacao de Lei
			this.gerInterface.retornarTopoLei().setLinha(textoPos);

			this.textoPos = this.textoPos + 1;
			this.identificador = this.identificador + 1;

			/* Atualizando anotations e relacionametnos de linha/termo
			 * no termo programa*/
			
			
			// Acho que é essa parte que colocar essa nova parte na AST
			this.gerInterface.atualizarRelationsAnn(programa, textoPos);
		}

		else if (modo.equals("reaplicar")) {

			String id = NatToRoman.natToRom(this.identificador, 0);

			//int linhaId = redoLinhaLeiPos.peek().getLinhaInicial();

			Term termo = this.gerInterface.getRedoTermosAplicados().peek();
			//Reinsere Identificador
			IdtUtils.InsertIdt(identificador, termo, Identificador.LEI);
			//Ja to reinserindo na pilha do desfazer
			this.gerInterface.getTermosAplicados().push(termo);
			int linhaId = RelationsUtils.retornarTopo(ExternalManager.getRealTerm(termo)).getLinhaInicial();

			CircusLaw leiAplicada = this.gerInterface.retornarRedoTopoLei().getLaw();
			this.gerInterface.retornarRedoTopoLei().setLinha(this.textoPos);
			String symbol = "";
			Transformation tipo = this.gerInterface.getType(leiAplicada);

			/*Tipos de LEI : Equivalencia, Simul�ao ou Refinamento*/
			if (tipo.equals(Transformation.Equivalence)) {
				symbol  = CircusString.EQUALS; 
			}
			else if (tipo.equals(Transformation.Refinement)){
				symbol = CircusString.CIRCREFINES;
			}
			else {
				symbol = CircusString.CIRCSIMULATES;
			}
			symbol += BRANCO +  "\"" +leiAplicada.getName() + "\"";

			String strId = (String)desenvolvimento.get(linhaId);
			desenvolvimento.remove(linhaId);
			String append = BRANCO + BRANCO + BRANCO + BRANCO + BRANCO + id;
			desenvolvimento.add(linhaId , strId + append);

			desenvolvimento.add(id + symbol);

			//Modificacao
			pilhas.getTextoPosAntigo().push(textoPos);
			//

			this.textoPos = this.textoPos + 1;
			this.identificador = this.identificador + 1;
			//Como o mesmo passa novamente pelo Printer, deve-se atualizar novamente os
			//relacionamentos.
			if (this.gerInterface.isMundandoFormato()){
				this.gerInterface.atualizarRelationsAnn(programa, textoPos);
			}
		}
		else if(modo.equals("coletar")) {
			desenvolvimento.add( this.retornarMensagem("COD0540") + " ");	
			//Modificao
			pilhas.getTextoPosAntigo().push(textoPos);
			//
			this.textoPos = this.textoPos + 1;
			/* Atualizando an	otations e relacionametnos de linha/termo
			 * no termo programa*/
			this.gerInterface.atualizarRelationsAnn(programa, textoPos);
			
		}

		int i;
		for(i=0; i<tamTexto-1; i++) {
			desenvolvimento.add(strProg[i]);
		}

		int newTextoPos = this.textoPos;
		//ou seja, se for carregamento de programa

		if (tamTexto > 0) {
			if(strProg[tamTexto-1].equals("")) {
				newTextoPos = newTextoPos + (tamTexto-1);
			}
			//se for carregamento de acao coletada ou lei.
			else {
				desenvolvimento.add( strProg[i]);
				newTextoPos = newTextoPos + tamTexto;
			}
		}
		
		 String[] textoTatica = new String[0];
		 this.gerInterface.setTextoDesTac(textoTatica);
		
		java.util.List<Relacionamento> newRels = this.atualizarRelacionamentos(relacionamentos);
		gerInterface.addRelacionamentos(newRels);
		this.textoPos = newTextoPos;

	} 

	/**
	 * Alguns termos contem comentarios e sao coletados. A relacao do comentario
	 * e atualizado junto do termo coletado. Deve-se entao atualizar a GUI. 
	 * Esse metodo realiza a atualizacao da GUI.
	 * @param termosComentados
	 */
	private void atualizarIdtComentarioTermoColetado(LinkedList<Term> termosComentados) {

		for (Term term : termosComentados){
			int i = IdtUtils.getId(term, Identificador.COMENTARIO).getIdt();
			for (Comentario com : comments){
				if (i == com.getIdentificador()){
					desfazComentarioIdt(com);
					this.gerInterface.retornarTelaDesenvolvimento().updateCommentIdentifierGUI(com.getLinha());
				}
			}
		}
	}

	private java.util.List<Relacionamento> atualizarRelacionamentos(java.util.List<Relacionamento> rels) {
		java.util.List<Relacionamento> result = new ArrayList();
		int adder = this.textoPos;

		for(Relacionamento rel : rels) {
			int newLinhaI = rel.getLinhaInicial() + adder;
			int newLinhaF = rel.getLinhaFinal() + adder;
			NoPrograma no = rel.getNoPrograma();
			Relacionamento newRel = new Relacionamento(newLinhaI, newLinhaF, no);
			result.add(newRel);
		}

		return result;
	}

	/**
	 * M�todo respons�vel pelo evento realizado ao se clicar o bot�o direito do
	 * mouse.
	 *
	 * @param e      O evento do mouse.
	 *
	 */
	public void textoDes_mouseClicked(MouseEvent e) {
		if(e.getModifiers() == MouseEvent.BUTTON3_MASK){
			this.mostrarPopMenu(e);
		} 
	}

	/**
	 * Metodo que mostra o PopMenu com diversas funcionalidades
	 *
	 */
	private void mostrarPopMenu(MouseEvent e) {
		PopMenuTelaDes popMenu = new PopMenuTelaDes(this.gerInterface);
		//JOptionPane.showMessageDialog (null, "mostrarPopMenu");
		popMenu.show(e.getComponent(),e.getX(),e.getY());

	}

	/**
	 * Retira a sele��o, se existir, da tela de desenvolvimento.
	 *
	 */
	public void tirarSelecao(){

		List.clearSelection();
	}

	void textoDes_keyPressed(KeyEvent e) {
		if(e.getKeyCode() == KeyEvent.VK_SHIFT){
			int[] indices = List.getSelectedIndices();
			int i;
			for(i = indices[0]; i<indices[indices.length-1]; i++){
				List.setSelectedIndex(i);
			}
		}
		else if(e.getKeyCode() == KeyEvent.VK_ESCAPE){
			this.tirarSelecao();
		}
	}

	/*
	 * Metodo utilizado para reconfigurar a tela de Desenvolvimento, desfazendo a a��o.[
	 * @param lastaction: Variavel que indica o que foi alterado no programa 
	 */
	public void desfazer( ) {

		//Retirando indentificador da  linha onde foi aplicada a lei 
		if (this.gerInterface.getLastAction() instanceof LawApplication) {

			this.identificador -= 1;
			int linhaId = RelationsUtils.retornarTopo(this.gerInterface.getTermosAplicados().peek()).getLinhaInicial();

			//Removendo Identificador;
			IdtUtils.removeIdt(this.gerInterface.getTermosAplicados().peek(), Identificador.LEI);

			this.gerInterface.getRedoTermosAplicados().push(this.gerInterface.getTermosAplicados().pop());
			String id = NatToRoman.natToRom(this.identificador,0);
			String strId = (String)desenvolvimento.get(linhaId);
			desenvolvimento.remove(linhaId);

			//retirando o identificador

			int tam = BRANCO.length()*5;//Tamanho ocupado pelos varios BRANCOS inseridos
			//na hora do por o identificador

			String append = new String();
			for (int k=0; k<strId.length() - tam - id.length(); k++ ) {
				append = append + strId.charAt(k);
			}
			desenvolvimento.add(linhaId , append );
		}
		/* Desfazendo Texto da Tela Desenvolvimento em caso de 
		 * desfetia de acao de aplicacao de lei ou Coleta de 
		 * codigo*/
		if (this.gerInterface.getLastAction() instanceof LawApplication ||
				this.gerInterface.getLastAction() instanceof Coleta) {

			Integer i = (Integer)pilhas.getTextoPosAntigo().get(pilhas.getTextoPosAntigo().size() -1);

			for (int k = i; k < textoPos; k++) {
				textoDes.remove(i);
			}   
//			atualizando o valor de TextoPos
			textoPos = pilhas.getTextoPosAntigo().pop();
		}
		else if (this.gerInterface.getLastAction() instanceof AdicaoComentario) {
			this.desfazerAdicaoComentario();
		}
		else if (this.gerInterface.getLastAction() instanceof RemocaoComentario) {
			this.desfazerRemocaoComentario();
		}

	}


	/**
	 * Metodo responsavel por desfazer a remocao de um Comentario
	 */
	public void desfazerRemocaoComentario() {

		Comentario aSerInserido = pilhas.lastRemovedComment();

		for (Comentario comment :  this.comments) {
			if (comment.getIdentificador() >= aSerInserido.getIdentificador()){
				comment.setIdentficador(comment.getIdentificador() + 1);
				refazComentarioIdt(comment);
			}
		}

		Term term = (this.gerInterface.retornarProgramaSelecionado
				(aSerInserido.getLinha(), aSerInserido.getLinhaFinal()).getPrograma());
		this.gerInterface.inserirIdtComent(term, idtComment);

		comments.add(aSerInserido);
		addIdtComment(aSerInserido);
		idtComment++;

		pilhas.addtoRedoRemovedComment(aSerInserido);
	}



	/**
	 * ReInsire o Idt do Comentario
	 * @param serInserido
	 */
	private void refazComentarioIdt(Comentario serInserido) {
		int row = serInserido.getLinha();

		String id = "(C" + (serInserido.getIdentificador() -1) + ")";
		String strId = (String)textoDes.get(row);
		textoDes.remove(row);

		//retirando o identificador

		int tam = BRANCO.length()*5;//Tamanho ocupado pelos varios BRANCOS inseridos
		//na hora do por o identificador

		String append = new String();
		for (int k=0; k<strId.length() - tam - id.length(); k++ ) {
			append = append + strId.charAt(k);
		}
		String id2 = "(C" + (serInserido.getIdentificador() ) + ")";
		append = append + BRANCO + BRANCO + BRANCO + BRANCO + BRANCO + id2;

		textoDes.add(row, append);

	}

	/**
	 * Metodo responsavel por desfazer uma acao de Inserir Comentario;
	 *
	 */
	public void desfazerAdicaoComentario() {

		Comentario aSerRemovido = this.pilhas.lastInsertedComment();
		this.removeComment(aSerRemovido);
		pilhas.addtoRedoInsertedComments(aSerRemovido);
	}

	public void teste () {
		StringBuilder strb = new StringBuilder();		

		Printer printer = new Printer(this.gerInterface.getMark(),
				false);

		java.util.List<Relacionamento> rels = this.gerInterface.getRelacionamentos();
		System.out.println("Chamando Relacionamentos!!!!!!!\n");

		for (Relacionamento rel : rels) {

			strb.append("class: " + rel.getNoPrograma().getPrograma().getClass() + "\n\n");
			strb.append("Linha Inicial  = " + rel.getLinhaInicial() + "\n\n");

			String[] strProg = (String[])printer.visitTerm(rel.getNoPrograma().getPrograma());
			strb.append(printer.getPercurso());
			for (int i = 0; i < strProg.length; i++)
				strb.append(strProg[i] + "\n\n");

			strb.append("Linha Final = " + rel.getLinhaFinal() + "\n\n");
		}

		System.out.println("RELACIONAMENTOS ");
		System.out.println(strb);

	}


	/**
	 * Metodo utilizado para definir o espa�o que sera dado para o alinhamento da tela
	 * @param aux contador
	 */
	public int getContSpace (Integer aux) {
		if (aux == 0) {
			aux = 1;
			int result = (int) Math.floor(Math.log10(aux));
			aux = 0;
			return result;
		}
		return (int) Math.floor(Math.log10(aux)) ;
	}

	public void setarIdentificador(int newValue) {
		this.identificador = newValue;
	}


	/**
	 * Metodo que retorna uma referencia para barra de rolagem
	 */
	public JScrollPane getRoll() {
		return roll;
	}

	/**
	 * Metodo que retorna as linhas onde ha a chamada explicita da lei.
	 * Linhas iniciadas com simbolo de refinamento ou equivalencia, seguido do
	 * nome da lei;
	 * @return
	 */
	public Stack<Integer> getTextoPosAntigo () {
		return pilhas.getTextoPosAntigo();
	}
	public int getSelectedRow () {
		return this.List.getSelectedIndex();
	}

	/**
	 * Utilizado no Unicode/Latex para efetuar o carregamento do programa 
	 * original em outro formato
	 * @param programa programa inicial
	 */
	public void setarTelaTextoDePrograma(Term programa) {
		textoPos = 0;
		this.textoDes.removeAllElements();
		this.desenvolvimento.clear();
		this.buildProgText(programa, "novo", -1, true);
	}

	/**
	 * Metodo que gera a selecao automatica das linhas que se encontram
	 * entre as duas linhas selecionadas.
	 */
	public void selecionarLinhas() {
		int linha[] = this.retornarLinhaSelecionada();
		if(linha.length > 1) {
			int linhaI = linha[0];
			int linhaF = linha[1];
			this.List.setSelectionInterval(linhaI, linhaF);
		}
	}

	/**
	 * Metodo que Insere um comentario
	 * 
	 * @param text
	 */
	public InsertCommentAnswer inserirComentario(String text, int linhaInicial, 
			int linhaFinal) {

		CommentsType tipo;

		/*
		 * Verificando se as linhas indicam um termo ou uma leiAplicada; 
		 */
		Term termC = null;
		RelationRowLaw leiC = null;
		/*
		 * Nesse caso eh um comentario de Termo.
		 */
		NoPrograma noProgramaSelected = this.gerInterface.
		retornarProgramaSelecionado(linhaInicial, linhaFinal);
		if (noProgramaSelected.getPrograma()!= null) {
			tipo = CommentsType.COMENTARIO_DE_TERMO;
			this.gerInterface.inserirIdtComent(noProgramaSelected.getPrograma(), idtComment);
			termC = noProgramaSelected.getPrograma();
		}
		else {
			tipo = CommentsType.COMENTARIO_DE_LEI;
			int i = linhaInicial;
			List<RelationRowLaw> lista = this.gerInterface.retornarPilhaDeLeis();
			for (RelationRowLaw lei : lista) {
				if (lei.getLinha() == i) {
					IdtCommentAnn idt = new IdtCommentAnn(idtComment,0);
					lei.setIdt(idt);
					leiC = lei;
				}
			}
		}
		/*
		 *Nesse caso, tem que ser um Comentario sobre lei, afinal 
		 *o JMenuItem seria desabilitado se nao pudesse inserir em
		 *nenhumas situacoes
		 */
		Comentario newComment = new Comentario(idtComment, text, termC, leiC);

		/* Adicionando a pilha para desfazer*/
		this.pilhas.addInsertedComment(newComment);
		
		/* Adicionando a lista de comentarios*/
		this.comments.add(newComment);

		this.addIdtComment(newComment);

		idtComment++;

		return new InsertCommentAnswer(linhaInicial, linhaFinal, text, newComment.getIdentificador());

	}

	/**
	 * Metodo que inseri o identificador de comentario 
	 * @param linhaID linha em que sera inserido o identificador
	 */
	public void addIdtComment(Comentario comentario) {
		int linhaId = comentario.getLinha();
		String id = "(C" + comentario.getIdentificador() + ")";
		String strId = (String)desenvolvimento.get(linhaId);
		desenvolvimento.remove(linhaId);
		String append = BRANCO + BRANCO + BRANCO + BRANCO + BRANCO + id;
		desenvolvimento.add(linhaId , strId + append);

	}


	/**
	 * Metodo que verifica a existencia de algum comentario com as respectivas
	 * linhas.
	 * @param linha linha inicial do comentario
	 * @param linhaF linha final do comentario
	 * @return true se ha comentario com estas linhas, false c.c.
	 */
	public boolean temComentario(int linha, int linhaF) {

		boolean result = false;
		for (Comentario com : comments) {
			if (com.getLinha() == linha && com.getLinhaFinal() == linhaF) {
				result = true;
			}
		}
		return result;
	}

	/**
	 * Metodo que retorna o Comentario referentes a linha, linhaF
	 * @param linha
	 * @param linhaF
	 * @return
	 */
	public Comentario getComentario(int linha, int linhaF) {

		for (Comentario com : comments) {
			if (com.getLinha() == linha && com.getLinhaFinal() == linhaF) {
				return com;
			}
		}
		return null;
	}

	/**
	 * Metodo que seta o novo texto editado de um comentario
	 * 
	 * @param text o novo conte�do do coment�rio
	 * @param linhaInicial a primeira linha selecionada na tela
	 * @param linhaFinal a �ltima linha selecionada na tela
	 */
	public Comentario editarComentario(String text, int linhaInicial, 
			int linhaFinal) {
		this.getComentario(linhaInicial, linhaFinal).setTexto(text);
		return this.getComentario(linhaInicial, linhaFinal);
	}


	/**
	 * Metodo auxiliar que remove Comentarios
	 * @param comment
	 */
	public void removeComment (Comentario comment) {
		int idt = comment.getIdentificador();
		//Remocao do comentario da Linha!
		desfazComentarioIdt (comment);
		comments.remove(comment);
		idtComment--;//Atualiza valor do prox comentario

		/* Removendo identificador de Termo*/
		Term term = (this.gerInterface.retornarProgramaSelecionado
				(comment.getLinha(),comment.getLinhaFinal())).getPrograma();
		this.gerInterface.removeIdtComment(term, comment);

		for (Comentario com : comments) {
			if (com.getIdentificador() > idt) {
				this.setIdtComment(com);
				com.setIdentficador(com.getIdentificador()-1);
				Term termCom = (this.gerInterface.retornarProgramaSelecionado
						(com.getLinha(),com.getLinhaFinal())).getPrograma();
				IdtUtils.decrIdt (termCom, Identificador.COMENTARIO);

			}
		}
	}


	/**
	 * Metodo que realiza a remocao do comentario, atualizando os outros 
	 * identificadores
	 */
	public RemoveCommentAnswer removerComentario(Comentario comment) {

		this.removeComment(comment);

		this.pilhas.addRemovedComment(comment);

		return new RemoveCommentAnswer(comment.getLinha(), 
				comment.getLinhaFinal(), comment.getIdentificador());
	}

	/**
	 * Metodo que realiza a remocao do identificador na linha
	 * @param comment
	 */
	private void desfazComentarioIdt(Comentario comment) {

		int row = comment.getLinha();
		String id = "(C" + comment.getIdentificador() + ")";
		String strId = (String)desenvolvimento.get(row);
		desenvolvimento.remove(row);

		//retirando o identificador

		int tam = BRANCO.length()*5;//Tamanho ocupado pelos varios BRANCOS inseridos
		//na hora do por o identificador

		String append = new String();
		for (int k=0; k<strId.length() - tam - id.length(); k++ ) {
			append = append + strId.charAt(k);
		}
		desenvolvimento.add(row, append);

	}

	private void setIdtComment(Comentario com) {

		int row = com.getLinha();

		String id = "(C" + com.getIdentificador() + ")";
		String strId = (String)textoDes.get(row);
		textoDes.remove(row);

		//retirando o identificador

		//na hora do por o identificador

		String append = new String();
		for (int k=0; k<strId.length() - id.length(); k++ ) {
			append = append + strId.charAt(k);
		}
		append = append + "(C" + (com.getIdentificador() -1) + ")";
		textoDes.add(row, append);

	}

	/**
	 * Metodo que me retorna uma Lista de termos que foram alvos de comentarios
	 * Utlizado na conversao Unicode/Lattex
	 * @return
	 */
	public List<Term> getCommentsTerms() {

		List<Term> termos = new ArrayList<Term>();

		for (Comentario com : comments) {
			if (com.getCommentType().equals(CommentsType.COMENTARIO_DE_TERMO)) {
				NoPrograma noprogs = this.gerInterface.retornarProgramaSelecionado(com.getLinha(), com.getLinhaFinal());
				if (noprogs.getPrograma() != null) {
					termos.add(noprogs.getPrograma());
				}
			}
		}

		return termos;
	}

	/**
	 * Metodo que retorna uma lista que contem as leis em que foram aplicados
	 * os comentarios
	 * @return
	 */
	public List<RelationRowLaw> getCommentsLaws() {
		List<RelationRowLaw> leis = new ArrayList<RelationRowLaw>();

		for (Comentario com : comments) {
			if (com.getCommentType().equals(CommentsType.COMENTARIO_DE_LEI)) {
				for (RelationRowLaw leiLinha : this.gerInterface.retornarPilhaDeLeis()){
					if (com.getLinha()== leiLinha.getLinha()){
						leis.add(leiLinha);
					}
				}
			}
		}

		return leis;
	}



	/**
	 * 
	 * @return Indice de Pois��o de texto
	 */
	public int getTextoPos() {
		return textoPos;
	}

	/**
	 * Retorna o Identificador do ultimo comentario inserido
	 * @return
	 */
	public int getIdtComment() {
		return idtComment;
	}

	public void setarTextoPos(int i) {
		textoPos = i;
	}
	public void setarComentarios(ArrayList<Comentario> comentariosList) {
		comments = comentariosList;
	}


	/**
	 * Seta o vetor de String como o texto da Tela Desenvolvimento.
	 * Utilizado quando algum arquivo � carregado.
	 * @param textoDes2
	 */
	public void setarTexto(String[] textoDes2) {
		textoDes.removeAllElements();
		for (int i=0; i < textoDes2.length;i++) {
			textoDes.addElement(textoDes2[i]);
		}
	}

	public int getIdt() {
		return identificador;
	}


	public void esvaziarRedoPilhas() {
		this.pilhas.esvaziarRedoPilhas();
	}

	public void esvaziarPilhas() {
		this.pilhas.esvaziarPilhas();
	}

	public void testeComments () {
		JOptionPane.showMessageDialog(null, pilhas.imprimirI());
	}

	/**
	 * Metodo de Redo que reinseri um comentario
	 *
	 */
	public void refazerAdicaoComentario() {

		Comentario comment = pilhas.redoInsertComment();

		Term term = (this.gerInterface.retornarProgramaSelecionado
				(comment.getLinha(), comment.getLinhaFinal())).getPrograma();
		this.gerInterface.inserirIdtComent(term, idtComment);

		/* Adicionando a pilha para desfazer*/
		this.pilhas.addInsertedComment(comment);

		/* Adicionando a lista de comentarios*/
		this.comments.add(comment);
		this.addIdtComment(comment);
		idtComment++;

	}

	/**
	 * Metodo de Redo que remove novamente um comentario
	 *
	 */
	public void refazerRemocaoComentario() {
		Comentario comment = pilhas.redoRemoveComment();

		this.removerComentario(comment);

		NoPrograma noProgramaSelected = gerInterface.
		retornarProgramaSelecionado(comment.getLinha()	,comment.getLinhaFinal());
		this.gerInterface.removeIdtComment(noProgramaSelected.getPrograma(), comment);
	}

	public Stack<Comentario> getRemovedComments() {
		return pilhas.getCommentsR();
	}

	public int getSizeofList() {
		return textoDes.getSize();
	}

	/**
	 * Desfazer uma aplicacao de Lei na TelaDesenvolvimento
	 */
	public void desfazerAplicLei() {
		//Retira o Identificador da linha em que ocorreu uma aplica��o de Lei.


		//Essa é a linha que foi selecionada 37
		int linhaId = RelationsUtils.retornarTopo(
				ExternalManager.getRealTerm(this.gerInterface.
						getTermosAplicados().peek())).getLinhaInicial();

		this.identificador -= 1;

		String id = NatToRoman.natToRom(this.identificador,0);
		String strId = (String)desenvolvimento.get(linhaId);
		desenvolvimento.remove(linhaId);

		//retirando o identificador

		int tam = BRANCO.length()*5;//Tamanho ocupado pelos varios BRANCOS inseridos
		//na hora do por o identificador

		String append = new String();
		for (int k=0; k<strId.length() - tam - id.length(); k++ ) {
			append = append + strId.charAt(k);
		}
		desenvolvimento.add(linhaId , append );

		this.retirarUltimasLinhas();
	}

	/**
	 * Desfazendo Texto da Tela Desenvolvimento em caso de 
	 * desfetia de acao de aplicacao de lei ou Coleta de 
	 * codigo
	 */
	public void retirarUltimasLinhas() {
		/* Desfazendo Texto da Tela Desenvolvimento em caso de 
		 * desfetia de acao de aplicacao de lei ou Coleta de 
		 * codigo*/

		Integer i = (Integer)pilhas.getTextoPosAntigo().get(pilhas.getTextoPosAntigo().size() -1);

		for (int k = i; k < textoPos; k++) {
			desenvolvimento.removeLast();
		}   
//		atualizando o valor de TextoPos
		textoPos = pilhas.getTextoPosAntigo().pop();
	}

	public boolean temTexto() {
		if (textoDes.size() >0) {
			return true;
		}
		return false;
	}

	public DefaultListModel getTextoDes() {
		return textoDes;
	}

	public void displayParagraph(InsertAnswer resposta) {
		int tamTexto;

		if (gerInterface.isMundandoFormato()) {
			RelationsUtils.removeRelationsAnn(resposta.getInsertedPara());
		}
		Printer printer = new Printer(this.gerInterface.getMark(),
				true);
		String[] strProg = (String[])printer.visitTerm(resposta.getInsertedPara());

		// setando a quantidade de linhas que o programa requer pra ser colocado 
		tamTexto = strProg.length;

		desenvolvimento.add(this.retornarMensagem("COD0627"));
		//Modificao
		pilhas.getTextoPosAntigo().push(textoPos);
		//
		this.textoPos = this.textoPos + 1;
		this.gerInterface.atualizarRelationsAnn(resposta.getInsertedPara(), textoPos);

		int i;
		for(i=0; i<tamTexto; i++) {
			desenvolvimento.add(strProg[i]);
		}
		textoPos = textoPos + tamTexto;
	}

	/**
	 * Este metodo retorna o texto Selecionado para que o mesmo seja Copiado.
	 * @return texto selecionado
	 */
	public ArrayList<String> getTextoSelecionado() {
		int [] linhas = 
			this.retornarLinhaSelecionada();

		ArrayList<String> result = new ArrayList<String>();
		for(int i= linhas[0]; i<= linhas[1];i++){
			result.add(desenvolvimento.get(i));
		}

		return result;
	}
	
	/**
	 * Seleciona a linha passada como par�metro do 
	 * Desenvolvimento utilizado
	 * @param toSelect linha a ser selecionada
	 */
	public void selecionarLinha(int toSelect) {
		List.setSelectedIndex(toSelect);
	}

	/**
	 * Ajusta o panel para exibir a linha selecioanda
	 * @param toSelect Linha selecionada
	 */
	public void normalizarSelecao(int toSelect) {
		/* Normalizacao*/
		JScrollBar bar  = this.getRoll().getVerticalScrollBar();
		int max = this.getSizeofList();
		int value = toSelect*((bar.getMaximum() - bar.getMinimum())/(max - 1 - 0));
		bar.setValue(value);
		
	}

	public void bloquearDesenvolvimento() {
		List.setEnabled(false);
	}

	public void liberarDesenvolvimento() {
		List.setEnabled(true);
	}
	
	/**
	 * Para a tática
	 * @param isUndoing
	 */
	public void updateLawIdentifierGUITactic(boolean isUndoing, int linha){
	
		int spaceAtual = this.getContSpace(desenvolvimento.size() - 1) + 2;
		/*
		 * Nesse caso todo o texto tera de ser recarregado, aplicando-se
		 * o novo espa�o. 
		 */

		int aux = spaceAtual - getContSpace(linha);
		String spc = " ";
		for (int j=0;j<aux;j++){
			spc+= " "; 
		}
		textoDes.remove(linha);
		textoDes.add(linha,linha + spc + BRANCO + desenvolvimento.get(linha));

	}
	
	/**
	 * M�todo que pega uma String obtida a partir de um programa e seta na
	 * tela no formato padr�o de c�lculo de programas, dependendo do par�metro
	 * modo(novo ou aplicar) ele seta o layout diferentemente.
	 *
	 * @param programa               Programa a ser colocado na tela.
	 * @param modo                   Modo do programa a ser colocado na tela
	 *                               (novo ou aplicado uma lei).
	 * @param toInsert				 Paramatro que define se devera
	 * 								 guardar ou nao relacionamento no visitor de impressao                             
	 *
	 * @return                       Quantidade de linhas de programa colocada no
	 *                               texto de desenvolvimento.
	 *
	 *VOU TER QUE PASSAR UM VETOR PARA IR COLOCANDO OS RESULTADOS DAS LEIS
	 *OU ENTÃO COLOCAR SÓ A RESPOSTA FINAL
	 */
	public void buildProgTextTatica(Term programa, String modo, 
			int linhaInicial, boolean toInsert, Tatica taticaSelecionada) {

		int tamTexto;

		if (gerInterface.isMundandoFormato()) {
			RelationsUtils.removeRelationsAnn(programa);
		}
		Printer printer = new Printer(this.gerInterface.getMark()
				,toInsert);
		
		//Aqui peguei a resposta da aplicação da lei no formato de String
		String[] strProg = (String[])printer.visitTerm(programa);
		if (strProg.equals("")){
			
		}
		
		//System.out.println(printer.getPercurso().toString());
		java.util.List<Relacionamento> relacionamentos = 
			printer.getRelacionamentos();

		// setando a quantidade de linhas que o programa requer pra ser colocado 
		tamTexto = strProg.length;
		
		
		// se o modo for de um novo programa 
		if(modo.equals("aplicar")) {
			String id = NatToRoman.natToRom(this.identificador, 0);
			/* Ira retornar a linha a qual o programa foi selecionado
			 *  a linha a qual o identificador de aplica��o sera colocado */

			int linhaId = linhaInicial;
            // A parte que coloca o (1) ....
			String strId = (String)desenvolvimento.get(linhaId);
			desenvolvimento.remove(linhaId);
			String append = BRANCO + BRANCO + BRANCO + BRANCO + BRANCO + id;
			desenvolvimento.add(linhaId , strId + append);
		
			//Nome da Tatica	
			String symbol = "";
			
			symbol += BRANCO +  "\" Tactic: " + taticaSelecionada.getId() + "\"";

			 desenvolvimento.add(id + symbol);
			 
			 String strId2 = (String)desenvolvimento.get(linhaId);
			
		/*	for (int i = 0; i < strProg.length; i++) {
				if (i==linhaId)
					strProg[i] = strId2;
				
			}*/
			
			//Guarda o TextoPosAntigo para utilizar no Desfazer
			pilhas.getTextoPosAntigo().push(textoPos);

			//Seta linha de aplicacao de Lei
			//A variável textoPos tem a linha final da tela de desenvolvimento
			this.gerInterface.retornarTopoTatica().setLinha(textoPos);

			this.textoPos = this.textoPos + 1;
			this.identificador = this.identificador + 1;

			/* Atualizando anotations e relacionametnos de linha/termo
			 * no termo programa*/
			this.gerInterface.atualizarRelationsAnn(programa, textoPos);
		}

		else if (modo.equals("reaplicar")) {

			String id = NatToRoman.natToRom(this.identificador, 0);

			//int linhaId = redoLinhaLeiPos.peek().getLinhaInicial();

			Term termo = this.gerInterface.getRedoTermosAplicados().peek();
			//Reinsere Identificador
			IdtUtils.InsertIdt(identificador, termo, Identificador.TATICA);
			//Ja to reinserindo na pilha do desfazer
			this.gerInterface.getTermosAplicados().push(termo);
			int linhaId = RelationsUtils.retornarTopo(ExternalManager.getRealTerm(termo)).getLinhaInicial();

			CircusLaw leiAplicada = this.gerInterface.retornarRedoTopoLei().getLaw();
			this.gerInterface.retornarRedoTopoLei().setLinha(this.textoPos);
			String symbol = "";
			Transformation tipo = this.gerInterface.getType(leiAplicada);

			/*Tipos de LEI : Equivalencia, Simul�ao ou Refinamento*/
			if (tipo.equals(Transformation.Equivalence)) {
				symbol  = CircusString.EQUALS; 
			}
			else if (tipo.equals(Transformation.Refinement)){
				symbol = CircusString.CIRCREFINES;
			}
			else {
				symbol = CircusString.CIRCSIMULATES;
			}
			symbol += BRANCO +  "\"" +leiAplicada.getName() + "\"";

			String strId = (String)desenvolvimento.get(linhaId);
			desenvolvimento.remove(linhaId);
			String append = BRANCO + BRANCO + BRANCO + BRANCO + BRANCO + id;
			desenvolvimento.add(linhaId , strId + append);

			desenvolvimento.add(id + symbol);

			//Modificacao
			pilhas.getTextoPosAntigo().push(textoPos);
			//

			this.textoPos = this.textoPos + 1;
			this.identificador = this.identificador + 1;
			//Como o mesmo passa novamente pelo Printer, deve-se atualizar novamente os
			//relacionamentos.
			if (this.gerInterface.isMundandoFormato()){
				this.gerInterface.atualizarRelationsAnn(programa, textoPos);
			}
		}
		else if(modo.equals("coletar")) {
			desenvolvimento.add( this.retornarMensagem("COD0540") + " ");	
			//Modificao
			pilhas.getTextoPosAntigo().push(textoPos);
			//
			this.textoPos = this.textoPos + 1;
			/* Atualizando an	otations e relacionametnos de linha/termo
			 * no termo programa*/
			this.gerInterface.atualizarRelationsAnn(programa, textoPos);
			
		}

		int i;
		for(i=0; i<tamTexto-1; i++) {
			desenvolvimento.add(strProg[i]);
		}

		int newTextoPos = this.textoPos;
		//ou seja, se for carregamento de programa

		if (tamTexto > 0) {
			if(strProg[tamTexto-1].equals("")) {
				newTextoPos = newTextoPos + (tamTexto-1);
			}
			//se for carregamento de acao coletada ou lei.
			else {
				desenvolvimento.add( strProg[i]);
				newTextoPos = newTextoPos + tamTexto;
			}
		}
		java.util.List<Relacionamento> newRels = this.atualizarRelacionamentos(relacionamentos);
		gerInterface.addRelacionamentos(newRels);
		this.textoPos = newTextoPos;
		
   
		 String[] textoTatica = new String[desenvolvimento.size()];
		 for (int j = 0; j < desenvolvimento.size(); j++) {
			 textoTatica[j] = desenvolvimento.get(j);
		}
		 this.gerInterface.setTextoDesTac(textoTatica);
		 //Term t = desText = (String[])printer.visitTerm(this.gerInterface.retornarProgAtual());
			
	} 
	

}