package circusRefine.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;

import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

import circusRefine.core.ExternalManager;
import circusRefine.util.CommentsMode;

/**
 * Janela que permite o usuario digitar o comentario! Bastante
 * Parecida com a Tela Parametro
 * @author Alessandro
 *
 */
public class CommentsFrame extends JDialog {

	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;

	private ExternalManager gerInterface;

	protected static String Space = " ";

	JPanel panel1 = new JPanel();
	JButton btnOK = new JButton();
	JButton btnCancel = new JButton();

	/*
	 * Me diz se a janela devera ser exibida para uma digitacao
	 * uma visualizacao ou uma edicao
	 */
	CommentsMode modo;

	/*
	 * Area de digitacao do Comentario
	 */
	JTextArea tfEspec = new JTextArea();
	JScrollPane rolagem;

	JLabel labelEntrada = new JLabel();
	JPanel panel2 = new JPanel();
	BorderLayout borderLayout1 = new BorderLayout();
	BorderLayout borderLayout2 = new BorderLayout();
	JPanel panel3 = new JPanel();
	GridLayout gridLayout1 = new GridLayout();
	JPanel panel4 = new JPanel();
	BorderLayout borderLayout3 = new BorderLayout();
	FlowLayout flowLayout1 = new FlowLayout();

	JPanel panel5 = new JPanel();
	JPanel panel6 = new JPanel();
	JPanel panel7 = new JPanel();
	JPanel panel8 = new JPanel();
	JPanel panel9 = new JPanel();

	private String textTarget = null;

	/**
	 * Construtor da classe TelaPredParametro.
	 *
	 * @param telaLeis           Um objeto da classe FLeis.
	 * @param gerInterface       Gerenciador de todas as telas do sistema.
	 *
	 */
	public CommentsFrame(ExternalManager gerInterface, CommentsMode mod) {
		super(gerInterface.retornarTelaPrincipal());
		modo = mod;

		try  {
			this.gerInterface = gerInterface;
			jbInit();
		}
		catch (Exception e) {
			e.printStackTrace();
		}


	}

	/**
	 * 
	 * @param gerInterface referencia ao gerenciador Externo
	 * @param txt Texto a ser exibido referente ao termo de um target
	 * de um subdesenvolvimento
	 */
	public CommentsFrame(ExternalManager gerInterface, String txt) {
		super(gerInterface.retornarTelaPrincipal());
		modo = CommentsMode.VISUALIZANDO;
		textTarget = txt;

		try  {
			this.gerInterface = gerInterface;
			jbInit();
		}
		catch (Exception e) {
			e.printStackTrace();
		}


	}



	/**
	 * Metodo que inicializar a gui
	 *
	 */
	private void jbInit() {

		this.setLocation(240,220);
		this.setSize(320, 160);
		this.setTitle(this.retornarMensagem("COD0276"));
		this.setModal( true );

		tfEspec.setFont(new Font ("CZT", Font.PLAIN, 12));
		tfEspec.setText("");


		rolagem = new JScrollPane(tfEspec);

		btnOK.setForeground(Color.green);
		btnOK.setFont(new Font("Dialog", 1, 12));
		btnOK.setText(this.retornarMensagem("COD0072"));
		btnOK.addActionListener(new java.awt.event.ActionListener() {
			public void actionPerformed(ActionEvent e) {
				btnOK_actionPerformed();
			}
		});

		btnCancel.setForeground(Color.red);
		btnCancel.setFont(new Font("Dialog", 1, 12));
		btnCancel.setText(this.retornarMensagem("COD0078"));
		btnCancel.addActionListener(new java.awt.event.ActionListener() {
			public void actionPerformed(ActionEvent e) {
				btnCancel_actionPerformed();
			}
		});

		labelEntrada.setText(" " + this.retornarMensagem("COD0275"));
		
		ConfigurarTfEspec();
		
		panel1.setLayout(borderLayout1);
		panel2.setLayout(borderLayout2);
		panel3.setLayout(gridLayout1);
		panel4.setLayout(borderLayout3);
		panel9.setLayout(flowLayout1);

		this.getContentPane().add(panel1, BorderLayout.CENTER);
		panel1.add(panel2, BorderLayout.CENTER);
		panel2.add(rolagem,  BorderLayout.CENTER);
		panel2.add(panel5, BorderLayout.WEST);
		panel2.add(panel6,  BorderLayout.SOUTH);
		panel2.add(panel7,  BorderLayout.EAST);
		panel2.add(panel8, BorderLayout.NORTH);
		panel1.add(panel3,  BorderLayout.SOUTH);
		panel3.add(btnOK, null);
		panel3.add(btnCancel, null);
		panel1.add(panel4, BorderLayout.NORTH);
		panel4.add(labelEntrada,  BorderLayout.CENTER);
		panel4.add(panel9,  BorderLayout.EAST);

	} 


	private void ConfigurarTfEspec() {
		if ( modo.equals(CommentsMode.VISUALIZANDO)) {
			labelEntrada.setText(" " + this.retornarMensagem("COD0285"));
			if (textTarget == null) {
				tfEspec.setEditable(false);
				int[] selectedIndices = this.gerInterface.retornarLinhasSelecionadas();
				Comentario comment = this.gerInterface
				.getComentario(selectedIndices[0],selectedIndices[1]);
				this.tfEspec.setText(comment.getTexto());
				this.tfEspec.setEditable(false);
			}
			else{
				this.setTitle(this.gerInterface.getMessage("COD0738").toUpperCase());
				this.tfEspec.setText(textTarget);
				this.labelEntrada.setText(this.gerInterface.getMessage("COD0738"));
				this.tfEspec.setEditable(false);
			}
		}
		else if ( modo.equals(CommentsMode.EDITANDO)) {
			tfEspec.setEditable(true);
			int[] selectedIndices = this.gerInterface.retornarLinhasSelecionadas();
			Comentario comment = this.gerInterface.retornarTelaDesenvolvimento()
			.getComentario(selectedIndices[0],selectedIndices[1]);
			this.tfEspec.setText(comment.getTexto());

		}
		else{
			tfEspec.setText("");
		}

	}

	/**
	 * Metodo chamado para cancelar o que foi digitado como Comentario
	 *
	 */
	private void btnCancel_actionPerformed() {
		this.setVisible(false);
	}

	/**
	 * Metodo que ir� inserir o comentario  na Lista Interna de Comentarios
	 */
	private void btnOK_actionPerformed() {

		if (modo.equals(CommentsMode.INSERINDO)) {
			String text = tfEspec.getText();
			this.gerInterface.insertComment(text);
		}
		else if (modo.equals(CommentsMode.EDITANDO)) {
			this.gerInterface.editComment(tfEspec.getText());
		}

		this.setVisible(false);
	}

	/**
	 * M�todo que retorna uma mensagem que ser� impressa na tela, tanto na forma
	 * de t�tulo quanto na forma de mensagem de erro.
	 *
	 * @param codigo     O c�digo da mensagem que ser� retornada.
	 *
	 * @return           Uma String que representa a mensagem de retorno.
	 *
	 */
	public String retornarMensagem(String codigo) {
		String mensagem = gerInterface.getMessage(codigo);
		return mensagem;
	}

	/**
	 * M�todo que seta o label da tela.
	 *
	 * @param label      String que representa o label que ser� exibido.
	 *
	 */
	public void setarLabel(String label){
		labelEntrada.setText(label);
	}

}
