package circusRefine.gui;

import net.sourceforge.czt.base.ast.Term;
import circusRefine.core.relations.RelationRowLaw;
import circusRefine.core.relations.RelationsUtils;
import circusRefine.util.CommentsType;

/**
 * Classe que guarda um comentario realizado pelo Usuario
 * 
 * @author Alessandro
 */
public class Comentario {
	
	/**
	 * Identifica se  o comentario C1, C2, etc...
	 */
	private int identificador;
	/**
	 * O texto propriamente dito do comentario
	 */
	private String texto;
	
	/**
	 * Tipo de comentario, podendo ser tanto um comentario de Lei, quanto de Termo
	 */
	private CommentsType tipo;
	
	/* Term que foi alvo de comentario*/
	private Term termoComentado;
	
	/* Aplicacao de Lei que foi alvo de Comentario*/
	private RelationRowLaw aplicLeiComentada;
	
	public Comentario (int idt, String text, Term term, RelationRowLaw lei) {
		
		identificador = idt;
		texto = text;
		if (term == null) {
			tipo = CommentsType.COMENTARIO_DE_LEI;
			aplicLeiComentada = lei;
		}
		else {
			tipo = CommentsType.COMENTARIO_DE_TERMO;
			termoComentado = term;
		}
		
	}
	
	public Comentario  () {
		identificador = 0;
		texto = "";
	}
	
	public int getLinha(){
		if (tipo.equals(CommentsType.COMENTARIO_DE_TERMO)){
			return RelationsUtils.retornarTopo(termoComentado).getLinhaInicial();
		}
		return aplicLeiComentada.getLinha();
	}
	public int getLinhaFinal(){
		if (tipo.equals(CommentsType.COMENTARIO_DE_TERMO)){
			return RelationsUtils.retornarTopo(termoComentado).getLinhaFinal();
		} 
		return aplicLeiComentada.getLinha();
	}
	public int getIdentificador () {
		return identificador;
	}
	public String getTexto(){
		return texto;
	}
	
	public  void setTexto(String text) {
		this.texto = text;
	}
	public  void  setIdentficador (int idt) {
		this.identificador = idt;
	}
	public CommentsType getCommentType () {
		return tipo;
	}
	public Term getTermoComentado () {
		return termoComentado;
	}
	
	public boolean hasAnotherRelation(Term term){
		boolean result = false;
		//if (RelationsUtils.retornaPilha(term))
		return result;
	}
	
	
	public RelationRowLaw getAplicLeiComentada(){
		return aplicLeiComentada;
	}
}
