package circusRefine.core.util;

import java.util.EmptyStackException;
import java.util.List;

import net.sourceforge.czt.base.ast.Term;
import net.sourceforge.czt.base.visitor.TermVisitor;
import circusRefine.core.relations.RelationsAnn;
import circusRefine.core.relations.RelationsAnnStack;
import circusRefine.core.relations.RelationsUtils;

/**
 * Classe  que encontra um termo a partir de seus diversos relacionamentos
 * @author Alessandro
 *
 */
public class SelectionTermByStackVisitor implements TermVisitor<Term> {

	/** Relacionamento a buscar na rvore */
	private RelationsAnn linhas;

	/**
	 * Construtor Padro. Passa um novo relacionamento padro (0, 0).
	 */
	public SelectionTermByStackVisitor() {
		this(new RelationsAnn());
	}

	/**
	 * Inicia um visitor com um relacionamento a pesquisar
	 * 
	 * @param rel as linhas inicial e final do Term a ser buscado
	 */
	public SelectionTermByStackVisitor(RelationsAnn rel) {
		this.setLinhas(rel);
	}

	public RelationsAnn getLinhas() {
		return linhas;
	}

	public void setLinhas(RelationsAnn linhas) {
		this.linhas = linhas;
	}

	private int getLinhaInicial() {
		return this.getLinhas().getLinhaInicial();
	}

	private int getLinhaFinal() {
		return this.getLinhas().getLinhaFinal();
	}

	/**
	 * Percorre a Arvore procurando o termo selecionado.
	 * 
	 * @param a AST a ser visitada
	 * @return o Term selecionado ou <code>null</code> se tal termo 
	 * 		no existe
	 */
	public Term visitTerm(Term termo) {
		RelationsAnnStack relTerm;

		try {
			relTerm = RelationsUtils.retornaPilha(termo);
		} catch (EmptyStackException e) {
			relTerm = null;
		}

		if (relTerm != null) { /* Tem relacionamento */

			/* Term se o Term visitado  o procurado */
			boolean isTheTerm = false;

			for (int i=0;i<relTerm.size();i++) {
				if (relTerm.get(i).getLinhaInicial() == this.getLinhaInicial() &&
						relTerm.get(i).getLinhaFinal() == this.getLinhaFinal()) {
					isTheTerm = true;
				}
			}
			if (isTheTerm) {

				return termo;
			} else {

				/* 
				 * Percorre os Filhos que podem conter o Term 
				 * pesquisado 
				 */
				ChildrenTermExtractor extrator = 
					new ChildrenTermExtractor();
				List<Term> filhos = termo.accept(extrator);

				for (Term filho : filhos) {
					Term result = filho.accept(this);
					if (result != null) {
						return result;
					}
				}

				/* 
				 * No achou o termo com aquelas linhas iniciais 
				 * e final 
				 */
				return null;


			}

		} else { /* No tem relacionamento */

			/* 
			 * Percorre os Filhos que podem conter o Term 
			 * pesquisado 
			 */
			ChildrenTermExtractor extrator = 
				new ChildrenTermExtractor();
			List<Term> filhos = termo.accept(extrator);

			for (Term filho : filhos) {
				Term result = filho.accept(this);
				if (result != null) {
					return result;
				}
			}

			/* 
			 * No achou o termo com as linhas inicial e final, 
			 * mas a busca continua
			 */
			return null;
		}

	}

}
