/*
 * Projeto: Circus Refine
 * 
 * Autores: Alessandro Gurgel <alessandro87@consiste.dimap.ufrn.br>
 * 			Cristiano Castro  <crisgc@consiste.dimap.ufrn.br>
 */
package circusRefine.core.util;

import java.util.ArrayList;

import net.sourceforge.czt.base.ast.Term;
import net.sourceforge.czt.base.visitor.TermVisitor;
import net.sourceforge.czt.base.visitor.VisitorUtils;
import net.sourceforge.czt.circuspatt.ast.CircusPatternFactory;
import net.sourceforge.czt.circuspatt.impl.CircusPatternFactoryImpl;
import net.sourceforge.czt.z.ast.Decl;
import net.sourceforge.czt.z.ast.DeclList;
import net.sourceforge.czt.z.ast.DecorExpr;
import net.sourceforge.czt.z.ast.InclDecl;
import net.sourceforge.czt.z.ast.RefExpr;
import net.sourceforge.czt.z.ast.SchExpr;
import net.sourceforge.czt.z.ast.SchText;
import net.sourceforge.czt.z.ast.ZDeclList;
import net.sourceforge.czt.z.ast.ZSchText;
import net.sourceforge.czt.z.visitor.DeclListVisitor;
import net.sourceforge.czt.z.visitor.DeclVisitor;
import net.sourceforge.czt.z.visitor.InclDeclVisitor;
import net.sourceforge.czt.z.visitor.SchExprVisitor;
import net.sourceforge.czt.z.visitor.SchTextVisitor;
import net.sourceforge.czt.z.visitor.ZDeclListVisitor;
import net.sourceforge.czt.z.visitor.ZSchTextVisitor;

/**
 * Classe para trocar a representao de \Delta e \Xi e dashed (') em 
 * um esquema para facilitar a troca de variveis por uma aplicao de
 * funo ou criao de {@link DecorExpr} no caso do dash
 * 
 * @author Cristiano Castro
 */
public class SchFunctionsRepresentationTransformer implements TermVisitor<Term>,
		SchExprVisitor<Term> {

	/**
	 * Percorre a rvore de representao do termo
	 * 
	 * @param o termo genrico a ser visitado
	 * @return o termo reescrito 
	 */
	public Term visitTerm(Term arg0) {
		
		/* No compartilha os filhos repetidos */
		return VisitorUtils.visitTerm(this, arg0, false);
	}

	/**
	 * Visita um esquema e para cada funo de esquema do tipo \Delta
	 * ou \Xi ou mesmo o dash (') aplicado a um nome, o mtodo troca 
	 * essa representao por uma aplicao de funo, no caso de 
	 * \Delta e \Xi ou por uma DecorExpr no caso do nome. Somente trata
	 * as declaraes includas (InclDecl).
	 * 
	 * @param arg0 o texto de esquema
	 */
	public Term visitSchExpr(SchExpr arg0) {
		if (arg0.getSchText() instanceof ZSchText) {
			
		} else {
			
		}
		return null;
	}
	
	/**
	 * Classe que percorre um esquema trocando as representaes de 
	 * \Delta e \Xi de um nome para uma aplicao de funoe o um 
	 * dashed de um nome para um DecorExpr
	 * 
	 * @author Cristiano Castro
	 */
	protected class InclDeclTransformer implements SchTextVisitor<Term>, 
	ZSchTextVisitor<Term>, DeclListVisitor<Term>, ZDeclListVisitor<Term>, 
	InclDeclVisitor<Term>, DeclVisitor<Term> {
		
		/** Fbrica de termos */
		CircusPatternFactory factory = new CircusPatternFactoryImpl();
		
		/**
		 * Implementa um visitor a um esquema genrico. Retorna o
		 * prprio esquema, pois no h nada a ser feito.
		 * 
		 * @param arg0 o esquema genrico a ser visitado
		 * @return uma referncia ao esquema passado como parmetro
		 */
		public SchText visitSchText(SchText arg0) {
			return arg0;
		}
		
		/**
		 * Visita um esquema tratvel, ele modifica a lista de 
		 * declaraes do esquema de acordo com as regras da definio 
		 * da classe
		 * 
		 * @param arg0 o esquema a ser visitado
		 * @return uma referncia as esquema com sua lista de 
		 * declaraes modificada
		 * @see InclDeclTransformer
		 */
		public ZSchText visitZSchText(ZSchText arg0) {
			DeclList listaDeclaracoes = 
				(DeclList) arg0.getDeclList().accept(this);
			arg0.setDeclList(listaDeclaracoes);
			return arg0;
		}

		/**
		 * Visita uma lista de declaraes genrica. Retorna a prpria 
		 * lista de declaraes.
		 * 
		 * @param arg0 a lista de declaraes a ser visitada
		 * @return uma referncia a lista de declaraes passada como
		 *  parmetro
		 */
		public DeclList visitDeclList(DeclList arg0) {
			return arg0;
		}
		
		/**
		 * Modifica os InclDecl da lista de declaraes de acordo a
		 * definio da classe
		 * 
		 * @param arg0 a lista de declaraes a ser modificada
		 * @return a prpria lista com as declaraes modificadas, caso
		 *  seja necessrio
		 */
		public ZDeclList visitZDeclList(ZDeclList arg0) {
			ArrayList<Decl> result = new ArrayList<Decl>(arg0.size());
			
			/* Monta a nova lista de declaraes */
			for (Decl decl : arg0) {
				result.add((Decl) decl.accept(this));
			}
			
			return this.factory.createZDeclList(result);
		}
		
		/**
		 * Quando se visita uma declarao genrica no h nada a ser
		 * feito.
		 * 
		 * @param arg0 a declarao genrica a ser visitada
		 * @return uma referncia a declarao passada como parmetro
		 */
		public Term visitDecl(Decl arg0) {
			return arg0;
		}

		/**
		 * 
		 */
		public InclDecl visitInclDecl(InclDecl arg0) {
			InclDecl result;
			if (arg0.getExpr() instanceof RefExpr) {
				
				/* Contm um nome */
			} else {
				
				/* No  um nome */
				result = arg0;
			}
			return null;
		}
		
	}

}
