/*
 * Projeto: Circus Refine
 * Autor: Cristiano Gurgel de Castro
 */
package circusRefine.core.util;

import net.sourceforge.czt.base.util.UnsupportedAstClassException;
import net.sourceforge.czt.circus.ast.ActionPara;
import net.sourceforge.czt.circus.ast.NameSetPara;
import net.sourceforge.czt.circus.visitor.ActionParaVisitor;
import net.sourceforge.czt.circus.visitor.NameSetParaVisitor;
import net.sourceforge.czt.circuspatt.ast.CircusPatternFactory;
import net.sourceforge.czt.circuspatt.impl.CircusPatternFactoryImpl;
import net.sourceforge.czt.z.ast.AxPara;
import net.sourceforge.czt.z.ast.ConstDecl;
import net.sourceforge.czt.z.ast.Name;
import net.sourceforge.czt.z.ast.Para;
import net.sourceforge.czt.z.ast.ZDeclList;
import net.sourceforge.czt.z.ast.ZName;
import net.sourceforge.czt.z.ast.ZParaList;
import net.sourceforge.czt.z.ast.ZSchText;
import net.sourceforge.czt.z.visitor.AxParaVisitor;

/**
 * Usado para retornar o nome de um pargrafo. til na aplicao da
 * lei Inserir Novo Pargrafo.
 * 
 * @author Cristiano Gurgel
 */
public class ParaNameGetter implements ActionParaVisitor<Name>, 
		AxParaVisitor<Name>, NameSetParaVisitor<Name> {
	
	/** Fbrica utilizada para criar os NameList */
	private static CircusPatternFactory factory = 
			new CircusPatternFactoryImpl();
	
	/**
	 * Mtodo utilitrio para retornar o nome de um pargrafo
	 * 
	 * @param paragrafo o pargrafo a ser a ser visitado
	 * @return o nome do pargrafo visitado
	 * @throws UnsupportedAstClassException se o pargrafo no for um
	 *  pargrafo de processo
	 * @throws ClassCastException se o nome do pargrafo no for um
	 *  {@link ZName}
	 */
	public static <E extends Para> ZName getNameList(E paragrafo) {
		return (ZName)paragrafo.accept(new ParaNameGetter());
	}
	
	/**
	 * Busca um pargrafo em uma lista pelo seu nome
	 * 
	 * @param nome o nome do pargrafo a ser procurado
	 * @param listaParagrafos a lista de pargrafos onde ser efetuada
	 *  a busca
	 * @return o pargrafo cujo nome seja igual ao pesquisado ou 
	 *  <code>null</code> caso esse no seja encontrado
	 */
	public static Para getParaFromName(ZName nome, ZParaList listaParagrafos) {
		for (Para paragrafo : listaParagrafos) {
			ZName nomePara = ParaNameGetter.getNameList(paragrafo);
					
			/* Encontrou */
			if (nome.equals(nomePara)) {
				return paragrafo;
			}
		}
		
		/* No encontrou nenhum */
		return null;
	}
	
	public static CircusPatternFactory getFactory() {
		return factory;
	}
	
	public static void setFactory(CircusPatternFactory factory) {
		ParaNameGetter.factory = factory;
	}
	
	/**
	 * Visita um pargrafo de ao.
	 * 
	 * @param arg0 o pargrafo de ao a ser visitado
	 * @return o nome da ao
	 */
	public Name visitActionPara(ActionPara arg0) {
		return arg0.getName();
	}
	
	/**
	 * Visita um pargrafo que contm uma definio de esquema.
	 * 
	 * @param arg0 o pargrafo de definio axiomtica
	 * @return o nome do esquema
	 */
	public Name visitAxPara(AxPara arg0) {
		ZSchText text = arg0.getZSchText();
		ZDeclList lista = text.getZDeclList();
		ConstDecl decl = (ConstDecl)lista.get(0);
		return decl.getName();
	}
	
	/**
	 * Visita um pargrafo de conjunto de nomes que pode ser definido
	 * no processo.
	 * 
	 * @param arg0 o pargrafo de nomes do processo
	 * @return o nome do pargrafo
	 */
	public Name visitNameSetPara(NameSetPara arg0) {
		return arg0.getName();
	}
	
}
