/*
 * Projeto: Circus Refine
 */
package circusRefine.core.util;

import net.sourceforge.czt.base.ast.Term;
import net.sourceforge.czt.base.util.UnsupportedAstClassException;
import net.sourceforge.czt.circuspatt.ast.JokerAction;
import net.sourceforge.czt.circuspatt.ast.JokerChannelSet;
import net.sourceforge.czt.circuspatt.ast.JokerCommunication;
import net.sourceforge.czt.circuspatt.ast.JokerNameSet;
import net.sourceforge.czt.circuspatt.ast.JokerPara;
import net.sourceforge.czt.circuspatt.ast.JokerParaList;
import net.sourceforge.czt.circuspatt.ast.JokerProcess;
import net.sourceforge.czt.circuspatt.visitor.JokerActionVisitor;
import net.sourceforge.czt.circuspatt.visitor.JokerChannelSetVisitor;
import net.sourceforge.czt.circuspatt.visitor.JokerCommunicationVisitor;
import net.sourceforge.czt.circuspatt.visitor.JokerNameSetVisitor;
import net.sourceforge.czt.circuspatt.visitor.JokerParaListVisitor;
import net.sourceforge.czt.circuspatt.visitor.JokerParaVisitor;
import net.sourceforge.czt.circuspatt.visitor.JokerProcessVisitor;
import net.sourceforge.czt.zpatt.ast.JokerDeclList;
import net.sourceforge.czt.zpatt.ast.JokerExpr;
import net.sourceforge.czt.zpatt.ast.JokerExprList;
import net.sourceforge.czt.zpatt.ast.JokerName;
import net.sourceforge.czt.zpatt.ast.JokerNameList;
import net.sourceforge.czt.zpatt.ast.JokerPred;
import net.sourceforge.czt.zpatt.ast.JokerRenameList;
import net.sourceforge.czt.zpatt.ast.JokerStroke;
import net.sourceforge.czt.zpatt.visitor.JokerDeclListVisitor;
import net.sourceforge.czt.zpatt.visitor.JokerExprListVisitor;
import net.sourceforge.czt.zpatt.visitor.JokerExprVisitor;
import net.sourceforge.czt.zpatt.visitor.JokerNameListVisitor;
import net.sourceforge.czt.zpatt.visitor.JokerNameVisitor;
import net.sourceforge.czt.zpatt.visitor.JokerPredVisitor;
import net.sourceforge.czt.zpatt.visitor.JokerRenameListVisitor;
import net.sourceforge.czt.zpatt.visitor.JokerStrokeVisitor;

/**
 * Classe til para extrair os nomes de Jokers
 * 
 * @author Cristiano Gurgel
 */
public class JokerNameGetterVisitor implements JokerActionVisitor<String>,
	JokerChannelSetVisitor<String>, JokerCommunicationVisitor<String>,
	JokerDeclListVisitor<String>, JokerExprVisitor<String>, 
	JokerExprListVisitor<String>, JokerNameVisitor<String>, 
	JokerNameListVisitor<String>, JokerNameSetVisitor<String>,
	JokerParaVisitor<String>, JokerParaListVisitor<String>,
	JokerPredVisitor<String>, JokerProcessVisitor<String>, 
	JokerRenameListVisitor<String>, JokerStrokeVisitor<String> {

	/**
	 * Mtodo utilitrio para capturar o nome de um joker 
	 * 
	 * @param joker o joker a ser visitado
	 * @return o nome do Joker
	 * @throws UnsupportedAstClassException caso o termo visitado no
	 *  seja um joker
	 */
	public static String getName(Term joker) 
		throws UnsupportedAstClassException {
		JokerNameGetterVisitor visitor = new JokerNameGetterVisitor();
		return joker.accept(visitor);
	}
	
	/**
	 * Retorna o nome de um JokerAction
	 * 
	 * @param arg0 o jokerAction
	 * @return o nome do joker
	 */
	public String visitJokerAction(JokerAction arg0) {
		return arg0.getName();
	}
	
	/**
	 * Retorna o nome de um {@link JokerChannelSet}
	 * 
	 * @param arg0 o Joker a ser visitado
	 * @return o nome do joker
	 */
	public String visitJokerChannelSet(JokerChannelSet arg0) {
		return arg0.getName();
	}
	
	/**
	 * Retorna o nome de um {@link JokerCommunication}
	 * 
	 * @param arg0 o Joker a ser visitado
	 * @return o nome do joker
	 */
	public String visitJokerCommunication(JokerCommunication arg0) {
		return arg0.getName();
	}
	
	/**
	 * Retorna o nome de um {@link JokerProcess}
	 * 
	 * @param arg0 o Joker a ser visitado
	 * @return o nome do joker
	 */
	public String visitJokerProcess(JokerProcess arg0) {
		return arg0.getName();
	}
	
	/**
	 * Retorna o nome de um {@link JokerDeclList}
	 * 
	 * @param arg0 o {@link JokerDeclList} a ser visitado
	 * @return o nome do joker
	 */
	public String visitJokerDeclList(JokerDeclList arg0) {
		return arg0.getName();
	}

	/**
	 * Retorna o nome de um {@link JokerExpr}
	 * 
	 * @param arg0 o {@link JokerExpr} a ser visitado
	 * @return o nome do joker
	 */
	public String visitJokerExpr(JokerExpr arg0) {
		return arg0.getName();
	}
	
	/**
	 * Retorna o nome de um {@link JokerExprList}
	 * 
	 * @param arg0 o {@link JokerExprList} a ser visitado
	 * @return o nome do joker
	 */
	public String visitJokerExprList(JokerExprList arg0) {
		return arg0.getName();
	}
	
	/**
	 * Retorna o nome de um {@link JokerName}
	 * 
	 * @param arg0 o {@link JokerName} a ser visitado
	 * @return o nome do joker
	 */
	public String visitJokerName(JokerName arg0) {
		return arg0.getName();
	}
	
	/**
	 * Retorna o nome de um {@link JokerNameSet}
	 * 
	 * @param arg0 o {@link JokerNameSet} a ser visitado
	 * @return o nome do joker
	 */
	public String visitJokerNameSet(JokerNameSet arg0) {
		return arg0.getName();
	}
	
	/**
	 * Retorna o nome de um {@link JokerNameSet}
	 * 
	 * @param arg0 o {@link JokerNameSet} a ser visitado
	 * @return o nome do joker
	 */
	public String visitJokerPred(JokerPred arg0) {
		return arg0.getName();
	}
	
	/**
	 * Retorna o nome de um {@link JokerNameList}
	 * 
	 * @param arg0 o {@link JokerNameList} a ser visitado
	 * @return o nome do joker
	 */
	public String visitJokerNameList(JokerNameList arg0) {
		return arg0.getName();
	}

	/**
	 * Retorna o nome de um {@link JokerRenameList}
	 * 
	 * @param arg0 o {@link JokerRenameList} a ser visitado
	 * @return o nome do joker
	 */
	public String visitJokerRenameList(JokerRenameList arg0) {
		return arg0.getName();
	}

	/**
	 * Retorna o nome de um {@link JokerStroke}
	 * 
	 * @param arg0 o {@link JokerStroke} a ser visitado
	 * @return o nome do joker
	 */
	public String visitJokerStroke(JokerStroke arg0) {
		return arg0.getName();
	}
	
	/**
	 * Retorna o nome de um {@link JokerPara}
	 * 
	 * @param arg0 o {@link JokerPara} a ser visitado
	 * @return o nome do joker
	 */
	public String visitJokerPara(JokerPara arg0) {
		return arg0.getName();
	}
	
	/**
	 * Retorna o nome de um {@link JokerParaList}
	 * 
	 * @param arg0 o {@link JokerParaList} a ser visitado
	 * @return o nome do joker
	 */
	public String visitJokerParaList(JokerParaList arg0) {
		return arg0.getName();
	}
	
}
