/*
 * Projeto: Circus Refine
 */
package circusRefine.core.util;

import java.util.Arrays;
import java.util.List;

import net.sourceforge.czt.base.ast.Term;
import net.sourceforge.czt.session.Markup;
import circusRefine.core.print.Printer;

/**
 * Classe usada para comparar duas ASTs. Ela retorna true se e 
 * somente se as estruturas de ambas as AST so iguais e se a 
 * comparao entre os filhos que implementam {@link Comparable} 
 * retorna o valor <code>0</code>.
 * 
 *  @author Cristiano Gurgel
 */
public class ComparatorVisitor {

	/**
	 * Compara dois programas baseados em suas strings
	 * 
	 * @param ast1 o programa 1
	 * @param ast2 o programa 2
	 * @return <code>true</code> caso os programas retornem a mesma 
	 *  impresso, ou <code>false</code> caso contrrio
	 */
	public static boolean compareStrings(Term ast1, Term ast2) {
		
		/* */
		String[] strAST1 = Printer.print(ast1, Markup.LATEX,false);
		String[] strAST2 = Printer.print(ast2, Markup.LATEX,false);

		List<String> lista1 = Arrays.asList(strAST1);
		List<String> lista2 = Arrays.asList(strAST2);
		
		return lista1.equals(lista2);
	}
	
}
