package circusRefine.core.util;

import circusRefine.util.CodNameParam;
import circusRefine.util.CodigoParametro;
import net.sourceforge.czt.base.ast.Term;
import net.sourceforge.czt.circuspatt.ast.JokerAction;
import net.sourceforge.czt.circuspatt.ast.JokerChannelSet;
import net.sourceforge.czt.circuspatt.ast.JokerCommunication;
import net.sourceforge.czt.circuspatt.ast.JokerNameSet;
import net.sourceforge.czt.circuspatt.ast.JokerPara;
import net.sourceforge.czt.circuspatt.ast.JokerParaList;
import net.sourceforge.czt.circuspatt.ast.JokerProcess;
import net.sourceforge.czt.circuspatt.visitor.JokerActionVisitor;
import net.sourceforge.czt.circuspatt.visitor.JokerChannelSetVisitor;
import net.sourceforge.czt.circuspatt.visitor.JokerCommunicationVisitor;
import net.sourceforge.czt.circuspatt.visitor.JokerNameSetVisitor;
import net.sourceforge.czt.circuspatt.visitor.JokerParaListVisitor;
import net.sourceforge.czt.circuspatt.visitor.JokerParaVisitor;
import net.sourceforge.czt.circuspatt.visitor.JokerProcessVisitor;
import net.sourceforge.czt.zpatt.ast.JokerDeclList;
import net.sourceforge.czt.zpatt.ast.JokerExpr;
import net.sourceforge.czt.zpatt.ast.JokerExprList;
import net.sourceforge.czt.zpatt.ast.JokerName;
import net.sourceforge.czt.zpatt.ast.JokerNameList;
import net.sourceforge.czt.zpatt.ast.JokerPred;
import net.sourceforge.czt.zpatt.ast.JokerRenameList;
import net.sourceforge.czt.zpatt.ast.JokerStroke;
import net.sourceforge.czt.zpatt.visitor.JokerDeclListVisitor;
import net.sourceforge.czt.zpatt.visitor.JokerExprListVisitor;
import net.sourceforge.czt.zpatt.visitor.JokerExprVisitor;
import net.sourceforge.czt.zpatt.visitor.JokerNameListVisitor;
import net.sourceforge.czt.zpatt.visitor.JokerNameVisitor;
import net.sourceforge.czt.zpatt.visitor.JokerPredVisitor;
import net.sourceforge.czt.zpatt.visitor.JokerRenameListVisitor;
import net.sourceforge.czt.zpatt.visitor.JokerStrokeVisitor;

/**
 * Classe que pega um termo um codigo que representa qual o tipo desse termo e 
 * consequentemente como devera ser a exibio da Tela Parametro
 * @author Alessandro
 *
 */
public class CodParamVisitor implements
	JokerActionVisitor<CodNameParam>,
	JokerPredVisitor<CodNameParam>,
	JokerChannelSetVisitor<CodNameParam>,
	JokerCommunicationVisitor<CodNameParam>,
	JokerDeclListVisitor<CodNameParam>,
	JokerExprVisitor<CodNameParam>,
	JokerExprListVisitor<CodNameParam>,
	JokerStrokeVisitor<CodNameParam>,
	JokerRenameListVisitor<CodNameParam>,
	JokerNameSetVisitor<CodNameParam>,
	JokerNameListVisitor<CodNameParam>,
	JokerNameVisitor<CodNameParam>,
	JokerProcessVisitor<CodNameParam>,
	JokerParaVisitor<CodNameParam>,
	JokerParaListVisitor<CodNameParam>
	

{

	/**
	 * Retorna o cdigo que identifica o tipo de joker.
	 * 
	 * @param joker o joker a ser analisado
	 * @return o tipo do joker
	 */
	public static CodNameParam getCode(Term joker) {
		CodParamVisitor visitor = new CodParamVisitor();
		return joker.accept(visitor);
	}
	
	public CodNameParam visitJokerAction(JokerAction term) {
		CodNameParam cod = new CodNameParam(CodigoParametro.ACTION, term.getName());
		return cod;
	}

	public CodNameParam visitJokerPred(JokerPred term) {
		CodNameParam cod = new CodNameParam(CodigoParametro.PREDICATE, term.getName());
		return cod;
	}

	public CodNameParam visitJokerChannelSet(JokerChannelSet term) {
		CodNameParam cod = new CodNameParam(CodigoParametro.CHANSET, term.getName());
		return cod;
	}

	public CodNameParam visitJokerCommunication(JokerCommunication term) {
		CodNameParam cod = new CodNameParam(CodigoParametro.COMMUN, term.getName());
		return cod;
	}

	public CodNameParam visitJokerDeclList(JokerDeclList term) {
		CodNameParam cod = new CodNameParam(CodigoParametro.DECLLIST, term.getName());
		return cod;
	}

	public CodNameParam visitJokerExpr(JokerExpr term) {
		CodNameParam cod = new CodNameParam(CodigoParametro.EXPRESSION, term.getName());
		return cod;
	}

	public CodNameParam visitJokerExprList(JokerExprList term) {
		CodNameParam cod = new CodNameParam(CodigoParametro.EXPRLIST, term.getName());
		return cod;
	}

	public CodNameParam visitJokerStroke(JokerStroke term) {
		CodNameParam cod = new CodNameParam(CodigoParametro.STROKE, term.getName());
		return cod;
	}

	public CodNameParam visitJokerRenameList(JokerRenameList term) {
		CodNameParam cod = new CodNameParam(CodigoParametro.RENAMELIST, term.getName());
		return cod;
	}

	public CodNameParam visitJokerNameSet(JokerNameSet term) {
		CodNameParam cod = new CodNameParam(CodigoParametro.NAMESET, term.getName());
		return cod;
	}

	public CodNameParam visitJokerNameList(JokerNameList term) {
		CodNameParam cod = new CodNameParam(CodigoParametro.NAMELIST, term.getName());
		return cod;
	}

	public CodNameParam visitJokerName(JokerName term) {
		CodNameParam cod = new CodNameParam(CodigoParametro.NAME, term.getName());
		return cod;
	}

	public CodNameParam visitJokerProcess(JokerProcess term) {
		CodNameParam cod = new CodNameParam(CodigoParametro.PROCESS, term.getName());
		return cod;
	}

	public CodNameParam visitJokerParaList(JokerParaList term) {
		CodNameParam cod = new CodNameParam(CodigoParametro.PARALIST, term.getName());
		return cod;
	}

	public CodNameParam visitJokerPara(JokerPara term) {
		CodNameParam cod = new CodNameParam(CodigoParametro.PARA, term.getName());
		return cod;
	}

}
