/*
 * Projeto: Circus Refine
 */
package circusRefine.core.util;

import java.util.ArrayList;
import java.util.List;

import circusRefine.util.Internacional;

import net.sourceforge.czt.base.ast.Term;
import net.sourceforge.czt.base.visitor.TermVisitor;

/**
 * Visitor utilizado para extrair os termos de filhos de um 
 * {@link Term}
 * 
 * @author Cristiano Gurgel
 */
public class ChildrenTermExtractor implements TermVisitor<List<Term>> {

	/**
	 * Metodo til para retornar somente os filhos de uma termo que 
	 * sao instancia de {@link Term}
	 * 
	 * @param arg0 o termo a ser visitado
	 * @return a lista com os filhos instancia de Term
	 */
	public static List<Term> extrairFilhos(Term termo) {
		List<Term> result;
		if (termo == null) {
			result = new ArrayList<Term>();
		} else {
			ChildrenTermExtractor extrator = new ChildrenTermExtractor();
			result = termo.accept(extrator);
		}
		return result;
	}
	
	public ChildrenTermExtractor() { }
	
	/**
	 * Metodo util para retornar somente os filhos de uma termo que 
	 * sao instancia de {@link Term}
	 * 
	 * @param arg0 o termo a ser visitado
	 * @return a lista com os filhos instancia de Term
	 */
	public List<Term> visitTerm(Term arg0) {
		List<Term> result = new ArrayList<Term>();
		
		for (Object obj : arg0.getChildren()) {
			if (obj instanceof Term) {
				result.add((Term)obj);
			}
		}
		
		return result;
	}
	
}
