/*
 * Projeto: Circus Refine
 */
package circusRefine.core.storage;

import java.io.Serializable;

import circusRefine.core.ExternalManager;
import circusRefine.core.crules.CRulesException;
import circusRefine.util.CRefineException;

/**
 * Interface que define os passos de execuo 
 * 
 * @author Cristiano Castro
 */
public interface StepOfExecution extends Serializable {

	/**
	 * Efetua o passo de execuo.
	 * 
	 * @param externo o gerenciador externo do CRefine
	 * @throws CRulesException 
	 */
	public void doStep(ExternalManager externo) throws CRefineException, CRulesException;
	
	/**
	 * Volta atrs em um passo de execuo.
	 * 
	 * @param externo o gerenciador externo do CRefine
	 */
	public void undoStep(ExternalManager externo)throws CRefineException, CRulesException;
	
	/**
	 * Refaz o passo de execuo desfeito
	 * @param externo
	 */
	public void redoStep(ExternalManager externo)throws CRefineException, CRulesException;
	
	
	public void undoPrintLatexStep(ExternalManager externo);
	
	public void redoPrintLatexStep(ExternalManager externo);
	
}
